/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes;

import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.changes.DirtBuilderReader;
import com.intellij.openapi.vcs.changes.VcsGuess;
import com.intellij.util.containers.MultiMap;
import org.jetbrains.annotations.NotNull;

public class DirtBuilder
implements DirtBuilderReader {
    private final VcsGuess myGuess;
    private final FileTypeManager myFileTypeManager;
    private final MultiMap<AbstractVcs, FilePath> myFiles;
    private final MultiMap<AbstractVcs, FilePath> myDirs;
    private boolean myEverythingDirty;

    public DirtBuilder(VcsGuess guess) {
        this.myGuess = guess;
        this.myDirs = MultiMap.createSet();
        this.myFiles = MultiMap.createSet();
        this.myEverythingDirty = false;
        this.myFileTypeManager = FileTypeManager.getInstance();
    }

    public DirtBuilder(DirtBuilder builder) {
        this(builder.myGuess);
        this.myDirs.putAllValues(builder.myDirs);
        this.myFiles.putAllValues(builder.myFiles);
        this.myEverythingDirty = builder.myEverythingDirty;
    }

    public void reset() {
        this.myFiles.clear();
        this.myDirs.clear();
        this.myEverythingDirty = false;
    }

    public void everythingDirty() {
        this.myEverythingDirty = true;
    }

    public void addDirtyFile(@NotNull AbstractVcs vcs, @NotNull FilePath file2) {
        if (this.myFileTypeManager.isFileIgnored(file2.getName())) {
            return;
        }
        this.myFiles.putValue((Object)vcs, (Object)file2);
    }

    public void addDirtyDirRecursively(@NotNull AbstractVcs vcs, @NotNull FilePath dir) {
        if (this.myFileTypeManager.isFileIgnored(dir.getName())) {
            return;
        }
        this.myDirs.putValue((Object)vcs, (Object)dir);
    }

    @Override
    public boolean isEverythingDirty() {
        return this.myEverythingDirty;
    }

    @Override
    @NotNull
    public MultiMap<AbstractVcs, FilePath> getFilesForVcs() {
        return this.myFiles;
    }

    @Override
    @NotNull
    public MultiMap<AbstractVcs, FilePath> getDirsForVcs() {
        return this.myDirs;
    }

    @Override
    public boolean isEmpty() {
        return this.myFiles.isEmpty() && this.myDirs.isEmpty();
    }
}

