/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes;

import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.changes.FileHolder;
import com.intellij.openapi.vcs.changes.IgnoredFilesHolder;
import com.intellij.openapi.vcs.changes.RecursiveFileHolder;
import com.intellij.openapi.vcs.changes.VcsIgnoredFilesHolder;
import com.intellij.openapi.vcs.changes.VcsModifiableDirtyScope;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IgnoredFilesCompositeHolder
implements IgnoredFilesHolder {
    private final Map<AbstractVcs, IgnoredFilesHolder> myVcsIgnoredHolderMap;
    private IgnoredFilesHolder myIdeIgnoredFilesHolder;
    private final Project myProject;
    private AbstractVcs myCurrentVcs;
    private final ProjectLevelVcsManager myVcsManager;

    public IgnoredFilesCompositeHolder(Project project2) {
        this.myProject = project2;
        this.myVcsIgnoredHolderMap = new HashMap<AbstractVcs, IgnoredFilesHolder>();
        this.myIdeIgnoredFilesHolder = new RecursiveFileHolder(this.myProject, FileHolder.HolderType.IGNORED);
        this.myVcsManager = ProjectLevelVcsManager.getInstance((Project)this.myProject);
    }

    @Override
    public void cleanAll() {
        this.myVcsIgnoredHolderMap.values().forEach(FileHolder::cleanAll);
        this.myVcsIgnoredHolderMap.clear();
        this.myIdeIgnoredFilesHolder.cleanAll();
    }

    @Override
    public void cleanAndAdjustScope(VcsModifiableDirtyScope scope) {
        AbstractVcs vcs = scope.getVcs();
        if (this.myVcsIgnoredHolderMap.containsKey(vcs)) {
            this.myVcsIgnoredHolderMap.get(vcs).cleanAndAdjustScope(scope);
        }
        this.myIdeIgnoredFilesHolder.cleanAndAdjustScope(scope);
    }

    @Override
    public FileHolder copy() {
        IgnoredFilesCompositeHolder result2 = new IgnoredFilesCompositeHolder(this.myProject);
        for (Map.Entry<AbstractVcs, IgnoredFilesHolder> entry : this.myVcsIgnoredHolderMap.entrySet()) {
            result2.myVcsIgnoredHolderMap.put(entry.getKey(), (IgnoredFilesHolder)entry.getValue().copy());
        }
        result2.myIdeIgnoredFilesHolder = (IgnoredFilesHolder)this.myIdeIgnoredFilesHolder.copy();
        return result2;
    }

    @Override
    public FileHolder.HolderType getType() {
        return FileHolder.HolderType.IGNORED;
    }

    @Override
    public void addFile(VirtualFile file2) {
        this.myIdeIgnoredFilesHolder.addFile(file2);
    }

    public boolean isInUpdatingMode() {
        return this.myVcsIgnoredHolderMap.values().stream().anyMatch(holder -> holder instanceof VcsIgnoredFilesHolder && ((VcsIgnoredFilesHolder)holder).isInUpdatingMode());
    }

    @Override
    public boolean containsFile(VirtualFile file2) {
        if (this.myIdeIgnoredFilesHolder.containsFile(file2)) {
            return true;
        }
        AbstractVcs vcs = this.myVcsManager.getVcsFor(file2);
        if (vcs == null) {
            return false;
        }
        IgnoredFilesHolder ignoredFilesHolder = this.myVcsIgnoredHolderMap.get(vcs);
        return ignoredFilesHolder != null && ignoredFilesHolder.containsFile(file2);
    }

    @Override
    public Collection<VirtualFile> values() {
        HashSet result2 = ContainerUtil.newHashSet();
        result2.addAll(this.myIdeIgnoredFilesHolder.values());
        result2.addAll(this.myVcsIgnoredHolderMap.values().stream().map(IgnoredFilesHolder::values).flatMap(set2 -> set2.stream()).collect(Collectors.toSet()));
        return result2;
    }

    @Override
    public void notifyVcsStarted(AbstractVcs vcs) {
        this.myCurrentVcs = vcs;
        if (this.myVcsIgnoredHolderMap.containsKey(vcs)) {
            return;
        }
        IgnoredFilesHolder ignoredFilesHolder = (IgnoredFilesHolder)ObjectUtils.chooseNotNull((Object)IgnoredFilesCompositeHolder.getHolderFromEP(vcs, this.myProject), new RecursiveFileHolder(this.myProject, FileHolder.HolderType.IGNORED));
        ignoredFilesHolder.notifyVcsStarted(vcs);
        this.myVcsIgnoredHolderMap.put(vcs, ignoredFilesHolder);
    }

    @Nullable
    public IgnoredFilesHolder getActiveVcsHolder() {
        return this.getIgnoredHolderByVcs(this.myCurrentVcs);
    }

    @Nullable
    private IgnoredFilesHolder getIgnoredHolderByVcs(AbstractVcs vcs) {
        if (!this.myVcsIgnoredHolderMap.containsKey(vcs)) {
            return null;
        }
        return this.myVcsIgnoredHolderMap.get(vcs);
    }

    @Nullable
    private static VcsIgnoredFilesHolder getHolderFromEP(AbstractVcs vcs, @NotNull Project project2) {
        Optional<VcsIgnoredFilesHolder> ignoredFilesHolder = Stream.of(Extensions.getExtensions(VcsIgnoredFilesHolder.VCS_IGNORED_FILES_HOLDER_EP, (AreaInstance)project2)).filter(holder -> holder.getVcs().equals((Object)vcs)).findFirst();
        return ignoredFilesHolder.isPresent() ? ignoredFilesHolder.get() : null;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof IgnoredFilesCompositeHolder)) {
            return false;
        }
        IgnoredFilesCompositeHolder other = (IgnoredFilesCompositeHolder)obj;
        return this.myVcsIgnoredHolderMap.equals(other.myVcsIgnoredHolderMap) && this.myIdeIgnoredFilesHolder.equals(other.myIdeIgnoredFilesHolder);
    }

    public int hashCode() {
        return Objects.hash(this.myVcsIgnoredHolderMap, this.myIdeIgnoredFilesHolder);
    }
}

