/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes;

import com.intellij.icons.AllIcons;
import com.intellij.ide.CommonActionsManager;
import com.intellij.ide.DataManager;
import com.intellij.ide.TreeExpander;
import com.intellij.ide.util.treeView.TreeState;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.DataSink;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.InvokeAfterUpdateMode;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserBase;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserNode;
import com.intellij.openapi.vcs.changes.ui.ChangesListView;
import com.intellij.openapi.vcs.changes.ui.TreeModelBuilder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.util.EditSourceOnDoubleClickHandler;
import com.intellij.util.EditSourceOnEnterKeyHandler;
import com.intellij.util.ui.tree.TreeUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.util.List;
import java.util.stream.Stream;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

abstract class SpecificFilesViewDialog
extends DialogWrapper {
    protected JPanel myPanel;
    protected final ChangesListView myView;
    protected final ChangeListManager myChangeListManager;
    protected boolean myInRefresh;
    protected final Project myProject;

    protected SpecificFilesViewDialog(@NotNull Project project2, @NotNull String title, final @NotNull DataKey<Stream<VirtualFile>> shownDataKey, @NotNull List<VirtualFile> initDataFiles) {
        super(project2, true);
        this.setTitle(title);
        this.myProject = project2;
        final Runnable closer = () -> this.close(0);
        this.myView = new ChangesListView(project2){

            @Override
            public void calcData(DataKey key2, DataSink sink) {
                super.calcData(key2, sink);
                if (shownDataKey.is(key2.getName())) {
                    sink.put(shownDataKey, this.getSelectedFiles());
                }
            }

            @Override
            protected void editSourceRegistration() {
                EditSourceOnDoubleClickHandler.install((JTree)((Object)this), (Runnable)closer);
                EditSourceOnEnterKeyHandler.install((JComponent)((Object)this), (Runnable)closer);
            }
        };
        this.myChangeListManager = ChangeListManager.getInstance((Project)project2);
        this.createPanel();
        this.setOKButtonText("Close");
        this.init();
        this.initData(initDataFiles);
        this.myView.setMinimumSize(new Dimension(100, 100));
    }

    @NotNull
    protected Action[] createActions() {
        return new Action[]{this.getOKAction()};
    }

    private void initData(@NotNull List<VirtualFile> files) {
        TreeState state = TreeState.createOn((JTree)((Object)this.myView), (DefaultMutableTreeNode)((ChangesBrowserNode)this.myView.getModel().getRoot()));
        DefaultTreeModel model = TreeModelBuilder.buildFromVirtualFiles(this.myProject, this.myView.isShowFlatten(), files);
        this.myView.setModel(model);
        this.myView.expandPath(new TreePath(((ChangesBrowserNode)model.getRoot()).getPath()));
        state.applyTo((JTree)((Object)this.myView));
    }

    private void createPanel() {
        this.myPanel = new JPanel(new BorderLayout());
        DefaultActionGroup group = new DefaultActionGroup();
        ActionToolbar actionToolbar = ActionManager.getInstance().createActionToolbar("SPECIFIC_FILES_DIALOG", (ActionGroup)group, true);
        this.addCustomActions(group, actionToolbar);
        CommonActionsManager cam = CommonActionsManager.getInstance();
        Expander expander = new Expander();
        group.addSeparator();
        group.add((AnAction)new ToggleShowFlattenAction());
        group.add(cam.createExpandAllAction((TreeExpander)expander, (JComponent)((Object)this.myView)));
        group.add(cam.createCollapseAllAction((TreeExpander)expander, (JComponent)((Object)this.myView)));
        this.myPanel.add((Component)actionToolbar.getComponent(), "North");
        this.myPanel.add((Component)ScrollPaneFactory.createScrollPane((Component)((Object)this.myView)), "Center");
        this.myView.setShowFlatten(false);
    }

    protected void addCustomActions(@NotNull DefaultActionGroup group, @NotNull ActionToolbar actionToolbar) {
    }

    protected String getDimensionServiceKey() {
        return "com.intellij.openapi.vcs.changes.SpecificFilesViewDialog";
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myView;
    }

    protected JComponent createCenterPanel() {
        return this.myPanel;
    }

    protected void refreshView() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (this.myInRefresh) {
            return;
        }
        this.myInRefresh = true;
        this.myChangeListManager.invokeAfterUpdate(() -> {
            try {
                this.initData(this.getFiles());
            }
            finally {
                this.myInRefresh = false;
            }
        }, InvokeAfterUpdateMode.BACKGROUND_NOT_CANCELLABLE, "", ModalityState.current());
    }

    @NotNull
    protected abstract List<VirtualFile> getFiles();

    protected static ChangesBrowserBase getBrowserBase(@NotNull ChangesListView view) {
        return (ChangesBrowserBase)ChangesBrowserBase.DATA_KEY.getData(DataManager.getInstance().getDataContext((Component)((Object)view)));
    }

    public static void refreshChanges(@NotNull Project project2, @Nullable ChangesBrowserBase browser) {
        if (browser != null) {
            ChangeListManager.getInstance((Project)project2).invokeAfterUpdate(browser::rebuildList, InvokeAfterUpdateMode.SYNCHRONOUS_CANCELLABLE, "Delete files", null);
        }
    }

    public class ToggleShowFlattenAction
    extends ToggleAction
    implements DumbAware {
        public ToggleShowFlattenAction() {
            super(VcsBundle.message((String)"changes.action.show.directories.text", (Object[])new Object[0]), VcsBundle.message((String)"changes.action.show.directories.description", (Object[])new Object[0]), AllIcons.Actions.GroupByPackage);
        }

        public boolean isSelected(AnActionEvent e) {
            return !SpecificFilesViewDialog.this.myView.isShowFlatten();
        }

        public void setSelected(AnActionEvent e, boolean state) {
            SpecificFilesViewDialog.this.myView.setShowFlatten(!state);
            SpecificFilesViewDialog.this.refreshView();
        }
    }

    private class Expander
    implements TreeExpander {
        private Expander() {
        }

        public void expandAll() {
            TreeUtil.expandAll((JTree)((Object)SpecificFilesViewDialog.this.myView));
        }

        public boolean canExpand() {
            return !SpecificFilesViewDialog.this.myView.isShowFlatten();
        }

        public void collapseAll() {
            TreeUtil.collapseAll((JTree)((Object)SpecificFilesViewDialog.this.myView), (int)1);
            TreeUtil.expand((JTree)((Object)SpecificFilesViewDialog.this.myView), (int)0);
        }

        public boolean canCollapse() {
            return !SpecificFilesViewDialog.this.myView.isShowFlatten();
        }
    }
}

