/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes;

import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonShortcuts;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.EmptyAction;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.actionSystem.ex.AnActionListener;
import com.intellij.openapi.actionSystem.impl.PresentationFactory;
import com.intellij.openapi.actionSystem.impl.Utils;
import com.intellij.openapi.application.impl.LaterInvocator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.changes.ChangeListManagerImpl;
import com.intellij.openapi.vcs.changes.SpecificFilesViewDialog;
import com.intellij.openapi.vcs.changes.ui.ChangesListView;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public class UnversionedViewDialog
extends SpecificFilesViewDialog {
    private AnAction myDeleteActionWithCustomShortcut;

    public UnversionedViewDialog(@NotNull Project project2) {
        super(project2, "Unversioned Files", ChangesListView.UNVERSIONED_FILES_DATA_KEY, ChangeListManagerImpl.getInstanceImpl(project2).getUnversionedFiles());
    }

    @Override
    protected void addCustomActions(@NotNull DefaultActionGroup group, @NotNull ActionToolbar actionToolbar) {
        List<AnAction> actions = UnversionedViewDialog.registerUnversionedActionsShortcuts(actionToolbar.getToolbarDataContext(), (JComponent)((Object)this.myView));
        this.myDeleteActionWithCustomShortcut = EmptyAction.registerWithShortcutSet((String)"ChangesView.DeleteUnversioned.From.Dialog", (ShortcutSet)CommonShortcuts.getDelete(), (JComponent)((Object)this.myView));
        actions.add(this.myDeleteActionWithCustomShortcut);
        this.refreshViewAfterActionPerformed(actions);
        group.add((AnAction)UnversionedViewDialog.getUnversionedActionGroup());
        DefaultActionGroup secondGroup = new DefaultActionGroup();
        secondGroup.addAll(UnversionedViewDialog.getUnversionedActionGroup());
        this.myView.setMenuActions((ActionGroup)secondGroup);
    }

    private void refreshViewAfterActionPerformed(final @NotNull List<AnAction> actions) {
        ActionManager.getInstance().addAnActionListener((AnActionListener)new AnActionListener.Adapter(){

            public void afterActionPerformed(AnAction action, DataContext dataContext, AnActionEvent event) {
                if (actions.contains(action)) {
                    UnversionedViewDialog.this.refreshView();
                    if (UnversionedViewDialog.this.myDeleteActionWithCustomShortcut.equals(action)) {
                        SpecificFilesViewDialog.refreshChanges(UnversionedViewDialog.this.myProject, SpecificFilesViewDialog.getBrowserBase(UnversionedViewDialog.this.myView));
                    }
                }
            }
        }, this.myDisposable);
    }

    @NotNull
    public static ActionGroup getUnversionedActionGroup() {
        return (ActionGroup)ActionManager.getInstance().getAction("Unversioned.Files.Dialog");
    }

    @NotNull
    public static List<AnAction> registerUnversionedActionsShortcuts(@NotNull DataContext dataContext, @NotNull JComponent component) {
        ActionManager manager = ActionManager.getInstance();
        ArrayList actions = ContainerUtil.newArrayList();
        Utils.expandActionGroup(LaterInvocator.isInModalContext(), UnversionedViewDialog.getUnversionedActionGroup(), actions, new PresentationFactory(), dataContext, "", manager);
        for (AnAction action : actions) {
            action.registerCustomShortcutSet(action.getShortcutSet(), component);
        }
        return actions;
    }

    @Override
    @NotNull
    protected List<VirtualFile> getFiles() {
        return ((ChangeListManagerImpl)this.myChangeListManager).getUnversionedFiles();
    }
}

