/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes;

import com.intellij.ide.impl.dataRules.GetDataRule;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.vcs.VcsDataKeys;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangesSelection;
import com.intellij.util.ArrayUtil;
import java.util.Arrays;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VcsChangesSelectionRule
implements GetDataRule {
    @Override
    @Nullable
    public Object getData(DataProvider dataProvider) {
        return this.getChangesSelection(dataProvider);
    }

    @Nullable
    public ChangesSelection getChangesSelection(@NotNull DataProvider dataProvider) {
        Change currentChange = (Change)VcsDataKeys.CURRENT_CHANGE.getData(dataProvider);
        Object[] selectedChanges = (Change[])VcsDataKeys.SELECTED_CHANGES.getData(dataProvider);
        if (selectedChanges != null) {
            int index = Math.max(ArrayUtil.indexOf((Object[])selectedChanges, (Object)currentChange), 0);
            return new ChangesSelection(Arrays.asList(selectedChanges), index);
        }
        Object[] changes = (Change[])VcsDataKeys.CHANGES.getData(dataProvider);
        if (changes != null) {
            int index = Math.max(ArrayUtil.indexOf((Object[])changes, (Object)currentChange), 0);
            return new ChangesSelection(Arrays.asList(changes), index);
        }
        if (currentChange != null) {
            return new ChangesSelection(Collections.singletonList(currentChange), 0);
        }
        return null;
    }
}

