/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.VcsKey;
import com.intellij.openapi.vcs.changes.ByteBackedContentRevision;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.diff.DiffProvider;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vcs.impl.ContentRevisionCache;
import com.intellij.openapi.vcs.impl.CurrentRevisionProvider;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.vcsUtil.VcsUtil;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VcsCurrentRevisionProxy
implements ContentRevision {
    @NotNull
    private final DiffProvider myDiffProvider;
    @NotNull
    private final VirtualFile myFile;
    @NotNull
    private final Project myProject;
    @NotNull
    private final VcsKey myVcsKey;

    @Nullable
    public static VcsCurrentRevisionProxy create(@NotNull VirtualFile file2, @NotNull Project project2) {
        DiffProvider diffProvider;
        AbstractVcs vcs = ProjectLevelVcsManager.getInstance((Project)project2).getVcsFor(file2);
        if (vcs != null && (diffProvider = vcs.getDiffProvider()) != null) {
            return new VcsCurrentRevisionProxy(diffProvider, file2, project2, vcs.getKeyInstanceMethod());
        }
        return null;
    }

    private VcsCurrentRevisionProxy(@NotNull DiffProvider diffProvider, @NotNull VirtualFile file2, @NotNull Project project2, @NotNull VcsKey vcsKey) {
        this.myDiffProvider = diffProvider;
        this.myFile = file2;
        this.myProject = project2;
        this.myVcsKey = vcsKey;
    }

    @Nullable
    public String getContent() throws VcsException {
        return this.getVcsRevision().getContent();
    }

    @NotNull
    public FilePath getFile() {
        return VcsUtil.getFilePath((VirtualFile)this.myFile);
    }

    @NotNull
    public VcsRevisionNumber getRevisionNumber() {
        try {
            return this.getVcsRevision().getRevisionNumber();
        }
        catch (VcsException ex) {
            return VcsRevisionNumber.NULL;
        }
    }

    @NotNull
    private ContentRevision getVcsRevision() throws VcsException {
        Pair pair;
        final FilePath file2 = this.getFile();
        try {
            pair = ContentRevisionCache.getOrLoadCurrentAsBytes((Project)this.myProject, (FilePath)file2, (VcsKey)this.myVcsKey, (CurrentRevisionProvider)new CurrentRevisionProvider(){

                public VcsRevisionNumber getCurrentRevision() throws VcsException {
                    return VcsCurrentRevisionProxy.this.getCurrentRevisionNumber();
                }

                public Pair<VcsRevisionNumber, byte[]> get() throws VcsException, IOException {
                    return VcsCurrentRevisionProxy.this.loadContent();
                }
            });
        }
        catch (IOException e) {
            throw new VcsException((Throwable)e);
        }
        return new ByteBackedContentRevision(){

            public String getContent() throws VcsException {
                return ContentRevisionCache.getAsString((byte[])this.getContentAsBytes(), (FilePath)file2, null);
            }

            @Nullable
            public byte[] getContentAsBytes() throws VcsException {
                return (byte[])pair.getSecond();
            }

            @NotNull
            public FilePath getFile() {
                return file2;
            }

            @NotNull
            public VcsRevisionNumber getRevisionNumber() {
                return (VcsRevisionNumber)pair.getFirst();
            }
        };
    }

    @NotNull
    private VcsRevisionNumber getCurrentRevisionNumber() throws VcsException {
        VcsRevisionNumber currentRevision = this.myDiffProvider.getCurrentRevision(this.myFile);
        if (currentRevision == null) {
            throw new VcsException("Failed to fetch current revision");
        }
        return currentRevision;
    }

    @NotNull
    private Pair<VcsRevisionNumber, byte[]> loadContent() throws VcsException {
        VcsRevisionNumber currentRevision = this.getCurrentRevisionNumber();
        ContentRevision contentRevision = this.myDiffProvider.createFileContent(currentRevision, this.myFile);
        if (contentRevision == null) {
            throw new VcsException("Failed to create content for current revision");
        }
        return Pair.create((Object)currentRevision, (Object)contentRevision.getContent().getBytes(this.myFile.getCharset()));
    }
}

