/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.ZipperUpdater;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.changes.VcsDirtyScopeManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.openapi.vfs.newvfs.events.VFileContentChangeEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileCopyEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileCreateEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileDeleteEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileMoveEvent;
import com.intellij.openapi.vfs.newvfs.events.VFilePropertyChangeEvent;
import com.intellij.util.Alarm;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcsUtil.VcsUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VcsDirtyScopeVfsListener
implements BulkFileListener,
Disposable {
    @NotNull
    private final ProjectLevelVcsManager myVcsManager;
    private boolean myForbid;
    @NotNull
    private final ZipperUpdater myZipperUpdater;
    private final List<FilesAndDirs> myQueue;
    private final Object myLock;
    @NotNull
    private final Runnable myDirtReporter;

    public VcsDirtyScopeVfsListener(@NotNull Project project2, @NotNull ProjectLevelVcsManager vcsManager, final @NotNull VcsDirtyScopeManager dirtyScopeManager) {
        this.myVcsManager = vcsManager;
        this.myLock = new Object();
        this.myQueue = new ArrayList<FilesAndDirs>();
        this.myDirtReporter = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                ArrayList list;
                Object object = VcsDirtyScopeVfsListener.this.myLock;
                synchronized (object) {
                    list = new ArrayList(VcsDirtyScopeVfsListener.this.myQueue);
                    VcsDirtyScopeVfsListener.this.myQueue.clear();
                }
                HashSet dirtyFiles = ContainerUtil.newHashSet();
                HashSet dirtyDirs = ContainerUtil.newHashSet();
                for (FilesAndDirs filesAndDirs : list) {
                    dirtyFiles.addAll(filesAndDirs.dirtyFiles);
                    dirtyDirs.addAll(filesAndDirs.dirtyDirs);
                }
                if (!dirtyFiles.isEmpty() || !dirtyDirs.isEmpty()) {
                    dirtyScopeManager.filePathsDirty((Collection)dirtyFiles, (Collection)dirtyDirs);
                }
            }
        };
        this.myZipperUpdater = new ZipperUpdater(300, Alarm.ThreadToUse.POOLED_THREAD, this);
        Disposer.register((Disposable)project2, (Disposable)this);
        project2.getMessageBus().connect().subscribe(VirtualFileManager.VFS_CHANGES, (Object)this);
    }

    public static VcsDirtyScopeVfsListener getInstance(@NotNull Project project2) {
        return (VcsDirtyScopeVfsListener)ServiceManager.getService((Project)project2, VcsDirtyScopeVfsListener.class);
    }

    public static void install(@NotNull Project project2) {
        if (!project2.isOpen()) {
            throw new RuntimeException("Already closed: " + project2);
        }
        VcsDirtyScopeVfsListener.getInstance(project2);
    }

    public void setForbid(boolean forbid) {
        assert (ApplicationManager.getApplication().isUnitTestMode());
        this.myForbid = forbid;
    }

    public void flushDirt() {
        this.myDirtReporter.run();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        Object object = this.myLock;
        synchronized (object) {
            this.myQueue.clear();
        }
    }

    public void before(@NotNull List<? extends VFileEvent> events) {
        if (this.myForbid || !this.myVcsManager.hasAnyMappings()) {
            return;
        }
        FilesAndDirs dirtyFilesAndDirs = new FilesAndDirs();
        for (VFileEvent vFileEvent : events) {
            VirtualFile file2;
            if (vFileEvent instanceof VFileCreateEvent || (file2 = vFileEvent.getFile()) == null || !file2.isInLocalFileSystem() || !(vFileEvent instanceof VFileDeleteEvent) && !(vFileEvent instanceof VFileMoveEvent) && !(vFileEvent instanceof VFilePropertyChangeEvent)) continue;
            dirtyFilesAndDirs.add(file2);
        }
        this.markDirtyOnPooled(dirtyFilesAndDirs);
    }

    public void after(@NotNull List<? extends VFileEvent> events) {
        if (this.myForbid || !this.myVcsManager.hasAnyMappings()) {
            return;
        }
        FilesAndDirs dirtyFilesAndDirs = new FilesAndDirs();
        for (VFileEvent vFileEvent : events) {
            VirtualFile file2;
            if (vFileEvent instanceof VFileDeleteEvent || (file2 = vFileEvent.getFile()) == null || !file2.isInLocalFileSystem()) continue;
            if (vFileEvent instanceof VFileContentChangeEvent || vFileEvent instanceof VFileCreateEvent || vFileEvent instanceof VFileMoveEvent) {
                dirtyFilesAndDirs.add(file2);
                continue;
            }
            if (vFileEvent instanceof VFileCopyEvent) {
                VFileCopyEvent copyEvent = (VFileCopyEvent)vFileEvent;
                dirtyFilesAndDirs.add(copyEvent.getNewParent().findChild(copyEvent.getNewChildName()));
                continue;
            }
            if (!(vFileEvent instanceof VFilePropertyChangeEvent)) continue;
            VFilePropertyChangeEvent pce = (VFilePropertyChangeEvent)vFileEvent;
            if (pce.getPropertyName().equals("name")) {
                dirtyFilesAndDirs.add(file2);
                dirtyFilesAndDirs.addToFiles(file2.getParent());
                continue;
            }
            dirtyFilesAndDirs.addToFiles(file2);
        }
        this.markDirtyOnPooled(dirtyFilesAndDirs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void markDirtyOnPooled(@NotNull FilesAndDirs dirtyFilesAndDirs) {
        if (!dirtyFilesAndDirs.isEmpty()) {
            Object object = this.myLock;
            synchronized (object) {
                this.myQueue.add(dirtyFilesAndDirs);
            }
            this.myZipperUpdater.queue(this.myDirtReporter);
        }
    }

    private static class FilesAndDirs {
        @NotNull
        HashSet<FilePath> dirtyFiles = ContainerUtil.newHashSet();
        @NotNull
        HashSet<FilePath> dirtyDirs = ContainerUtil.newHashSet();

        private FilesAndDirs() {
        }

        private void add(@Nullable VirtualFile file2, boolean addToFiles) {
            if (file2 == null) {
                return;
            }
            boolean isDirectory = file2.isDirectory();
            FilePath path = VcsUtil.getFilePath((String)file2.getPath(), (boolean)isDirectory);
            if (addToFiles || !isDirectory) {
                this.dirtyFiles.add(path);
            } else {
                this.dirtyDirs.add(path);
            }
        }

        private void add(@Nullable VirtualFile file2) {
            this.add(file2, false);
        }

        private void addToFiles(@Nullable VirtualFile file2) {
            this.add(file2, true);
        }

        private boolean isEmpty() {
            return this.dirtyFiles.isEmpty() && this.dirtyDirs.isEmpty();
        }
    }
}

