/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.actions;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.AbstractVcsHelper;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vcs.changes.ChangesViewManager;
import com.intellij.openapi.vcs.changes.VcsDirtyScopeManager;
import com.intellij.openapi.vcs.changes.ui.ChangesListView;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public abstract class AbstractMissingFilesAction
extends AnAction
implements DumbAware {
    public void update(AnActionEvent e) {
        List files = (List)e.getData(ChangesListView.MISSING_FILES_DATA_KEY);
        boolean enabled = files != null && !files.isEmpty();
        e.getPresentation().setEnabled(enabled);
        e.getPresentation().setVisible(enabled);
    }

    public void actionPerformed(AnActionEvent e) {
        final Project project2 = (Project)e.getData(CommonDataKeys.PROJECT);
        final List files = (List)e.getData(ChangesListView.MISSING_FILES_DATA_KEY);
        if (files == null) {
            return;
        }
        ProgressManager progressManager = ProgressManager.getInstance();
        Runnable action = new Runnable(){

            @Override
            public void run() {
                ArrayList allExceptions = new ArrayList();
                ChangesUtil.processFilePathsByVcs((Project)project2, (Collection)files, (vcs, items) -> {
                    List<VcsException> exceptions = AbstractMissingFilesAction.this.processFiles(vcs, files);
                    if (exceptions != null) {
                        allExceptions.addAll(exceptions);
                    }
                });
                for (FilePath file2 : files) {
                    VcsDirtyScopeManager.getInstance((Project)project2).fileDirty(file2);
                }
                ChangesViewManager.getInstance(project2).scheduleRefresh();
                if (allExceptions.size() > 0) {
                    AbstractVcsHelper.getInstance((Project)project2).showErrors(allExceptions, "VCS Errors");
                }
            }
        };
        if (this.synchronously()) {
            action.run();
        } else {
            progressManager.runProcessWithProgressSynchronously(action, this.getName(), true, project2);
        }
    }

    protected abstract boolean synchronously();

    protected abstract String getName();

    protected abstract List<VcsException> processFiles(AbstractVcs var1, List<FilePath> var2);
}

