/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.actions;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsDataKeys;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.changes.committed.CommittedChangesBrowserUseCase;
import com.intellij.openapi.vcs.vfs.ContentRevisionVirtualFile;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import org.jetbrains.annotations.NotNull;

public class OpenRepositoryVersionAction
extends AnAction
implements DumbAware {
    public OpenRepositoryVersionAction() {
        super(VcsBundle.message((String)"open.repository.version.text", (Object[])new Object[0]), VcsBundle.message((String)"open.repository.version.description", (Object[])new Object[0]), AllIcons.ObjectBrowser.ShowEditorHighlighting);
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Project project2 = (Project)e.getRequiredData(CommonDataKeys.PROJECT);
        Change[] changes = (Change[])e.getRequiredData(VcsDataKeys.SELECTED_CHANGES);
        OpenRepositoryVersionAction.openRepositoryVersion(project2, changes);
    }

    public void update(@NotNull AnActionEvent e) {
        Project project2 = (Project)e.getData(CommonDataKeys.PROJECT);
        Change[] changes = (Change[])e.getData(VcsDataKeys.SELECTED_CHANGES);
        e.getPresentation().setEnabled(project2 != null && changes != null && !CommittedChangesBrowserUseCase.IN_AIR.equals(CommittedChangesBrowserUseCase.DATA_KEY.getData(e.getDataContext())) && OpenRepositoryVersionAction.hasValidChanges(changes) && ModalityState.NON_MODAL.equals(ModalityState.current()));
    }

    private static boolean hasValidChanges(@NotNull Change[] changes) {
        return ContainerUtil.exists((Object[])changes, c -> c.getAfterRevision() != null && !c.getAfterRevision().getFile().isDirectory());
    }

    private static void openRepositoryVersion(@NotNull Project project2, @NotNull Change[] changes) {
        for (Change change : changes) {
            ContentRevision revision = change.getAfterRevision();
            if (revision == null || revision.getFile().isDirectory()) continue;
            ContentRevisionVirtualFile vFile = ContentRevisionVirtualFile.create((ContentRevision)revision);
            OpenFileDescriptor navigatable = new OpenFileDescriptor(project2, (VirtualFile)vFile);
            navigatable.navigate(true);
        }
    }
}

