/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.actions;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsDataKeys;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeList;
import com.intellij.openapi.vcs.changes.actions.RevertCommittedStuffAbstractAction;
import com.intellij.openapi.vcs.versionBrowser.CommittedChangeList;
import com.intellij.util.containers.Convertor;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class RevertSelectedChangesAction
extends RevertCommittedStuffAbstractAction {
    private static Icon ourIcon;
    private static String ourText;

    @Override
    public void update(AnActionEvent e) {
        Presentation presentation = e.getPresentation();
        RevertSelectedChangesAction.initPresentation();
        presentation.setIcon(ourIcon);
        presentation.setText(ourText);
        super.update(e);
    }

    @Override
    protected boolean isEnabled(@NotNull AnActionEvent e) {
        return super.isEnabled(e) && RevertSelectedChangesAction.allSelectedChangeListsAreRevertable(e);
    }

    private static boolean allSelectedChangeListsAreRevertable(@NotNull AnActionEvent e) {
        ChangeList[] changeLists = (ChangeList[])e.getData(VcsDataKeys.CHANGE_LISTS);
        if (changeLists == null) {
            return true;
        }
        for (ChangeList list : changeLists) {
            if (!(list instanceof CommittedChangeList) || ((CommittedChangeList)list).isModifiable()) continue;
            return false;
        }
        return true;
    }

    private static void initPresentation() {
        if (ourIcon == null) {
            ourIcon = AllIcons.Actions.Rollback;
            ourText = VcsBundle.message((String)"action.revert.selected.changes.text", (Object[])new Object[0]);
        }
    }

    public RevertSelectedChangesAction() {
        super(new Convertor<AnActionEvent, Change[]>(){

            public Change[] convert(AnActionEvent e) {
                return (Change[])e.getData(VcsDataKeys.SELECTED_CHANGES_IN_DETAILS);
            }
        }, new Convertor<AnActionEvent, Change[]>(){

            public Change[] convert(AnActionEvent e) {
                e.getData(VcsDataKeys.CHANGES_WITH_MOVED_CHILDREN);
                return (Change[])e.getData(VcsDataKeys.SELECTED_CHANGES_IN_DETAILS);
            }
        });
    }
}

