/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.actions;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.FileStatusManager;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsDataKeys;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeListManagerImpl;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserBase;
import com.intellij.openapi.vcs.changes.ui.ChangesListView;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Consumer;
import com.intellij.util.containers.UtilKt;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ScheduleForAdditionAction
extends AnAction
implements DumbAware {
    public void update(@NotNull AnActionEvent e) {
        boolean enabled = e.getProject() != null && !UtilKt.isEmpty(this.getUnversionedFiles(e, e.getProject()));
        e.getPresentation().setEnabled(enabled);
        if ("ActionPlace.VcsQuickListPopupAction".equals(e.getPlace()) || "ChangesViewPopup".equals(e.getPlace())) {
            e.getPresentation().setVisible(enabled);
        }
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Project project2 = (Project)e.getRequiredData(CommonDataKeys.PROJECT);
        List<VirtualFile> unversionedFiles = this.getUnversionedFiles(e, project2).collect(Collectors.toList());
        ScheduleForAdditionAction.addUnversioned(project2, unversionedFiles, (Condition<FileStatus>)((Condition)this::isStatusForAddition), (ChangesBrowserBase)e.getData(ChangesBrowserBase.DATA_KEY));
    }

    public static boolean addUnversioned(@NotNull Project project2, @NotNull List<VirtualFile> files, @NotNull Condition<FileStatus> unversionedFileCondition, @Nullable ChangesBrowserBase browser) {
        boolean result2 = true;
        if (!files.isEmpty()) {
            FileDocumentManager.getInstance().saveAllDocuments();
            Consumer consumer2 = browser == null ? null : changes -> {
                browser.rebuildList();
                browser.getViewer().excludeChanges(files);
                browser.getViewer().includeChanges(changes);
            };
            ChangeListManagerImpl manager = ChangeListManagerImpl.getInstanceImpl(project2);
            LocalChangeList targetChangeList = browser == null ? manager.getDefaultChangeList() : (LocalChangeList)browser.getSelectedChangeList();
            List<VcsException> exceptions = manager.addUnversionedFiles(targetChangeList, files, unversionedFileCondition, (Consumer<List<Change>>)consumer2);
            result2 = exceptions.isEmpty();
        }
        return result2;
    }

    @NotNull
    private Stream<VirtualFile> getUnversionedFiles(@NotNull AnActionEvent e, @NotNull Project project2) {
        boolean hasExplicitUnversioned;
        ProjectLevelVcsManager vcsManager = ProjectLevelVcsManager.getInstance((Project)project2);
        FileStatusManager fileStatusManager = FileStatusManager.getInstance((Project)project2);
        boolean bl = hasExplicitUnversioned = !UtilKt.isEmpty((Stream)e.getData(ChangesListView.UNVERSIONED_FILES_DATA_KEY));
        return hasExplicitUnversioned ? (Stream<VirtualFile>)e.getRequiredData(ChangesListView.UNVERSIONED_FILES_DATA_KEY) : (this.checkVirtualFiles(e) ? UtilKt.notNullize((Stream)e.getData(VcsDataKeys.VIRTUAL_FILE_STREAM)).filter(file2 -> this.isFileUnversioned((VirtualFile)file2, vcsManager, fileStatusManager)) : Stream.empty());
    }

    private boolean isFileUnversioned(@NotNull VirtualFile file2, @NotNull ProjectLevelVcsManager vcsManager, @NotNull FileStatusManager fileStatusManager) {
        AbstractVcs vcs = vcsManager.getVcsFor(file2);
        return vcs != null && !vcs.areDirectoriesVersionedItems() && file2.isDirectory() || this.isStatusForAddition(fileStatusManager.getStatus(file2));
    }

    protected boolean isStatusForAddition(FileStatus status) {
        return status == FileStatus.UNKNOWN;
    }

    protected boolean checkVirtualFiles(@NotNull AnActionEvent e) {
        return ArrayUtil.isEmpty((Object[])((Object[])e.getData(VcsDataKeys.CHANGES)));
    }
}

