/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.actions;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsDataKeys;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.ChangesSelection;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.changes.CurrentContentRevision;
import com.intellij.openapi.vcs.changes.actions.diff.ShowDiffAction;
import com.intellij.openapi.vcs.changes.committed.CommittedChangesBrowserUseCase;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ShowDiffWithLocalAction
extends AnAction
implements DumbAware {
    public ShowDiffWithLocalAction() {
        super(VcsBundle.message((String)"show.diff.with.local.action.text", (Object[])new Object[0]), VcsBundle.message((String)"show.diff.with.local.action.description", (Object[])new Object[0]), AllIcons.Actions.DiffWithCurrent);
    }

    public void actionPerformed(AnActionEvent e) {
        Project project2 = (Project)e.getData(CommonDataKeys.PROJECT);
        if (ChangeListManager.getInstance((Project)project2).isFreezedWithNotification(null)) {
            return;
        }
        ChangesSelection selection = (ChangesSelection)e.getRequiredData(VcsDataKeys.CHANGES_SELECTION);
        int index = 0;
        ArrayList<Change> changesToLocal = new ArrayList<Change>();
        for (int i2 = 0; i2 < selection.getChanges().size(); ++i2) {
            ContentRevision afterRevision;
            if (i2 == selection.getIndex()) {
                index = changesToLocal.size();
            }
            if ((afterRevision = ((Change)selection.getChanges().get(i2)).getAfterRevision()) == null || !ShowDiffWithLocalAction.isValidAfterRevision(afterRevision)) continue;
            changesToLocal.add(new Change(afterRevision, this.getCurrentRevision(afterRevision, e)));
        }
        if (!changesToLocal.isEmpty()) {
            ShowDiffAction.showDiffForChange(project2, changesToLocal, index);
        }
    }

    @NotNull
    protected ContentRevision getCurrentRevision(@NotNull ContentRevision afterRevision, @NotNull AnActionEvent e) {
        return CurrentContentRevision.create((FilePath)afterRevision.getFile());
    }

    public void update(AnActionEvent e) {
        Project project2 = (Project)e.getData(CommonDataKeys.PROJECT);
        ChangesSelection selection = (ChangesSelection)e.getData(VcsDataKeys.CHANGES_SELECTION);
        boolean isInAir = CommittedChangesBrowserUseCase.IN_AIR.equals(CommittedChangesBrowserUseCase.DATA_KEY.getData(e.getDataContext()));
        e.getPresentation().setEnabled(project2 != null && selection != null && !isInAir && ShowDiffWithLocalAction.anyHasAfterRevision(selection.getChanges()));
    }

    private static boolean isValidAfterRevision(@Nullable ContentRevision afterRevision) {
        return afterRevision != null && !afterRevision.getFile().isNonLocal() && !afterRevision.getFile().isDirectory();
    }

    private static boolean anyHasAfterRevision(@NotNull List<Change> changes) {
        for (Change c : changes) {
            if (!ShowDiffWithLocalAction.isValidAfterRevision(c.getAfterRevision())) continue;
            return true;
        }
        return false;
    }
}

