/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.committed;

import com.intellij.codeInsight.hint.HintUtil;
import com.intellij.ide.DataManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.CachingCommittedChangesProvider;
import com.intellij.openapi.vcs.ChangeListColumn;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsDataKeys;
import com.intellij.openapi.vcs.changes.ChangeList;
import com.intellij.openapi.vcs.changes.committed.ReceivedChangeList;
import com.intellij.openapi.vcs.changes.issueLinks.IssueLinkHtmlRenderer;
import com.intellij.openapi.vcs.versionBrowser.CommittedChangeList;
import com.intellij.ui.BrowserHyperlinkListener;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.DateFormatUtil;
import com.intellij.util.ui.UIUtil;
import com.intellij.xml.util.XmlStringUtil;
import java.awt.Component;
import java.awt.Font;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.event.HyperlinkListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ChangeListDetailsAction
extends AnAction
implements DumbAware {
    public void actionPerformed(@NotNull AnActionEvent e) {
        Project project2 = (Project)e.getRequiredData(CommonDataKeys.PROJECT);
        ChangeList[] changeLists = (ChangeList[])e.getRequiredData(VcsDataKeys.CHANGE_LISTS);
        ChangeListDetailsAction.showDetailsPopup(project2, (CommittedChangeList)changeLists[0]);
    }

    public void update(@NotNull AnActionEvent e) {
        ChangeList[] changeLists = (ChangeList[])e.getData(VcsDataKeys.CHANGE_LISTS);
        e.getPresentation().setEnabled(e.getProject() != null && changeLists != null && changeLists.length == 1 && changeLists[0] instanceof CommittedChangeList);
    }

    public static void showDetailsPopup(@NotNull Project project2, @NotNull CommittedChangeList changeList) {
        String details = String.format("<html><head>%s</head><body>%s</body></html>", UIUtil.getCssFontDeclaration((Font)UIUtil.getLabelFont()), ChangeListDetailsAction.getDetails(project2, changeList));
        JEditorPane editorPane = new JEditorPane("text/html", details);
        editorPane.setEditable(false);
        editorPane.setBackground(HintUtil.getInformationColor());
        editorPane.select(0, 0);
        editorPane.addHyperlinkListener((HyperlinkListener)BrowserHyperlinkListener.INSTANCE);
        JBPopupFactory.getInstance().createComponentPopupBuilder((JComponent)ScrollPaneFactory.createScrollPane((Component)editorPane), (JComponent)editorPane).setDimensionServiceKey(project2, "changelist.details.popup", false).setResizable(true).setMovable(true).setRequestFocus(true).setTitle(VcsBundle.message((String)"changelist.details.title", (Object[])new Object[0])).createPopup().showInBestPositionFor(DataManager.getInstance().getDataContext());
    }

    @NotNull
    private static String getDetails(@NotNull Project project2, @NotNull CommittedChangeList changeList) {
        return StringUtil.join((Collection)ContainerUtil.packNullables((Object[])new String[]{ChangeListDetailsAction.getNumber(changeList), ChangeListDetailsAction.getCommitterAndDate(changeList), ChangeListDetailsAction.getCustomDetails(changeList), IssueLinkHtmlRenderer.formatTextWithLinks(project2, changeList.getComment())}), (String)"<br>");
    }

    @Nullable
    private static String getNumber(@NotNull CommittedChangeList changeList) {
        return Optional.ofNullable(changeList.getVcs()).map(AbstractVcs::getCachingCommittedChangesProvider).map(CachingCommittedChangesProvider::getChangelistTitle).map(changeListTitle -> changeListTitle + " #" + changeList.getNumber()).orElse(null);
    }

    @NotNull
    private static String getCommitterAndDate(@NotNull CommittedChangeList changeList) {
        String committer = "<b>" + changeList.getCommitterName() + "</b>";
        return VcsBundle.message((String)"changelist.details.committed.format", (Object[])new Object[]{committer, DateFormatUtil.formatPrettyDateTime((Date)changeList.getCommitDate())});
    }

    @Nullable
    private static String getCustomDetails(@NotNull CommittedChangeList changeList) {
        AbstractVcs vcs = changeList.getVcs();
        if (vcs != null && vcs.getCachingCommittedChangesProvider() != null) {
            CommittedChangeList originalChangeList = ReceivedChangeList.unwrap(changeList);
            return StringUtil.nullize((String)Arrays.stream(vcs.getCachingCommittedChangesProvider().getColumns()).filter(ChangeListColumn::isCustom).map(column -> column.getTitle() + ": " + XmlStringUtil.escapeString((String)ChangeListDetailsAction.toString(column.getValue((ChangeList)originalChangeList)))).collect(Collectors.joining("<br>")));
        }
        return null;
    }

    @NotNull
    private static String toString(@Nullable Object value2) {
        String result2 = value2 != null ? value2.toString() : "";
        return result2.isEmpty() ? "<none>" : result2;
    }
}

