/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.committed;

import com.google.common.collect.Iterables;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vcs.RepositoryLocation;
import com.intellij.openapi.vcs.changes.committed.RepositoryLocationGroup;
import com.intellij.openapi.vcs.changes.committed.VcsCommittedListsZipper;
import com.intellij.openapi.vcs.versionBrowser.CommittedChangeList;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class CommittedListsSequencesZipper {
    @NotNull
    private final VcsCommittedListsZipper myVcsPartner;
    @NotNull
    private final List<RepositoryLocation> myInLocations;
    @NotNull
    private final Map<String, List<CommittedChangeList>> myInLists;
    @NotNull
    private final Comparator<CommittedChangeList> myComparator;

    public CommittedListsSequencesZipper(@NotNull VcsCommittedListsZipper vcsPartner) {
        this.myVcsPartner = vcsPartner;
        this.myInLocations = ContainerUtil.newArrayList();
        this.myInLists = ContainerUtil.newHashMap();
        this.myComparator = new Comparator<CommittedChangeList>(){

            @Override
            public int compare(CommittedChangeList o1, CommittedChangeList o2) {
                return Comparing.compare((long)CommittedListsSequencesZipper.this.myVcsPartner.getNumber(o1), (long)CommittedListsSequencesZipper.this.myVcsPartner.getNumber(o2));
            }
        };
    }

    public void add(@NotNull RepositoryLocation location, @NotNull List<CommittedChangeList> lists) {
        this.myInLocations.add(location);
        Collections.sort(lists, this.myComparator);
        this.myInLists.put(location.toPresentableString(), lists);
    }

    @NotNull
    public List<CommittedChangeList> execute() {
        Pair groupingResult = this.myVcsPartner.groupLocations(this.myInLocations);
        ArrayList result2 = ContainerUtil.newArrayList();
        result2.addAll(ContainerUtil.flatten(this.collectChangeLists((List)groupingResult.getSecond())));
        for (RepositoryLocationGroup group : (List)groupingResult.getFirst()) {
            result2.addAll(this.mergeLocationGroupChangeLists(group));
        }
        return result2;
    }

    @NotNull
    private List<List<CommittedChangeList>> collectChangeLists(@NotNull List<RepositoryLocation> locations) {
        ArrayList result2 = ContainerUtil.newArrayListWithCapacity((int)locations.size());
        for (RepositoryLocation location : locations) {
            result2.add(this.myInLists.get(location.toPresentableString()));
        }
        return result2;
    }

    @NotNull
    private List<CommittedChangeList> mergeLocationGroupChangeLists(@NotNull RepositoryLocationGroup group) {
        ArrayList result2 = ContainerUtil.newArrayList();
        ArrayList equalLists = ContainerUtil.newArrayList();
        CommittedChangeList previousList = null;
        for (CommittedChangeList list : Iterables.mergeSorted(this.collectChangeLists(group.getLocations()), this.myComparator)) {
            if (previousList != null && this.myComparator.compare(previousList, list) != 0) {
                result2.add(this.zip(group, equalLists));
                equalLists.clear();
            }
            equalLists.add(list);
            previousList = list;
        }
        if (!equalLists.isEmpty()) {
            result2.add(this.zip(group, equalLists));
        }
        return result2;
    }

    @NotNull
    private CommittedChangeList zip(@NotNull RepositoryLocationGroup group, @NotNull List<CommittedChangeList> equalLists) {
        if (equalLists.isEmpty()) {
            throw new IllegalArgumentException("equalLists can not be empty");
        }
        return equalLists.size() > 1 ? this.myVcsPartner.zip(group, equalLists) : equalLists.get(0);
    }
}

