/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.committed;

import com.intellij.icons.AllIcons;
import com.intellij.ide.DataManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.CachingCommittedChangesProvider;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsListener;
import com.intellij.openapi.vcs.changes.committed.CommittedChangesAdapter;
import com.intellij.openapi.vcs.changes.committed.CommittedChangesCache;
import com.intellij.openapi.vcs.changes.ui.ChangesViewContentManager;
import com.intellij.openapi.vcs.versionBrowser.CommittedChangeList;
import com.intellij.openapi.wm.StatusBar;
import com.intellij.openapi.wm.StatusBarWidget;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.util.Consumer;
import com.intellij.util.messages.MessageBus;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.event.MouseEvent;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IncomingChangesIndicator {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.vcs.changes.committed.IncomingChangesIndicator");
    private final Project myProject;
    private final CommittedChangesCache myCache;
    private IndicatorComponent myIndicatorComponent;

    public IncomingChangesIndicator(Project project2, CommittedChangesCache cache2, MessageBus bus) {
        this.myProject = project2;
        this.myCache = cache2;
        MessageBusConnection connection = bus.connect();
        connection.subscribe(CommittedChangesCache.COMMITTED_TOPIC, (Object)new CommittedChangesAdapter(){

            @Override
            public void incomingChangesUpdated(@Nullable List<CommittedChangeList> receivedChanges) {
                ApplicationManager.getApplication().invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        IncomingChangesIndicator.this.refreshIndicator();
                    }
                });
            }
        });
        VcsListener listener2 = new VcsListener(){

            public void directoryMappingChanged() {
                UIUtil.invokeLaterIfNeeded((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        IncomingChangesIndicator.this.updateIndicatorVisibility();
                    }
                });
            }
        };
        connection.subscribe(ProjectLevelVcsManager.VCS_CONFIGURATION_CHANGED, (Object)listener2);
        connection.subscribe(ProjectLevelVcsManager.VCS_CONFIGURATION_CHANGED_IN_PLUGIN, (Object)listener2);
    }

    private void updateIndicatorVisibility() {
        StatusBar statusBar = WindowManager.getInstance().getStatusBar(this.myProject);
        if (this.needIndicator()) {
            if (this.myIndicatorComponent == null) {
                this.myIndicatorComponent = new IndicatorComponent();
                statusBar.addWidget((StatusBarWidget)this.myIndicatorComponent, (Disposable)this.myProject);
                this.refreshIndicator();
            }
        } else if (this.myIndicatorComponent != null) {
            statusBar.removeWidget(this.myIndicatorComponent.ID());
            this.myIndicatorComponent = null;
        }
    }

    private boolean needIndicator() {
        AbstractVcs[] vcss;
        for (AbstractVcs vcs : vcss = ProjectLevelVcsManager.getInstance((Project)this.myProject).getAllActiveVcss()) {
            CachingCommittedChangesProvider provider2 = vcs.getCachingCommittedChangesProvider();
            if (provider2 == null || !provider2.supportsIncomingChanges()) continue;
            return true;
        }
        return false;
    }

    private void refreshIndicator() {
        if (this.myIndicatorComponent == null) {
            return;
        }
        List<CommittedChangeList> list = this.myCache.getCachedIncomingChanges();
        if (list == null || list.isEmpty()) {
            IncomingChangesIndicator.debug("Refreshing indicator: no changes");
            this.myIndicatorComponent.clear();
        } else {
            IncomingChangesIndicator.debug("Refreshing indicator: " + list.size() + " changes");
            this.myIndicatorComponent.setChangesAvailable(VcsBundle.message((String)"incoming.changes.indicator.tooltip", (Object[])new Object[]{list.size()}));
        }
    }

    private static void debug(@NonNls String message2) {
        LOG.debug(message2);
    }

    private static class IndicatorComponent
    implements StatusBarWidget,
    StatusBarWidget.IconPresentation {
        private StatusBar myStatusBar;
        private Icon myCurrentIcon = AllIcons.Ide.IncomingChangesOff;
        private String myToolTipText;

        private IndicatorComponent() {
        }

        void clear() {
            this.update(AllIcons.Ide.IncomingChangesOff, "No incoming changelists available");
        }

        void setChangesAvailable(@NotNull String toolTipText) {
            this.update(AllIcons.Ide.IncomingChangesOn, toolTipText);
        }

        private void update(@NotNull Icon icon, @Nullable String toolTipText) {
            this.myCurrentIcon = icon;
            this.myToolTipText = toolTipText;
            if (this.myStatusBar != null) {
                this.myStatusBar.updateWidget(this.ID());
            }
        }

        @NotNull
        public Icon getIcon() {
            return this.myCurrentIcon;
        }

        public String getTooltipText() {
            return this.myToolTipText;
        }

        public Consumer<MouseEvent> getClickConsumer() {
            return new Consumer<MouseEvent>(){

                public void consume(MouseEvent mouseEvent) {
                    DataContext dataContext;
                    Project project2;
                    if (myStatusBar != null && (project2 = (Project)CommonDataKeys.PROJECT.getData(dataContext = DataManager.getInstance().getDataContext((Component)myStatusBar))) != null) {
                        ToolWindow changesView = ToolWindowManager.getInstance((Project)project2).getToolWindow(ChangesViewContentManager.TOOLWINDOW_ID);
                        changesView.show(new Runnable(){

                            @Override
                            public void run() {
                                ChangesViewContentManager.getInstance(project2).selectContent("Incoming");
                            }
                        });
                    }
                }
            };
        }

        @NotNull
        public String ID() {
            return "IncomingChanges";
        }

        public StatusBarWidget.WidgetPresentation getPresentation(@NotNull StatusBarWidget.PlatformType type2) {
            return this;
        }

        public void install(@NotNull StatusBar statusBar) {
            this.myStatusBar = statusBar;
        }

        public void dispose() {
            this.myStatusBar = null;
        }
    }
}

