/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.committed;

import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.CommittedChangesProvider;
import com.intellij.openapi.vcs.VcsKey;
import com.intellij.openapi.vcs.changes.ChangeProvider;
import com.intellij.openapi.vcs.checkin.CheckinEnvironment;
import com.intellij.openapi.vcs.diff.DiffProvider;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MockAbstractVcs
extends AbstractVcs {
    private static final String NAME = "mock";
    private static final VcsKey ourKey = MockAbstractVcs.createKey((String)"mock");
    private boolean myMarkExternalChangesAsCurrent = false;
    private CheckinEnvironment myCheckinEnvironment;
    private CommittedChangesProvider myCommittedChangesProvider;
    private DiffProvider myDiffProvider;
    private ChangeProvider myChangeProvider;
    private boolean myAllowNestedRoots;

    public MockAbstractVcs(@NotNull Project project2) {
        super(project2, NAME);
        this.myAllowNestedRoots = false;
    }

    public MockAbstractVcs(@NotNull Project project2, String name) {
        super(project2, name);
    }

    public CheckinEnvironment getCheckinEnvironment() {
        return this.myCheckinEnvironment;
    }

    public CommittedChangesProvider getCommittedChangesProvider() {
        return this.myCommittedChangesProvider;
    }

    public DiffProvider getDiffProvider() {
        return this.myDiffProvider;
    }

    public String getDisplayName() {
        return this.getName();
    }

    public Configurable getConfigurable() {
        return null;
    }

    public ChangeProvider getChangeProvider() {
        return this.myChangeProvider;
    }

    public boolean markExternalChangesAsUpToDate() {
        return this.myMarkExternalChangesAsCurrent;
    }

    public void setMarkExternalChangesAsCurrent(boolean value2) {
        this.myMarkExternalChangesAsCurrent = value2;
    }

    public void setCheckinEnvironment(CheckinEnvironment ce) {
        this.myCheckinEnvironment = ce;
    }

    public void setCommittedChangesProvider(CommittedChangesProvider committedChangesProvider) {
        this.myCommittedChangesProvider = committedChangesProvider;
    }

    public void setDiffProvider(DiffProvider diffProvider) {
        this.myDiffProvider = diffProvider;
    }

    @Nullable
    public VcsRevisionNumber parseRevisionNumber(String revisionNumberString) {
        return new VcsRevisionNumber.Int(Integer.parseInt(revisionNumberString));
    }

    public String getRevisionPattern() {
        return "\\d+";
    }

    public void setChangeProvider(ChangeProvider changeProvider) {
        this.myChangeProvider = changeProvider;
    }

    public static VcsKey getKey() {
        return ourKey;
    }

    public boolean allowsNestedRoots() {
        return this.myAllowNestedRoots;
    }

    public void setAllowNestedRoots(boolean allowNestedRoots) {
        this.myAllowNestedRoots = allowNestedRoots;
    }
}

