/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.conflicts;

import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.options.binding.BindControl;
import com.intellij.openapi.options.binding.BindableConfigurable;
import com.intellij.openapi.options.binding.ControlBinder;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.changes.ChangeListManagerImpl;
import com.intellij.openapi.vcs.changes.conflicts.ChangelistConflictTracker;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.components.JBList;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class ChangelistConflictConfigurable
extends BindableConfigurable
implements SearchableConfigurable,
Configurable.NoScroll {
    private JPanel myPanel;
    private JPanel myOptionsPanel;
    @BindControl(value="TRACKING_ENABLED")
    private JCheckBox myEnableCheckBox;
    @BindControl(value="SHOW_DIALOG")
    private JCheckBox myShowDialogCheckBox;
    @BindControl(value="HIGHLIGHT_CONFLICTS")
    private JCheckBox myHighlightConflictsCheckBox;
    @BindControl(value="HIGHLIGHT_NON_ACTIVE_CHANGELIST")
    private JCheckBox myHighlightNonActiveCheckBox;
    private JBList myIgnoredFiles;
    private JButton myClearButton;
    private boolean myIgnoredFilesCleared;
    private final ChangelistConflictTracker myConflictTracker;

    public ChangelistConflictConfigurable(ChangeListManagerImpl manager) {
        super(new ControlBinder(manager.getConflictTracker().getOptions()));
        this.$$$setupUI$$$();
        this.myEnableCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                UIUtil.setEnabled((Component)ChangelistConflictConfigurable.this.myOptionsPanel, (boolean)ChangelistConflictConfigurable.this.myEnableCheckBox.isSelected(), (boolean)true);
            }
        });
        this.myConflictTracker = manager.getConflictTracker();
        this.myClearButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ChangelistConflictConfigurable.this.myIgnoredFiles.setModel(new DefaultListModel());
                ChangelistConflictConfigurable.this.myIgnoredFilesCleared = true;
                ChangelistConflictConfigurable.this.myClearButton.setEnabled(false);
            }
        });
        this.myIgnoredFiles.getEmptyText().setText(VcsBundle.message((String)"no.ignored.files", (Object[])new Object[0]));
    }

    public JComponent createComponent() {
        this.getBinder().bindAnnotations(this);
        return this.myPanel;
    }

    @Override
    public void reset() {
        super.reset();
        Collection<String> conflicts = this.myConflictTracker.getIgnoredConflicts();
        this.myIgnoredFiles.setListData((Object[])ArrayUtil.toStringArray(conflicts));
        this.myClearButton.setEnabled(!conflicts.isEmpty());
        UIUtil.setEnabled((Component)this.myOptionsPanel, (boolean)this.myEnableCheckBox.isSelected(), (boolean)true);
    }

    @Override
    public void apply() throws ConfigurationException {
        super.apply();
        if (this.myIgnoredFilesCleared) {
            for (ChangelistConflictTracker.Conflict conflict : this.myConflictTracker.getConflicts().values()) {
                conflict.ignored = false;
            }
        }
        this.myConflictTracker.optionsChanged();
    }

    @Override
    public boolean isModified() {
        return super.isModified() || this.myIgnoredFiles.getModel().getSize() != this.myConflictTracker.getIgnoredConflicts().size();
    }

    @Nls
    public String getDisplayName() {
        return "Changelist Conflicts";
    }

    public String getHelpTopic() {
        return "project.propVCSSupport.ChangelistConflict";
    }

    @NotNull
    public String getId() {
        return this.getHelpTopic();
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JButton jButton;
        JBList jBList;
        JCheckBox jCheckBox;
        JCheckBox jCheckBox2;
        JCheckBox jCheckBox3;
        JPanel jPanel;
        JCheckBox jCheckBox4;
        JPanel jPanel2;
        this.myPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(3, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.myEnableCheckBox = jCheckBox4 = new JCheckBox();
        jCheckBox4.setText("Enable changelist conflict tracking");
        jPanel2.add((Component)jCheckBox4, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myOptionsPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(4, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null, 2));
        this.myShowDialogCheckBox = jCheckBox3 = new JCheckBox();
        jCheckBox3.setText("Show conflict resolving dialog ");
        jCheckBox3.setMnemonic('D');
        jCheckBox3.setDisplayedMnemonicIndex(24);
        jPanel.add((Component)jCheckBox3, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myHighlightConflictsCheckBox = jCheckBox2 = new JCheckBox();
        jCheckBox2.setText("Highlight files with conflicts");
        jCheckBox2.setMnemonic('H');
        jCheckBox2.setDisplayedMnemonicIndex(0);
        jPanel.add((Component)jCheckBox2, new GridConstraints(1, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myHighlightNonActiveCheckBox = jCheckBox = new JCheckBox();
        jCheckBox.setText("Highlight files from non-active changelists");
        jCheckBox.setMnemonic('N');
        jCheckBox.setDisplayedMnemonicIndex(21);
        jPanel.add((Component)jCheckBox, new GridConstraints(2, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(2, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel3.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithoutIndent");
        jPanel.add((Component)jPanel3, new GridConstraints(3, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        jPanel3.setBorder(IdeBorderFactory.PlainSmallWithoutIndent.createTitledBorder(null, (String)"Files with ignored conflicts", (int)0, (int)0, null, null));
        JBScrollPane jBScrollPane = new JBScrollPane();
        jPanel3.add((Component)jBScrollPane, new GridConstraints(0, 0, 1, 2, 0, 3, 7, 7, null, null, null));
        this.myIgnoredFiles = jBList = new JBList();
        jBScrollPane.setViewportView((Component)jBList);
        this.myClearButton = jButton = new JButton();
        jButton.setText("Clear");
        jPanel3.add((Component)jButton, new GridConstraints(1, 1, 1, 1, 0, 1, 3, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel3.add((Component)spacer, new GridConstraints(1, 0, 1, 1, 0, 1, 6, 1, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel2.add((Component)spacer2, new GridConstraints(2, 0, 1, 1, 0, 2, 1, 6, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }
}

