/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.patch;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diff.impl.patch.BinaryFilePatch;
import com.intellij.openapi.diff.impl.patch.FilePatch;
import com.intellij.openapi.diff.impl.patch.TextFilePatch;
import com.intellij.openapi.diff.impl.patch.apply.GenericPatchApplier;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vcs.ObjectsConvertor;
import com.intellij.openapi.vcs.changes.patch.AbstractFilePatchInProgress;
import com.intellij.openapi.vcs.changes.patch.AutoMatchStrategy;
import com.intellij.openapi.vcs.changes.patch.BinaryFilePatchInProgress;
import com.intellij.openapi.vcs.changes.patch.PatchBaseDirectoryDetector;
import com.intellij.openapi.vcs.changes.patch.ShelvedBinaryFilePatchInProgress;
import com.intellij.openapi.vcs.changes.patch.TextFilePatchInProgress;
import com.intellij.openapi.vcs.changes.shelf.ShelveChangesManager;
import com.intellij.openapi.vcs.changes.shelf.ShelvedBinaryFilePatch;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.Convertor;
import com.intellij.util.containers.MultiMap;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MatchPatchPaths {
    private static final int BIG_FILE_BOUND = 100000;
    private final Project myProject;
    private final VirtualFile myBaseDir;
    private boolean myUseProjectRootAsPredefinedBase;

    public MatchPatchPaths(Project project2) {
        this.myProject = project2;
        this.myBaseDir = this.myProject.getBaseDir();
    }

    public List<AbstractFilePatchInProgress> execute(@NotNull List<? extends FilePatch> list) {
        return this.execute(list, false);
    }

    public List<AbstractFilePatchInProgress> execute(@NotNull List<? extends FilePatch> list, boolean useProjectRootAsPredefinedBase) {
        PatchBaseDirectoryDetector directoryDetector = PatchBaseDirectoryDetector.getInstance(this.myProject);
        this.myUseProjectRootAsPredefinedBase = useProjectRootAsPredefinedBase;
        ArrayList<PatchAndVariants> candidates = new ArrayList<PatchAndVariants>(list.size());
        ArrayList<FilePatch> newOrWithoutMatches = new ArrayList<FilePatch>();
        this.findCandidates(list, directoryDetector, candidates, newOrWithoutMatches);
        MultiMap result2 = new MultiMap();
        MatchPatchPaths.filterExactMatches(candidates, (MultiMap<VirtualFile, AbstractFilePatchInProgress>)result2);
        MatchPatchPaths.selectByContextOrByStrip(candidates, (MultiMap<VirtualFile, AbstractFilePatchInProgress>)result2);
        this.workWithNotExisting(directoryDetector, newOrWithoutMatches, (MultiMap<VirtualFile, AbstractFilePatchInProgress>)result2);
        return new ArrayList<AbstractFilePatchInProgress>(result2.values());
    }

    private void workWithNotExisting(@NotNull PatchBaseDirectoryDetector directoryDetector, @NotNull List<FilePatch> newOrWithoutMatches, @NotNull MultiMap<VirtualFile, AbstractFilePatchInProgress> result2) {
        for (FilePatch patch : newOrWithoutMatches) {
            AbstractFilePatchInProgress patchInProgress;
            String afterName = patch.getAfterName();
            String[] strings = afterName != null ? afterName.replace('\\', '/').split("/") : ArrayUtil.EMPTY_STRING_ARRAY;
            Pair<VirtualFile, Integer> best = null;
            for (int i2 = strings.length - 2; i2 >= 0; --i2) {
                String name = strings[i2];
                Collection<VirtualFile> files = this.findFilesFromIndex(directoryDetector, name);
                if (files.isEmpty()) continue;
                for (VirtualFile file2 : files) {
                    Pair<VirtualFile, Integer> pair = MatchPatchPaths.compareNamesImpl(strings, file2, i2);
                    if (pair == null || (Integer)pair.getSecond() >= i2 || best != null && (Integer)pair.getSecond() >= (Integer)best.getSecond() && !this.isGoodAndProjectBased(best, pair)) continue;
                    best = pair;
                }
            }
            if (best != null) {
                patchInProgress = MatchPatchPaths.createPatchInProgress(patch, (VirtualFile)best.getFirst());
                if (patchInProgress == null) break;
                AutoMatchStrategy.processStipUp(patchInProgress, (Integer)best.getSecond());
                result2.putValue(best.getFirst(), (Object)patchInProgress);
                continue;
            }
            patchInProgress = MatchPatchPaths.createPatchInProgress(patch, this.myBaseDir);
            if (patchInProgress == null) break;
            result2.putValue((Object)this.myBaseDir, (Object)patchInProgress);
        }
    }

    private boolean isGoodAndProjectBased(@NotNull Pair<VirtualFile, Integer> bestVariant, @NotNull Pair<VirtualFile, Integer> currentVariant) {
        return ((Integer)currentVariant.getSecond()).equals(bestVariant.getSecond()) && this.myBaseDir.equals(currentVariant.getFirst());
    }

    private static void selectByContextOrByStrip(@NotNull List<PatchAndVariants> candidates, @NotNull MultiMap<VirtualFile, AbstractFilePatchInProgress> result2) {
        for (PatchAndVariants candidate : candidates) {
            candidate.findAndAddBestVariant(result2);
        }
    }

    private static void filterExactMatches(@NotNull List<PatchAndVariants> candidates, @NotNull MultiMap<VirtualFile, AbstractFilePatchInProgress> result2) {
        Iterator<PatchAndVariants> iterator = candidates.iterator();
        while (iterator.hasNext()) {
            PatchAndVariants candidate = iterator.next();
            if (candidate.getVariants().size() == 1) {
                AbstractFilePatchInProgress oneCandidate = candidate.getVariants().get(0);
                result2.putValue((Object)oneCandidate.getBase(), (Object)oneCandidate);
                iterator.remove();
                continue;
            }
            ArrayList<AbstractFilePatchInProgress> exact = new ArrayList<AbstractFilePatchInProgress>(candidate.getVariants().size());
            for (AbstractFilePatchInProgress patch : candidate.getVariants()) {
                if (patch.getCurrentStrip() != 0) continue;
                exact.add(patch);
            }
            if (exact.size() == 1) {
                AbstractFilePatchInProgress patchInProgress = (AbstractFilePatchInProgress)exact.get(0);
                MatchPatchPaths.putSelected(result2, candidate.getVariants(), patchInProgress);
                iterator.remove();
                continue;
            }
            if (exact.isEmpty()) continue;
            candidate.getVariants().retainAll(exact);
        }
    }

    private void findCandidates(@NotNull List<? extends FilePatch> list, @NotNull PatchBaseDirectoryDetector directoryDetector, @NotNull List<PatchAndVariants> candidates, @NotNull List<FilePatch> newOrWithoutMatches) {
        for (final FilePatch filePatch : list) {
            VirtualFile relativeFile;
            String fileName = filePatch.getBeforeFileName();
            if (filePatch.isNewFile() || filePatch.getBeforeName() == null) {
                newOrWithoutMatches.add(filePatch);
                continue;
            }
            ArrayList<VirtualFile> files = new ArrayList<VirtualFile>(this.findFilesFromIndex(directoryDetector, fileName));
            if (filePatch.getBeforeName() != null && filePatch.getBeforeName().startsWith("..") && (relativeFile = VfsUtil.findRelativeFile((VirtualFile)this.myBaseDir, (String[])filePatch.getBeforeName().replace('\\', '/').split("/"))) != null) {
                files.add(relativeFile);
            }
            if (files.isEmpty()) {
                newOrWithoutMatches.add(filePatch);
                continue;
            }
            List<AbstractFilePatchInProgress> variants = ObjectsConvertor.convert(files, new Convertor<VirtualFile, AbstractFilePatchInProgress>(){

                public AbstractFilePatchInProgress convert(VirtualFile o) {
                    return MatchPatchPaths.processMatch(filePatch, o);
                }
            }, ObjectsConvertor.NOT_NULL);
            if (variants.isEmpty()) {
                newOrWithoutMatches.add(filePatch);
                continue;
            }
            candidates.add(new PatchAndVariants(variants));
        }
    }

    private Collection<VirtualFile> findFilesFromIndex(final @NotNull PatchBaseDirectoryDetector directoryDetector, final @NotNull String fileName) {
        Collection files = (Collection)ApplicationManager.getApplication().runReadAction((Computable)new Computable<Collection<VirtualFile>>(){

            public Collection<VirtualFile> compute() {
                return directoryDetector.findFiles(fileName);
            }
        });
        File shelfResourcesDirectory = ShelveChangesManager.getInstance(this.myProject).getShelfResourcesDirectory();
        return ContainerUtil.filter((Collection)files, file2 -> !FileUtil.isAncestor((File)shelfResourcesDirectory, (File)VfsUtilCore.virtualToIoFile((VirtualFile)file2), (boolean)false));
    }

    private static void putSelected(@NotNull MultiMap<VirtualFile, AbstractFilePatchInProgress> result2, @NotNull List<AbstractFilePatchInProgress> variants, @NotNull AbstractFilePatchInProgress patchInProgress) {
        patchInProgress.setAutoBases(ObjectsConvertor.convert(variants, new Convertor<AbstractFilePatchInProgress, VirtualFile>(){

            public VirtualFile convert(AbstractFilePatchInProgress o) {
                return o.getBase();
            }
        }, ObjectsConvertor.NOT_NULL));
        result2.putValue((Object)patchInProgress.getBase(), (Object)patchInProgress);
    }

    private static int getMatchingLines(AbstractFilePatchInProgress<TextFilePatch> patch) {
        String text;
        VirtualFile base = patch.getCurrentBase();
        if (base == null) {
            return -1;
        }
        try {
            text = base.getLength() > 100000L ? VfsUtilCore.loadText((VirtualFile)base, (int)100000) : VfsUtilCore.loadText((VirtualFile)base);
        }
        catch (IOException e) {
            return 0;
        }
        return new GenericPatchApplier(text, patch.getPatch().getHunks()).weightContextMatch(100, 5);
    }

    private boolean variantMatchedToProjectDir(@NotNull AbstractFilePatchInProgress variant) {
        return variant.getCurrentStrip() == 0 && this.myProject.getBaseDir().equals(variant.getBase());
    }

    private static Pair<VirtualFile, Integer> compareNames(String beforeName, VirtualFile file2) {
        if (beforeName == null) {
            return null;
        }
        String[] parts = beforeName.replace('\\', '/').split("/");
        return MatchPatchPaths.compareNamesImpl(parts, file2.getParent(), parts.length - 2);
    }

    private static Pair<VirtualFile, Integer> compareNamesImpl(String[] parts, VirtualFile parent, int idx) {
        while (parent != null && idx >= 0) {
            if (!parent.getName().equals(parts[idx])) {
                return new Pair((Object)parent, (Object)(idx + 1));
            }
            parent = parent.getParent();
            --idx;
        }
        return new Pair((Object)parent, (Object)(idx + 1));
    }

    @Nullable
    private static AbstractFilePatchInProgress processMatch(FilePatch patch, VirtualFile file2) {
        String beforeName = patch.getBeforeName();
        Pair<VirtualFile, Integer> pair = MatchPatchPaths.compareNames(beforeName, file2);
        if (pair == null) {
            return null;
        }
        VirtualFile parent = (VirtualFile)pair.getFirst();
        if (parent == null) {
            return null;
        }
        AbstractFilePatchInProgress result2 = MatchPatchPaths.createPatchInProgress(patch, parent);
        if (result2 != null) {
            AutoMatchStrategy.processStipUp(result2, (Integer)pair.getSecond());
        }
        return result2;
    }

    @Nullable
    private static AbstractFilePatchInProgress createPatchInProgress(@NotNull FilePatch patch, @NotNull VirtualFile dir) {
        if (patch instanceof TextFilePatch) {
            return new TextFilePatchInProgress((TextFilePatch)patch, null, dir);
        }
        if (patch instanceof ShelvedBinaryFilePatch) {
            return new ShelvedBinaryFilePatchInProgress((ShelvedBinaryFilePatch)patch, null, dir);
        }
        if (patch instanceof BinaryFilePatch) {
            return new BinaryFilePatchInProgress((BinaryFilePatch)patch, null, dir);
        }
        return null;
    }

    private class PatchAndVariants {
        @NotNull
        private final List<AbstractFilePatchInProgress> myVariants;

        private PatchAndVariants(List<AbstractFilePatchInProgress> variants) {
            this.myVariants = variants;
        }

        @NotNull
        public List<AbstractFilePatchInProgress> getVariants() {
            return this.myVariants;
        }

        public void findAndAddBestVariant(@NotNull MultiMap<VirtualFile, AbstractFilePatchInProgress> result2) {
            AbstractFilePatchInProgress best = (AbstractFilePatchInProgress)ContainerUtil.getFirstItem(this.myVariants);
            if (best == null) {
                return;
            }
            if (best instanceof TextFilePatchInProgress) {
                int maxLines = -100;
                for (AbstractFilePatchInProgress variant : this.myVariants) {
                    TextFilePatchInProgress textFilePAch = (TextFilePatchInProgress)variant;
                    if (MatchPatchPaths.this.myUseProjectRootAsPredefinedBase && MatchPatchPaths.this.variantMatchedToProjectDir(textFilePAch)) {
                        best = textFilePAch;
                        break;
                    }
                    int lines = MatchPatchPaths.getMatchingLines(textFilePAch);
                    if (lines <= maxLines) continue;
                    maxLines = lines;
                    best = textFilePAch;
                }
                MatchPatchPaths.putSelected((MultiMap<VirtualFile, AbstractFilePatchInProgress>)result2, this.myVariants, best);
            } else {
                int stripCounter = Integer.MAX_VALUE;
                for (AbstractFilePatchInProgress variant : this.myVariants) {
                    int currentStrip = variant.getCurrentStrip();
                    if (MatchPatchPaths.this.variantMatchedToProjectDir(variant)) {
                        best = variant;
                        break;
                    }
                    if (currentStrip >= stripCounter) continue;
                    best = variant;
                    stripCounter = currentStrip;
                }
                MatchPatchPaths.putSelected((MultiMap<VirtualFile, AbstractFilePatchInProgress>)result2, this.myVariants, best);
            }
        }
    }
}

