/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.patch;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.vcs.changes.patch.PatchBaseDirectoryDetector;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.FilenameIndex;
import com.intellij.psi.search.GlobalSearchScope;
import java.util.Collection;
import org.jetbrains.annotations.Nullable;

public class PsiPatchBaseDirectoryDetector
extends PatchBaseDirectoryDetector {
    private final Project myProject;

    public PsiPatchBaseDirectoryDetector(Project project2) {
        this.myProject = project2;
    }

    @Override
    @Nullable
    public PatchBaseDirectoryDetector.Result detectBaseDirectory(String patchFileName) {
        String[] nameComponents = patchFileName.split("/");
        String patchName = nameComponents[nameComponents.length - 1];
        if (patchName.isEmpty()) {
            return null;
        }
        PsiFile[] psiFiles2 = FilenameIndex.getFilesByName(this.myProject, patchName, GlobalSearchScope.projectScope((Project)this.myProject));
        if (psiFiles2.length == 1) {
            PsiDirectory parent = psiFiles2[0].getContainingDirectory();
            for (int i2 = nameComponents.length - 2; i2 >= 0; --i2) {
                if (!parent.getName().equals(nameComponents[i2]) || Comparing.equal((Object)parent.getVirtualFile(), (Object)this.myProject.getBaseDir())) {
                    return new PatchBaseDirectoryDetector.Result(parent.getVirtualFile().getPresentableUrl(), i2 + 1);
                }
                parent = parent.getParentDirectory();
            }
            if (parent == null) {
                return null;
            }
            return new PatchBaseDirectoryDetector.Result(parent.getVirtualFile().getPresentableUrl(), 0);
        }
        return null;
    }

    @Override
    public Collection<VirtualFile> findFiles(String fileName) {
        return FilenameIndex.getVirtualFilesByName(this.myProject, fileName, GlobalSearchScope.projectScope((Project)this.myProject));
    }
}

