/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.patch.tool;

import com.intellij.diff.DiffContentFactory;
import com.intellij.diff.DiffContext;
import com.intellij.diff.DiffDialogHints;
import com.intellij.diff.DiffManager;
import com.intellij.diff.actions.ProxyUndoRedoAction;
import com.intellij.diff.actions.impl.FocusOppositePaneAction;
import com.intellij.diff.actions.impl.SetEditorSettingsAction;
import com.intellij.diff.contents.DiffContent;
import com.intellij.diff.contents.DocumentContent;
import com.intellij.diff.merge.MergeModelBase;
import com.intellij.diff.requests.DiffRequest;
import com.intellij.diff.requests.SimpleDiffRequest;
import com.intellij.diff.tools.fragmented.LineNumberConvertor;
import com.intellij.diff.tools.holders.TextEditorHolder;
import com.intellij.diff.tools.util.DiffDataKeys;
import com.intellij.diff.tools.util.DiffSplitter;
import com.intellij.diff.tools.util.FocusTrackerSupport;
import com.intellij.diff.tools.util.FoldingModelSupport;
import com.intellij.diff.tools.util.PrevNextDifferenceIterableBase;
import com.intellij.diff.tools.util.SimpleDiffPanel;
import com.intellij.diff.tools.util.StatusPanel;
import com.intellij.diff.tools.util.SyncScrollSupport;
import com.intellij.diff.tools.util.base.TextDiffSettingsHolder;
import com.intellij.diff.tools.util.base.TextDiffViewerUtil;
import com.intellij.diff.tools.util.side.TwosideContentPanel;
import com.intellij.diff.util.DiffDividerDrawUtil;
import com.intellij.diff.util.DiffDrawUtil;
import com.intellij.diff.util.DiffUserDataKeys;
import com.intellij.diff.util.DiffUtil;
import com.intellij.diff.util.LineRange;
import com.intellij.diff.util.Side;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.CompositeShortcutSet;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.command.UndoConfirmationPolicy;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diff.DiffBundle;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.event.VisibleAreaListener;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.EditorMarkupModel;
import com.intellij.openapi.editor.impl.DocumentImpl;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.BooleanGetter;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.changes.patch.AppliedTextPatch;
import com.intellij.openapi.vcs.changes.patch.tool.ApplyPatchChange;
import com.intellij.openapi.vcs.changes.patch.tool.ApplyPatchRequest;
import com.intellij.openapi.vcs.changes.patch.tool.PatchChangeBuilder;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.TIntArrayList;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import javax.swing.JComponent;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class ApplyPatchViewer
implements DataProvider,
Disposable {
    private static final Logger LOG = Logger.getInstance(ApplyPatchViewer.class);
    @Nullable
    private final Project myProject;
    @NotNull
    private final DiffContext myContext;
    @NotNull
    private final ApplyPatchRequest myPatchRequest;
    @NotNull
    private final TextEditorHolder myResultHolder;
    @NotNull
    private final TextEditorHolder myPatchHolder;
    @NotNull
    private final EditorEx myResultEditor;
    @NotNull
    private final EditorEx myPatchEditor;
    @NotNull
    private final SimpleDiffPanel myPanel;
    @NotNull
    private final TwosideContentPanel myContentPanel;
    @NotNull
    private final MyModel myModel;
    @NotNull
    private final FocusTrackerSupport<Side> myFocusTrackerSupport;
    @NotNull
    private final MyPrevNextDifferenceIterable myPrevNextDifferenceIterable;
    @NotNull
    private final StatusPanel myStatusPanel;
    @NotNull
    private final MyFoldingModel myFoldingModel;
    @NotNull
    private final SetEditorSettingsAction myEditorSettingsAction;
    @NotNull
    private final List<ApplyPatchChange> myResultChanges = new ArrayList<ApplyPatchChange>();
    @NotNull
    private final List<ApplyPatchChange> myPatchChanges = new ArrayList<ApplyPatchChange>();
    @NotNull
    private final List<ApplyPatchChange> myModelChanges = new ArrayList<ApplyPatchChange>();
    private boolean myDisposed;

    public ApplyPatchViewer(@NotNull DiffContext context, @NotNull ApplyPatchRequest request) {
        this.myProject = context.getProject();
        this.myContext = context;
        this.myPatchRequest = request;
        DocumentContent resultContent = request.getResultContent();
        DocumentContent patchContent = DiffContentFactory.getInstance().create((Document)new DocumentImpl("", true), resultContent);
        this.myResultHolder = TextEditorHolder.create(this.myProject, resultContent);
        this.myPatchHolder = TextEditorHolder.create(this.myProject, patchContent);
        this.myResultEditor = this.myResultHolder.getEditor();
        this.myPatchEditor = this.myPatchHolder.getEditor();
        if (this.isReadOnly()) {
            this.myResultEditor.setViewer(true);
        }
        this.myPatchEditor.setViewer(true);
        DiffUtil.disableBlitting(this.myResultEditor);
        DiffUtil.disableBlitting(this.myPatchEditor);
        ((EditorMarkupModel)((Object)this.myResultEditor.getMarkupModel())).setErrorStripeVisible(false);
        this.myResultEditor.setVerticalScrollbarOrientation(0);
        this.myPatchEditor.getGutterComponentEx().setForceShowRightFreePaintersArea(true);
        ((EditorMarkupModel)((Object)this.myPatchEditor.getMarkupModel())).setErrorStripeVisible(false);
        List holders = ContainerUtil.list((Object[])new TextEditorHolder[]{this.myResultHolder, this.myPatchHolder});
        List editors = ContainerUtil.list((Object[])new EditorEx[]{this.myResultEditor, this.myPatchEditor});
        JComponent resultTitle = DiffUtil.createTitle(this.myPatchRequest.getResultTitle());
        JComponent patchTitle = DiffUtil.createTitle(this.myPatchRequest.getPatchTitle());
        List<JComponent> titleComponents = DiffUtil.createSyncHeightComponents(ContainerUtil.list((Object[])new JComponent[]{resultTitle, patchTitle}));
        this.myContentPanel = new TwosideContentPanel(holders, titleComponents);
        this.myPanel = new SimpleDiffPanel(this.myContentPanel, (DataProvider)this, this.myContext);
        this.myModel = new MyModel(this.myProject, this.myResultEditor.getDocument());
        this.myFocusTrackerSupport = new FocusTrackerSupport.Twoside(holders);
        this.myFocusTrackerSupport.setCurrentSide(Side.LEFT);
        this.myPrevNextDifferenceIterable = new MyPrevNextDifferenceIterable();
        this.myStatusPanel = new MyStatusPanel();
        this.myFoldingModel = new MyFoldingModel(this.myResultEditor, (Disposable)this);
        new MyFocusOppositePaneAction().install(this.myPanel);
        new TextDiffViewerUtil.EditorActionsPopup(this.createEditorPopupActions()).install(editors);
        new TextDiffViewerUtil.EditorFontSizeSynchronizer(editors).install(this);
        this.myEditorSettingsAction = new SetEditorSettingsAction(this.getTextSettings(), editors);
        this.myEditorSettingsAction.applyDefaults();
        if (!this.isReadOnly()) {
            DiffUtil.registerAction((AnAction)new ApplySelectedChangesAction(true), this.myPanel);
            DiffUtil.registerAction((AnAction)new IgnoreSelectedChangesAction(true), this.myPanel);
        }
        ProxyUndoRedoAction.register(this.myProject, this.myResultEditor, this.myContentPanel);
    }

    @NotNull
    protected List<AnAction> createToolbarActions() {
        ArrayList<AnAction> group = new ArrayList<AnAction>();
        if (!this.isReadOnly()) {
            group.add((AnAction)new MyToggleExpandByDefaultAction());
            group.add((AnAction)this.myEditorSettingsAction);
            group.add((AnAction)Separator.getInstance());
            group.add((AnAction)new ShowDiffWithLocalAction());
            group.add((AnAction)new ApplyNonConflictsAction());
        }
        return group;
    }

    @NotNull
    private List<AnAction> createEditorPopupActions() {
        ArrayList<AnAction> group = new ArrayList<AnAction>();
        if (!this.isReadOnly()) {
            group.add((AnAction)new ApplySelectedChangesAction(false));
            group.add((AnAction)new IgnoreSelectedChangesAction(false));
        }
        group.add((AnAction)Separator.getInstance());
        group.addAll(TextDiffViewerUtil.createEditorPopupActions());
        return group;
    }

    public void dispose() {
        if (this.myDisposed) {
            return;
        }
        this.myDisposed = true;
        this.myFoldingModel.destroy();
        Disposer.dispose((Disposable)this.myModel);
        Disposer.dispose((Disposable)this.myResultHolder);
        Disposer.dispose((Disposable)this.myPatchHolder);
    }

    public boolean isReadOnly() {
        return !DiffUtil.canMakeWritable(this.myResultEditor.getDocument());
    }

    @NotNull
    public MyModel getModel() {
        return this.myModel;
    }

    @NotNull
    public List<ApplyPatchChange> getModelChanges() {
        return this.myModelChanges;
    }

    public boolean isDisposed() {
        return this.myDisposed;
    }

    @NotNull
    public StatusPanel getStatusPanel() {
        return this.myStatusPanel;
    }

    @NotNull
    public JComponent getComponent() {
        return this.myPanel;
    }

    @Nullable
    public JComponent getPreferredFocusedComponent() {
        return this.myResultEditor.getContentComponent();
    }

    @NotNull
    public EditorEx getResultEditor() {
        return this.myResultEditor;
    }

    @NotNull
    public EditorEx getPatchEditor() {
        return this.myPatchEditor;
    }

    @NotNull
    public Side getCurrentSide() {
        return this.myFocusTrackerSupport.getCurrentSide();
    }

    @NotNull
    public List<ApplyPatchChange> getPatchChanges() {
        return this.myPatchChanges;
    }

    @Nullable
    public Object getData(@NonNls String dataId) {
        if (CommonDataKeys.PROJECT.is(dataId)) {
            return this.myProject;
        }
        if (DiffDataKeys.PREV_NEXT_DIFFERENCE_ITERABLE.is(dataId)) {
            return this.myPrevNextDifferenceIterable;
        }
        return null;
    }

    @NotNull
    public TextDiffSettingsHolder.TextDiffSettings getTextSettings() {
        return TextDiffSettingsHolder.TextDiffSettings.getSettings("ApplyPatch");
    }

    @NotNull
    public FoldingModelSupport.Settings getFoldingModelSettings() {
        TextDiffSettingsHolder.TextDiffSettings settings = this.getTextSettings();
        return new FoldingModelSupport.Settings(settings.getContextRange(), settings.isExpandByDefault());
    }

    protected void initPatchViewer() {
        DocumentEx outputDocument = this.myResultEditor.getDocument();
        boolean success = DiffUtil.executeWriteCommand(outputDocument, this.myProject, "Init merge content", () -> {
            outputDocument.setText(this.myPatchRequest.getLocalContent());
            if (!this.isReadOnly()) {
                DiffUtil.putNonundoableOperation(this.myProject, outputDocument);
            }
        });
        if (!success && !StringUtil.equals((CharSequence)outputDocument.getText(), (CharSequence)this.myPatchRequest.getLocalContent())) {
            this.myPanel.setErrorContent("Failed to display patch applier - local content was modified");
            return;
        }
        PatchChangeBuilder builder = new PatchChangeBuilder();
        builder.exec(this.myPatchRequest.getPatch().getHunks());
        DocumentEx patchDocument = this.myPatchEditor.getDocument();
        patchDocument.setText(builder.getPatchContent());
        LineNumberConvertor convertor1 = builder.getLineConvertor1();
        LineNumberConvertor convertor2 = builder.getLineConvertor2();
        this.myPatchEditor.getGutterComponentEx().setLineNumberConvertor(convertor1.createConvertor(), convertor2.createConvertor());
        TIntArrayList lines = builder.getSeparatorLines();
        for (int i2 = 0; i2 < lines.size(); ++i2) {
            int offset = patchDocument.getLineStartOffset(lines.get(i2));
            DiffDrawUtil.createLineSeparatorHighlighter(this.myPatchEditor, offset, offset, BooleanGetter.TRUE);
        }
        List<PatchChangeBuilder.Hunk> hunks = builder.getHunks();
        int[] modelToPatchIndexes = DiffUtil.getSortedIndexes(hunks, (h1, h2) -> {
            LineRange lines1 = h1.getAppliedToLines();
            LineRange lines2 = h2.getAppliedToLines();
            if (lines1 == null && lines2 == null) {
                return 0;
            }
            if (lines1 == null) {
                return -1;
            }
            if (lines2 == null) {
                return 1;
            }
            return lines1.start - lines2.start;
        });
        int[] patchToModelIndexes = DiffUtil.invertIndexes(modelToPatchIndexes);
        ArrayList<LineRange> modelRanges = new ArrayList<LineRange>();
        for (int modelIndex = 0; modelIndex < hunks.size(); ++modelIndex) {
            int patchIndex = modelToPatchIndexes[modelIndex];
            PatchChangeBuilder.Hunk hunk = hunks.get(patchIndex);
            LineRange resultRange = hunk.getAppliedToLines();
            ApplyPatchChange change = new ApplyPatchChange(hunk, modelIndex, this);
            this.myModelChanges.add(change);
            if (resultRange != null) {
                this.myResultChanges.add(change);
            }
            modelRanges.add(resultRange != null ? resultRange : new LineRange(-1, -1));
        }
        this.myModel.setChanges(modelRanges);
        for (int index : patchToModelIndexes) {
            this.myPatchChanges.add(this.myModelChanges.get(index));
        }
        this.myFoldingModel.install(this.myResultChanges, this.getFoldingModelSettings());
        Object modelIndex = this.myModelChanges.iterator();
        while (modelIndex.hasNext()) {
            ApplyPatchChange change = (ApplyPatchChange)modelIndex.next();
            change.reinstallHighlighters();
        }
        this.myStatusPanel.update();
        this.myContentPanel.setPainter(new MyDividerPainter());
        VisibleAreaListener areaListener = e -> this.myContentPanel.repaint();
        this.myResultEditor.getScrollingModel().addVisibleAreaListener(areaListener);
        this.myPatchEditor.getScrollingModel().addVisibleAreaListener(areaListener);
        this.myPatchEditor.getGutterComponentEx().revalidateMarkup();
        if (this.myResultChanges.size() > 0) {
            this.scrollToChange(this.myResultChanges.get(0), Side.LEFT, true);
        }
    }

    public void scrollToChange(@NotNull ApplyPatchChange change, @NotNull Side masterSide, boolean forceScroll) {
        if (change.getResultRange() == null) {
            DiffUtil.moveCaret(this.myPatchEditor, change.getPatchRange().start);
            this.myPatchEditor.getScrollingModel().scrollToCaret(forceScroll ? ScrollType.CENTER : ScrollType.MAKE_VISIBLE);
        } else {
            LineRange resultRange = change.getResultRange();
            LineRange patchRange = change.getPatchAffectedRange();
            int topShift = -1;
            if (!forceScroll) {
                int masterLine = masterSide.select(resultRange.start, patchRange.start);
                EditorEx masterEditor = (EditorEx)masterSide.select((Object)this.myResultEditor, (Object)this.myPatchEditor);
                int targetY = masterEditor.logicalPositionToXY((LogicalPosition)new LogicalPosition((int)masterLine, (int)0)).y;
                int scrollOffset = masterEditor.getScrollingModel().getVerticalScrollOffset();
                topShift = targetY - scrollOffset;
            }
            int[] offsets = SyncScrollSupport.getTargetOffsets(this.myResultEditor, this.myPatchEditor, resultRange.start, resultRange.end, patchRange.start, patchRange.end, topShift);
            DiffUtil.moveCaret(this.myResultEditor, resultRange.start);
            DiffUtil.moveCaret(this.myPatchEditor, patchRange.start);
            DiffUtil.scrollToPoint(this.myResultEditor, new Point(0, offsets[0]), false);
            DiffUtil.scrollToPoint(this.myPatchEditor, new Point(0, offsets[1]), false);
        }
    }

    public void repaintDivider() {
        this.myContentPanel.repaintDivider();
    }

    public boolean executeCommand(@Nullable String commandName, @NotNull Runnable task) {
        return this.myModel.executeMergeCommand(commandName, null, UndoConfirmationPolicy.DEFAULT, false, null, task);
    }

    protected void onChangeResolved() {
        if (this.isDisposed()) {
            return;
        }
        this.myStatusPanel.update();
    }

    public void markChangeResolved(@NotNull ApplyPatchChange change) {
        if (change.isResolved()) {
            return;
        }
        change.setResolved(true);
        this.myModel.invalidateHighlighters(change.getIndex());
        this.onChangeResolved();
    }

    public void replaceChange(@NotNull ApplyPatchChange change) {
        LineRange resultRange = change.getResultRange();
        LineRange patchRange = change.getPatchInsertionRange();
        if (resultRange == null || change.isResolved()) {
            return;
        }
        if (change.getStatus() != AppliedTextPatch.HunkStatus.EXACTLY_APPLIED) {
            return;
        }
        List<String> newContent = DiffUtil.getLines(this.myPatchEditor.getDocument(), patchRange.start, patchRange.end);
        this.myModel.replaceChange(change.getIndex(), newContent);
        this.markChangeResolved(change);
    }

    private class MyStatusPanel
    extends StatusPanel {
        private MyStatusPanel() {
        }

        @Override
        @Nullable
        protected String getMessage() {
            int totalUnresolved = 0;
            int alreadyApplied = 0;
            int notApplied = 0;
            for (ApplyPatchChange change : ApplyPatchViewer.this.myPatchChanges) {
                if (change.isResolved()) continue;
                ++totalUnresolved;
                switch (change.getStatus()) {
                    case ALREADY_APPLIED: {
                        ++alreadyApplied;
                        break;
                    }
                    case NOT_APPLIED: {
                        ++notApplied;
                        break;
                    }
                }
            }
            if (totalUnresolved == 0) {
                return DiffBundle.message((String)"apply.somehow.status.message.all.applied", (Object[])new Object[]{notApplied});
            }
            if (totalUnresolved == notApplied) {
                return DiffBundle.message((String)"apply.somehow.status.message.cant.apply", (Object[])new Object[]{notApplied});
            }
            String message2 = DiffBundle.message((String)"apply.somehow.status.message.cant.apply.some", (Object[])new Object[]{notApplied, totalUnresolved});
            if (alreadyApplied == 0) {
                return message2;
            }
            return message2 + ". " + DiffBundle.message((String)"apply.somehow.status.message.already.applied", (Object[])new Object[]{alreadyApplied});
        }
    }

    private static class MyFoldingModel
    extends FoldingModelSupport {
        public MyFoldingModel(@NotNull EditorEx editor, @NotNull Disposable disposable) {
            super(new EditorEx[]{editor}, disposable);
        }

        /*
         * Exception decompiling
         */
        public void install(@Nullable List<ApplyPatchChange> changes, @NotNull FoldingModelSupport.Settings settings) {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * java.lang.UnsupportedOperationException
             *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.NewAnonymousArray.getDimSize(NewAnonymousArray.java:142)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.isNewArrayLambda(LambdaRewriter.java:455)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:409)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
             *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
             *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.StaticFunctionInvokation.applyExpressionRewriterToArgs(StaticFunctionInvokation.java:103)
             *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.StaticFunctionInvokation.applyExpressionRewriter(StaticFunctionInvokation.java:90)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
             *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredAssignment.rewriteExpressions(StructuredAssignment.java:146)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }
    }

    private class MyDividerPainter
    implements DiffSplitter.Painter,
    DiffDividerDrawUtil.DividerPaintable {
        private MyDividerPainter() {
        }

        @Override
        public void paint(@NotNull Graphics g, @NotNull JComponent divider) {
            Graphics2D gg = DiffDividerDrawUtil.getDividerGraphics(g, divider, ApplyPatchViewer.this.myPatchEditor.getComponent());
            gg.setColor(DiffDrawUtil.getDividerColor(ApplyPatchViewer.this.myPatchEditor));
            gg.fill(gg.getClipBounds());
            DiffDividerDrawUtil.paintPolygons(gg, divider.getWidth(), ApplyPatchViewer.this.myResultEditor, ApplyPatchViewer.this.myPatchEditor, this);
            gg.dispose();
        }

        @Override
        public void process(@NotNull DiffDividerDrawUtil.DividerPaintable.Handler handler2) {
            for (ApplyPatchChange change : ApplyPatchViewer.this.myResultChanges) {
                LineRange resultRange = change.getResultRange();
                LineRange patchRange = change.getPatchRange();
                assert (resultRange != null);
                Color color = change.getDiffType().getColor(ApplyPatchViewer.this.myPatchEditor);
                handler2.process(resultRange.start, resultRange.end, patchRange.start, patchRange.end, color, change.isResolved());
            }
        }
    }

    private class MyPrevNextDifferenceIterable
    extends PrevNextDifferenceIterableBase<ApplyPatchChange> {
        private MyPrevNextDifferenceIterable() {
        }

        @Override
        @NotNull
        protected List<ApplyPatchChange> getChanges() {
            return (List)ApplyPatchViewer.this.getCurrentSide().select((Object)ApplyPatchViewer.this.myResultChanges, (Object)ApplyPatchViewer.this.myPatchChanges);
        }

        @Override
        @NotNull
        protected EditorEx getEditor() {
            return (EditorEx)ApplyPatchViewer.this.getCurrentSide().select((Object)ApplyPatchViewer.this.myResultEditor, (Object)ApplyPatchViewer.this.myPatchEditor);
        }

        @Override
        protected int getStartLine(@NotNull ApplyPatchChange change) {
            return ((LineRange)ApplyPatchViewer.this.getCurrentSide().select((Object)change.getResultRange(), (Object)change.getPatchAffectedRange())).start;
        }

        @Override
        protected int getEndLine(@NotNull ApplyPatchChange change) {
            return ((LineRange)ApplyPatchViewer.this.getCurrentSide().select((Object)change.getResultRange(), (Object)change.getPatchAffectedRange())).end;
        }

        @Override
        protected void scrollToChange(@NotNull ApplyPatchChange change) {
            ApplyPatchViewer.this.scrollToChange(change, ApplyPatchViewer.this.getCurrentSide(), true);
        }
    }

    private class ShowDiffWithLocalAction
    extends DumbAwareAction {
        public ShowDiffWithLocalAction() {
            super("Compare with local content", null, AllIcons.Diff.Diff);
        }

        public void actionPerformed(AnActionEvent e) {
            DocumentContent resultContent = ApplyPatchViewer.this.myPatchRequest.getResultContent();
            DocumentContent localContent = DiffContentFactory.getInstance().create(ApplyPatchViewer.this.myProject, ApplyPatchViewer.this.myPatchRequest.getLocalContent(), resultContent);
            SimpleDiffRequest request = new SimpleDiffRequest(ApplyPatchViewer.this.myPatchRequest.getTitle(), (DiffContent)localContent, (DiffContent)resultContent, ApplyPatchViewer.this.myPatchRequest.getLocalTitle(), ApplyPatchViewer.this.myPatchRequest.getResultTitle());
            LogicalPosition currentPosition = DiffUtil.getCaretPosition(ApplyPatchViewer.this.myResultEditor);
            request.putUserData(DiffUserDataKeys.SCROLL_TO_LINE, (Object)Pair.create((Object)Side.RIGHT, (Object)currentPosition.line));
            DiffManager.getInstance().showDiff(ApplyPatchViewer.this.myProject, (DiffRequest)request, new DiffDialogHints(null, (Component)ApplyPatchViewer.this.myPanel));
        }
    }

    private class MyToggleExpandByDefaultAction
    extends TextDiffViewerUtil.ToggleExpandByDefaultAction {
        public MyToggleExpandByDefaultAction() {
            super(ApplyPatchViewer.this.getTextSettings());
        }

        @Override
        protected void expandAll(boolean expand) {
            ApplyPatchViewer.this.myFoldingModel.expandAll(expand);
        }
    }

    private class MyFocusOppositePaneAction
    extends FocusOppositePaneAction {
        public MyFocusOppositePaneAction() {
            super(false);
        }

        @Override
        public void actionPerformed(@NotNull AnActionEvent e) {
            EditorEx targetEditor = (EditorEx)ApplyPatchViewer.this.getCurrentSide().other().select((Object)ApplyPatchViewer.this.myResultEditor, (Object)ApplyPatchViewer.this.myPatchEditor);
            DiffUtil.requestFocus(ApplyPatchViewer.this.myProject, targetEditor.getContentComponent());
        }
    }

    private class ApplyNonConflictsAction
    extends DumbAwareAction {
        public ApplyNonConflictsAction() {
            ActionUtil.copyFrom((AnAction)this, (String)"Diff.ApplyNonConflicts");
        }

        public void update(AnActionEvent e) {
            boolean enabled = ContainerUtil.exists((Iterable)ApplyPatchViewer.this.myModelChanges, c -> {
                if (c.isResolved()) {
                    return false;
                }
                return c.getStatus() != AppliedTextPatch.HunkStatus.NOT_APPLIED;
            });
            e.getPresentation().setEnabled(enabled);
        }

        public void actionPerformed(AnActionEvent e) {
            List changes = ApplyPatchViewer.this.myModelChanges;
            if (changes.isEmpty()) {
                return;
            }
            ApplyPatchViewer.this.executeCommand("Apply Non Conflicted Changes", () -> {
                block4: for (int i2 = changes.size() - 1; i2 >= 0; --i2) {
                    ApplyPatchChange change = (ApplyPatchChange)changes.get(i2);
                    switch (change.getStatus()) {
                        case ALREADY_APPLIED: {
                            ApplyPatchViewer.this.markChangeResolved(change);
                            continue block4;
                        }
                        case EXACTLY_APPLIED: {
                            ApplyPatchViewer.this.replaceChange(change);
                            continue block4;
                        }
                    }
                }
            });
        }
    }

    private abstract class ApplySelectedChangesActionBase
    extends DumbAwareAction {
        private final boolean myShortcut;

        public ApplySelectedChangesActionBase(boolean shortcut) {
            this.myShortcut = shortcut;
        }

        public void update(@NotNull AnActionEvent e) {
            if (this.myShortcut) {
                e.getPresentation().setEnabledAndVisible(true);
                return;
            }
            Presentation presentation = e.getPresentation();
            Editor editor = (Editor)e.getData(CommonDataKeys.EDITOR);
            Side side = Side.fromValue((List)ContainerUtil.list((Object[])new EditorEx[]{ApplyPatchViewer.this.myResultEditor, ApplyPatchViewer.this.myPatchEditor}), (Object)editor);
            if (side == null) {
                presentation.setEnabledAndVisible(false);
                return;
            }
            presentation.setVisible(true);
            presentation.setEnabled(this.isSomeChangeSelected(side));
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            Editor editor = (Editor)e.getData(CommonDataKeys.EDITOR);
            Side side = Side.fromValue((List)ContainerUtil.list((Object[])new EditorEx[]{ApplyPatchViewer.this.myResultEditor, ApplyPatchViewer.this.myPatchEditor}), (Object)editor);
            if (editor == null || side == null) {
                return;
            }
            List<ApplyPatchChange> selectedChanges = this.getSelectedChanges(side);
            if (selectedChanges.isEmpty()) {
                return;
            }
            String title = e.getPresentation().getText() + " in patch resolve";
            ApplyPatchViewer.this.executeCommand(title, () -> this.apply(selectedChanges));
        }

        private boolean isSomeChangeSelected(@NotNull Side side) {
            EditorEx editor = (EditorEx)side.select((Object)ApplyPatchViewer.this.myResultEditor, (Object)ApplyPatchViewer.this.myPatchEditor);
            List carets = editor.getCaretModel().getAllCarets();
            if (carets.size() != 1) {
                return true;
            }
            Caret caret = (Caret)carets.get(0);
            if (caret.hasSelection()) {
                return true;
            }
            int line = editor.getDocument().getLineNumber(editor.getExpectedCaretOffset());
            List changes = ApplyPatchViewer.this.myModelChanges;
            for (ApplyPatchChange change : changes) {
                LineRange range;
                if (!this.isEnabled(change) || (range = (LineRange)side.select((Object)change.getResultRange(), (Object)change.getPatchRange())) == null || !DiffUtil.isSelectedByLine(line, range.start, range.end)) continue;
                return true;
            }
            return false;
        }

        @NotNull
        private List<ApplyPatchChange> getSelectedChanges(@NotNull Side side) {
            BitSet lines = DiffUtil.getSelectedLines((Editor)side.select((Object)ApplyPatchViewer.this.myResultEditor, (Object)ApplyPatchViewer.this.myPatchEditor));
            ArrayList<ApplyPatchChange> affectedChanges = new ArrayList<ApplyPatchChange>();
            for (ApplyPatchChange change : ApplyPatchViewer.this.myModelChanges) {
                LineRange range;
                if (!this.isEnabled(change) || (range = (LineRange)side.select((Object)change.getResultRange(), (Object)change.getPatchRange())) == null || !DiffUtil.isSelectedByLine(lines, range.start, range.end)) continue;
                affectedChanges.add(change);
            }
            return affectedChanges;
        }

        protected abstract boolean isEnabled(@NotNull ApplyPatchChange var1);

        protected abstract void apply(@NotNull List<ApplyPatchChange> var1);
    }

    private class IgnoreSelectedChangesAction
    extends ApplySelectedChangesActionBase {
        private IgnoreSelectedChangesAction(boolean shortcut) {
            super(shortcut);
            this.getTemplatePresentation().setText("Ignore");
            this.getTemplatePresentation().setIcon(AllIcons.Diff.Remove);
            this.setShortcutSet((ShortcutSet)new CompositeShortcutSet(new ShortcutSet[]{ActionManager.getInstance().getAction("Diff.IgnoreRightSide").getShortcutSet(), ActionManager.getInstance().getAction("Diff.ApplyLeftSide").getShortcutSet()}));
        }

        @Override
        protected boolean isEnabled(@NotNull ApplyPatchChange change) {
            return !change.isResolved();
        }

        @Override
        protected void apply(@NotNull List<ApplyPatchChange> changes) {
            for (ApplyPatchChange change : changes) {
                ApplyPatchViewer.this.markChangeResolved(change);
            }
        }
    }

    private class ApplySelectedChangesAction
    extends ApplySelectedChangesActionBase {
        private ApplySelectedChangesAction(boolean shortcut) {
            super(shortcut);
            this.getTemplatePresentation().setText("Accept");
            this.getTemplatePresentation().setIcon(AllIcons.Actions.Checked);
            this.copyShortcutFrom(ActionManager.getInstance().getAction("Diff.ApplyRightSide"));
        }

        @Override
        protected boolean isEnabled(@NotNull ApplyPatchChange change) {
            return !change.isResolved() && change.getStatus() == AppliedTextPatch.HunkStatus.EXACTLY_APPLIED;
        }

        @Override
        protected void apply(@NotNull List<ApplyPatchChange> changes) {
            for (int i2 = changes.size() - 1; i2 >= 0; --i2) {
                ApplyPatchViewer.this.replaceChange(changes.get(i2));
            }
        }
    }

    class MyModel
    extends MergeModelBase<ApplyPatchChange.State> {
        public MyModel(@NotNull Project project2, Document document) {
            super(project2, document);
        }

        @Override
        protected void reinstallHighlighters(int index) {
            ApplyPatchChange change = (ApplyPatchChange)ApplyPatchViewer.this.myModelChanges.get(index);
            change.reinstallHighlighters();
        }

        @Override
        @NotNull
        protected ApplyPatchChange.State storeChangeState(int index) {
            ApplyPatchChange change = (ApplyPatchChange)ApplyPatchViewer.this.myModelChanges.get(index);
            return change.storeState();
        }

        @Override
        protected void restoreChangeState(@NotNull ApplyPatchChange.State state) {
            super.restoreChangeState(state);
            ApplyPatchChange change = (ApplyPatchChange)ApplyPatchViewer.this.myModelChanges.get(state.myIndex);
            boolean wasResolved = change.isResolved();
            change.restoreState(state);
            if (wasResolved != change.isResolved()) {
                ApplyPatchViewer.this.onChangeResolved();
            }
        }
    }
}

