/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.patch.tool;

import com.intellij.diff.tools.fragmented.LineNumberConvertor;
import com.intellij.diff.util.LineRange;
import com.intellij.openapi.vcs.changes.patch.AppliedTextPatch;
import gnu.trove.TIntArrayList;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class PatchChangeBuilder {
    @NotNull
    private final StringBuilder myBuilder = new StringBuilder();
    @NotNull
    private final List<Hunk> myHunks = new ArrayList<Hunk>();
    @NotNull
    private final LineNumberConvertor.Builder myConvertor1 = new LineNumberConvertor.Builder();
    @NotNull
    private final LineNumberConvertor.Builder myConvertor2 = new LineNumberConvertor.Builder();
    @NotNull
    private final TIntArrayList myChangedLines = new TIntArrayList();
    private int totalLines = 0;

    PatchChangeBuilder() {
    }

    public void exec(@NotNull List<AppliedTextPatch.AppliedSplitPatchHunk> splitHunks) {
        int lastBeforeLine = -1;
        for (AppliedTextPatch.AppliedSplitPatchHunk hunk : splitHunks) {
            List<String> contextBefore = hunk.getContextBefore();
            List<String> contextAfter = hunk.getContextAfter();
            LineRange beforeRange = hunk.getLineRangeBefore();
            LineRange afterRange = hunk.getLineRangeAfter();
            int overlappedContext = 0;
            if (lastBeforeLine != -1) {
                if (lastBeforeLine >= beforeRange.start) {
                    overlappedContext = lastBeforeLine - beforeRange.start + 1;
                } else if (lastBeforeLine < beforeRange.start - 1) {
                    this.appendSeparator();
                }
            }
            List<String> trimContext = contextBefore.subList(overlappedContext, contextBefore.size());
            this.addContext(trimContext, beforeRange.start + overlappedContext, afterRange.start + overlappedContext);
            int deletion = this.totalLines;
            this.appendLines(hunk.getDeletedLines());
            int insertion = this.totalLines;
            this.appendLines(hunk.getInsertedLines());
            int hunkEnd = this.totalLines;
            this.myConvertor1.put(deletion, beforeRange.start + contextBefore.size(), insertion - deletion);
            this.myConvertor2.put(insertion, afterRange.start + contextBefore.size(), hunkEnd - insertion);
            this.addContext(contextAfter, beforeRange.end - contextAfter.size(), afterRange.end - contextAfter.size());
            lastBeforeLine = beforeRange.end - 1;
            LineRange deletionRange = new LineRange(deletion, insertion);
            LineRange insertionRange = new LineRange(insertion, hunkEnd);
            this.myHunks.add(new Hunk(hunk.getInsertedLines(), deletionRange, insertionRange, hunk.getAppliedTo(), hunk.getStatus()));
        }
    }

    private void addContext(@NotNull List<String> context, int beforeLineNumber, int afterLineNumber) {
        this.myConvertor1.put(this.totalLines, beforeLineNumber, context.size());
        this.myConvertor2.put(this.totalLines, afterLineNumber, context.size());
        this.appendLines(context);
    }

    private void appendLines(@NotNull List<String> lines) {
        for (String line : lines) {
            this.myBuilder.append(line).append("\n");
        }
        this.totalLines += lines.size();
    }

    private void appendSeparator() {
        this.myChangedLines.add(this.totalLines);
        this.myBuilder.append("\n");
        ++this.totalLines;
    }

    @NotNull
    public CharSequence getPatchContent() {
        return this.myBuilder;
    }

    @NotNull
    public List<Hunk> getHunks() {
        return this.myHunks;
    }

    @NotNull
    public LineNumberConvertor getLineConvertor1() {
        return this.myConvertor1.build();
    }

    @NotNull
    public LineNumberConvertor getLineConvertor2() {
        return this.myConvertor2.build();
    }

    @NotNull
    public TIntArrayList getSeparatorLines() {
        return this.myChangedLines;
    }

    static class Hunk {
        @NotNull
        private final List<String> myInsertedLines;
        @NotNull
        private final LineRange myPatchDeletionRange;
        @NotNull
        private final LineRange myPatchInsertionRange;
        @Nullable
        private final LineRange myAppliedToLines;
        @NotNull
        private final AppliedTextPatch.HunkStatus myStatus;

        public Hunk(@NotNull List<String> insertedLines, @NotNull LineRange patchDeletionRange, @NotNull LineRange patchInsertionRange, @Nullable LineRange appliedToLines, @NotNull AppliedTextPatch.HunkStatus status) {
            this.myInsertedLines = insertedLines;
            this.myPatchDeletionRange = patchDeletionRange;
            this.myPatchInsertionRange = patchInsertionRange;
            this.myAppliedToLines = appliedToLines;
            this.myStatus = status;
        }

        @NotNull
        public LineRange getPatchDeletionRange() {
            return this.myPatchDeletionRange;
        }

        @NotNull
        public LineRange getPatchInsertionRange() {
            return this.myPatchInsertionRange;
        }

        @NotNull
        public AppliedTextPatch.HunkStatus getStatus() {
            return this.myStatus;
        }

        @Nullable
        public LineRange getAppliedToLines() {
            return this.myAppliedToLines;
        }

        @NotNull
        private List<String> getInsertedLines() {
            return this.myInsertedLines;
        }
    }
}

