/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.shelf;

import com.intellij.concurrency.JobScheduler;
import com.intellij.lifecycle.PeriodicalTasksCloser;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.impl.LaterInvocator;
import com.intellij.openapi.components.AbstractProjectComponent;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.PathMacroManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diff.impl.patch.ApplyPatchStatus;
import com.intellij.openapi.diff.impl.patch.BaseRevisionTextPatchEP;
import com.intellij.openapi.diff.impl.patch.FilePatch;
import com.intellij.openapi.diff.impl.patch.IdeaTextPatchBuilder;
import com.intellij.openapi.diff.impl.patch.PatchEP;
import com.intellij.openapi.diff.impl.patch.PatchReader;
import com.intellij.openapi.diff.impl.patch.PatchSyntaxException;
import com.intellij.openapi.diff.impl.patch.SelectFilesToAddTextsToPatchPanel;
import com.intellij.openapi.diff.impl.patch.TextFilePatch;
import com.intellij.openapi.diff.impl.patch.UnifiedDiffWriter;
import com.intellij.openapi.diff.impl.patch.apply.ApplyFilePatchBase;
import com.intellij.openapi.diff.impl.patch.formove.CustomBinaryPatchApplier;
import com.intellij.openapi.diff.impl.patch.formove.PatchApplier;
import com.intellij.openapi.options.NonLazySchemeProcessor;
import com.intellij.openapi.options.SchemeManager;
import com.intellij.openapi.options.SchemeManagerFactory;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.JDOMExternalizable;
import com.intellij.openapi.util.JDOMExternalizerUtil;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsConfiguration;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.VcsNotifier;
import com.intellij.openapi.vcs.VcsType;
import com.intellij.openapi.vcs.changes.BinaryContentRevision;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.ChangeListUtil;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vcs.changes.CommitContext;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import com.intellij.openapi.vcs.changes.patch.ApplyPatchDefaultExecutor;
import com.intellij.openapi.vcs.changes.shelf.ShelfFileProcessorUtil;
import com.intellij.openapi.vcs.changes.shelf.ShelvedBinaryFile;
import com.intellij.openapi.vcs.changes.shelf.ShelvedBinaryFilePatch;
import com.intellij.openapi.vcs.changes.shelf.ShelvedChange;
import com.intellij.openapi.vcs.changes.shelf.ShelvedChangeList;
import com.intellij.openapi.vcs.changes.ui.RollbackChangesDialog;
import com.intellij.openapi.vcs.changes.ui.RollbackWorker;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.project.ProjectKt;
import com.intellij.util.Consumer;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PathUtil;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.MessageBus;
import com.intellij.util.messages.Topic;
import com.intellij.util.text.CharArrayCharSequence;
import com.intellij.util.text.UniqueNameGenerator;
import com.intellij.util.ui.UIUtil;
import com.intellij.vcsUtil.FilesProgress;
import com.intellij.vcsUtil.VcsUtil;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import javax.swing.Icon;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jdom.Element;
import org.jdom.Parent;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ShelveChangesManager
extends AbstractProjectComponent
implements JDOMExternalizable {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.vcs.changes.shelf.ShelveChangesManager");
    @NonNls
    private static final String ELEMENT_CHANGELIST = "changelist";
    @NonNls
    private static final String ELEMENT_RECYCLED_CHANGELIST = "recycled_changelist";
    @NonNls
    private static final String DEFAULT_PATCH_NAME = "shelved";
    @NonNls
    private static final String REMOVE_FILES_FROM_SHELF_STRATEGY = "remove_strategy";
    @NotNull
    private final PathMacroManager myPathMacroSubstitutor;
    @NotNull
    private SchemeManager<ShelvedChangeList> mySchemeManager;
    private ScheduledFuture<?> myCleaningFuture;
    private boolean myRemoveFilesFromShelf;
    private static final String SHELVE_MANAGER_DIR_PATH = "shelf";
    public static final String DEFAULT_PROJECT_PRESENTATION_PATH = "<Project>/shelf";
    private final MessageBus myBus;
    @NonNls
    private static final String ATTRIBUTE_SHOW_RECYCLED = "show_recycled";
    public static final Topic<ChangeListener> SHELF_TOPIC = new Topic("shelf updates", ChangeListener.class);
    private boolean myShowRecycled;

    public static ShelveChangesManager getInstance(Project project2) {
        return (ShelveChangesManager)((Object)PeriodicalTasksCloser.getInstance().safeGetComponent(project2, ShelveChangesManager.class));
    }

    @NotNull
    public static String getDefaultShelfPath(@NotNull Project project2) {
        return VcsUtil.getFilePath((VirtualFile)((VirtualFile)ObjectUtils.chooseNotNull((Object)ProjectKt.getProjectStoreDirectory(project2.getBaseDir()), (Object)project2.getBaseDir())), (String)SHELVE_MANAGER_DIR_PATH).getPath();
    }

    public ShelveChangesManager(Project project2, MessageBus bus) {
        super(project2);
        this.myPathMacroSubstitutor = PathMacroManager.getInstance((ComponentManager)this.myProject);
        this.myBus = bus;
        this.mySchemeManager = this.createShelveSchemeManager(project2, VcsConfiguration.getInstance((Project)project2).CUSTOM_SHELF_PATH);
        this.myCleaningFuture = JobScheduler.getScheduler().scheduleWithFixedDelay(() -> this.cleanSystemUnshelvedOlderOneWeek(), 1L, 1L, TimeUnit.DAYS);
        Disposer.register((Disposable)project2, (Disposable)new Disposable(){

            public void dispose() {
                ShelveChangesManager.this.stopCleanScheduler();
            }
        });
        File shelfDirectory = this.mySchemeManager.getRootDirectory();
        if (shelfDirectory.exists()) {
            ChangeListManager.getInstance((Project)project2).addDirectoryToIgnoreImplicitly(shelfDirectory.getAbsolutePath());
        }
    }

    private void stopCleanScheduler() {
        if (this.myCleaningFuture != null) {
            this.myCleaningFuture.cancel(false);
            this.myCleaningFuture = null;
        }
    }

    @NotNull
    private SchemeManager<ShelvedChangeList> createShelveSchemeManager(@NotNull Project project2, @Nullable String customPath) {
        FilePath customShelfFilePath = customPath != null ? VcsUtil.getFilePath((String)this.myPathMacroSubstitutor.expandPath(customPath)) : null;
        final boolean shouldCollapsePath = !VcsConfiguration.getInstance((Project)this.myProject).USE_CUSTOM_SHELF_PATH;
        return SchemeManagerFactory.getInstance(project2).create(customShelfFilePath != null ? customShelfFilePath.getName() : SHELVE_MANAGER_DIR_PATH, new NonLazySchemeProcessor<ShelvedChangeList, ShelvedChangeList>(){

            @Override
            @NotNull
            public ShelvedChangeList readScheme(@NotNull Element element, boolean duringLoad) throws InvalidDataException {
                return ShelveChangesManager.this.readOneShelvedChangeList(element);
            }

            @Override
            @NotNull
            public Parent writeScheme(@NotNull ShelvedChangeList scheme2) throws WriteExternalException {
                Element child = new Element(ShelveChangesManager.ELEMENT_CHANGELIST);
                scheme2.writeExternal(child);
                if (shouldCollapsePath) {
                    ShelveChangesManager.this.myPathMacroSubstitutor.collapsePaths(child);
                }
                return child;
            }
        }, null, customPath != null ? Paths.get(customPath, new String[0]) : null);
    }

    public void projectOpened() {
        try {
            this.mySchemeManager.loadSchemes();
            this.filterNonValidShelvedChangeLists();
            this.cleanSystemUnshelvedOlderOneWeek();
        }
        catch (Exception e) {
            LOG.error("Couldn't read shelf information", (Throwable)e);
        }
    }

    private void filterNonValidShelvedChangeLists() {
        ArrayList allSchemes = ContainerUtil.newArrayList(this.mySchemeManager.getAllSchemes());
        ContainerUtil.process((List)allSchemes, shelvedChangeList -> {
            if (!shelvedChangeList.isValid()) {
                this.mySchemeManager.removeScheme((ShelvedChangeList)shelvedChangeList);
            }
            return true;
        });
    }

    public void checkAndMigrateUnderProgress(final @NotNull File fromFile, final @NotNull File toFile, final boolean wasCustom) {
        final SchemeManager<ShelvedChangeList> newSchemeManager = this.createShelveSchemeManager(this.myProject, VcsUtil.getFilePath((File)toFile).getPath());
        newSchemeManager.loadSchemes();
        if (VcsConfiguration.getInstance((Project)this.myProject).MOVE_SHELVES && fromFile.exists()) {
            new Task.Modal(this.myProject, "Moving Shelves to the New Directory...", true){

                public void run(@NotNull ProgressIndicator indicator) {
                    for (ShelvedChangeList list : ShelveChangesManager.this.mySchemeManager.getAllSchemes()) {
                        if (!list.isValid()) continue;
                        ShelvedChangeList migratedList = ShelvedChangeList.copy(list);
                        File newTargetDirectory = ShelveChangesManager.suggestPatchName(this.myProject, migratedList.DESCRIPTION, toFile, "");
                        ShelveChangesManager.migrateResourcesTo(migratedList, newTargetDirectory, false);
                        newSchemeManager.addNewScheme(migratedList, false);
                        indicator.checkCanceled();
                    }
                    ShelveChangesManager.this.clearShelvedLists(ShelveChangesManager.this.mySchemeManager.getAllSchemes(), false);
                }

                public void onSuccess() {
                    super.onSuccess();
                    ShelveChangesManager.this.updateShelveSchemaManager(newSchemeManager);
                }

                public void onCancel() {
                    super.onCancel();
                    this.suggestToCancelMigrationOrRevertPathToPrevious();
                }

                private void suggestToCancelMigrationOrRevertPathToPrevious() {
                    if (Messages.showOkCancelDialog((Project)this.myProject, (String)"Shelves moving failed. <br/>Would you like to use new shelf directory path or revert it to previous?", (String)"Shelf Error", (String)"&Use New", (String)"&Revert", (Icon)UIUtil.getWarningIcon()) == 0) {
                        ShelveChangesManager.this.updateShelveSchemaManager(newSchemeManager);
                    } else {
                        VcsConfiguration vcsConfiguration = VcsConfiguration.getInstance((Project)this.myProject);
                        vcsConfiguration.USE_CUSTOM_SHELF_PATH = wasCustom;
                        if (wasCustom) {
                            vcsConfiguration.CUSTOM_SHELF_PATH = FileUtil.toSystemIndependentName((String)fromFile.getPath());
                        }
                    }
                }

                public void onThrowable(@NotNull Throwable error) {
                    super.onThrowable(error);
                    this.suggestToCancelMigrationOrRevertPathToPrevious();
                }
            }.queue();
        } else {
            this.updateShelveSchemaManager(newSchemeManager);
        }
    }

    private void updateShelveSchemaManager(SchemeManager<ShelvedChangeList> newSchemeManager) {
        this.myProject.save();
        ApplicationManager.getApplication().saveSettings();
        SchemeManagerFactory.getInstance(this.myProject).dispose(this.mySchemeManager);
        this.mySchemeManager = newSchemeManager;
        this.notifyStateChanged();
    }

    @NotNull
    public File getShelfResourcesDirectory() {
        return this.mySchemeManager.getRootDirectory();
    }

    @NotNull
    private ShelvedChangeList readOneShelvedChangeList(@NotNull Element element) throws InvalidDataException {
        ShelvedChangeList data = new ShelvedChangeList();
        this.myPathMacroSubstitutor.expandPaths(element);
        data.readExternal(element);
        return data;
    }

    @NonNls
    @NotNull
    public String getComponentName() {
        return "ShelveChangesManager";
    }

    public void readExternal(Element element) throws InvalidDataException {
        String showRecycled = element.getAttributeValue(ATTRIBUTE_SHOW_RECYCLED);
        this.myShowRecycled = showRecycled == null || Boolean.parseBoolean(showRecycled);
        String removeFilesStrategy = JDOMExternalizerUtil.readField((Element)element, (String)REMOVE_FILES_FROM_SHELF_STRATEGY);
        this.myRemoveFilesFromShelf = removeFilesStrategy != null && Boolean.parseBoolean(removeFilesStrategy);
        this.migrateOldShelfInfo(element, true);
        this.migrateOldShelfInfo(element, false);
    }

    private void migrateOldShelfInfo(@NotNull Element element, boolean recycled) throws InvalidDataException {
        Element changeSetElement;
        ShelvedChangeList list;
        Iterator iterator = element.getChildren(recycled ? ELEMENT_RECYCLED_CHANGELIST : ELEMENT_CHANGELIST).iterator();
        while (iterator.hasNext() && (list = this.readOneShelvedChangeList(changeSetElement = (Element)iterator.next())).isValid()) {
            File uniqueDir = this.generateUniqueSchemePatchDir(list.DESCRIPTION, false);
            list.setName(uniqueDir.getName());
            list.setRecycled(recycled);
            this.mySchemeManager.addNewScheme(list, false);
        }
    }

    @NotNull
    public Collection<String> checkAndMigrateOldPatchResourcesToNewSchemeStorage() {
        ArrayList nonMigratedPaths = ContainerUtil.newArrayList();
        for (ShelvedChangeList list : this.mySchemeManager.getAllSchemes()) {
            File newPatchDir = new File(this.getShelfResourcesDirectory(), list.getName());
            if (newPatchDir.exists() || !newPatchDir.mkdirs()) continue;
            nonMigratedPaths.addAll(ShelveChangesManager.migrateResourcesTo(list, newPatchDir, true));
        }
        return nonMigratedPaths;
    }

    @NotNull
    private static Collection<String> migrateResourcesTo(@NotNull ShelvedChangeList list, @NotNull File targetDirectory, boolean deleteOld) {
        ArrayList nonMigratedPaths = ContainerUtil.newArrayList();
        File patchFile = new File(list.PATH);
        if (patchFile.exists()) {
            File newPatchFile = ShelveChangesManager.getPatchFileInConfigDir(targetDirectory);
            try {
                FileUtil.copy((File)patchFile, (File)newPatchFile);
                list.PATH = FileUtil.toSystemIndependentName((String)newPatchFile.getPath());
                if (deleteOld) {
                    FileUtil.delete((File)patchFile);
                }
            }
            catch (IOException e) {
                nonMigratedPaths.add(list.PATH);
            }
        }
        for (ShelvedBinaryFile file2 : list.getBinaryFiles()) {
            if (file2.SHELVED_PATH == null) continue;
            File shelvedFile = new File(file2.SHELVED_PATH);
            if (StringUtil.isEmptyOrSpaces((String)file2.AFTER_PATH) || !shelvedFile.exists()) continue;
            File newShelvedFile = new File(targetDirectory, PathUtil.getFileName((String)file2.AFTER_PATH));
            try {
                FileUtil.copy((File)shelvedFile, (File)newShelvedFile);
                file2.SHELVED_PATH = FileUtil.toSystemIndependentName((String)newShelvedFile.getPath());
                if (!deleteOld) continue;
                FileUtil.delete((File)shelvedFile);
            }
            catch (IOException e) {
                nonMigratedPaths.add(shelvedFile.getPath());
            }
        }
        return nonMigratedPaths;
    }

    public void writeExternal(Element element) throws WriteExternalException {
        element.setAttribute(ATTRIBUTE_SHOW_RECYCLED, Boolean.toString(this.myShowRecycled));
        JDOMExternalizerUtil.writeField((Element)element, (String)REMOVE_FILES_FROM_SHELF_STRATEGY, (String)Boolean.toString(this.isRemoveFilesFromShelf()));
    }

    @NotNull
    public List<ShelvedChangeList> getShelvedChangeLists() {
        return this.getRecycled(false);
    }

    @NotNull
    private List<ShelvedChangeList> getRecycled(boolean recycled) {
        return ContainerUtil.newUnmodifiableList((List)ContainerUtil.filter(this.mySchemeManager.getAllSchemes(), list -> recycled == list.isRecycled()));
    }

    public ShelvedChangeList shelveChanges(Collection<Change> changes, String commitMessage, boolean rollback) throws IOException, VcsException {
        return this.shelveChanges(changes, commitMessage, rollback, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ShelvedChangeList shelveChanges(Collection<Change> changes, String commitMessage, boolean rollback, boolean markToBeDeleted) throws IOException, VcsException {
        ShelvedChangeList changeList;
        ProgressIndicator progressIndicator = ProgressManager.getInstance().getProgressIndicator();
        if (progressIndicator != null) {
            progressIndicator.setText(VcsBundle.message((String)"shelve.changes.progress.title", (Object[])new Object[0]));
        }
        File schemePatchDir = this.generateUniqueSchemePatchDir(commitMessage, true);
        ArrayList<Change> textChanges = new ArrayList<Change>();
        ArrayList<ShelvedBinaryFile> binaryFiles = new ArrayList<ShelvedBinaryFile>();
        for (Change change : changes) {
            if (ChangesUtil.getFilePath((Change)change).isDirectory()) continue;
            if (change.getBeforeRevision() instanceof BinaryContentRevision || change.getAfterRevision() instanceof BinaryContentRevision) {
                binaryFiles.add(this.shelveBinaryFile(schemePatchDir, change));
                continue;
            }
            textChanges.add(change);
        }
        try {
            File patchFile = ShelveChangesManager.getPatchFileInConfigDir(schemePatchDir);
            ProgressManager.checkCanceled();
            List<FilePatch> patches = IdeaTextPatchBuilder.buildPatch(this.myProject, textChanges, this.myProject.getBaseDir().getPresentableUrl(), false);
            ProgressManager.checkCanceled();
            CommitContext commitContext = new CommitContext();
            this.baseRevisionsOfDvcsIntoContext(textChanges, commitContext);
            ShelfFileProcessorUtil.savePatchFile(this.myProject, patchFile, patches, null, commitContext);
            changeList = new ShelvedChangeList(patchFile.toString(), commitMessage.replace('\n', ' '), binaryFiles);
            changeList.markToDelete(markToBeDeleted);
            changeList.setName(schemePatchDir.getName());
            ProgressManager.checkCanceled();
            this.mySchemeManager.addNewScheme(changeList, false);
            if (rollback) {
                boolean modalContext;
                String operationName = UIUtil.removeMnemonic((String)RollbackChangesDialog.operationNameByChanges(this.myProject, changes));
                boolean bl = modalContext = ApplicationManager.getApplication().isDispatchThread() && LaterInvocator.isInModalContext();
                if (progressIndicator != null) {
                    progressIndicator.startNonCancelableSection();
                }
                new RollbackWorker(this.myProject, operationName, modalContext).doRollback(changes, true, null, VcsBundle.message((String)"shelve.changes.action", (Object[])new Object[0]));
            }
        }
        finally {
            this.notifyStateChanged();
        }
        return changeList;
    }

    @NotNull
    private static File getPatchFileInConfigDir(@NotNull File schemePatchDir) {
        return new File(schemePatchDir, "shelved.patch");
    }

    private void baseRevisionsOfDvcsIntoContext(List<Change> textChanges, CommitContext commitContext) {
        ProjectLevelVcsManager vcsManager = ProjectLevelVcsManager.getInstance((Project)this.myProject);
        if (this.dvcsUsedInProject() && VcsConfiguration.getInstance((Project)this.myProject).INCLUDE_TEXT_INTO_SHELF) {
            Set<Change> big = SelectFilesToAddTextsToPatchPanel.getBig(textChanges);
            ArrayList<FilePath> toKeep = new ArrayList<FilePath>();
            for (Change change : textChanges) {
                FilePath filePath;
                AbstractVcs vcs;
                if (change.getBeforeRevision() == null || change.getAfterRevision() == null || big.contains(change) || (vcs = vcsManager.getVcsFor(filePath = ChangesUtil.getFilePath((Change)change))) == null || !VcsType.distributed.equals((Object)vcs.getType())) continue;
                toKeep.add(filePath);
            }
            commitContext.putUserData(BaseRevisionTextPatchEP.ourPutBaseRevisionTextKey, (Object)true);
            commitContext.putUserData(BaseRevisionTextPatchEP.ourBaseRevisionPaths, toKeep);
        }
    }

    private boolean dvcsUsedInProject() {
        return Arrays.stream(ProjectLevelVcsManager.getInstance((Project)this.myProject).getAllActiveVcss()).anyMatch(vcs -> VcsType.distributed.equals((Object)vcs.getType()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ShelvedChangeList importFilePatches(String fileName, List<FilePatch> patches, PatchEP[] patchTransitExtensions) throws IOException {
        try {
            File schemePatchDir = this.generateUniqueSchemePatchDir(fileName, true);
            File patchFile = ShelveChangesManager.getPatchFileInConfigDir(schemePatchDir);
            ShelfFileProcessorUtil.savePatchFile(this.myProject, patchFile, patches, patchTransitExtensions, new CommitContext());
            ShelvedChangeList changeList = new ShelvedChangeList(patchFile.toString(), fileName.replace('\n', ' '), (List<ShelvedBinaryFile>)new SmartList());
            changeList.setName(schemePatchDir.getName());
            this.mySchemeManager.addNewScheme(changeList, false);
            ShelvedChangeList shelvedChangeList = changeList;
            return shelvedChangeList;
        }
        finally {
            this.notifyStateChanged();
        }
    }

    public List<VirtualFile> gatherPatchFiles(Collection<VirtualFile> files) {
        ArrayList<VirtualFile> result2 = new ArrayList<VirtualFile>();
        LinkedList<VirtualFile> filesQueue = new LinkedList<VirtualFile>(files);
        while (!filesQueue.isEmpty()) {
            ProgressManager.checkCanceled();
            VirtualFile file2 = filesQueue.removeFirst();
            if (file2.isDirectory()) {
                filesQueue.addAll(Arrays.asList(file2.getChildren()));
                continue;
            }
            if (!"PATCH".equals(file2.getFileType().getName())) continue;
            result2.add(file2);
        }
        return result2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ShelvedChangeList> importChangeLists(Collection<VirtualFile> files, Consumer<VcsException> exceptionConsumer) {
        ArrayList<ShelvedChangeList> result2 = new ArrayList<ShelvedChangeList>(files.size());
        try {
            FilesProgress filesProgress = new FilesProgress(files.size(), "Processing ");
            for (VirtualFile file2 : files) {
                filesProgress.updateIndicator(file2);
                String description = file2.getNameWithoutExtension().replace('_', ' ');
                File schemeNameDir = this.generateUniqueSchemePatchDir(description, true);
                File patchPath = ShelveChangesManager.getPatchFileInConfigDir(schemeNameDir);
                ShelvedChangeList list = new ShelvedChangeList(patchPath.getPath(), description, (List<ShelvedBinaryFile>)new SmartList(), file2.getTimeStamp());
                list.setName(schemeNameDir.getName());
                try {
                    List<TextFilePatch> patchesList = ShelveChangesManager.loadPatches(this.myProject, file2.getPath(), new CommitContext());
                    if (patchesList.isEmpty()) continue;
                    FileUtil.copy((File)new File(file2.getPath()), (File)patchPath);
                    this.mySchemeManager.addNewScheme(list, false);
                    result2.add(list);
                }
                catch (PatchSyntaxException | IOException e) {
                    exceptionConsumer.consume((Object)new VcsException(e));
                }
            }
        }
        finally {
            this.notifyStateChanged();
        }
        return result2;
    }

    private ShelvedBinaryFile shelveBinaryFile(@NotNull File schemePatchDir, Change change) throws IOException {
        ContentRevision beforeRevision = change.getBeforeRevision();
        ContentRevision afterRevision = change.getAfterRevision();
        File beforeFile = beforeRevision == null ? null : beforeRevision.getFile().getIOFile();
        File afterFile = afterRevision == null ? null : afterRevision.getFile().getIOFile();
        String shelvedPath = null;
        if (afterFile != null) {
            String shelvedFileName = afterFile.getName();
            String name = FileUtil.getNameWithoutExtension((String)shelvedFileName);
            String extension = FileUtilRt.getExtension((String)shelvedFileName);
            File shelvedFile = FileUtil.findSequentNonexistentFile((File)schemePatchDir, (String)name, (String)extension);
            FileUtil.copy((File)afterRevision.getFile().getIOFile(), (File)shelvedFile);
            shelvedPath = shelvedFile.getPath();
        }
        String beforePath = ChangesUtil.getProjectRelativePath((Project)this.myProject, (File)beforeFile);
        String afterPath = ChangesUtil.getProjectRelativePath((Project)this.myProject, (File)afterFile);
        return new ShelvedBinaryFile(beforePath, afterPath, shelvedPath);
    }

    private void notifyStateChanged() {
        if (!this.myProject.isDisposed()) {
            ((ChangeListener)this.myBus.syncPublisher(SHELF_TOPIC)).stateChanged(new ChangeEvent((Object)this));
        }
    }

    @NotNull
    private File generateUniqueSchemePatchDir(@NotNull String defaultName, boolean createResourceDirectory) {
        this.ignoreShelfDirectoryIfFirstShelf();
        String uniqueName = UniqueNameGenerator.generateUniqueName((String)ShelveChangesManager.shortenAndSanitize(defaultName), this.mySchemeManager.getAllSchemeNames());
        File dir = new File(this.getShelfResourcesDirectory(), uniqueName);
        if (createResourceDirectory && !dir.exists()) {
            dir.mkdirs();
        }
        return dir;
    }

    private void ignoreShelfDirectoryIfFirstShelf() {
        File shelfDir = this.getShelfResourcesDirectory();
        if (!shelfDir.exists()) {
            ChangeListManager.getInstance((Project)this.myProject).addDirectoryToIgnoreImplicitly(shelfDir.getAbsolutePath());
        }
    }

    @NotNull
    public static File suggestPatchName(Project project2, @NotNull String commitMessage, File file2, String extension) {
        File nonexistentFile;
        String defaultPath = ShelveChangesManager.shortenAndSanitize(commitMessage);
        while ((nonexistentFile = FileUtil.findSequentNonexistentFile((File)file2, (String)defaultPath, (String)(extension == null ? VcsConfiguration.getInstance((Project)project2).getPatchFileExtension() : extension))).getName().length() >= 100) {
            defaultPath = defaultPath.substring(0, defaultPath.length() - 1);
        }
        return nonexistentFile;
    }

    @NotNull
    private static String shortenAndSanitize(@NotNull String commitMessage) {
        String defaultPath = FileUtil.sanitizeFileName((String)commitMessage);
        if (defaultPath.isEmpty()) {
            defaultPath = "unnamed";
        }
        if (defaultPath.length() > 90) {
            defaultPath = defaultPath.substring(0, 90);
        }
        return defaultPath;
    }

    public void unshelveChangeList(ShelvedChangeList changeList, @Nullable List<ShelvedChange> changes, @Nullable List<ShelvedBinaryFile> binaryFiles, @Nullable LocalChangeList targetChangeList, boolean showSuccessNotification) {
        this.unshelveChangeList(changeList, changes, binaryFiles, targetChangeList, showSuccessNotification, false, false, null, null);
    }

    public void unshelveChangeList(ShelvedChangeList changeList, @Nullable List<ShelvedChange> changes, @Nullable List<ShelvedBinaryFile> binaryFiles, @Nullable LocalChangeList targetChangeList, boolean showSuccessNotification, boolean systemOperation, boolean reverse, String leftConflictTitle, String rightConflictTitle) {
        List<TextFilePatch> textFilePatches;
        ArrayList<FilePatch> remainingPatches = new ArrayList<FilePatch>();
        CommitContext commitContext = new CommitContext();
        try {
            textFilePatches = ShelveChangesManager.loadTextPatches(this.myProject, changeList, changes, remainingPatches, commitContext);
        }
        catch (IOException e) {
            LOG.info((Throwable)e);
            PatchApplier.showError(this.myProject, "Cannot load patch(es): " + e.getMessage());
            return;
        }
        catch (PatchSyntaxException e) {
            PatchApplier.showError(this.myProject, "Cannot load patch(es): " + e.getMessage());
            LOG.info((Throwable)e);
            return;
        }
        ArrayList<TextFilePatch> patches = new ArrayList<TextFilePatch>(textFilePatches);
        ArrayList<ShelvedBinaryFile> remainingBinaries = new ArrayList<ShelvedBinaryFile>();
        List<ShelvedBinaryFile> binaryFilesToUnshelve = ShelveChangesManager.getBinaryFilesToUnshelve(changeList, binaryFiles, remainingBinaries);
        for (ShelvedBinaryFile shelvedBinaryFile : binaryFilesToUnshelve) {
            patches.add((TextFilePatch)new ShelvedBinaryFilePatch(shelvedBinaryFile));
        }
        ApplicationManager.getApplication().invokeAndWait(() -> {
            BinaryPatchApplier binaryPatchApplier = new BinaryPatchApplier();
            PatchApplier<ShelvedBinaryFilePatch> patchApplier = new PatchApplier<ShelvedBinaryFilePatch>(this.myProject, this.myProject.getBaseDir(), (List<FilePatch>)patches, targetChangeList, binaryPatchApplier, commitContext, reverse, leftConflictTitle, rightConflictTitle);
            patchApplier.setIsSystemOperation(systemOperation);
            patchApplier.execute(showSuccessNotification, systemOperation);
            if (this.isRemoveFilesFromShelf() || systemOperation) {
                remainingPatches.addAll(patchApplier.getRemainingPatches());
                if (remainingPatches.isEmpty() && remainingBinaries.isEmpty()) {
                    this.recycleChangeList(changeList);
                } else {
                    this.saveRemainingPatches(changeList, remainingPatches, remainingBinaries, commitContext);
                }
            }
        });
    }

    private static List<TextFilePatch> loadTextPatches(Project project2, ShelvedChangeList changeList, List<ShelvedChange> changes, List<FilePatch> remainingPatches, CommitContext commitContext) throws IOException, PatchSyntaxException {
        List<TextFilePatch> textFilePatches = ShelveChangesManager.loadPatches(project2, changeList.PATH, commitContext);
        if (changes != null) {
            Iterator<TextFilePatch> iterator = textFilePatches.iterator();
            while (iterator.hasNext()) {
                TextFilePatch patch = iterator.next();
                if (ShelveChangesManager.needUnshelve((FilePatch)patch, changes)) continue;
                remainingPatches.add((FilePatch)patch);
                iterator.remove();
            }
        }
        return textFilePatches;
    }

    public void setRemoveFilesFromShelf(boolean removeFilesFromShelf) {
        this.myRemoveFilesFromShelf = removeFilesFromShelf;
    }

    public boolean isRemoveFilesFromShelf() {
        return this.myRemoveFilesFromShelf;
    }

    private void cleanSystemUnshelvedOlderOneWeek() {
        Calendar cal = Calendar.getInstance();
        cal.add(5, -7);
        this.cleanUnshelved(true, cal.getTimeInMillis());
    }

    public void cleanUnshelved(boolean onlyMarkedToDelete, long timeBefore) {
        Date limitDate = new Date(timeBefore);
        List toDelete = ContainerUtil.filter(this.mySchemeManager.getAllSchemes(), list -> list.isRecycled() && list.DATE.before(limitDate) && (!onlyMarkedToDelete || list.isMarkedToDelete()));
        this.clearShelvedLists(toDelete, true);
    }

    public void shelveSilentlyUnderProgress(@NotNull List<Change> changes) {
        boolean completed = ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> this.shelveChangesInSeparatedLists(changes), VcsBundle.getString((String)"shelve.changes.progress.title"), true, this.myProject);
        if (completed) {
            VcsNotifier.getInstance(this.myProject).notifySuccess("Changes shelved successfully");
        }
    }

    public void shelveChangesInSeparatedLists(@NotNull Collection<Change> changes) {
        ArrayList failedChangeLists = ContainerUtil.newArrayList();
        List changeListsCopy = ChangeListManager.getInstance((Project)this.myProject).getChangeListsCopy();
        for (LocalChangeList list : changeListsCopy) {
            Collection changesForChangelist = ContainerUtil.intersection((Collection)list.getChanges(), changes);
            if (changesForChangelist.isEmpty()) continue;
            try {
                this.shelveChanges(changesForChangelist, list.getName(), true);
            }
            catch (Exception e) {
                LOG.warn((Throwable)e);
                failedChangeLists.add(list.getName());
            }
        }
        if (!failedChangeLists.isEmpty()) {
            VcsNotifier.getInstance(this.myProject).notifyError("Shelf Failed", String.format("Shelving changes for %s [%s] failed", StringUtil.pluralize((String)ELEMENT_CHANGELIST, (int)failedChangeLists.size()), StringUtil.join((Collection)failedChangeLists, (String)",")));
        }
    }

    public void unshelveSilentlyAsynchronously(@NotNull Project project2, final @NotNull List<ShelvedChangeList> selectedChangeLists, final @NotNull List<ShelvedChange> selectedChanges, final @NotNull List<ShelvedBinaryFile> selectedBinaryChanges, final @Nullable LocalChangeList forcePredefinedOneChangelist) {
        ProgressManager.getInstance().run((Task)new Task.Backgroundable(project2, VcsBundle.getString((String)"unshelve.changes.progress.title"), true){

            public void run(@NotNull ProgressIndicator indicator) {
                for (ShelvedChangeList changeList : selectedChangeLists) {
                    ArrayList changesForChangelist = ContainerUtil.newArrayList((Iterable)ContainerUtil.intersection(changeList.getChanges(this.myProject), (Collection)selectedChanges));
                    ArrayList binariesForChangelist = ContainerUtil.newArrayList((Iterable)ContainerUtil.intersection(changeList.getBinaryFiles(), (Collection)selectedBinaryChanges));
                    boolean shouldUnshelveAllList = changesForChangelist.isEmpty() && binariesForChangelist.isEmpty();
                    ShelveChangesManager.this.unshelveChangeList(changeList, shouldUnshelveAllList ? null : changesForChangelist, shouldUnshelveAllList ? null : binariesForChangelist, forcePredefinedOneChangelist != null ? forcePredefinedOneChangelist : ShelveChangesManager.this.getChangeListUnshelveTo(changeList), true);
                }
            }
        });
    }

    @NotNull
    private LocalChangeList getChangeListUnshelveTo(@NotNull ShelvedChangeList list) {
        String changeListName = list.DESCRIPTION;
        ChangeListManager manager = ChangeListManager.getInstance((Project)this.myProject);
        LocalChangeList localChangeList = manager.findChangeList(changeListName);
        if (localChangeList != null) {
            return localChangeList;
        }
        if (list.isMarkedToDelete()) {
            localChangeList = ChangeListUtil.getPredefinedChangeList(changeListName, manager);
        }
        return localChangeList != null ? localChangeList : manager.addChangeList(changeListName, "");
    }

    private static List<ShelvedBinaryFile> getBinaryFilesToUnshelve(ShelvedChangeList changeList, List<ShelvedBinaryFile> binaryFiles, List<ShelvedBinaryFile> remainingBinaries) {
        if (binaryFiles == null) {
            return new ArrayList<ShelvedBinaryFile>(changeList.getBinaryFiles());
        }
        ArrayList<ShelvedBinaryFile> result2 = new ArrayList<ShelvedBinaryFile>();
        for (ShelvedBinaryFile file2 : changeList.getBinaryFiles()) {
            if (binaryFiles.contains(file2)) {
                result2.add(file2);
                continue;
            }
            remainingBinaries.add(file2);
        }
        return result2;
    }

    private void unshelveBinaryFile(ShelvedBinaryFile file2, final @NotNull VirtualFile patchTarget) throws IOException {
        final Ref ex = new Ref();
        final Ref patchedFileRef = new Ref();
        final File shelvedFile = file2.SHELVED_PATH == null ? null : new File(file2.SHELVED_PATH);
        ApplicationManager.getApplication().runWriteAction(new Runnable(){

            @Override
            public void run() {
                try {
                    if (shelvedFile == null) {
                        patchTarget.delete((Object)this);
                    } else {
                        patchTarget.setBinaryContent(FileUtil.loadFileBytes((File)shelvedFile));
                        patchedFileRef.set((Object)patchTarget);
                    }
                }
                catch (IOException e) {
                    ex.set((Object)e);
                }
            }
        });
        if (!ex.isNull()) {
            throw (IOException)ex.get();
        }
    }

    private static boolean needUnshelve(FilePatch patch, List<ShelvedChange> changes) {
        for (ShelvedChange change : changes) {
            if (!Comparing.equal((String)patch.getBeforeName(), (String)change.getBeforePath())) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writePatchesToFile(Project project2, String path, List<FilePatch> remainingPatches, CommitContext commitContext) {
        try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(path), CharsetToolkit.UTF8_CHARSET);){
            UnifiedDiffWriter.write((Project)project2, remainingPatches, (Writer)writer, (String)"\n", (CommitContext)commitContext);
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
        }
    }

    public void saveRemainingPatches(ShelvedChangeList changeList, List<FilePatch> remainingPatches, List<ShelvedBinaryFile> remainingBinaries, CommitContext commitContext) {
        ShelvedChangeList listCopy;
        try {
            listCopy = !changeList.isRecycled() ? this.createRecycledChangelist(changeList) : null;
        }
        catch (IOException e) {
            return;
        }
        ShelveChangesManager.writePatchesToFile(this.myProject, changeList.PATH, remainingPatches, commitContext);
        changeList.getBinaryFiles().retainAll(remainingBinaries);
        changeList.clearLoadedChanges();
        if (listCopy != null) {
            this.recycleChangeList(listCopy, changeList);
            this.mySchemeManager.addNewScheme(listCopy, false);
        }
        this.notifyStateChanged();
    }

    @NotNull
    private ShelvedChangeList createRecycledChangelist(ShelvedChangeList changeList) throws IOException {
        File newPatchDir = this.generateUniqueSchemePatchDir(changeList.DESCRIPTION, true);
        File newPath = ShelveChangesManager.getPatchFileInConfigDir(newPatchDir);
        FileUtil.copy((File)new File(changeList.PATH), (File)newPath);
        ShelvedChangeList listCopy = new ShelvedChangeList(newPath.getAbsolutePath(), changeList.DESCRIPTION, new ArrayList<ShelvedBinaryFile>(changeList.getBinaryFiles()));
        listCopy.markToDelete(changeList.isMarkedToDelete());
        listCopy.setName(newPatchDir.getName());
        return listCopy;
    }

    public void restoreList(@NotNull ShelvedChangeList changeList) {
        ShelvedChangeList list = this.mySchemeManager.findSchemeByName(changeList.getName());
        if (list != null) {
            list.setRecycled(false);
            list.updateDate();
        }
        this.notifyStateChanged();
    }

    @NotNull
    public List<ShelvedChangeList> getRecycledShelvedChangeLists() {
        return this.getRecycled(true);
    }

    public void clearRecycled() {
        this.clearShelvedLists(this.getRecycledShelvedChangeLists(), true);
    }

    private void clearShelvedLists(@NotNull List<ShelvedChangeList> shelvedLists, boolean updateView) {
        if (shelvedLists.isEmpty()) {
            return;
        }
        for (ShelvedChangeList list : shelvedLists) {
            this.deleteListImpl(list);
            this.mySchemeManager.removeScheme(list);
        }
        if (updateView) {
            this.notifyStateChanged();
        }
    }

    private void recycleChangeList(@NotNull ShelvedChangeList listCopy, @Nullable ShelvedChangeList newList) {
        if (newList != null) {
            Iterator<ShelvedBinaryFile> shelvedChangeListIterator = listCopy.getBinaryFiles().iterator();
            while (shelvedChangeListIterator.hasNext()) {
                ShelvedBinaryFile binaryFile = shelvedChangeListIterator.next();
                for (ShelvedBinaryFile newBinary : newList.getBinaryFiles()) {
                    if (!Comparing.equal((String)newBinary.BEFORE_PATH, (String)binaryFile.BEFORE_PATH) || !Comparing.equal((String)newBinary.AFTER_PATH, (String)binaryFile.AFTER_PATH)) continue;
                    shelvedChangeListIterator.remove();
                }
            }
            Iterator<ShelvedChange> iterator = listCopy.getChanges(this.myProject).iterator();
            while (iterator.hasNext()) {
                ShelvedChange change = iterator.next();
                for (ShelvedChange newChange : newList.getChanges(this.myProject)) {
                    if (!Comparing.equal((String)change.getBeforePath(), (String)newChange.getBeforePath()) || !Comparing.equal((String)change.getAfterPath(), (String)newChange.getAfterPath())) continue;
                    iterator.remove();
                }
            }
            try {
                CommitContext commitContext = new CommitContext();
                ArrayList<FilePatch> patches = new ArrayList<FilePatch>();
                for (ShelvedChange change : listCopy.getChanges(this.myProject)) {
                    patches.add((FilePatch)change.loadFilePatch(this.myProject, commitContext));
                }
                ShelveChangesManager.writePatchesToFile(this.myProject, listCopy.PATH, patches, commitContext);
            }
            catch (PatchSyntaxException | IOException e) {
                LOG.info(e);
            }
        }
        if (!listCopy.getBinaryFiles().isEmpty() || !listCopy.getChanges(this.myProject).isEmpty()) {
            listCopy.setRecycled(true);
            listCopy.updateDate();
            this.notifyStateChanged();
        }
    }

    public void recycleChangeList(@NotNull ShelvedChangeList changeList) {
        this.recycleChangeList(changeList, null);
        this.notifyStateChanged();
    }

    public void deleteChangeList(@NotNull ShelvedChangeList changeList) {
        this.deleteListImpl(changeList);
        this.mySchemeManager.removeScheme(changeList);
        this.notifyStateChanged();
    }

    private void deleteListImpl(@NotNull ShelvedChangeList changeList) {
        FileUtil.delete((File)new File(this.getShelfResourcesDirectory(), changeList.getName()));
        FileUtil.delete((File)new File(changeList.PATH));
        for (ShelvedBinaryFile binaryFile : changeList.getBinaryFiles()) {
            String path = binaryFile.SHELVED_PATH;
            if (path == null) continue;
            FileUtil.delete((File)new File(path));
        }
    }

    public void renameChangeList(ShelvedChangeList changeList, String newName) {
        changeList.DESCRIPTION = newName;
        this.notifyStateChanged();
    }

    @NotNull
    public static List<TextFilePatch> loadPatches(Project project2, String patchPath, CommitContext commitContext) throws IOException, PatchSyntaxException {
        return ShelveChangesManager.loadPatches(project2, patchPath, commitContext, true);
    }

    @NotNull
    static List<? extends FilePatch> loadPatchesWithoutContent(Project project2, String patchPath, CommitContext commitContext) throws IOException, PatchSyntaxException {
        return ShelveChangesManager.loadPatches(project2, patchPath, commitContext, false);
    }

    private static List<TextFilePatch> loadPatches(Project project2, String patchPath, CommitContext commitContext, boolean loadContent) throws IOException, PatchSyntaxException {
        char[] text = FileUtil.loadFileText((File)new File(patchPath), (String)"UTF-8");
        PatchReader reader = new PatchReader((CharSequence)new CharArrayCharSequence(text), loadContent);
        List textFilePatches = reader.readTextPatches();
        ApplyPatchDefaultExecutor.applyAdditionalInfoBefore(project2, (ThrowableComputable<Map<String, Map<String, CharSequence>>, PatchSyntaxException>)reader.getAdditionalInfo(null), commitContext);
        return textFilePatches;
    }

    public boolean isShowRecycled() {
        return this.myShowRecycled;
    }

    public void setShowRecycled(boolean showRecycled) {
        this.myShowRecycled = showRecycled;
        this.notifyStateChanged();
    }

    private class BinaryPatchApplier
    implements CustomBinaryPatchApplier<ShelvedBinaryFilePatch> {
        private final List<FilePatch> myAppliedPatches = new ArrayList<FilePatch>();

        private BinaryPatchApplier() {
        }

        @Override
        @NotNull
        public ApplyPatchStatus apply(List<Pair<VirtualFile, ApplyFilePatchBase<ShelvedBinaryFilePatch>>> patches) throws IOException {
            for (Pair<VirtualFile, ApplyFilePatchBase<ShelvedBinaryFilePatch>> patch : patches) {
                ShelvedBinaryFilePatch shelvedPatch = (ShelvedBinaryFilePatch)((Object)((ApplyFilePatchBase)patch.getSecond()).getPatch());
                ShelveChangesManager.this.unshelveBinaryFile(shelvedPatch.getShelvedBinaryFile(), (VirtualFile)patch.getFirst());
                this.myAppliedPatches.add(shelvedPatch);
            }
            return ApplyPatchStatus.SUCCESS;
        }

        @Override
        @NotNull
        public List<FilePatch> getAppliedPatches() {
            return this.myAppliedPatches;
        }
    }
}

