/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.ui;

import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ui.CommitLegendPanel;
import com.intellij.util.Processor;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class ChangeInfoCalculator
implements CommitLegendPanel.InfoCalculator {
    @NotNull
    private List<Change> myDisplayedChanges = Collections.emptyList();
    @NotNull
    private List<Change> myIncludedChanges = Collections.emptyList();
    private int myUnversionedFilesCount = 0;
    private int myIncludedUnversionedFilesCount = 0;
    private static final Processor<Change> MODIFIED_FILTER = new Processor<Change>(){

        public boolean process(@NotNull Change item) {
            return item.getType() == Change.Type.MODIFICATION || item.getType() == Change.Type.MOVED;
        }
    };
    private static final Processor<Change> NEW_FILTER = new Processor<Change>(){

        public boolean process(@NotNull Change item) {
            return item.getType() == Change.Type.NEW;
        }
    };
    private static final Processor<Change> DELETED_FILTER = new Processor<Change>(){

        public boolean process(@NotNull Change item) {
            return item.getType() == Change.Type.DELETED;
        }
    };

    public void update(@NotNull List<Change> displayedChanges, @NotNull List<Change> includedChanges) {
        this.update(displayedChanges, includedChanges, 0, 0);
    }

    public void update(@NotNull List<Change> displayedChanges, @NotNull List<Change> includedChanges, int unversionedFilesCount, int includedUnversionedFilesCount) {
        this.myDisplayedChanges = displayedChanges;
        this.myIncludedChanges = includedChanges;
        this.myUnversionedFilesCount = unversionedFilesCount;
        this.myIncludedUnversionedFilesCount = includedUnversionedFilesCount;
    }

    @Override
    public int getNew() {
        return ChangeInfoCalculator.countMatchingItems(this.myDisplayedChanges, NEW_FILTER);
    }

    @Override
    public int getModified() {
        return ChangeInfoCalculator.countMatchingItems(this.myDisplayedChanges, MODIFIED_FILTER);
    }

    @Override
    public int getDeleted() {
        return ChangeInfoCalculator.countMatchingItems(this.myDisplayedChanges, DELETED_FILTER);
    }

    @Override
    public int getUnversioned() {
        return this.myUnversionedFilesCount;
    }

    @Override
    public int getIncludedNew() {
        return ChangeInfoCalculator.countMatchingItems(this.myIncludedChanges, NEW_FILTER);
    }

    @Override
    public int getIncludedModified() {
        return ChangeInfoCalculator.countMatchingItems(this.myIncludedChanges, MODIFIED_FILTER);
    }

    @Override
    public int getIncludedDeleted() {
        return ChangeInfoCalculator.countMatchingItems(this.myIncludedChanges, DELETED_FILTER);
    }

    @Override
    public int getIncludedUnversioned() {
        return this.myIncludedUnversionedFilesCount;
    }

    private static <T> int countMatchingItems(@NotNull List<T> items, @NotNull Processor<T> filter) {
        int count = 0;
        for (T item : items) {
            if (!filter.process(item)) continue;
            ++count;
        }
        return count;
    }
}

