/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.ui;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeList;
import com.intellij.openapi.vcs.changes.ui.ChangeNodeDecorator;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserBase;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserNode;
import com.intellij.openapi.vcs.changes.ui.TreeModelBuilder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import javax.swing.tree.DefaultTreeModel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ChangesBrowser
extends ChangesBrowserBase<Change> {
    public ChangesBrowser(@NotNull Project project2, @Nullable List<? extends ChangeList> changeLists, @NotNull List<Change> changes, @Nullable ChangeList initialListSelection, boolean capableOfExcludingChanges, boolean highlightProblems, @Nullable Runnable inclusionListener, @NotNull MyUseCase useCase, @Nullable VirtualFile toSelect) {
        super(project2, changes, capableOfExcludingChanges, highlightProblems, inclusionListener, useCase, toSelect, Change.class);
        this.init();
        this.setInitialSelection(changeLists, changes, initialListSelection);
        this.rebuildList();
    }

    @Override
    @NotNull
    protected DefaultTreeModel buildTreeModel(List<Change> changes, ChangeNodeDecorator changeNodeDecorator, boolean showFlatten) {
        return TreeModelBuilder.buildFromChanges(this.myProject, showFlatten, changes, changeNodeDecorator);
    }

    @Override
    @NotNull
    protected List<Change> getSelectedObjects(@NotNull ChangesBrowserNode<Change> node) {
        return node.getAllChangesUnder();
    }

    @Override
    @Nullable
    protected Change getLeadSelectedObject(@NotNull ChangesBrowserNode node) {
        Object o = node.getUserObject();
        if (o instanceof Change) {
            return (Change)o;
        }
        return null;
    }

    @Override
    @NotNull
    public List<Change> getSelectedChanges() {
        return this.myViewer.getSelectedChanges();
    }

    @Override
    @NotNull
    public List<Change> getAllChanges() {
        return this.myViewer.getChanges();
    }

    @Override
    @NotNull
    public List<Change> getCurrentDisplayedChanges() {
        return this.myChangesToDisplay != null ? this.myChangesToDisplay : super.getCurrentDisplayedChanges();
    }

    @Override
    @NotNull
    public List<Change> getCurrentIncludedChanges() {
        return ContainerUtil.newArrayList(this.myViewer.getIncludedChanges());
    }

    @Override
    @NotNull
    public List<Change> getCurrentDisplayedObjects() {
        return this.getCurrentDisplayedChanges();
    }

    public static enum MyUseCase {
        LOCAL_CHANGES,
        COMMITTED_CHANGES;

    }
}

