/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.ui;

import com.intellij.openapi.util.SystemInfoRt;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserNode;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserNodeRenderer;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.FontUtil;
import com.intellij.util.PlatformIcons;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ChangesBrowserFilePathNode
extends ChangesBrowserNode<FilePath> {
    public ChangesBrowserFilePathNode(FilePath userObject) {
        super(userObject);
    }

    @Override
    protected boolean isFile() {
        return !((FilePath)this.getUserObject()).isDirectory();
    }

    @Override
    protected boolean isDirectory() {
        return ((FilePath)this.getUserObject()).isDirectory() && this.isLeaf();
    }

    @Override
    public void render(ChangesBrowserNodeRenderer renderer, boolean selected, boolean expanded, boolean hasFocus) {
        FilePath path = (FilePath)this.userObject;
        if (path.isDirectory() || !this.isLeaf()) {
            renderer.append(this.getRelativePath(path), SimpleTextAttributes.REGULAR_ATTRIBUTES);
            if (!this.isLeaf()) {
                this.appendCount(renderer);
            }
            renderer.setIcon(PlatformIcons.DIRECTORY_CLOSED_ICON);
        } else {
            if (renderer.isShowFlatten()) {
                renderer.append(path.getName(), SimpleTextAttributes.REGULAR_ATTRIBUTES);
                FilePath parentPath = path.getParentPath();
                renderer.append(FontUtil.spaceAndThinSpace() + FileUtil.getLocationRelativeToUserHome((String)parentPath.getPresentableUrl()), SimpleTextAttributes.GRAYED_ATTRIBUTES);
            } else {
                renderer.append(this.getRelativePath(path), SimpleTextAttributes.REGULAR_ATTRIBUTES);
            }
            renderer.setIcon(path.getFileType().getIcon());
        }
    }

    @NotNull
    protected String getRelativePath(FilePath path) {
        return ChangesBrowserFilePathNode.getRelativePath(ChangesBrowserFilePathNode.safeCastToFilePath(((ChangesBrowserNode)this.getParent()).getUserObject()), path);
    }

    @Override
    public String getTextPresentation() {
        return this.getRelativePath((FilePath)this.getUserObject());
    }

    @Override
    public String toString() {
        return FileUtil.toSystemDependentName((String)((FilePath)this.getUserObject()).getPath());
    }

    @Nullable
    public static FilePath safeCastToFilePath(Object o) {
        if (o instanceof FilePath) {
            return (FilePath)o;
        }
        if (o instanceof Change) {
            return ChangesUtil.getAfterPath((Change)((Change)o));
        }
        return null;
    }

    @NotNull
    public static String getRelativePath(@Nullable FilePath parent, @NotNull FilePath child) {
        boolean isLocal = !child.isNonLocal();
        boolean caseSensitive = isLocal && SystemInfoRt.isFileSystemCaseSensitive;
        String result2 = parent != null ? FileUtil.getRelativePath((String)parent.getPath(), (String)child.getPath(), (char)'/', (boolean)caseSensitive) : null;
        result2 = result2 == null ? child.getPath() : result2;
        return isLocal ? FileUtil.toSystemDependentName((String)result2) : result2;
    }

    @Override
    public int getSortWeight() {
        if (((FilePath)this.userObject).isDirectory()) {
            return 4;
        }
        return 5;
    }

    @Override
    public int compareUserObjects(Object o2) {
        if (o2 instanceof FilePath) {
            return ((FilePath)this.getUserObject()).getPath().compareToIgnoreCase(((FilePath)o2).getPath());
        }
        return 0;
    }
}

