/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.ui;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeListOwner;
import com.intellij.openapi.vcs.changes.LocallyDeletedChange;
import com.intellij.openapi.vcs.changes.ui.ChangeListDragBean;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserChangeNode;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserFileNode;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserFilePathNode;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserLocallyDeletedNode;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserLockedFoldersNode;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserLogicallyLockedFile;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserNodeRenderer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.FontUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.Convertor;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;

public class ChangesBrowserNode<T>
extends DefaultMutableTreeNode {
    public static final Object IGNORED_FILES_TAG = new Tag("changes.nodetitle.ignored.files");
    public static final Object LOCKED_FOLDERS_TAG = new Tag("changes.nodetitle.locked.folders");
    public static final Object LOGICALLY_LOCKED_TAG = new Tag("changes.nodetitle.logicallt.locked.folders");
    public static final Object UNVERSIONED_FILES_TAG = new Tag("changes.nodetitle.unversioned.files");
    public static final Object MODIFIED_WITHOUT_EDITING_TAG = new Tag("changes.nodetitle.modified.without.editing");
    public static final Object SWITCHED_FILES_TAG = new Tag("changes.nodetitle.switched.files");
    public static final Object SWITCHED_ROOTS_TAG = new Tag("changes.nodetitle.switched.roots");
    public static final Object LOCALLY_DELETED_NODE_TAG = new Tag("changes.nodetitle.locally.deleted.files");
    protected static final int DEFAULT_CHANGE_LIST_SORT_WEIGHT = 1;
    protected static final int CHANGE_LIST_SORT_WEIGHT = 2;
    protected static final int MODULE_SORT_WEIGHT = 3;
    protected static final int DIRECTORY_PATH_SORT_WEIGHT = 4;
    protected static final int FILE_PATH_SORT_WEIGHT = 5;
    protected static final int CHANGE_SORT_WEIGHT = 6;
    protected static final int VIRTUAL_FILE_SORT_WEIGHT = 7;
    protected static final int UNVERSIONED_SORT_WEIGHT = 8;
    protected static final int DEFAULT_SORT_WEIGHT = 9;
    protected static final int IGNORED_SORT_WEIGHT = 10;
    public static final Convertor<TreePath, String> TO_TEXT_CONVERTER = path -> ((ChangesBrowserNode)path.getLastPathComponent()).getTextPresentation();
    private SimpleTextAttributes myAttributes = SimpleTextAttributes.REGULAR_ATTRIBUTES;
    private int myFileCount = -1;
    private int myDirectoryCount = -1;

    protected ChangesBrowserNode(Object userObject) {
        super(userObject);
    }

    @NotNull
    public static ChangesBrowserNode create(@NotNull LocallyDeletedChange change) {
        return new ChangesBrowserLocallyDeletedNode(change);
    }

    @NotNull
    public static ChangesBrowserNode create(@NotNull Project project2, @NotNull Object userObject) {
        if (userObject instanceof Change) {
            return new ChangesBrowserChangeNode(project2, (Change)userObject, null);
        }
        if (userObject instanceof VirtualFile) {
            return new ChangesBrowserFileNode(project2, (VirtualFile)userObject);
        }
        if (userObject instanceof FilePath) {
            return new ChangesBrowserFilePathNode((FilePath)userObject);
        }
        if (userObject == LOCKED_FOLDERS_TAG) {
            return new ChangesBrowserLockedFoldersNode(project2, userObject);
        }
        if (userObject instanceof ChangesBrowserLogicallyLockedFile) {
            return (ChangesBrowserNode)userObject;
        }
        return new ChangesBrowserNode(userObject);
    }

    @Override
    public void insert(MutableTreeNode newChild, int childIndex) {
        super.insert(newChild, childIndex);
        this.resetFileCounters();
    }

    @Override
    public void remove(int childIndex) {
        super.remove(childIndex);
        this.resetFileCounters();
    }

    protected boolean isFile() {
        return false;
    }

    protected boolean isDirectory() {
        return false;
    }

    public int getFileCount() {
        if (this.myFileCount == -1) {
            this.myFileCount = (this.isFile() ? 1 : 0) + ChangesBrowserNode.toStream(this.children()).mapToInt(ChangesBrowserNode::getFileCount).sum();
        }
        return this.myFileCount;
    }

    public int getDirectoryCount() {
        if (this.myDirectoryCount == -1) {
            this.myDirectoryCount = (this.isDirectory() ? 1 : 0) + ChangesBrowserNode.toStream(this.children()).mapToInt(ChangesBrowserNode::getDirectoryCount).sum();
        }
        return this.myDirectoryCount;
    }

    private void resetFileCounters() {
        this.myFileCount = -1;
        this.myDirectoryCount = -1;
    }

    @NotNull
    public List<Change> getAllChangesUnder() {
        return this.getAllObjectsUnder(Change.class);
    }

    @NotNull
    public <U> List<U> getAllObjectsUnder(@NotNull Class<U> clazz) {
        return this.getObjectsUnderStream(clazz).collect(Collectors.toList());
    }

    @NotNull
    public <U> Stream<U> getObjectsUnderStream(@NotNull Class<U> clazz) {
        return ChangesBrowserNode.toStream(this.preorderEnumeration()).map(ChangesBrowserNode::getUserObject).filter(userObject -> clazz.isAssignableFrom(userObject.getClass())).map(clazz::cast);
    }

    @NotNull
    public List<VirtualFile> getAllFilesUnder() {
        return this.getFilesUnderStream().collect(Collectors.toList());
    }

    @NotNull
    public Stream<VirtualFile> getFilesUnderStream() {
        return ChangesBrowserNode.toStream(this.breadthFirstEnumeration()).map(ChangesBrowserNode::getUserObject).filter(userObject -> userObject instanceof VirtualFile).map(VirtualFile.class::cast).filter(VirtualFile::isValid);
    }

    @NotNull
    public List<FilePath> getAllFilePathsUnder() {
        return this.getFilePathsUnderStream().collect(Collectors.toList());
    }

    @NotNull
    public Stream<FilePath> getFilePathsUnderStream() {
        return ChangesBrowserNode.toStream(this.breadthFirstEnumeration()).filter(DefaultMutableTreeNode::isLeaf).map(ChangesBrowserNode::getUserObject).filter(userObject -> userObject instanceof FilePath).map(FilePath.class::cast);
    }

    @NotNull
    private static Stream<ChangesBrowserNode> toStream(@NotNull Enumeration enumeration) {
        Iterator iterator = ContainerUtil.iterate((Enumeration)enumeration);
        Spliterator spliterator = Spliterators.spliteratorUnknownSize(iterator, 272);
        return StreamSupport.stream(spliterator, false);
    }

    public void render(@NotNull ChangesBrowserNodeRenderer renderer, boolean selected, boolean expanded, boolean hasFocus) {
        renderer.append(this.userObject.toString(), this.myAttributes);
        this.appendCount(renderer);
    }

    @NotNull
    protected String getCountText() {
        int count = this.getFileCount();
        int dirCount = this.getDirectoryCount();
        String result2 = "";
        if (dirCount != 0 || count != 0) {
            result2 = FontUtil.spaceAndThinSpace() + (dirCount == 0 ? VcsBundle.message((String)"changes.nodetitle.changecount", (Object[])new Object[]{count}) : (count == 0 ? VcsBundle.message((String)"changes.nodetitle.directory.changecount", (Object[])new Object[]{dirCount}) : VcsBundle.message((String)"changes.nodetitle.directory.file.changecount", (Object[])new Object[]{dirCount, count})));
        }
        return result2;
    }

    protected void appendCount(@NotNull ColoredTreeCellRenderer renderer) {
        renderer.append(this.getCountText(), SimpleTextAttributes.GRAYED_ATTRIBUTES);
    }

    @Override
    public String toString() {
        return this.getTextPresentation();
    }

    public String getTextPresentation() {
        return this.userObject == null ? "" : this.userObject.toString();
    }

    public T getUserObject() {
        return (T)this.userObject;
    }

    public boolean canAcceptDrop(ChangeListDragBean dragBean) {
        return false;
    }

    public void acceptDrop(ChangeListOwner dragOwner, ChangeListDragBean dragBean) {
    }

    public int getSortWeight() {
        return 9;
    }

    public int compareUserObjects(Object o2) {
        return 0;
    }

    public void setAttributes(@NotNull SimpleTextAttributes attributes) {
        this.myAttributes = attributes;
    }

    protected void appendUpdatingState(@NotNull ChangesBrowserNodeRenderer renderer) {
        renderer.append((this.getCountText().isEmpty() ? FontUtil.spaceAndThinSpace() : ", ") + VcsBundle.message((String)"changes.nodetitle.updating", (Object[])new Object[0]), SimpleTextAttributes.GRAYED_ATTRIBUTES);
    }

    @Deprecated
    public final int getCount() {
        return this.getFileCount();
    }

    private static class Tag {
        @NotNull
        private final String myKey;

        public Tag(@NotNull String key2) {
            this.myKey = key2;
        }

        public String toString() {
            return VcsBundle.message((String)this.myKey, (Object[])new Object[0]);
        }
    }
}

