/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.ui;

import com.intellij.ide.CopyProvider;
import com.intellij.ide.dnd.DnDAware;
import com.intellij.ide.util.treeView.TreeState;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.DataSink;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.TypeSafeDataProvider;
import com.intellij.openapi.fileChooser.actions.VirtualFileDeleteProvider;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.VcsDataKeys;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeList;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.changes.CurrentContentRevision;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import com.intellij.openapi.vcs.changes.LocallyDeletedChange;
import com.intellij.openapi.vcs.changes.VcsCurrentRevisionProxy;
import com.intellij.openapi.vcs.changes.issueLinks.TreeLinkMouseListener;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserChangeListNode;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserChangeNode;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserNode;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserNodeCopyProvider;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserNodeRenderer;
import com.intellij.openapi.vcs.changes.ui.TreeModelBuilder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.PopupHandler;
import com.intellij.ui.SmartExpander;
import com.intellij.ui.TreeSpeedSearch;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.util.EditSourceOnDoubleClickHandler;
import com.intellij.util.EditSourceOnEnterKeyHandler;
import com.intellij.util.containers.UtilKt;
import com.intellij.util.ui.tree.TreeUtil;
import com.intellij.vcsUtil.VcsUtil;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ChangesListView
extends Tree
implements TypeSafeDataProvider,
DnDAware {
    private final Project myProject;
    private boolean myShowFlatten = false;
    private final CopyProvider myCopyProvider;
    @NonNls
    public static final String HELP_ID = "ideaInterface.changes";
    @NonNls
    public static final DataKey<Stream<VirtualFile>> UNVERSIONED_FILES_DATA_KEY = DataKey.create((String)"ChangeListView.UnversionedFiles");
    @NonNls
    public static final DataKey<Stream<VirtualFile>> IGNORED_FILES_DATA_KEY = DataKey.create((String)"ChangeListView.IgnoredFiles");
    @NonNls
    public static final DataKey<List<FilePath>> MISSING_FILES_DATA_KEY = DataKey.create((String)"ChangeListView.MissingFiles");
    @NonNls
    public static final DataKey<List<LocallyDeletedChange>> LOCALLY_DELETED_CHANGES = DataKey.create((String)"ChangeListView.LocallyDeletedChanges");

    public ChangesListView(@NotNull Project project2) {
        this.myProject = project2;
        this.setModel(TreeModelBuilder.buildEmpty(project2));
        this.setShowsRootHandles(true);
        this.setRootVisible(false);
        this.setDragEnabled(true);
        this.myCopyProvider = new ChangesBrowserNodeCopyProvider((JTree)((Object)this));
        ChangesBrowserNodeRenderer renderer = new ChangesBrowserNodeRenderer(project2, () -> this.myShowFlatten, true);
        this.setCellRenderer((TreeCellRenderer)((Object)renderer));
        new TreeSpeedSearch(this, ChangesBrowserNode.TO_TEXT_CONVERTER);
        SmartExpander.installOn((JTree)((Object)this));
        new TreeLinkMouseListener(renderer).installOn((Component)((Object)this));
    }

    public DefaultTreeModel getModel() {
        return (DefaultTreeModel)super.getModel();
    }

    public boolean isShowFlatten() {
        return this.myShowFlatten;
    }

    public void setShowFlatten(boolean showFlatten) {
        this.myShowFlatten = showFlatten;
    }

    public void updateModel(@NotNull DefaultTreeModel newModel) {
        TreeState state = TreeState.createOn((JTree)((Object)this), this.getRoot());
        state.setScrollToSelection(false);
        DefaultTreeModel oldModel = this.getModel();
        this.setModel(newModel);
        ChangesBrowserNode<?> newRoot = this.getRoot();
        this.expandPath(new TreePath(newRoot.getPath()));
        state.applyTo((JTree)((Object)this), newRoot);
        this.expandDefaultChangeList(oldModel, newRoot);
    }

    private void expandDefaultChangeList(DefaultTreeModel oldModel, ChangesBrowserNode root) {
        if (((ChangesBrowserNode)oldModel.getRoot()).getFileCount() == 0 && TreeUtil.collectExpandedPaths((JTree)((Object)this)).size() == 1) {
            TreeNode toExpand = null;
            for (int i = 0; i < root.getChildCount(); ++i) {
                ChangeList object;
                TreeNode node = root.getChildAt(i);
                if (!(node instanceof ChangesBrowserChangeListNode) || node.getChildCount() <= 0 || !((object = (ChangeList)((ChangesBrowserChangeListNode)node).getUserObject()) instanceof LocalChangeList) || !((LocalChangeList)object).isDefault()) continue;
                toExpand = node;
                break;
            }
            if (toExpand != null) {
                this.expandPath(new TreePath(new Object[]{root, toExpand}));
            }
        }
    }

    public void calcData(DataKey key2, DataSink sink) {
        ChangesBrowserNode firstNode;
        TreePath selectionPath;
        if (key2 == VcsDataKeys.CHANGES) {
            sink.put(VcsDataKeys.CHANGES, this.getSelectedChanges().toArray(Change[]::new));
        } else if (key2 == VcsDataKeys.CHANGE_LEAD_SELECTION) {
            sink.put(VcsDataKeys.CHANGE_LEAD_SELECTION, this.getLeadSelection().toArray(Change[]::new));
        } else if (key2 == VcsDataKeys.CHANGE_LISTS) {
            sink.put(VcsDataKeys.CHANGE_LISTS, this.getSelectedChangeLists().toArray(ChangeList[]::new));
        } else if (key2 == CommonDataKeys.VIRTUAL_FILE_ARRAY) {
            sink.put(CommonDataKeys.VIRTUAL_FILE_ARRAY, this.getSelectedFiles().toArray(VirtualFile[]::new));
        } else if (key2 == VcsDataKeys.VIRTUAL_FILE_STREAM) {
            sink.put(VcsDataKeys.VIRTUAL_FILE_STREAM, this.getSelectedFiles());
        } else if (key2 == CommonDataKeys.NAVIGATABLE) {
            VirtualFile file2 = UtilKt.getIfSingle(this.getSelectedFiles());
            if (file2 != null && !file2.isDirectory()) {
                sink.put(CommonDataKeys.NAVIGATABLE, (Object)new OpenFileDescriptor(this.myProject, file2, 0));
            }
        } else if (key2 == CommonDataKeys.NAVIGATABLE_ARRAY) {
            sink.put(CommonDataKeys.NAVIGATABLE_ARRAY, (Object)ChangesUtil.getNavigatableArray((Project)this.myProject, this.getSelectedFiles()));
        } else if (key2 == PlatformDataKeys.DELETE_ELEMENT_PROVIDER) {
            if (this.getSelectionObjectsStream().anyMatch(userObject -> !(userObject instanceof ChangeList))) {
                sink.put(PlatformDataKeys.DELETE_ELEMENT_PROVIDER, (Object)new VirtualFileDeleteProvider());
            }
        } else if (key2 == PlatformDataKeys.COPY_PROVIDER) {
            sink.put(PlatformDataKeys.COPY_PROVIDER, (Object)this.myCopyProvider);
        } else if (key2 == UNVERSIONED_FILES_DATA_KEY) {
            sink.put(UNVERSIONED_FILES_DATA_KEY, this.getSelectedUnversionedFiles());
        } else if (key2 == IGNORED_FILES_DATA_KEY) {
            sink.put(IGNORED_FILES_DATA_KEY, this.getSelectedIgnoredFiles());
        } else if (key2 == VcsDataKeys.MODIFIED_WITHOUT_EDITING_DATA_KEY) {
            sink.put(VcsDataKeys.MODIFIED_WITHOUT_EDITING_DATA_KEY, this.getSelectedModifiedWithoutEditing().collect(Collectors.toList()));
        } else if (key2 == LOCALLY_DELETED_CHANGES) {
            sink.put(LOCALLY_DELETED_CHANGES, this.getSelectedLocallyDeletedChanges().collect(Collectors.toList()));
        } else if (key2 == MISSING_FILES_DATA_KEY) {
            sink.put(MISSING_FILES_DATA_KEY, this.getSelectedMissingFiles().collect(Collectors.toList()));
        } else if (VcsDataKeys.HAVE_LOCALLY_DELETED == key2) {
            sink.put(VcsDataKeys.HAVE_LOCALLY_DELETED, (Object)this.getSelectedMissingFiles().findAny().isPresent());
        } else if (VcsDataKeys.HAVE_MODIFIED_WITHOUT_EDITING == key2) {
            sink.put(VcsDataKeys.HAVE_MODIFIED_WITHOUT_EDITING, (Object)this.getSelectedModifiedWithoutEditing().findAny().isPresent());
        } else if (VcsDataKeys.HAVE_SELECTED_CHANGES == key2) {
            sink.put(VcsDataKeys.HAVE_SELECTED_CHANGES, (Object)this.haveSelectedChanges());
        } else if (key2 == PlatformDataKeys.HELP_ID) {
            sink.put(PlatformDataKeys.HELP_ID, (Object)HELP_ID);
        } else if (key2 == VcsDataKeys.CHANGES_IN_LIST_KEY && (selectionPath = this.getSelectionPath()) != null && selectionPath.getPathCount() > 1 && (firstNode = (ChangesBrowserNode)selectionPath.getPathComponent(1)) instanceof ChangesBrowserChangeListNode) {
            sink.put(VcsDataKeys.CHANGES_IN_LIST_KEY, firstNode.getAllChangesUnder());
        }
    }

    @NotNull
    private Stream<VirtualFile> getSelectedUnversionedFiles() {
        return this.getSelectedVirtualFiles(ChangesBrowserNode.UNVERSIONED_FILES_TAG);
    }

    @NotNull
    private Stream<VirtualFile> getSelectedIgnoredFiles() {
        return this.getSelectedVirtualFiles(ChangesBrowserNode.IGNORED_FILES_TAG);
    }

    @NotNull
    private Stream<VirtualFile> getSelectedModifiedWithoutEditing() {
        return this.getSelectedVirtualFiles(ChangesBrowserNode.MODIFIED_WITHOUT_EDITING_TAG);
    }

    @NotNull
    private Stream<VirtualFile> getSelectedVirtualFiles(@Nullable Object tag) {
        return this.getSelectionNodesStream(tag).flatMap(ChangesBrowserNode::getFilesUnderStream).distinct();
    }

    @NotNull
    private Stream<ChangesBrowserNode<?>> getSelectionNodesStream() {
        return this.getSelectionNodesStream(null);
    }

    @NotNull
    private Stream<ChangesBrowserNode<?>> getSelectionNodesStream(@Nullable Object tag) {
        return UtilKt.stream(this.getSelectionPaths()).filter(path -> ChangesListView.isUnderTag(path, tag)).map(TreePath::getLastPathComponent).map(node -> (ChangesBrowserNode)node);
    }

    @NotNull
    private Stream<Object> getSelectionObjectsStream() {
        return this.getSelectionNodesStream().map(ChangesBrowserNode::getUserObject);
    }

    @NotNull
    static Stream<VirtualFile> getVirtualFiles(@Nullable TreePath[] paths, @Nullable Object tag) {
        return UtilKt.stream(paths).filter(path -> ChangesListView.isUnderTag(path, tag)).map(TreePath::getLastPathComponent).map(node -> (ChangesBrowserNode)node).flatMap(ChangesBrowserNode::getFilesUnderStream).distinct();
    }

    static boolean isUnderTag(@NotNull TreePath path, @Nullable Object tag) {
        boolean result2 = true;
        if (tag != null) {
            result2 = path.getPathCount() > 1 && ((ChangesBrowserNode)path.getPathComponent(1)).getUserObject() == tag;
        }
        return result2;
    }

    @NotNull
    static Stream<Change> getChanges(@NotNull Project project2, @Nullable TreePath[] paths) {
        Stream<Change> changes = UtilKt.stream(paths).map(TreePath::getLastPathComponent).map(node -> (ChangesBrowserNode)node).flatMap(node -> node.getObjectsUnderStream(Change.class)).map(Change.class::cast);
        Stream<Change> hijackedChanges = ChangesListView.getVirtualFiles(paths, ChangesBrowserNode.MODIFIED_WITHOUT_EDITING_TAG).map(file2 -> ChangesListView.toHijackedChange(project2, file2)).filter(Objects::nonNull);
        return Stream.concat(changes, hijackedChanges).distinct();
    }

    @Nullable
    private static Change toHijackedChange(@NotNull Project project2, @NotNull VirtualFile file2) {
        VcsCurrentRevisionProxy before = VcsCurrentRevisionProxy.create(file2, project2);
        if (before != null) {
            CurrentContentRevision afterRevision = new CurrentContentRevision(VcsUtil.getFilePath((VirtualFile)file2));
            return new Change((ContentRevision)before, (ContentRevision)afterRevision, FileStatus.HIJACKED);
        }
        return null;
    }

    @NotNull
    private Stream<LocallyDeletedChange> getSelectedLocallyDeletedChanges() {
        return this.getSelectionNodesStream(ChangesBrowserNode.LOCALLY_DELETED_NODE_TAG).flatMap(node -> node.getObjectsUnderStream(LocallyDeletedChange.class)).distinct();
    }

    @NotNull
    private Stream<FilePath> getSelectedMissingFiles() {
        return this.getSelectedLocallyDeletedChanges().map(LocallyDeletedChange::getPath);
    }

    @NotNull
    protected Stream<VirtualFile> getSelectedFiles() {
        return Stream.concat(ChangesUtil.getAllFiles(this.getSelectedChanges()), this.getSelectedVirtualFiles(null)).distinct();
    }

    private boolean haveSelectedChanges() {
        return this.getSelectionNodesStream().anyMatch(node -> node instanceof ChangesBrowserChangeNode || node instanceof ChangesBrowserChangeListNode && node.getChildCount() > 0);
    }

    @NotNull
    private Stream<Change> getLeadSelection() {
        return this.getSelectionNodesStream().filter(node -> node instanceof ChangesBrowserChangeNode).map(ChangesBrowserChangeNode.class::cast).map(ChangesBrowserNode::getUserObject).distinct();
    }

    @NotNull
    public ChangesBrowserNode<?> getRoot() {
        return (ChangesBrowserNode)this.getModel().getRoot();
    }

    @NotNull
    public Stream<Change> getChanges() {
        return this.getRoot().getObjectsUnderStream(Change.class);
    }

    @NotNull
    public Stream<Change> getSelectedChanges() {
        return ChangesListView.getChanges(this.myProject, this.getSelectionPaths());
    }

    @NotNull
    private Stream<ChangeList> getSelectedChangeLists() {
        return this.getSelectionObjectsStream().filter(userObject -> userObject instanceof ChangeList).map(ChangeList.class::cast).distinct();
    }

    public void setMenuActions(ActionGroup menuGroup) {
        PopupHandler.installPopupHandler((JComponent)((Object)this), (ActionGroup)menuGroup, (String)"ChangesViewPopup", (ActionManager)ActionManager.getInstance());
        this.editSourceRegistration();
    }

    protected void editSourceRegistration() {
        EditSourceOnDoubleClickHandler.install((JTree)((Object)this));
        EditSourceOnEnterKeyHandler.install((JTree)((Object)this));
    }

    @NotNull
    public JComponent getComponent() {
        return this;
    }

    public void processMouseEvent(MouseEvent e) {
        if (!(502 != e.getID() || this.isSelectionEmpty() || e.isShiftDown() || e.isControlDown() || e.isMetaDown() || e.isPopupTrigger() || !this.isOverSelection(e.getPoint()))) {
            this.clearSelection();
            TreePath path = this.getPathForLocation(e.getPoint().x, e.getPoint().y);
            if (path != null) {
                this.setSelectionPath(path);
            }
        }
        super.processMouseEvent(e);
    }

    public boolean isOverSelection(Point point) {
        return TreeUtil.isOverSelection((JTree)((Object)this), (Point)point);
    }

    public void dropSelectionButUnderPoint(Point point) {
        TreeUtil.dropSelectionButUnderPoint((JTree)((Object)this), (Point)point);
    }
}

