/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.ui;

import com.intellij.history.LocalHistory;
import com.intellij.history.LocalHistoryAction;
import com.intellij.ide.util.DelegatingProgressIndicator;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsConfiguration;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.VcsNotifier;
import com.intellij.openapi.vcs.VcsShowConfirmationOption;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeList;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.ChangeListManagerImpl;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vcs.changes.CommitResultHandler;
import com.intellij.openapi.vcs.changes.InvokeAfterUpdateMode;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import com.intellij.openapi.vcs.changes.VcsDirtyScopeManager;
import com.intellij.openapi.vcs.changes.actions.MoveChangesToAnotherListAction;
import com.intellij.openapi.vcs.changes.committed.CommittedChangesCache;
import com.intellij.openapi.vcs.changes.ui.ChangelistMoveOfferDialog;
import com.intellij.openapi.vcs.checkin.CheckinEnvironment;
import com.intellij.openapi.vcs.checkin.CheckinHandler;
import com.intellij.openapi.vcs.update.RefreshVFsSynchronously;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Consumer;
import com.intellij.util.Function;
import com.intellij.util.NullableFunction;
import com.intellij.util.WaitForProgressToShow;
import com.intellij.util.concurrency.Semaphore;
import com.intellij.util.ui.ConfirmationDialog;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CommitHelper {
    public static final Key<Object> DOCUMENT_BEING_COMMITTED_KEY = new Key("DOCUMENT_BEING_COMMITTED");
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.vcs.changes.ui.CommitHelper");
    @NotNull
    private final Project myProject;
    @NotNull
    private final ChangeList myChangeList;
    @NotNull
    private final List<Change> myIncludedChanges;
    @NotNull
    private final String myActionName;
    @NotNull
    private final String myCommitMessage;
    @NotNull
    private final List<CheckinHandler> myHandlers;
    private final boolean myAllOfDefaultChangeListChangesIncluded;
    private final boolean myForceSyncCommit;
    @NotNull
    private final NullableFunction<Object, Object> myAdditionalData;
    @Nullable
    private final CommitResultHandler myCustomResultHandler;
    @NotNull
    private final List<Document> myCommittingDocuments = new ArrayList<Document>();
    @NotNull
    private final VcsConfiguration myConfiguration;
    @NotNull
    private final HashSet<String> myFeedback = new HashSet();

    public CommitHelper(@NotNull Project project2, @NotNull ChangeList changeList, @NotNull List<Change> includedChanges, @NotNull String actionName, @NotNull String commitMessage, @NotNull List<CheckinHandler> handlers, boolean allOfDefaultChangeListChangesIncluded, boolean synchronously, @NotNull NullableFunction<Object, Object> additionalDataHolder, @Nullable CommitResultHandler customResultHandler) {
        this.myProject = project2;
        this.myChangeList = changeList;
        this.myIncludedChanges = includedChanges;
        this.myActionName = actionName;
        this.myCommitMessage = commitMessage;
        this.myHandlers = handlers;
        this.myAllOfDefaultChangeListChangesIncluded = allOfDefaultChangeListChangesIncluded;
        this.myForceSyncCommit = synchronously;
        this.myAdditionalData = additionalDataHolder;
        this.myCustomResultHandler = customResultHandler;
        this.myConfiguration = VcsConfiguration.getInstance((Project)this.myProject);
    }

    public boolean doCommit() {
        return this.doCommit((AbstractVcs)null);
    }

    public boolean doCommit(@Nullable AbstractVcs vcs) {
        return this.doCommit(new CommitProcessor(vcs));
    }

    public boolean doAlienCommit(@NotNull AbstractVcs vcs) {
        return this.doCommit(new AlienCommitProcessor(vcs));
    }

    private boolean doCommit(final GeneralCommitProcessor processor2) {
        Task.Backgroundable task = new Task.Backgroundable(this.myProject, this.myActionName, true, this.myConfiguration.getCommitOption()){

            public void run(@NotNull ProgressIndicator indicator) {
                ProjectLevelVcsManager vcsManager = ProjectLevelVcsManager.getInstance((Project)this.myProject);
                vcsManager.startBackgroundVcsOperation();
                try {
                    CommitHelper.this.delegateCommitToVcsThread(processor2);
                }
                finally {
                    vcsManager.stopBackgroundVcsOperation();
                }
            }

            public boolean shouldStartInBackground() {
                return !CommitHelper.this.myForceSyncCommit && super.shouldStartInBackground();
            }

            public boolean isConditionalModal() {
                return CommitHelper.this.myForceSyncCommit;
            }
        };
        ProgressManager.getInstance().run((Task)task);
        return CommitHelper.doesntContainErrors(processor2.getVcsExceptions());
    }

    private void delegateCommitToVcsThread(GeneralCommitProcessor processor2) {
        DelegatingProgressIndicator indicator = new DelegatingProgressIndicator();
        Semaphore endSemaphore = new Semaphore();
        endSemaphore.down();
        ChangeListManagerImpl.getInstanceImpl(this.myProject).executeOnUpdaterThread(new Runnable((ProgressIndicator)indicator, processor2, endSemaphore){
            final /* synthetic */ ProgressIndicator val$indicator;
            final /* synthetic */ GeneralCommitProcessor val$processor;
            final /* synthetic */ Semaphore val$endSemaphore;
            {
                this.val$indicator = progressIndicator;
                this.val$processor = generalCommitProcessor;
                this.val$endSemaphore = semaphore;
            }

            @Override
            public void run() {
                this.val$indicator.setText("Performing VCS commit...");
                try {
                    ProgressManager.getInstance().runProcess(new Runnable(){

                        @Override
                        public void run() {
                            val$indicator.checkCanceled();
                            CommitHelper.this.generalCommit(val$processor);
                        }
                    }, this.val$indicator);
                }
                finally {
                    this.val$endSemaphore.up();
                }
            }
        });
        indicator.setText("Waiting for VCS background tasks to finish...");
        while (!endSemaphore.waitFor(20L)) {
            indicator.checkCanceled();
        }
    }

    private void reportResult(@NotNull GeneralCommitProcessor processor2) {
        List<VcsException> errors = CommitHelper.collectErrors(processor2.getVcsExceptions());
        int errorsSize = errors.size();
        int warningsSize = processor2.getVcsExceptions().size() - errorsSize;
        VcsNotifier notifier = VcsNotifier.getInstance(this.myProject);
        String message2 = this.getCommitSummary(processor2);
        if (errorsSize > 0) {
            String title = StringUtil.pluralize((String)VcsBundle.message((String)"message.text.commit.failed.with.error", (Object[])new Object[0]), (int)errorsSize);
            notifier.notifyError(title, message2);
        } else if (warningsSize > 0) {
            String title = StringUtil.pluralize((String)VcsBundle.message((String)"message.text.commit.finished.with.warning", (Object[])new Object[0]), (int)warningsSize);
            notifier.notifyImportantWarning(title, message2);
        } else {
            notifier.notifySuccess(message2);
        }
    }

    @NotNull
    private String getCommitSummary(@NotNull GeneralCommitProcessor processor2) {
        List<VcsException> exceptions;
        StringBuilder content = new StringBuilder(this.getFileSummaryReport(processor2.getChangesFailedToCommit()));
        if (!StringUtil.isEmpty((String)this.myCommitMessage)) {
            content.append(": ").append(CommitHelper.escape(this.myCommitMessage));
        }
        if (!this.myFeedback.isEmpty()) {
            content.append("<br/>");
            content.append(StringUtil.join(this.myFeedback, (String)"<br/>"));
        }
        if (!CommitHelper.doesntContainErrors(exceptions = processor2.getVcsExceptions())) {
            content.append("<br/>");
            content.append(StringUtil.join(exceptions, (Function)new Function<VcsException, String>(){

                public String fun(VcsException e) {
                    return e.getMessage();
                }
            }, (String)"<br/>"));
        }
        return content.toString();
    }

    @NotNull
    private String getFileSummaryReport(@NotNull List<Change> changesFailedToCommit) {
        int failed = changesFailedToCommit.size();
        int committed = this.myIncludedChanges.size() - failed;
        String fileSummary = committed + " " + StringUtil.pluralize((String)"file", (int)committed) + " committed";
        if (failed > 0) {
            fileSummary = fileSummary + ", " + failed + " " + StringUtil.pluralize((String)"file", (int)failed) + " failed to commit";
        }
        return fileSummary;
    }

    private static String escape(String s) {
        String[] FROM = new String[]{"<", ">"};
        String[] TO = new String[]{"&lt;", "&gt;"};
        return StringUtil.replace((String)s, (String[])FROM, (String[])TO);
    }

    private static boolean doesntContainErrors(List<VcsException> vcsExceptions) {
        for (VcsException vcsException : vcsExceptions) {
            if (vcsException.isWarning()) continue;
            return false;
        }
        return true;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void generalCommit(GeneralCommitProcessor processor2) {
        try {
            Application appManager = ApplicationManager.getApplication();
            appManager.runReadAction(new Runnable(){

                @Override
                public void run() {
                    CommitHelper.this.markCommittingDocuments();
                }
            });
            try {
                processor2.callSelf();
            }
            catch (Throwable throwable) {
                appManager.runReadAction(new Runnable(){

                    @Override
                    public void run() {
                        CommitHelper.this.unmarkCommittingDocuments();
                    }
                });
                throw throwable;
            }
            appManager.runReadAction(new /* invalid duplicate definition of identical inner class */);
            processor2.doBeforeRefresh();
        }
        catch (ProcessCanceledException pce) {
            try {
                throw pce;
                catch (RuntimeException e) {
                    LOG.error((Throwable)e);
                    processor2.myVcsExceptions.add(new VcsException((Throwable)e));
                    throw e;
                }
                catch (Throwable e) {
                    LOG.error(e);
                    processor2.myVcsExceptions.add(new VcsException(e));
                    throw new RuntimeException(e);
                }
            }
            catch (Throwable throwable) {
                this.commitCompleted(processor2.getVcsExceptions(), processor2);
                processor2.customRefresh();
                WaitForProgressToShow.runOrInvokeLaterAboveProgress((Runnable)new Runnable(processor2){
                    final /* synthetic */ GeneralCommitProcessor val$processor;
                    {
                        this.val$processor = generalCommitProcessor;
                    }

                    @Override
                    public void run() {
                        this.val$processor.doPostRefresh();
                    }
                }, null, (Project)this.myProject);
                throw throwable;
            }
        }
        this.commitCompleted(processor2.getVcsExceptions(), processor2);
        processor2.customRefresh();
        WaitForProgressToShow.runOrInvokeLaterAboveProgress((Runnable)new /* invalid duplicate definition of identical inner class */, null, (Project)this.myProject);
    }

    private void markCommittingDocuments() {
        this.myCommittingDocuments.addAll(CommitHelper.markCommittingDocuments(this.myProject, this.myIncludedChanges));
    }

    private void unmarkCommittingDocuments() {
        CommitHelper.unmarkCommittingDocuments(this.myCommittingDocuments);
        this.myCommittingDocuments.clear();
    }

    @NotNull
    private static Collection<Document> markCommittingDocuments(@NotNull Project project2, @NotNull List<Change> changes) {
        ArrayList<Document> committingDocs = new ArrayList<Document>();
        for (Change change : changes) {
            Document doc;
            VirtualFile virtualFile = ChangesUtil.getFilePath((Change)change).getVirtualFile();
            if (virtualFile == null || virtualFile.getFileType().isBinary() || (doc = FileDocumentManager.getInstance().getDocument(virtualFile)) == null) continue;
            doc.putUserData(DOCUMENT_BEING_COMMITTED_KEY, (Object)project2);
            committingDocs.add(doc);
        }
        return committingDocs;
    }

    private static void unmarkCommittingDocuments(@NotNull Collection<Document> committingDocs) {
        for (Document doc : committingDocs) {
            doc.putUserData(DOCUMENT_BEING_COMMITTED_KEY, null);
        }
    }

    private void commitCompleted(List<VcsException> allExceptions, GeneralCommitProcessor processor2) {
        List<VcsException> errors = CommitHelper.collectErrors(allExceptions);
        boolean noErrors = errors.isEmpty();
        boolean noWarnings = allExceptions.isEmpty();
        if (noErrors) {
            ProgressIndicator indicator;
            for (CheckinHandler handler2 : this.myHandlers) {
                handler2.checkinSuccessful();
            }
            processor2.afterSuccessfulCheckIn();
            if (this.myCustomResultHandler != null) {
                this.myCustomResultHandler.onSuccess(this.myCommitMessage);
            } else {
                this.reportResult(processor2);
            }
            if (noWarnings && (indicator = ProgressManager.getInstance().getProgressIndicator()) != null) {
                indicator.setText(VcsBundle.message((String)"commit.dialog.completed.successfully", (Object[])new Object[0]));
            }
        } else {
            for (CheckinHandler handler3 : this.myHandlers) {
                handler3.checkinFailed(errors);
            }
            processor2.afterFailedCheckIn();
            if (this.myCustomResultHandler != null) {
                this.myCustomResultHandler.onFailure();
            } else {
                this.reportResult(processor2);
            }
        }
    }

    public static void moveToFailedList(ChangeList changeList, String commitMessage, List<Change> failedChanges, String newChangelistName, Project project2) {
        VcsShowConfirmationOption option;
        boolean result2;
        if (failedChanges.containsAll(changeList.getChanges())) {
            return;
        }
        final VcsConfiguration configuration = VcsConfiguration.getInstance((Project)project2);
        if (configuration.MOVE_TO_FAILED_COMMIT_CHANGELIST != VcsShowConfirmationOption.Value.DO_ACTION_SILENTLY && !(result2 = ConfirmationDialog.requestForConfirmation((VcsShowConfirmationOption)(option = new VcsShowConfirmationOption(){

            public VcsShowConfirmationOption.Value getValue() {
                return configuration.MOVE_TO_FAILED_COMMIT_CHANGELIST;
            }

            public void setValue(VcsShowConfirmationOption.Value value2) {
                configuration.MOVE_TO_FAILED_COMMIT_CHANGELIST = value2;
            }

            public boolean isPersistent() {
                return true;
            }
        }), (Project)project2, (String)VcsBundle.message((String)"commit.failed.confirm.prompt", (Object[])new Object[0]), (String)VcsBundle.message((String)"commit.failed.confirm.title", (Object[])new Object[0]), (Icon)Messages.getQuestionIcon()))) {
            return;
        }
        ChangeListManager changeListManager = ChangeListManager.getInstance((Project)project2);
        int index = 1;
        String failedListName = newChangelistName;
        while (changeListManager.findChangeList(failedListName) != null) {
            failedListName = newChangelistName + " (" + ++index + ")";
        }
        LocalChangeList failedList = changeListManager.addChangeList(failedListName, commitMessage);
        changeListManager.moveChangesTo(failedList, failedChanges.toArray(new Change[failedChanges.size()]));
    }

    private static List<VcsException> collectErrors(List<VcsException> vcsExceptions) {
        ArrayList<VcsException> result2 = new ArrayList<VcsException>();
        for (VcsException vcsException : vcsExceptions) {
            if (vcsException.isWarning()) continue;
            result2.add(vcsException);
        }
        return result2;
    }

    private class CommitProcessor
    extends GeneralCommitProcessor {
        private boolean myKeepChangeListAfterCommit;
        private LocalHistoryAction myAction;
        private ChangeListsModificationAfterCommit myAfterVcsRefreshModification;
        private boolean myCommitSuccess;
        @Nullable
        private final AbstractVcs myVcs;

        private CommitProcessor(AbstractVcs vcs) {
            this.myVcs = vcs;
            this.myAfterVcsRefreshModification = ChangeListsModificationAfterCommit.NOTHING;
            if (CommitHelper.this.myChangeList instanceof LocalChangeList) {
                LocalChangeList localList = (LocalChangeList)CommitHelper.this.myChangeList;
                boolean containsAll = new HashSet(CommitHelper.this.myIncludedChanges).containsAll(new HashSet(CommitHelper.this.myChangeList.getChanges()));
                if (containsAll && !localList.isDefault() && !localList.isReadOnly()) {
                    this.myAfterVcsRefreshModification = ChangeListsModificationAfterCommit.DELETE_LIST;
                } else if (((CommitHelper)CommitHelper.this).myConfiguration.OFFER_MOVE_TO_ANOTHER_CHANGELIST_ON_PARTIAL_COMMIT && !containsAll && localList.isDefault() && CommitHelper.this.myAllOfDefaultChangeListChangesIncluded) {
                    this.myAfterVcsRefreshModification = ChangeListsModificationAfterCommit.MOVE_OTHERS;
                }
            }
        }

        @Override
        public void callSelf() {
            if (this.myVcs != null && CommitHelper.this.myIncludedChanges.isEmpty()) {
                this.process(this.myVcs, CommitHelper.this.myIncludedChanges);
            }
            ChangesUtil.processChangesByVcs((Project)CommitHelper.this.myProject, (Collection)CommitHelper.this.myIncludedChanges, this::process);
        }

        private void process(@NotNull AbstractVcs vcs, @NotNull List<Change> items) {
            CheckinEnvironment environment = vcs.getCheckinEnvironment();
            if (environment != null) {
                List exceptions;
                List paths = ChangesUtil.getPaths(items);
                this.myPathsToRefresh.addAll(paths);
                if (environment.keepChangeListAfterCommit(CommitHelper.this.myChangeList)) {
                    this.myKeepChangeListAfterCommit = true;
                }
                if ((exceptions = environment.commit(items, CommitHelper.this.myCommitMessage, CommitHelper.this.myAdditionalData, (Set)CommitHelper.this.myFeedback)) != null && exceptions.size() > 0) {
                    this.myVcsExceptions.addAll(exceptions);
                    this.myChangesFailedToCommit.addAll(items);
                }
            }
        }

        @Override
        public void afterSuccessfulCheckIn() {
            this.myCommitSuccess = true;
        }

        @Override
        public void afterFailedCheckIn() {
            ApplicationManager.getApplication().invokeLater(new Runnable(){

                @Override
                public void run() {
                    CommitHelper.moveToFailedList(CommitHelper.this.myChangeList, CommitHelper.this.myCommitMessage, CommitProcessor.this.getChangesFailedToCommit(), VcsBundle.message((String)"commit.dialog.failed.commit.template", (Object[])new Object[]{CommitHelper.this.myChangeList.getName()}), CommitHelper.this.myProject);
                }
            }, ModalityState.defaultModalityState(), CommitHelper.this.myProject.getDisposed());
        }

        @Override
        public void doBeforeRefresh() {
            ChangeListManagerImpl clManager = (ChangeListManagerImpl)ChangeListManager.getInstance((Project)CommitHelper.this.myProject);
            clManager.showLocalChangesInvalidated();
            this.myAction = (LocalHistoryAction)ApplicationManager.getApplication().runReadAction((Computable)new Computable<LocalHistoryAction>(){

                public LocalHistoryAction compute() {
                    return LocalHistory.getInstance().startAction(CommitHelper.this.myActionName);
                }
            });
        }

        @Override
        public void customRefresh() {
            ArrayList<Change> toRefresh = new ArrayList<Change>();
            ChangesUtil.processChangesByVcs((Project)CommitHelper.this.myProject, (Collection)CommitHelper.this.myIncludedChanges, (vcs, items) -> {
                CheckinEnvironment ce = vcs.getCheckinEnvironment();
                if (ce != null && ce.isRefreshAfterCommitNeeded()) {
                    toRefresh.addAll(items);
                }
            });
            if (toRefresh.isEmpty()) {
                return;
            }
            ProgressIndicator indicator = ProgressManager.getInstance().getProgressIndicator();
            if (indicator != null) {
                indicator.setText(VcsBundle.message((String)"commit.dialog.refresh.files", (Object[])new Object[0]));
            }
            RefreshVFsSynchronously.updateChanges(toRefresh);
        }

        @Override
        public void doPostRefresh() {
            if (this.myAction != null) {
                this.myAction.finish();
            }
            if (!CommitHelper.this.myProject.isDisposed()) {
                final ChangeListManager clManager = ChangeListManager.getInstance((Project)CommitHelper.this.myProject);
                clManager.invokeAfterUpdate(new Runnable(){

                    @Override
                    public void run() {
                        if (CommitProcessor.this.myCommitSuccess) {
                            ChangelistMoveOfferDialog dialog2;
                            if (ChangeListsModificationAfterCommit.DELETE_LIST.equals((Object)CommitProcessor.this.myAfterVcsRefreshModification)) {
                                if (!CommitProcessor.this.myKeepChangeListAfterCommit) {
                                    clManager.removeChangeList(CommitHelper.this.myChangeList.getName());
                                }
                            } else if (ChangeListsModificationAfterCommit.MOVE_OTHERS.equals((Object)CommitProcessor.this.myAfterVcsRefreshModification) && (dialog2 = new ChangelistMoveOfferDialog(CommitHelper.this.myConfiguration)).showAndGet()) {
                                Collection changes = clManager.getDefaultChangeList().getChanges();
                                MoveChangesToAnotherListAction.askAndMove(CommitHelper.this.myProject, changes, Collections.emptyList());
                            }
                        }
                        CommittedChangesCache cache2 = CommittedChangesCache.getInstance(CommitHelper.this.myProject);
                        cache2.refreshAllCachesAsync(false, true);
                        cache2.refreshIncomingChangesAsync();
                    }
                }, InvokeAfterUpdateMode.SILENT, null, (Consumer)new Consumer<VcsDirtyScopeManager>(){

                    public void consume(VcsDirtyScopeManager vcsDirtyScopeManager) {
                        for (FilePath path : CommitProcessor.this.getPathsToRefresh()) {
                            vcsDirtyScopeManager.fileDirty(path);
                        }
                    }
                }, null);
                LocalHistory.getInstance().putSystemLabel(CommitHelper.this.myProject, CommitHelper.this.myActionName + ": " + CommitHelper.this.myCommitMessage);
            }
        }
    }

    private static enum ChangeListsModificationAfterCommit {
        DELETE_LIST,
        MOVE_OTHERS,
        NOTHING;

    }

    private static abstract class GeneralCommitProcessor {
        protected final List<FilePath> myPathsToRefresh = new ArrayList<FilePath>();
        protected final List<VcsException> myVcsExceptions = new ArrayList<VcsException>();
        protected final List<Change> myChangesFailedToCommit = new ArrayList<Change>();

        private GeneralCommitProcessor() {
        }

        public abstract void callSelf();

        public abstract void afterSuccessfulCheckIn();

        public abstract void afterFailedCheckIn();

        public abstract void doBeforeRefresh();

        public abstract void customRefresh();

        public abstract void doPostRefresh();

        public List<FilePath> getPathsToRefresh() {
            return this.myPathsToRefresh;
        }

        public List<VcsException> getVcsExceptions() {
            return this.myVcsExceptions;
        }

        public List<Change> getChangesFailedToCommit() {
            return this.myChangesFailedToCommit;
        }
    }

    private class AlienCommitProcessor
    extends GeneralCommitProcessor {
        @NotNull
        private final AbstractVcs myVcs;

        private AlienCommitProcessor(AbstractVcs vcs) {
            this.myVcs = vcs;
        }

        @Override
        public void callSelf() {
            ChangesUtil.processItemsByVcs((Collection)CommitHelper.this.myIncludedChanges, change -> this.myVcs, this::process);
        }

        private void process(@NotNull AbstractVcs vcs, @NotNull List<Change> items) {
            CheckinEnvironment environment;
            if (this.myVcs.getName().equals(vcs.getName()) && (environment = vcs.getCheckinEnvironment()) != null) {
                List paths = ChangesUtil.getPaths(items);
                this.myPathsToRefresh.addAll(paths);
                List exceptions = environment.commit(items, CommitHelper.this.myCommitMessage, CommitHelper.this.myAdditionalData, (Set)CommitHelper.this.myFeedback);
                if (exceptions != null && exceptions.size() > 0) {
                    this.myVcsExceptions.addAll(exceptions);
                    this.myChangesFailedToCommit.addAll(items);
                }
            }
        }

        @Override
        public void afterSuccessfulCheckIn() {
        }

        @Override
        public void afterFailedCheckIn() {
        }

        @Override
        public void doBeforeRefresh() {
        }

        @Override
        public void customRefresh() {
        }

        @Override
        public void doPostRefresh() {
        }
    }
}

