/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.ui;

import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public class CommitLegendPanel {
    @NotNull
    private final SimpleColoredComponent myRootPanel;
    @NotNull
    private final InfoCalculator myInfoCalculator;

    public CommitLegendPanel(@NotNull InfoCalculator infoCalculator) {
        this.myInfoCalculator = infoCalculator;
        this.myRootPanel = new SimpleColoredComponent();
    }

    @NotNull
    public JComponent getComponent() {
        return this.myRootPanel;
    }

    public void update() {
        this.myRootPanel.clear();
        this.appendText(this.myInfoCalculator.getNew(), this.myInfoCalculator.getIncludedNew(), FileStatus.ADDED, VcsBundle.message((String)"commit.legend.new", (Object[])new Object[0]));
        this.appendText(this.myInfoCalculator.getModified(), this.myInfoCalculator.getIncludedModified(), FileStatus.MODIFIED, VcsBundle.message((String)"commit.legend.modified", (Object[])new Object[0]));
        this.appendText(this.myInfoCalculator.getDeleted(), this.myInfoCalculator.getIncludedDeleted(), FileStatus.DELETED, VcsBundle.message((String)"commit.legend.deleted", (Object[])new Object[0]));
        this.appendText(this.myInfoCalculator.getUnversioned(), this.myInfoCalculator.getIncludedUnversioned(), FileStatus.UNKNOWN, VcsBundle.message((String)"commit.legend.unversioned", (Object[])new Object[0]));
    }

    protected void appendText(int total, int included, @NotNull FileStatus fileStatus, @NotNull String labelName) {
        if (total > 0) {
            if (!this.isPanelEmpty()) {
                this.appendSpace();
            }
            String pattern = total == included ? "%s %d" : "%s %d of %d";
            String text = String.format(pattern, labelName, included, total);
            this.myRootPanel.append(text, new SimpleTextAttributes(0, fileStatus.getColor()));
        }
    }

    private boolean isPanelEmpty() {
        return !this.myRootPanel.iterator().hasNext();
    }

    protected final void appendSpace() {
        this.myRootPanel.append("   ");
    }

    public static interface InfoCalculator {
        public int getNew();

        public int getModified();

        public int getDeleted();

        public int getUnversioned();

        public int getIncludedNew();

        public int getIncludedModified();

        public int getIncludedDeleted();

        public int getIncludedUnversioned();
    }
}

