/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.ui;

import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.RemoteRevisionsCache;
import com.intellij.openapi.vcs.changes.ui.ChangeListRemoteState;
import com.intellij.openapi.vcs.changes.ui.ChangeNodeDecorator;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserNodeRenderer;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RemoteStatusChangeNodeDecorator
implements ChangeNodeDecorator {
    private final RemoteRevisionsCache myRemoteRevisionsCache;
    private final ChangeListRemoteState myListState;
    private final int myIdx;

    public RemoteStatusChangeNodeDecorator(@NotNull RemoteRevisionsCache remoteRevisionsCache) {
        this(remoteRevisionsCache, null, -1);
    }

    public RemoteStatusChangeNodeDecorator(@NotNull RemoteRevisionsCache remoteRevisionsCache, @Nullable ChangeListRemoteState listRemoteState, int idx) {
        this.myRemoteRevisionsCache = remoteRevisionsCache;
        this.myListState = listRemoteState;
        this.myIdx = idx;
    }

    @Override
    public void decorate(Change change, SimpleColoredComponent component, boolean isShowFlatten) {
        boolean state = this.myRemoteRevisionsCache.isUpToDate(change);
        if (this.myListState != null) {
            this.myListState.report(this.myIdx, state);
        }
        if (!state) {
            component.append(" ");
            component.append(VcsBundle.message((String)"change.nodetitle.change.is.outdated", (Object[])new Object[0]), SimpleTextAttributes.ERROR_ATTRIBUTES);
        }
    }

    @Override
    public void preDecorate(Change change, ChangesBrowserNodeRenderer renderer, boolean showFlatten) {
    }
}

