/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.ui;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeList;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.changes.CurrentContentRevision;
import com.intellij.openapi.vcs.changes.LocallyDeletedChange;
import com.intellij.openapi.vcs.changes.LogicalLock;
import com.intellij.openapi.vcs.changes.RemoteRevisionsCache;
import com.intellij.openapi.vcs.changes.ui.ChangeListRemoteState;
import com.intellij.openapi.vcs.changes.ui.ChangeNodeDecorator;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserChangeListNode;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserChangeNode;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserIgnoredFilesNode;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserLogicallyLockedFile;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserNode;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserNodeRenderer;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserSpecificFilesNode;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserUnversionedFilesNode;
import com.intellij.openapi.vcs.changes.ui.ChangesGroupingPolicy;
import com.intellij.openapi.vcs.changes.ui.ChangesGroupingPolicyFactory;
import com.intellij.openapi.vcs.changes.ui.RemoteStatusChangeNodeDecorator;
import com.intellij.openapi.vcs.changes.ui.StaticFilePath;
import com.intellij.openapi.vcs.changes.ui.VirtualFileHierarchicalComparator;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.Convertor;
import com.intellij.util.containers.FactoryMap;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.ui.tree.TreeUtil;
import com.intellij.vcsUtil.VcsUtil;
import java.io.File;
import java.util.Collection;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TreeModelBuilder {
    @NonNls
    private static final String ROOT_NODE_VALUE = "root";
    private static final int UNVERSIONED_MAX_SIZE = 50;
    @NotNull
    protected final Project myProject;
    protected final boolean myShowFlatten;
    @NotNull
    protected final DefaultTreeModel myModel;
    @NotNull
    protected final ChangesBrowserNode myRoot;
    @NotNull
    private final Map<ChangesBrowserNode, ChangesGroupingPolicy> myGroupingPoliciesCache;
    @NotNull
    private final Map<ChangesBrowserNode, Map<String, ChangesBrowserNode>> myFoldersCache;
    private static final Comparator<ChangesBrowserNode> BROWSER_NODE_COMPARATOR = (node1, node2) -> {
        int sortWeightDiff = Comparing.compare((int)node1.getSortWeight(), (int)node2.getSortWeight());
        if (sortWeightDiff != 0) {
            return sortWeightDiff;
        }
        if (node1 instanceof Comparable && node1.getClass().equals(node2.getClass())) {
            return ((Comparable)((Object)node1)).compareTo(node2);
        }
        return node1.compareUserObjects(node2.getUserObject());
    };
    protected static final Comparator<Change> PATH_LENGTH_COMPARATOR = (o1, o2) -> {
        FilePath fp1 = ChangesUtil.getFilePath((Change)o1);
        FilePath fp2 = ChangesUtil.getFilePath((Change)o2);
        return Comparing.compare((int)fp1.getPath().length(), (int)fp2.getPath().length());
    };

    public TreeModelBuilder(@NotNull Project project2, boolean showFlatten) {
        this.myProject = project2;
        this.myShowFlatten = showFlatten;
        this.myRoot = ChangesBrowserNode.create(this.myProject, ROOT_NODE_VALUE);
        this.myModel = new DefaultTreeModel(this.myRoot);
        this.myGroupingPoliciesCache = new MyGroupingPolicyFactoryMap(this.myProject, this.myModel);
        this.myFoldersCache = new HashMap<ChangesBrowserNode, Map<String, ChangesBrowserNode>>();
    }

    @NotNull
    public static DefaultTreeModel buildEmpty(@NotNull Project project2) {
        return new DefaultTreeModel(ChangesBrowserNode.create(project2, ROOT_NODE_VALUE));
    }

    @NotNull
    public static DefaultTreeModel buildFromChanges(@NotNull Project project2, boolean showFlatten, @NotNull Collection<? extends Change> changes, @Nullable ChangeNodeDecorator changeNodeDecorator) {
        return new TreeModelBuilder(project2, showFlatten).setChanges(changes, changeNodeDecorator).build();
    }

    @NotNull
    public static DefaultTreeModel buildFromFilePaths(@NotNull Project project2, boolean showFlatten, @NotNull Collection<FilePath> filePaths) {
        return new TreeModelBuilder(project2, showFlatten).setFilePaths(filePaths).build();
    }

    @NotNull
    public static DefaultTreeModel buildFromChangeLists(@NotNull Project project2, boolean showFlatten, @NotNull Collection<? extends ChangeList> changeLists) {
        return new TreeModelBuilder(project2, showFlatten).setChangeLists(changeLists).build();
    }

    @NotNull
    public static DefaultTreeModel buildFromVirtualFiles(@NotNull Project project2, boolean showFlatten, @NotNull Collection<VirtualFile> virtualFiles) {
        return new TreeModelBuilder(project2, showFlatten).setVirtualFiles(virtualFiles, null).build();
    }

    @NotNull
    public TreeModelBuilder setChanges(@NotNull Collection<? extends Change> changes, @Nullable ChangeNodeDecorator changeNodeDecorator) {
        List sortedChanges = ContainerUtil.sorted(changes, PATH_LENGTH_COMPARATOR);
        for (Change change : sortedChanges) {
            this.insertChangeNode(change, this.myRoot, this.createChangeNode(change, changeNodeDecorator));
        }
        return this;
    }

    @NotNull
    public TreeModelBuilder setUnversioned(@Nullable List<VirtualFile> unversionedFiles) {
        if (ContainerUtil.isEmpty(unversionedFiles)) {
            return this;
        }
        int dirsCount = ContainerUtil.count(unversionedFiles, it -> it.isDirectory());
        int filesCount = unversionedFiles.size() - dirsCount;
        boolean manyFiles = unversionedFiles.size() > 50;
        ChangesBrowserUnversionedFilesNode node = new ChangesBrowserUnversionedFilesNode(this.myProject, filesCount, dirsCount, manyFiles);
        return this.insertSpecificNodeToModel(unversionedFiles, node);
    }

    @NotNull
    public TreeModelBuilder setIgnored(@Nullable List<VirtualFile> ignoredFiles, boolean updatingMode) {
        if (ContainerUtil.isEmpty(ignoredFiles)) {
            return this;
        }
        int dirsCount = ContainerUtil.count(ignoredFiles, it -> it.isDirectory());
        int filesCount = ignoredFiles.size() - dirsCount;
        boolean manyFiles = ignoredFiles.size() > 50;
        ChangesBrowserIgnoredFilesNode node = new ChangesBrowserIgnoredFilesNode(this.myProject, filesCount, dirsCount, manyFiles, updatingMode);
        return this.insertSpecificNodeToModel(ignoredFiles, node);
    }

    @NotNull
    private TreeModelBuilder insertSpecificNodeToModel(@NotNull List<VirtualFile> specificFiles, @NotNull ChangesBrowserSpecificFilesNode node) {
        this.myModel.insertNodeInto(node, this.myRoot, this.myRoot.getChildCount());
        if (!node.isManyFiles()) {
            this.insertFilesIntoNode(specificFiles, node);
        }
        return this;
    }

    @NotNull
    public TreeModelBuilder setChangeLists(@NotNull Collection<? extends ChangeList> changeLists) {
        RemoteRevisionsCache revisionsCache = RemoteRevisionsCache.getInstance(this.myProject);
        for (ChangeList changeList : changeLists) {
            List changes = ContainerUtil.sorted((Collection)changeList.getChanges(), PATH_LENGTH_COMPARATOR);
            ChangeListRemoteState listRemoteState = new ChangeListRemoteState(changes.size());
            ChangesBrowserChangeListNode listNode = new ChangesBrowserChangeListNode(this.myProject, changeList, listRemoteState);
            this.myModel.insertNodeInto(listNode, this.myRoot, 0);
            for (int i = 0; i < changes.size(); ++i) {
                Change change = (Change)changes.get(i);
                RemoteStatusChangeNodeDecorator decorator = new RemoteStatusChangeNodeDecorator(revisionsCache, listRemoteState, i);
                this.insertChangeNode(change, listNode, this.createChangeNode(change, decorator));
            }
        }
        return this;
    }

    protected ChangesBrowserNode createChangeNode(Change change, ChangeNodeDecorator decorator) {
        return new ChangesBrowserChangeNode(this.myProject, change, decorator);
    }

    @NotNull
    public TreeModelBuilder setLockedFolders(@Nullable List<VirtualFile> lockedFolders) {
        return this.setVirtualFiles(lockedFolders, ChangesBrowserNode.LOCKED_FOLDERS_TAG);
    }

    @NotNull
    public TreeModelBuilder setModifiedWithoutEditing(@NotNull List<VirtualFile> modifiedWithoutEditing) {
        return this.setVirtualFiles(modifiedWithoutEditing, ChangesBrowserNode.MODIFIED_WITHOUT_EDITING_TAG);
    }

    @NotNull
    private TreeModelBuilder setVirtualFiles(@Nullable Collection<VirtualFile> files, @Nullable Object tag) {
        if (ContainerUtil.isEmpty(files)) {
            return this;
        }
        this.insertFilesIntoNode(files, this.createTagNode(tag));
        return this;
    }

    @NotNull
    private ChangesBrowserNode createTagNode(@Nullable Object tag) {
        if (tag == null) {
            return this.myRoot;
        }
        ChangesBrowserNode subtreeRoot = ChangesBrowserNode.create(this.myProject, tag);
        this.myModel.insertNodeInto(subtreeRoot, this.myRoot, this.myRoot.getChildCount());
        return subtreeRoot;
    }

    private void insertFilesIntoNode(@NotNull Collection<VirtualFile> files, @NotNull ChangesBrowserNode subtreeRoot) {
        List sortedFiles = ContainerUtil.sorted(files, (Comparator)VirtualFileHierarchicalComparator.getInstance());
        for (VirtualFile file2 : sortedFiles) {
            this.insertChangeNode(file2, subtreeRoot, ChangesBrowserNode.create(this.myProject, file2));
        }
    }

    @NotNull
    public TreeModelBuilder setLocallyDeletedPaths(@Nullable Collection<LocallyDeletedChange> locallyDeletedChanges) {
        if (ContainerUtil.isEmpty(locallyDeletedChanges)) {
            return this;
        }
        ChangesBrowserNode subtreeRoot = this.createTagNode(ChangesBrowserNode.LOCALLY_DELETED_NODE_TAG);
        for (LocallyDeletedChange change : locallyDeletedChanges) {
            StaticFilePath key2 = new StaticFilePath(false, change.getPresentableUrl(), change.getPath().getVirtualFile());
            ChangesBrowserNode oldNode = this.getFolderCache(subtreeRoot).get(key2.getKey());
            if (oldNode != null) continue;
            ChangesBrowserNode node = ChangesBrowserNode.create(change);
            ChangesBrowserNode parent = this.getParentNodeFor(key2, subtreeRoot);
            this.myModel.insertNodeInto(node, parent, parent.getChildCount());
            this.getFolderCache(subtreeRoot).put(key2.getKey(), node);
        }
        return this;
    }

    @NotNull
    public TreeModelBuilder setFilePaths(@NotNull Collection<FilePath> filePaths) {
        return this.setFilePaths(filePaths, this.myRoot);
    }

    @NotNull
    private TreeModelBuilder setFilePaths(@NotNull Collection<FilePath> filePaths, @NotNull ChangesBrowserNode subtreeRoot) {
        for (FilePath file2 : filePaths) {
            StaticFilePath pathKey;
            assert (file2 != null);
            String path = file2.getPath();
            StaticFilePath staticFilePath = pathKey = !FileUtil.isAbsolute((String)path) || VcsUtil.isPathRemote((String)path) ? new StaticFilePath(false, path, null) : new StaticFilePath(false, new File(file2.getIOFile().getPath().replace('\\', '/')).getAbsolutePath(), file2.getVirtualFile());
            ChangesBrowserNode oldNode = this.getFolderCache(subtreeRoot).get(pathKey.getKey());
            if (oldNode != null) continue;
            ChangesBrowserNode node = ChangesBrowserNode.create(this.myProject, file2);
            ChangesBrowserNode parentNode = this.getParentNodeFor(pathKey, subtreeRoot);
            this.myModel.insertNodeInto(node, parentNode, 0);
            this.getFolderCache(subtreeRoot).put(pathKey.getKey(), node);
        }
        return this;
    }

    @NotNull
    public TreeModelBuilder setSwitchedRoots(@Nullable Map<VirtualFile, String> switchedRoots) {
        if (ContainerUtil.isEmpty(switchedRoots)) {
            return this;
        }
        ChangesBrowserNode rootsHeadNode = this.createTagNode(ChangesBrowserNode.SWITCHED_ROOTS_TAG);
        rootsHeadNode.setAttributes(SimpleTextAttributes.GRAYED_BOLD_ATTRIBUTES);
        List files = ContainerUtil.sorted(switchedRoots.keySet(), (Comparator)VirtualFileHierarchicalComparator.getInstance());
        for (VirtualFile vf : files) {
            CurrentContentRevision cr = new CurrentContentRevision(VcsUtil.getFilePath((VirtualFile)vf));
            Change change = new Change((ContentRevision)cr, (ContentRevision)cr, FileStatus.NOT_CHANGED);
            final String branchName = switchedRoots.get(vf);
            this.insertChangeNode(vf, rootsHeadNode, this.createChangeNode(change, new ChangeNodeDecorator(){

                @Override
                public void decorate(Change change1, SimpleColoredComponent component, boolean isShowFlatten) {
                }

                @Override
                public void preDecorate(Change change1, ChangesBrowserNodeRenderer renderer, boolean showFlatten) {
                    renderer.append("[" + branchName + "] ", SimpleTextAttributes.GRAYED_BOLD_ATTRIBUTES);
                }
            }));
        }
        return this;
    }

    @NotNull
    public TreeModelBuilder setSwitchedFiles(@NotNull MultiMap<String, VirtualFile> switchedFiles) {
        if (switchedFiles.isEmpty()) {
            return this;
        }
        ChangesBrowserNode subtreeRoot = this.createTagNode(ChangesBrowserNode.SWITCHED_FILES_TAG);
        for (String branchName : switchedFiles.keySet()) {
            List switchedFileList = ContainerUtil.sorted((Collection)switchedFiles.get((Object)branchName), (Comparator)VirtualFileHierarchicalComparator.getInstance());
            if (switchedFileList.size() <= 0) continue;
            ChangesBrowserNode branchNode = ChangesBrowserNode.create(this.myProject, branchName);
            this.myModel.insertNodeInto(branchNode, subtreeRoot, subtreeRoot.getChildCount());
            for (VirtualFile file2 : switchedFileList) {
                this.insertChangeNode(file2, branchNode, ChangesBrowserNode.create(this.myProject, file2));
            }
        }
        return this;
    }

    @NotNull
    public TreeModelBuilder setLogicallyLockedFiles(@Nullable Map<VirtualFile, LogicalLock> logicallyLockedFiles) {
        if (ContainerUtil.isEmpty(logicallyLockedFiles)) {
            return this;
        }
        ChangesBrowserNode subtreeRoot = this.createTagNode(ChangesBrowserNode.LOGICALLY_LOCKED_TAG);
        List keys = ContainerUtil.sorted(logicallyLockedFiles.keySet(), (Comparator)VirtualFileHierarchicalComparator.getInstance());
        for (VirtualFile file2 : keys) {
            LogicalLock lock = logicallyLockedFiles.get(file2);
            ChangesBrowserLogicallyLockedFile obj = new ChangesBrowserLogicallyLockedFile(this.myProject, file2, lock);
            this.insertChangeNode(obj, subtreeRoot, ChangesBrowserNode.create(this.myProject, obj));
        }
        return this;
    }

    protected void insertChangeNode(@NotNull Object change, @NotNull ChangesBrowserNode subtreeRoot, @NotNull ChangesBrowserNode node) {
        this.insertChangeNode(change, subtreeRoot, node, (Convertor<StaticFilePath, ChangesBrowserNode>)((Convertor)this::createPathNode));
    }

    protected void insertChangeNode(@NotNull Object change, @NotNull ChangesBrowserNode subtreeRoot, @NotNull ChangesBrowserNode node, @NotNull Convertor<StaticFilePath, ChangesBrowserNode> nodeBuilder) {
        StaticFilePath pathKey = TreeModelBuilder.getKey(change);
        ChangesBrowserNode parentNode = this.getParentNodeFor(pathKey, subtreeRoot, nodeBuilder);
        this.myModel.insertNodeInto(node, parentNode, this.myModel.getChildCount(parentNode));
        if (pathKey.isDirectory()) {
            this.getFolderCache(subtreeRoot).put(pathKey.getKey(), node);
        }
    }

    @NotNull
    public DefaultTreeModel build() {
        TreeModelBuilder.collapseDirectories(this.myModel, this.myRoot);
        this.sortNodes();
        return this.myModel;
    }

    private void sortNodes() {
        TreeUtil.sort((DefaultTreeModel)this.myModel, BROWSER_NODE_COMPARATOR);
        this.myModel.nodeStructureChanged((TreeNode)this.myModel.getRoot());
    }

    private static void collapseDirectories(@NotNull DefaultTreeModel model, @NotNull ChangesBrowserNode node) {
        if (node.getUserObject() instanceof FilePath && node.getChildCount() == 1) {
            ChangesBrowserNode child = (ChangesBrowserNode)node.getChildAt(0);
            if (child.getUserObject() instanceof FilePath && !child.isLeaf()) {
                ChangesBrowserNode parent = (ChangesBrowserNode)node.getParent();
                int idx = parent.getIndex(node);
                model.removeNodeFromParent(node);
                model.removeNodeFromParent(child);
                model.insertNodeInto(child, parent, idx);
                TreeModelBuilder.collapseDirectories(model, parent);
            }
        } else {
            Enumeration<TreeNode> children2 = node.children();
            while (children2.hasMoreElements()) {
                ChangesBrowserNode child = (ChangesBrowserNode)children2.nextElement();
                TreeModelBuilder.collapseDirectories(model, child);
            }
        }
    }

    @NotNull
    private static StaticFilePath getKey(@NotNull Object o) {
        if (o instanceof Change) {
            return TreeModelBuilder.staticFrom(ChangesUtil.getFilePath((Change)((Change)o)));
        }
        if (o instanceof VirtualFile) {
            return TreeModelBuilder.staticFrom((VirtualFile)o);
        }
        if (o instanceof FilePath) {
            return TreeModelBuilder.staticFrom((FilePath)o);
        }
        if (o instanceof ChangesBrowserLogicallyLockedFile) {
            return TreeModelBuilder.staticFrom((VirtualFile)((ChangesBrowserLogicallyLockedFile)o).getUserObject());
        }
        if (o instanceof LocallyDeletedChange) {
            return TreeModelBuilder.staticFrom(((LocallyDeletedChange)o).getPath());
        }
        throw new IllegalArgumentException("Unknown type - " + o.getClass());
    }

    @NotNull
    private static StaticFilePath staticFrom(@NotNull FilePath fp) {
        String path = fp.getPath();
        if (fp.isNonLocal() && (!FileUtil.isAbsolute((String)path) || VcsUtil.isPathRemote((String)path))) {
            return new StaticFilePath(fp.isDirectory(), fp.getIOFile().getPath().replace('\\', '/'), fp.getVirtualFile());
        }
        return new StaticFilePath(fp.isDirectory(), new File(fp.getIOFile().getPath().replace('\\', '/')).getAbsolutePath(), fp.getVirtualFile());
    }

    @NotNull
    private static StaticFilePath staticFrom(@NotNull VirtualFile vf) {
        return new StaticFilePath(vf.isDirectory(), vf.getPath(), vf);
    }

    @NotNull
    public static FilePath getPathForObject(@NotNull Object o) {
        if (o instanceof Change) {
            return ChangesUtil.getFilePath((Change)((Change)o));
        }
        if (o instanceof VirtualFile) {
            return VcsUtil.getFilePath((VirtualFile)((VirtualFile)o));
        }
        if (o instanceof FilePath) {
            return (FilePath)o;
        }
        if (o instanceof ChangesBrowserLogicallyLockedFile) {
            return VcsUtil.getFilePath((VirtualFile)((VirtualFile)((ChangesBrowserLogicallyLockedFile)o).getUserObject()));
        }
        if (o instanceof LocallyDeletedChange) {
            return ((LocallyDeletedChange)o).getPath();
        }
        throw new IllegalArgumentException("Unknown type - " + o.getClass());
    }

    @NotNull
    protected ChangesBrowserNode getParentNodeFor(@NotNull StaticFilePath nodePath, @NotNull ChangesBrowserNode subtreeRoot) {
        return this.getParentNodeFor(nodePath, subtreeRoot, (Convertor<StaticFilePath, ChangesBrowserNode>)((Convertor)this::createPathNode));
    }

    @NotNull
    protected ChangesBrowserNode getParentNodeFor(@NotNull StaticFilePath nodePath, @NotNull ChangesBrowserNode subtreeRoot, @NotNull Convertor<StaticFilePath, ChangesBrowserNode> nodeBuilder) {
        ChangesBrowserNode nodeFromPolicy;
        if (this.myShowFlatten) {
            return subtreeRoot;
        }
        ChangesGroupingPolicy policy = this.myGroupingPoliciesCache.get(subtreeRoot);
        if (policy != null && (nodeFromPolicy = policy.getParentNodeFor(nodePath, subtreeRoot)) != null) {
            return nodeFromPolicy;
        }
        for (StaticFilePath parentPath = nodePath.getParent(); parentPath != null; parentPath = parentPath.getParent()) {
            ChangesBrowserNode oldParentNode = this.getFolderCache(subtreeRoot).get(parentPath.getKey());
            if (oldParentNode != null) {
                return oldParentNode;
            }
            ChangesBrowserNode parentNode = (ChangesBrowserNode)nodeBuilder.convert((Object)parentPath);
            if (parentNode == null) continue;
            ChangesBrowserNode grandPa = this.getParentNodeFor(parentPath, subtreeRoot, nodeBuilder);
            this.myModel.insertNodeInto(parentNode, grandPa, grandPa.getChildCount());
            this.getFolderCache(subtreeRoot).put(parentPath.getKey(), parentNode);
            return parentNode;
        }
        return subtreeRoot;
    }

    @Nullable
    private ChangesBrowserNode createPathNode(@NotNull StaticFilePath path) {
        FilePath filePath = path.getVf() == null ? VcsUtil.getFilePath((String)path.getPath(), (boolean)true) : VcsUtil.getFilePath((VirtualFile)path.getVf());
        return ChangesBrowserNode.create(this.myProject, filePath);
    }

    @NotNull
    private Map<String, ChangesBrowserNode> getFolderCache(@NotNull ChangesBrowserNode subtreeRoot) {
        return this.myFoldersCache.computeIfAbsent(subtreeRoot, key2 -> new HashMap());
    }

    public boolean isEmpty() {
        return this.myModel.getChildCount(this.myRoot) == 0;
    }

    @Deprecated
    @NotNull
    public DefaultTreeModel buildModel(@NotNull List<Change> changes, @Nullable ChangeNodeDecorator changeNodeDecorator) {
        return this.setChanges(changes, changeNodeDecorator).build();
    }

    private static class MyGroupingPolicyFactoryMap
    extends FactoryMap<ChangesBrowserNode, ChangesGroupingPolicy> {
        @NotNull
        private final Project myProject;
        @NotNull
        private final DefaultTreeModel myModel;

        public MyGroupingPolicyFactoryMap(@NotNull Project project2, @NotNull DefaultTreeModel model) {
            this.myProject = project2;
            this.myModel = model;
        }

        @Nullable
        protected ChangesGroupingPolicy create(ChangesBrowserNode key2) {
            ChangesGroupingPolicyFactory factory = ChangesGroupingPolicyFactory.getInstance(this.myProject);
            return factory != null ? factory.createGroupingPolicy(this.myModel) : null;
        }
    }
}

