/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.checkin;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.actions.OptimizeImportsProcessor;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.CheckinProjectPanel;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsConfiguration;
import com.intellij.openapi.vcs.checkin.CheckinHandler;
import com.intellij.openapi.vcs.checkin.CheckinHandlerUtil;
import com.intellij.openapi.vcs.checkin.CheckinMetaHandler;
import com.intellij.openapi.vcs.ui.RefreshableOnComponent;
import com.intellij.ui.NonFocusableCheckBox;
import java.awt.GridLayout;
import java.util.Collection;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OptimizeImportsBeforeCheckinHandler
extends CheckinHandler
implements CheckinMetaHandler {
    public static final String COMMAND_NAME = CodeInsightBundle.message((String)"process.optimize.imports.before.commit", (Object[])new Object[0]);
    protected final Project myProject;
    private final CheckinProjectPanel myPanel;

    public OptimizeImportsBeforeCheckinHandler(Project project2, CheckinProjectPanel panel2) {
        this.myProject = project2;
        this.myPanel = panel2;
    }

    @Nullable
    public RefreshableOnComponent getBeforeCheckinConfigurationPanel() {
        NonFocusableCheckBox optimizeBox = new NonFocusableCheckBox(VcsBundle.message((String)"checkbox.checkin.options.optimize.imports", (Object[])new Object[0]));
        CheckinHandlerUtil.disableWhenDumb(this.myProject, (JCheckBox)optimizeBox, "Impossible until indices are up-to-date");
        return new RefreshableOnComponent((JCheckBox)optimizeBox){
            final /* synthetic */ JCheckBox val$optimizeBox;
            {
                this.val$optimizeBox = jCheckBox;
            }

            public JComponent getComponent() {
                JPanel panel2 = new JPanel(new GridLayout(1, 0));
                panel2.add(this.val$optimizeBox);
                return panel2;
            }

            public void refresh() {
            }

            public void saveState() {
                OptimizeImportsBeforeCheckinHandler.this.getSettings().OPTIMIZE_IMPORTS_BEFORE_PROJECT_COMMIT = this.val$optimizeBox.isSelected();
            }

            public void restoreState() {
                this.val$optimizeBox.setSelected(OptimizeImportsBeforeCheckinHandler.this.getSettings().OPTIMIZE_IMPORTS_BEFORE_PROJECT_COMMIT);
            }
        };
    }

    protected VcsConfiguration getSettings() {
        return VcsConfiguration.getInstance((Project)this.myProject);
    }

    public void runCheckinHandlers(final @NotNull Runnable finishAction) {
        VcsConfiguration configuration = VcsConfiguration.getInstance((Project)this.myProject);
        Collection files = this.myPanel.getVirtualFiles();
        Runnable performCheckoutAction = new Runnable(){

            @Override
            public void run() {
                FileDocumentManager.getInstance().saveAllDocuments();
                finishAction.run();
            }
        };
        if (configuration.OPTIMIZE_IMPORTS_BEFORE_PROJECT_COMMIT && !DumbService.isDumb((Project)this.myProject)) {
            new OptimizeImportsProcessor(this.myProject, CheckinHandlerUtil.getPsiFiles(this.myProject, files), COMMAND_NAME, performCheckoutAction).run();
        } else {
            finishAction.run();
        }
    }
}

