/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.configurable;

import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.UnnamedConfigurable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Getter;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.configurable.LazyConfigurable;
import com.intellij.openapi.vcs.impl.VcsDescriptor;
import com.intellij.openapi.vcs.impl.projectlevelman.AllVcses;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.components.JBList;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VcsConfigurationsDialog
extends DialogWrapper {
    private JList myVcses;
    private JPanel myVcsConfigurationPanel;
    private final Project myProject;
    private JPanel myVersionControlConfigurationsPanel;
    private static final String NONE = VcsBundle.message((String)"none.vcs.presentation", (Object[])new Object[0]);
    private final Map<String, UnnamedConfigurable> myVcsNameToConfigurableMap;
    private static final ColoredListCellRenderer VCS_LIST_RENDERER = new ColoredListCellRenderer(){

        protected void customizeCellRenderer(@NotNull JList list, Object value2, int index, boolean selected, boolean hasFocus) {
            String name = value2 == null ? NONE : ((VcsDescriptor)value2).getDisplayName();
            this.append(name, new SimpleTextAttributes(0, list.getForeground()));
        }
    };
    private JScrollPane myVcsesScrollPane;
    @Nullable
    private final JComboBox myVcsesToUpdate;

    public VcsConfigurationsDialog(Project project2, @Nullable JComboBox vcses, VcsDescriptor selectedVcs) {
        super(project2, false);
        this.$$$setupUI$$$();
        this.myVcsNameToConfigurableMap = new HashMap<String, UnnamedConfigurable>();
        this.myProject = project2;
        VcsDescriptor[] abstractVcses = this.collectAvailableNames();
        this.initList(abstractVcses);
        this.initVcsConfigurable(abstractVcses);
        this.updateConfiguration();
        this.myVcsesToUpdate = vcses;
        for (String vcsName : this.myVcsNameToConfigurableMap.keySet()) {
            UnnamedConfigurable configurable = this.myVcsNameToConfigurableMap.get(vcsName);
            if (configurable == null || !configurable.isModified()) continue;
            configurable.reset();
        }
        this.updateConfiguration();
        if (selectedVcs != null) {
            this.myVcses.setSelectedValue(selectedVcs, true);
        }
        this.init();
        this.setTitle(VcsBundle.message((String)"dialog.title.version.control.configurations", (Object[])new Object[0]));
    }

    private void updateConfiguration() {
        String currentName;
        int selectedIndex = this.myVcses.getSelectionModel().getMinSelectionIndex();
        VcsDescriptor currentVcs = selectedIndex >= 0 ? (VcsDescriptor)this.myVcses.getModel().getElementAt(selectedIndex) : null;
        String string = currentName = currentVcs == null ? NONE : currentVcs.getName();
        if (currentVcs != null) {
            UnnamedConfigurable unnamedConfigurable = this.myVcsNameToConfigurableMap.get(currentName);
            unnamedConfigurable.createComponent();
            unnamedConfigurable.reset();
        }
        CardLayout cardLayout = (CardLayout)this.myVcsConfigurationPanel.getLayout();
        cardLayout.show(this.myVcsConfigurationPanel, currentName);
    }

    private void initVcsConfigurable(VcsDescriptor[] vcses) {
        this.myVcsConfigurationPanel.setLayout(new CardLayout());
        MyNullConfigurable nullConfigurable = new MyNullConfigurable();
        this.myVcsNameToConfigurableMap.put(NONE, (UnnamedConfigurable)nullConfigurable);
        this.myVcsConfigurationPanel.add((Component)nullConfigurable.createComponent(), NONE);
        for (VcsDescriptor vcs : vcses) {
            this.addConfigurationPanelFor(vcs);
        }
    }

    private void addConfigurationPanelFor(final VcsDescriptor vcs) {
        String name = vcs.getName();
        JPanel parentPanel = new JPanel();
        LazyConfigurable lazyConfigurable = new LazyConfigurable(new Getter<Configurable>(){

            public Configurable get() {
                return AllVcses.getInstance(VcsConfigurationsDialog.this.myProject).getByName(vcs.getName()).getConfigurable();
            }
        }, parentPanel);
        this.myVcsNameToConfigurableMap.put(name, lazyConfigurable);
        this.myVcsConfigurationPanel.add((Component)parentPanel, name);
    }

    private void initList(VcsDescriptor[] names) {
        DefaultListModel<VcsDescriptor> model = new DefaultListModel<VcsDescriptor>();
        for (VcsDescriptor name : names) {
            model.addElement(name);
        }
        this.myVcses.setModel(model);
        this.myVcses.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                VcsConfigurationsDialog.this.updateConfiguration();
            }
        });
        this.myVcses.setCellRenderer(VCS_LIST_RENDERER);
        this.myVcsesScrollPane.setMinimumSize(this.myVcsesScrollPane.getPreferredSize());
    }

    private VcsDescriptor[] collectAvailableNames() {
        return ProjectLevelVcsManager.getInstance((Project)this.myProject).getAllVcss();
    }

    protected JComponent createCenterPanel() {
        return this.myVersionControlConfigurationsPanel;
    }

    protected void doOKAction() {
        for (String vcsName : this.myVcsNameToConfigurableMap.keySet()) {
            UnnamedConfigurable configurable = this.myVcsNameToConfigurableMap.get(vcsName);
            if (configurable == null || !configurable.isModified()) continue;
            try {
                configurable.apply();
            }
            catch (ConfigurationException e) {
                Messages.showErrorDialog((String)VcsBundle.message((String)"message.text.unable.to.save.settings", (Object[])new Object[]{e.getMessage()}), (String)VcsBundle.message((String)"message.title.unable.to.save.settings", (Object[])new Object[0]));
            }
        }
        JComboBox vcsesToUpdate = this.myVcsesToUpdate;
        if (vcsesToUpdate != null) {
            VcsDescriptor wrapper = (VcsDescriptor)this.myVcses.getSelectedValue();
            vcsesToUpdate.setSelectedItem(wrapper);
            ComboBoxModel model = vcsesToUpdate.getModel();
            for (int i2 = 0; i2 < model.getSize(); ++i2) {
                VcsDescriptor defaultVcsWrapper;
                Object vcsWrapper = model.getElementAt(i2);
                if (!(vcsWrapper instanceof VcsDescriptor) || !(defaultVcsWrapper = (VcsDescriptor)vcsWrapper).equals((Object)wrapper)) continue;
                vcsesToUpdate.setSelectedIndex(i2);
                break;
            }
        }
        super.doOKAction();
    }

    protected void dispose() {
        this.myVcses.setCellRenderer(new DefaultListCellRenderer());
        super.dispose();
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JPanel jPanel;
        JPanel jPanel2;
        this.myVersionControlConfigurationsPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(4, 4, 0, 0), -1, -1, false, false));
        JLabel jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, ResourceBundle.getBundle("messages/VcsBundle").getString("label.configure.vcses.available.vcses"));
        jPanel2.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel3, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JBScrollPane jBScrollPane = new JBScrollPane();
        this.myVcsesScrollPane = jBScrollPane;
        jPanel3.add((Component)jBScrollPane, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JBList jBList = new JBList();
        this.myVcses = jBList;
        jBScrollPane.setViewportView((Component)jBList);
        this.myVcsConfigurationPanel = jPanel = new JPanel();
        jPanel3.add((Component)jPanel, new GridConstraints(0, 1, 1, 1, 0, 3, 3, 3, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myVersionControlConfigurationsPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int j = 0; j < string.length(); ++j) {
            if (string.charAt(j) == '&') {
                if (++j == string.length()) break;
                if (!bl && string.charAt(j) != '&') {
                    bl = true;
                    c = string.charAt(j);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(j));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private static class MyNullConfigurable
    implements Configurable {
        private MyNullConfigurable() {
        }

        public String getDisplayName() {
            return NONE;
        }

        public String getHelpTopic() {
            return "project.propVCSSupport";
        }

        public JComponent createComponent() {
            return new JPanel();
        }

        public boolean isModified() {
            return false;
        }

        public void apply() throws ConfigurationException {
        }

        public void reset() {
        }

        public void disposeUIResources() {
        }
    }
}

