/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.configurable;

import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.configurable.ModuleVcsListener;
import com.intellij.openapi.vcs.configurable.VcsDirectoryConfigurationPanel;
import com.intellij.openapi.vcs.configurable.VcsGeneralConfigurationPanel;
import com.intellij.openapi.vcs.configurable.VcsManagerConfigurable;
import java.util.Arrays;
import java.util.Collection;
import javax.swing.JComponent;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VcsGeneralConfigurationConfigurable
implements SearchableConfigurable {
    private VcsGeneralConfigurationPanel myPanel;
    private Project myProject;
    private VcsManagerConfigurable myMainConfigurable;

    public VcsGeneralConfigurationConfigurable(Project project2, VcsManagerConfigurable configurable) {
        this.myProject = project2;
        this.myMainConfigurable = configurable;
    }

    @Nullable
    public JComponent createComponent() {
        this.myPanel = new VcsGeneralConfigurationPanel(this.myProject);
        if (this.getMappings() != null) {
            this.myPanel.updateAvailableOptions(this.getMappings().getActiveVcses());
            this.addListenerToGeneralPanel();
        } else {
            this.myPanel.updateAvailableOptions(Arrays.asList(ProjectLevelVcsManager.getInstance((Project)this.myProject).getAllActiveVcss()));
        }
        this.addListenerToGeneralPanel();
        return this.myPanel.getPanel();
    }

    private VcsDirectoryConfigurationPanel getMappings() {
        return this.myMainConfigurable.getMappings();
    }

    private void addListenerToGeneralPanel() {
        VcsDirectoryConfigurationPanel mappings = this.getMappings();
        if (mappings != null) {
            mappings.addVcsListener(new ModuleVcsListener(){

                @Override
                public void activeVcsSetChanged(Collection<AbstractVcs> activeVcses) {
                    VcsGeneralConfigurationConfigurable.this.myPanel.updateAvailableOptions(activeVcses);
                }
            });
        }
    }

    public void apply() throws ConfigurationException {
        this.myPanel.apply();
    }

    public boolean isModified() {
        return this.myPanel.isModified();
    }

    public void reset() {
        this.myPanel.reset();
    }

    public void disposeUIResources() {
        this.myPanel = null;
    }

    @Nls
    public String getDisplayName() {
        return "Confirmation";
    }

    @NotNull
    public String getHelpTopic() {
        return "project.propVCSSupport.Confirmation";
    }

    @NotNull
    public String getId() {
        return this.getHelpTopic();
    }
}

