/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.configurable;

import com.intellij.ide.actions.ShowFilePathAction;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsConfiguration;
import com.intellij.openapi.vcs.VcsShowConfirmationOption;
import com.intellij.openapi.vcs.VcsShowConfirmationOptionImpl;
import com.intellij.openapi.vcs.VcsShowOptionsSettingImpl;
import com.intellij.openapi.vcs.ex.ProjectLevelVcsManagerEx;
import com.intellij.openapi.vcs.readOnlyHandler.ReadonlyStatusHandlerImpl;
import com.intellij.openapi.vfs.ReadonlyStatusHandler;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.TreeSet;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.border.Border;
import org.jetbrains.annotations.Nullable;

public class VcsGeneralConfigurationPanel {
    private JCheckBox myForceNonEmptyComment;
    private JCheckBox myShowReadOnlyStatusDialog;
    private JRadioButton myShowDialogOnAddingFile;
    private JRadioButton myPerformActionOnAddingFile;
    private JRadioButton myDoNothingOnAddingFile;
    private JRadioButton myShowDialogOnRemovingFile;
    private JRadioButton myPerformActionOnRemovingFile;
    private JRadioButton myDoNothingOnRemovingFile;
    private JPanel myPanel;
    private final JRadioButton[] myOnFileAddingGroup;
    private final JRadioButton[] myOnFileRemovingGroup;
    private final Project myProject;
    private JPanel myPromptsPanel;
    Map<VcsShowOptionsSettingImpl, JCheckBox> myPromptOptions;
    private JPanel myRemoveConfirmationPanel;
    private JPanel myAddConfirmationPanel;
    private JCheckBox myCbOfferToMoveChanges;
    private JComboBox myFailedCommitChangelistCombo;
    private JComboBox myOnPatchCreation;
    private JCheckBox myClearInitialCommitMessage;
    private ButtonGroup myEmptyChangelistRemovingGroup;

    public VcsGeneralConfigurationPanel(Project project2) {
        this.$$$setupUI$$$();
        this.myPromptOptions = new LinkedHashMap<VcsShowOptionsSettingImpl, JCheckBox>();
        this.myProject = project2;
        this.myOnFileAddingGroup = new JRadioButton[]{this.myShowDialogOnAddingFile, this.myPerformActionOnAddingFile, this.myDoNothingOnAddingFile};
        this.myOnFileRemovingGroup = new JRadioButton[]{this.myShowDialogOnRemovingFile, this.myPerformActionOnRemovingFile, this.myDoNothingOnRemovingFile};
        this.myPromptsPanel.setLayout(new GridLayout(3, 0));
        List<VcsShowOptionsSettingImpl> options = ProjectLevelVcsManagerEx.getInstanceEx(project2).getAllOptions();
        for (VcsShowOptionsSettingImpl setting : options) {
            if (setting.getApplicableVcses().isEmpty() && !project2.isDefault()) continue;
            JCheckBox checkBox = new JCheckBox(setting.getDisplayName());
            this.myPromptsPanel.add(checkBox);
            this.myPromptOptions.put(setting, checkBox);
        }
        this.myPromptsPanel.setSize(this.myPromptsPanel.getPreferredSize());
        this.myOnPatchCreation.setName((SystemInfo.isMac ? "Reveal patch in" : "Show patch in ") + ShowFilePathAction.getFileManagerName() + " after creation:");
    }

    public void apply() throws ConfigurationException {
        VcsConfiguration settings = VcsConfiguration.getInstance((Project)this.myProject);
        settings.FORCE_NON_EMPTY_COMMENT = this.myForceNonEmptyComment.isSelected();
        settings.CLEAR_INITIAL_COMMIT_MESSAGE = this.myClearInitialCommitMessage.isSelected();
        settings.OFFER_MOVE_TO_ANOTHER_CHANGELIST_ON_PARTIAL_COMMIT = this.myCbOfferToMoveChanges.isSelected();
        settings.REMOVE_EMPTY_INACTIVE_CHANGELISTS = VcsGeneralConfigurationPanel.getSelected(this.myEmptyChangelistRemovingGroup);
        settings.MOVE_TO_FAILED_COMMIT_CHANGELIST = this.getFailedCommitConfirm();
        for (VcsShowOptionsSettingImpl setting : this.myPromptOptions.keySet()) {
            setting.setValue(this.myPromptOptions.get(setting).isSelected());
        }
        this.getAddConfirmation().setValue(VcsGeneralConfigurationPanel.getSelected(this.myOnFileAddingGroup));
        this.getRemoveConfirmation().setValue(VcsGeneralConfigurationPanel.getSelected(this.myOnFileRemovingGroup));
        this.applyPatchOption(settings);
        this.getReadOnlyStatusHandler().getState().SHOW_DIALOG = this.myShowReadOnlyStatusDialog.isSelected();
    }

    private void applyPatchOption(VcsConfiguration settings) {
        settings.SHOW_PATCH_IN_EXPLORER = this.getShowPatchValue();
    }

    @Nullable
    private Boolean getShowPatchValue() {
        int index = this.myOnPatchCreation.getSelectedIndex();
        if (index == 0) {
            return null;
        }
        if (index == 1) {
            return true;
        }
        return false;
    }

    private VcsShowConfirmationOption.Value getFailedCommitConfirm() {
        switch (this.myFailedCommitChangelistCombo.getSelectedIndex()) {
            case 0: {
                return VcsShowConfirmationOption.Value.DO_ACTION_SILENTLY;
            }
            case 1: {
                return VcsShowConfirmationOption.Value.DO_NOTHING_SILENTLY;
            }
        }
        return VcsShowConfirmationOption.Value.SHOW_CONFIRMATION;
    }

    private VcsShowConfirmationOption getAddConfirmation() {
        return ProjectLevelVcsManagerEx.getInstanceEx(this.myProject).getConfirmation(VcsConfiguration.StandardConfirmation.ADD);
    }

    private VcsShowConfirmationOption getRemoveConfirmation() {
        return ProjectLevelVcsManagerEx.getInstanceEx(this.myProject).getConfirmation(VcsConfiguration.StandardConfirmation.REMOVE);
    }

    private static VcsShowConfirmationOption.Value getSelected(JRadioButton[] group) {
        if (group[0].isSelected()) {
            return VcsShowConfirmationOption.Value.SHOW_CONFIRMATION;
        }
        if (group[1].isSelected()) {
            return VcsShowConfirmationOption.Value.DO_ACTION_SILENTLY;
        }
        return VcsShowConfirmationOption.Value.DO_NOTHING_SILENTLY;
    }

    private static VcsShowConfirmationOption.Value getSelected(ButtonGroup group) {
        switch (UIUtil.getSelectedButton((ButtonGroup)group)) {
            case 0: {
                return VcsShowConfirmationOption.Value.SHOW_CONFIRMATION;
            }
            case 1: {
                return VcsShowConfirmationOption.Value.DO_ACTION_SILENTLY;
            }
        }
        return VcsShowConfirmationOption.Value.DO_NOTHING_SILENTLY;
    }

    private ReadonlyStatusHandlerImpl getReadOnlyStatusHandler() {
        return (ReadonlyStatusHandlerImpl)ReadonlyStatusHandler.getInstance((Project)this.myProject);
    }

    public boolean isModified() {
        VcsConfiguration settings = VcsConfiguration.getInstance((Project)this.myProject);
        if (settings.FORCE_NON_EMPTY_COMMENT != this.myForceNonEmptyComment.isSelected()) {
            return true;
        }
        if (settings.CLEAR_INITIAL_COMMIT_MESSAGE != this.myClearInitialCommitMessage.isSelected()) {
            return true;
        }
        if (settings.OFFER_MOVE_TO_ANOTHER_CHANGELIST_ON_PARTIAL_COMMIT != this.myCbOfferToMoveChanges.isSelected()) {
            return true;
        }
        if (settings.REMOVE_EMPTY_INACTIVE_CHANGELISTS != VcsGeneralConfigurationPanel.getSelected(this.myEmptyChangelistRemovingGroup)) {
            return true;
        }
        if (!Comparing.equal((Object)this.getFailedCommitConfirm(), (Object)settings.MOVE_TO_FAILED_COMMIT_CHANGELIST)) {
            return true;
        }
        if (this.getReadOnlyStatusHandler().getState().SHOW_DIALOG != this.myShowReadOnlyStatusDialog.isSelected()) {
            return true;
        }
        for (VcsShowOptionsSettingImpl setting : this.myPromptOptions.keySet()) {
            if (setting.getValue() == this.myPromptOptions.get(setting).isSelected()) continue;
            return true;
        }
        if (VcsGeneralConfigurationPanel.getSelected(this.myOnFileAddingGroup) != this.getAddConfirmation().getValue()) {
            return true;
        }
        if (VcsGeneralConfigurationPanel.getSelected(this.myOnFileRemovingGroup) != this.getRemoveConfirmation().getValue()) {
            return true;
        }
        return !Comparing.equal((Object)settings.SHOW_PATCH_IN_EXPLORER, (Object)this.getShowPatchValue());
    }

    public void reset() {
        VcsConfiguration settings = VcsConfiguration.getInstance((Project)this.myProject);
        this.myForceNonEmptyComment.setSelected(settings.FORCE_NON_EMPTY_COMMENT);
        this.myClearInitialCommitMessage.setSelected(settings.CLEAR_INITIAL_COMMIT_MESSAGE);
        this.myCbOfferToMoveChanges.setSelected(settings.OFFER_MOVE_TO_ANOTHER_CHANGELIST_ON_PARTIAL_COMMIT);
        VcsShowConfirmationOption.Value value2 = settings.REMOVE_EMPTY_INACTIVE_CHANGELISTS;
        UIUtil.setSelectedButton((ButtonGroup)this.myEmptyChangelistRemovingGroup, (int)(value2 == VcsShowConfirmationOption.Value.SHOW_CONFIRMATION ? 0 : (value2 == VcsShowConfirmationOption.Value.DO_NOTHING_SILENTLY ? 2 : 1)));
        this.myShowReadOnlyStatusDialog.setSelected(this.getReadOnlyStatusHandler().getState().SHOW_DIALOG);
        if (settings.MOVE_TO_FAILED_COMMIT_CHANGELIST == VcsShowConfirmationOption.Value.DO_ACTION_SILENTLY) {
            this.myFailedCommitChangelistCombo.setSelectedIndex(0);
        } else if (settings.MOVE_TO_FAILED_COMMIT_CHANGELIST == VcsShowConfirmationOption.Value.DO_NOTHING_SILENTLY) {
            this.myFailedCommitChangelistCombo.setSelectedIndex(1);
        } else {
            this.myFailedCommitChangelistCombo.setSelectedIndex(2);
        }
        for (VcsShowOptionsSettingImpl setting : this.myPromptOptions.keySet()) {
            this.myPromptOptions.get(setting).setSelected(setting.getValue());
        }
        VcsGeneralConfigurationPanel.selectInGroup(this.myOnFileAddingGroup, this.getAddConfirmation());
        VcsGeneralConfigurationPanel.selectInGroup(this.myOnFileRemovingGroup, this.getRemoveConfirmation());
        if (settings.SHOW_PATCH_IN_EXPLORER == null) {
            this.myOnPatchCreation.setSelectedIndex(0);
        } else if (Boolean.TRUE.equals(settings.SHOW_PATCH_IN_EXPLORER)) {
            this.myOnPatchCreation.setSelectedIndex(1);
        } else {
            this.myOnPatchCreation.setSelectedIndex(2);
        }
    }

    private static void selectInGroup(JRadioButton[] group, VcsShowConfirmationOption confirmation) {
        int index;
        VcsShowConfirmationOption.Value value2 = confirmation.getValue();
        switch (value2) {
            case SHOW_CONFIRMATION: {
                index = 0;
                break;
            }
            case DO_ACTION_SILENTLY: {
                index = 1;
                break;
            }
            default: {
                index = 2;
            }
        }
        group[index].setSelected(true);
    }

    public JComponent getPanel() {
        return this.myPanel;
    }

    public void updateAvailableOptions(Collection<AbstractVcs> activeVcses) {
        for (VcsShowOptionsSettingImpl setting : this.myPromptOptions.keySet()) {
            JCheckBox checkBox = this.myPromptOptions.get(setting);
            checkBox.setEnabled(setting.isApplicableTo(activeVcses) || this.myProject.isDefault());
            if (this.myProject.isDefault()) continue;
            checkBox.setToolTipText(VcsBundle.message((String)"tooltip.text.action.applicable.to.vcses", (Object[])new Object[]{VcsGeneralConfigurationPanel.composeText(setting.getApplicableVcses())}));
        }
        if (!this.myProject.isDefault()) {
            ProjectLevelVcsManagerEx vcsManager = ProjectLevelVcsManagerEx.getInstanceEx(this.myProject);
            VcsShowConfirmationOptionImpl addConfirmation = vcsManager.getConfirmation(VcsConfiguration.StandardConfirmation.ADD);
            UIUtil.setEnabled((Component)this.myAddConfirmationPanel, (boolean)addConfirmation.isApplicableTo(activeVcses), (boolean)true);
            this.myAddConfirmationPanel.setToolTipText(VcsBundle.message((String)"tooltip.text.action.applicable.to.vcses", (Object[])new Object[]{VcsGeneralConfigurationPanel.composeText(addConfirmation.getApplicableVcses())}));
            VcsShowConfirmationOptionImpl removeConfirmation = vcsManager.getConfirmation(VcsConfiguration.StandardConfirmation.REMOVE);
            UIUtil.setEnabled((Component)this.myRemoveConfirmationPanel, (boolean)removeConfirmation.isApplicableTo(activeVcses), (boolean)true);
            this.myRemoveConfirmationPanel.setToolTipText(VcsBundle.message((String)"tooltip.text.action.applicable.to.vcses", (Object[])new Object[]{VcsGeneralConfigurationPanel.composeText(removeConfirmation.getApplicableVcses())}));
        }
    }

    private static String composeText(List<AbstractVcs> applicableVcses) {
        TreeSet<String> result2 = new TreeSet<String>();
        for (AbstractVcs abstractVcs : applicableVcses) {
            result2.add(abstractVcs.getDisplayName());
        }
        return StringUtil.join(result2, (String)", ");
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JCheckBox jCheckBox;
        JComboBox jComboBox;
        JComboBox jComboBox2;
        JCheckBox jCheckBox2;
        JCheckBox jCheckBox3;
        JCheckBox jCheckBox4;
        JPanel jPanel;
        JRadioButton jRadioButton;
        JRadioButton jRadioButton2;
        JRadioButton jRadioButton3;
        JPanel jPanel2;
        JRadioButton jRadioButton4;
        JRadioButton jRadioButton5;
        JRadioButton jRadioButton6;
        JPanel jPanel3;
        JPanel jPanel4;
        this.myPanel = jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(4, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        Spacer spacer = new Spacer();
        jPanel4.add((Component)spacer, new GridConstraints(3, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        this.myAddConfirmationPanel = jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(3, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel3.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithIndent");
        jPanel4.add((Component)jPanel3, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        jPanel3.setBorder(IdeBorderFactory.PlainSmallWithIndent.createTitledBorder((Border)BorderFactory.createEtchedBorder(), (String)"When files are created", (int)0, (int)0, null, null));
        this.myShowDialogOnAddingFile = jRadioButton6 = new JRadioButton();
        this.$$$loadButtonText$$$(jRadioButton6, ResourceBundle.getBundle("messages/VcsBundle").getString("radio.after.creation.show.options"));
        jRadioButton6.setMargin(new Insets(2, 2, 2, 2));
        jPanel3.add((Component)jRadioButton6, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myPerformActionOnAddingFile = jRadioButton5 = new JRadioButton();
        this.$$$loadButtonText$$$(jRadioButton5, ResourceBundle.getBundle("messages/VcsBundle").getString("radio.after.creation.add.silently"));
        jPanel3.add((Component)jRadioButton5, new GridConstraints(1, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myDoNothingOnAddingFile = jRadioButton4 = new JRadioButton();
        this.$$$loadButtonText$$$(jRadioButton4, ResourceBundle.getBundle("messages/VcsBundle").getString("radio.after.creation.do.not.add"));
        jPanel3.add((Component)jRadioButton4, new GridConstraints(2, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout((LayoutManager)new GridLayoutManager(3, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel5.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithIndent");
        jPanel4.add((Component)jPanel5, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, new Dimension(300, -1), null, null));
        jPanel5.setBorder(IdeBorderFactory.PlainSmallWithIndent.createTitledBorder((Border)BorderFactory.createEtchedBorder(), (String)"When empty changelist becomes inactive", (int)0, (int)0, null, null));
        JRadioButton jRadioButton7 = new JRadioButton();
        jRadioButton7.setText("Show options before removing");
        jRadioButton7.setMargin(new Insets(2, 2, 2, 2));
        jPanel5.add((Component)jRadioButton7, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        JRadioButton jRadioButton8 = new JRadioButton();
        jRadioButton8.setText("Remove silently");
        jPanel5.add((Component)jRadioButton8, new GridConstraints(1, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        JRadioButton jRadioButton9 = new JRadioButton();
        jRadioButton9.setText("Do not remove");
        jPanel5.add((Component)jRadioButton9, new GridConstraints(2, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myRemoveConfirmationPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(3, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithIndent");
        jPanel4.add((Component)jPanel2, new GridConstraints(0, 1, 1, 1, 0, 3, 3, 3, null, null, null));
        jPanel2.setBorder(IdeBorderFactory.PlainSmallWithIndent.createTitledBorder((Border)BorderFactory.createEtchedBorder(), (String)"When files are deleted", (int)0, (int)0, null, null));
        this.myShowDialogOnRemovingFile = jRadioButton3 = new JRadioButton();
        this.$$$loadButtonText$$$(jRadioButton3, ResourceBundle.getBundle("messages/VcsBundle").getString("radio.after.deletion.show.options"));
        jRadioButton3.setMargin(new Insets(2, 2, 2, 2));
        jPanel2.add((Component)jRadioButton3, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myPerformActionOnRemovingFile = jRadioButton2 = new JRadioButton();
        this.$$$loadButtonText$$$(jRadioButton2, ResourceBundle.getBundle("messages/VcsBundle").getString("radio.after.deletion.remove.silently"));
        jRadioButton2.setMargin(new Insets(2, 2, 2, 2));
        jPanel2.add((Component)jRadioButton2, new GridConstraints(1, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myDoNothingOnRemovingFile = jRadioButton = new JRadioButton();
        this.$$$loadButtonText$$$(jRadioButton, ResourceBundle.getBundle("messages/VcsBundle").getString("radio.after.deletion.do.not.remove"));
        jRadioButton.setMargin(new Insets(2, 2, 2, 2));
        jPanel2.add((Component)jRadioButton, new GridConstraints(2, 0, 1, 1, 8, 0, 3, 0, null, new Dimension(97, 23), null));
        this.myPromptsPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithIndent");
        jPanel4.add((Component)jPanel, new GridConstraints(1, 1, 1, 1, 0, 3, 3, 3, new Dimension(400, -1), null, null));
        jPanel.setBorder(IdeBorderFactory.PlainSmallWithIndent.createTitledBorder((Border)BorderFactory.createEtchedBorder(), (String)ResourceBundle.getBundle("messages/VcsBundle").getString("border.display.dialog.when.commands.invoked"), (int)0, (int)0, null, null));
        Spacer spacer2 = new Spacer();
        jPanel4.add((Component)spacer2, new GridConstraints(0, 2, 1, 1, 0, 1, 6, 1, null, null, null));
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout((LayoutManager)new GridLayoutManager(6, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel4.add((Component)jPanel6, new GridConstraints(2, 0, 1, 2, 0, 3, 3, 3, null, null, null));
        this.myCbOfferToMoveChanges = jCheckBox4 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox4, ResourceBundle.getBundle("messages/VcsBundle").getString("checkbox.changelist.move.offer"));
        jPanel6.add((Component)jCheckBox4, new GridConstraints(1, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myForceNonEmptyComment = jCheckBox3 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox3, ResourceBundle.getBundle("messages/VcsBundle").getString("checkbox.force.non.empty.messages"));
        jPanel6.add((Component)jCheckBox3, new GridConstraints(2, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myShowReadOnlyStatusDialog = jCheckBox2 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox2, ResourceBundle.getBundle("messages/VcsBundle").getString("checkbox.show.clear.read.only.status.dialog"));
        jPanel6.add((Component)jCheckBox2, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        JPanel jPanel7 = new JPanel();
        jPanel7.setLayout(new FlowLayout(0, 5, 2));
        jPanel6.add((Component)jPanel7, new GridConstraints(5, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JLabel jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, ResourceBundle.getBundle("messages/VcsBundle").getString("create.changelist.on.failed.commit"));
        Component component = jPanel7.add(jLabel);
        this.myFailedCommitChangelistCombo = jComboBox2 = new JComboBox();
        DefaultComboBoxModel<String> defaultComboBoxModel = new DefaultComboBoxModel<String>();
        defaultComboBoxModel.addElement("Yes");
        defaultComboBoxModel.addElement("No");
        defaultComboBoxModel.addElement("Ask");
        jComboBox2.setModel(defaultComboBoxModel);
        Component component2 = jPanel7.add(jComboBox2);
        JPanel jPanel8 = new JPanel();
        jPanel8.setLayout(new FlowLayout(0, 5, 2));
        jPanel6.add((Component)jPanel8, new GridConstraints(4, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JLabel jLabel2 = new JLabel();
        jLabel2.setText("Show patch in Explorer after creation:");
        Component component3 = jPanel8.add(jLabel2);
        this.myOnPatchCreation = jComboBox = new JComboBox();
        DefaultComboBoxModel<String> defaultComboBoxModel2 = new DefaultComboBoxModel<String>();
        defaultComboBoxModel2.addElement("Ask");
        defaultComboBoxModel2.addElement("Yes");
        defaultComboBoxModel2.addElement("No");
        jComboBox.setModel(defaultComboBoxModel2);
        Component component4 = jPanel8.add(jComboBox);
        this.myClearInitialCommitMessage = jCheckBox = new JCheckBox();
        jCheckBox.setText("Clear initial commit message");
        jCheckBox.setMnemonic('I');
        jCheckBox.setDisplayedMnemonicIndex(6);
        jPanel6.add((Component)jCheckBox, new GridConstraints(3, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        jLabel.setLabelFor(jComboBox2);
        jLabel2.setLabelFor(jComboBox);
        ButtonGroup buttonGroup2 = new ButtonGroup();
        buttonGroup2.add(jRadioButton6);
        buttonGroup2.add(jRadioButton5);
        buttonGroup2.add(jRadioButton4);
        buttonGroup2 = new ButtonGroup();
        buttonGroup2.add(jRadioButton3);
        buttonGroup2.add(jRadioButton2);
        buttonGroup2.add(jRadioButton);
        this.myEmptyChangelistRemovingGroup = buttonGroup2 = new ButtonGroup();
        buttonGroup2.add(jRadioButton7);
        buttonGroup2.add(jRadioButton8);
        buttonGroup2.add(jRadioButton9);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int j = 0; j < string.length(); ++j) {
            if (string.charAt(j) == '&') {
                if (++j == string.length()) break;
                if (!bl && string.charAt(j) != '&') {
                    bl = true;
                    c = string.charAt(j);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(j));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int j = 0; j < string.length(); ++j) {
            if (string.charAt(j) == '&') {
                if (++j == string.length()) break;
                if (!bl && string.charAt(j) != '&') {
                    bl = true;
                    c = string.charAt(j);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(j));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }
}

