/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.ex;

import com.intellij.codeInsight.hint.EditorFragmentComponent;
import com.intellij.codeInsight.hint.HintManagerImpl;
import com.intellij.diff.comparison.ByWord;
import com.intellij.diff.comparison.ComparisonPolicy;
import com.intellij.diff.fragments.DiffFragment;
import com.intellij.diff.util.DiffDrawUtil;
import com.intellij.diff.util.DiffUtil;
import com.intellij.diff.util.TextDiffType;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.highlighter.EditorHighlighterFactory;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.PlainTextFileType;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.util.BackgroundTaskUtil;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vcs.VcsApplicationSettings;
import com.intellij.openapi.vcs.ex.LineStatusTrackerBase;
import com.intellij.openapi.vcs.ex.Range;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.HintHint;
import com.intellij.ui.HintListener;
import com.intellij.ui.LightweightHint;
import com.intellij.util.Function;
import com.intellij.util.ui.JBEmptyBorder;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.components.BorderLayoutPanel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class LineStatusMarkerPopup {
    @NotNull
    public final LineStatusTrackerBase myTracker;
    @NotNull
    public final Editor myEditor;
    @NotNull
    public final Range myRange;

    public LineStatusMarkerPopup(@NotNull LineStatusTrackerBase tracker, @NotNull Editor editor, @NotNull Range range) {
        this.myTracker = tracker;
        this.myEditor = editor;
        this.myRange = range;
    }

    @NotNull
    protected abstract List<AnAction> createToolbarActions(@Nullable Point var1);

    @NotNull
    protected FileType getFileType() {
        return PlainTextFileType.INSTANCE;
    }

    protected boolean isShowInnerDifferences() {
        return VcsApplicationSettings.getInstance().SHOW_LST_WORD_DIFFERENCES;
    }

    public void scrollAndShow() {
        if (!this.myTracker.isValid()) {
            return;
        }
        Document document = this.myTracker.getDocument();
        int line = Math.min(this.myRange.getType() == 3 ? this.myRange.getLine2() : this.myRange.getLine2() - 1, DiffUtil.getLineCount(document) - 1);
        int lastOffset = document.getLineStartOffset(line);
        this.myEditor.getCaretModel().moveToOffset(lastOffset);
        this.myEditor.getScrollingModel().scrollToCaret(ScrollType.CENTER);
        this.showAfterScroll();
    }

    public void showAfterScroll() {
        this.myEditor.getScrollingModel().runActionOnScrollingFinished(new Runnable(){

            @Override
            public void run() {
                LineStatusMarkerPopup.this.showHintAt(null);
            }
        });
    }

    public void showHint(@NotNull MouseEvent e) {
        JComponent comp = (JComponent)e.getComponent();
        JLayeredPane layeredPane = comp.getRootPane().getLayeredPane();
        Point point = SwingUtilities.convertPoint(comp, ((EditorEx)this.myEditor).getGutterComponentEx().getWidth(), e.getY(), layeredPane);
        this.showHintAt(point);
        e.consume();
    }

    public void showHintAt(@Nullable Point mousePosition) {
        if (!this.myTracker.isValid()) {
            return;
        }
        final Disposable disposable = Disposer.newDisposable();
        FileType fileType = this.getFileType();
        List<DiffFragment> wordDiff = this.computeWordDiff();
        this.installMasterEditorHighlighters(wordDiff, disposable);
        EditorFragmentComponent editorComponent = this.createEditorComponent(fileType, wordDiff);
        ActionToolbar toolbar = this.buildToolbar(mousePosition, disposable);
        toolbar.updateActionsImmediately();
        toolbar.setReservePlaceAutoPopupIcon(false);
        PopupPanel popupPanel = new PopupPanel(this.myEditor, toolbar, editorComponent);
        LightweightHint hint = new LightweightHint(popupPanel);
        HintListener closeListener = new HintListener(){

            @Override
            public void hintHidden(EventObject event) {
                Disposer.dispose((Disposable)disposable);
            }
        };
        hint.addHintListener(closeListener);
        int line = this.myEditor.getCaretModel().getLogicalPosition().line;
        Point point = HintManagerImpl.getHintPosition(hint, this.myEditor, new LogicalPosition(line, 0), (short)2);
        if (mousePosition != null) {
            int lineHeight = this.myEditor.getLineHeight();
            int delta = (point.y - mousePosition.y) % lineHeight;
            if (delta < 0) {
                delta += lineHeight;
            }
            point.y = mousePosition.y + delta;
        }
        point.x -= popupPanel.getEditorTextOffset();
        int flags = 42;
        HintManagerImpl.getInstanceImpl().showEditorHint(hint, this.myEditor, point, flags, -1, false, new HintHint(this.myEditor, point));
        if (!hint.isVisible()) {
            closeListener.hintHidden(null);
        }
    }

    @Nullable
    private List<DiffFragment> computeWordDiff() {
        if (!this.isShowInnerDifferences()) {
            return null;
        }
        if (this.myRange.getType() != 1) {
            return null;
        }
        final CharSequence vcsContent = this.myTracker.getVcsContent(this.myRange);
        final CharSequence currentContent = this.myTracker.getCurrentContent(this.myRange);
        return BackgroundTaskUtil.tryComputeFast(new Function<ProgressIndicator, List<DiffFragment>>(){

            public List<DiffFragment> fun(ProgressIndicator indicator) {
                return ByWord.compare(vcsContent, currentContent, ComparisonPolicy.DEFAULT, indicator);
            }
        }, 200L);
    }

    private void installMasterEditorHighlighters(@Nullable List<DiffFragment> wordDiff, @NotNull Disposable parentDisposable) {
        if (wordDiff == null) {
            return;
        }
        final ArrayList<RangeHighlighter> highlighters = new ArrayList<RangeHighlighter>();
        int currentStartShift = this.myTracker.getCurrentTextRange(this.myRange).getStartOffset();
        for (DiffFragment fragment : wordDiff) {
            int currentStart = currentStartShift + fragment.getStartOffset2();
            int currentEnd = currentStartShift + fragment.getEndOffset2();
            TextDiffType type2 = DiffUtil.getDiffType(fragment);
            highlighters.addAll(DiffDrawUtil.createInlineHighlighter(this.myEditor, currentStart, currentEnd, type2));
        }
        Disposer.register((Disposable)parentDisposable, (Disposable)new Disposable(){

            public void dispose() {
                for (RangeHighlighter highlighter : highlighters) {
                    highlighter.dispose();
                }
            }
        });
    }

    @Nullable
    private EditorFragmentComponent createEditorComponent(@Nullable FileType fileType, @Nullable List<DiffFragment> wordDiff) {
        if (this.myRange.getType() == 2) {
            return null;
        }
        EditorEx uEditor = (EditorEx)EditorFactory.getInstance().createViewer(this.myTracker.getVcsDocument(), this.myTracker.getProject());
        uEditor.setColorsScheme(this.myEditor.getColorsScheme());
        DiffUtil.setEditorCodeStyle(this.myTracker.getProject(), uEditor, fileType);
        EditorHighlighterFactory highlighterFactory = EditorHighlighterFactory.getInstance();
        uEditor.setHighlighter(highlighterFactory.createEditorHighlighter(this.myTracker.getProject(), LineStatusMarkerPopup.getFileName(this.myTracker.getDocument())));
        if (wordDiff != null) {
            int vcsStartShift = this.myTracker.getVcsTextRange(this.myRange).getStartOffset();
            for (DiffFragment fragment : wordDiff) {
                int vcsStart = vcsStartShift + fragment.getStartOffset1();
                int vcsEnd = vcsStartShift + fragment.getEndOffset1();
                TextDiffType type2 = DiffUtil.getDiffType(fragment);
                DiffDrawUtil.createInlineHighlighter(uEditor, vcsStart, vcsEnd, type2);
            }
        }
        EditorFragmentComponent fragmentComponent = EditorFragmentComponent.createEditorFragmentComponent(this.myEditor.getContentComponent(), uEditor, this.myRange.getVcsLine1(), this.myRange.getVcsLine2(), false, false);
        EditorFactory.getInstance().releaseEditor((Editor)uEditor);
        return fragmentComponent;
    }

    private static String getFileName(@NotNull Document document) {
        VirtualFile file2 = FileDocumentManager.getInstance().getFile(document);
        if (file2 == null) {
            return "";
        }
        return file2.getName();
    }

    @NotNull
    private ActionToolbar buildToolbar(@Nullable Point mousePosition, @NotNull Disposable parentDisposable) {
        final List<AnAction> actions = this.createToolbarActions(mousePosition);
        final JComponent editorComponent = this.myEditor.getComponent();
        for (AnAction action : actions) {
            DiffUtil.registerAction(action, editorComponent);
        }
        Disposer.register((Disposable)parentDisposable, (Disposable)new Disposable(){

            public void dispose() {
                ActionUtil.getActions((JComponent)editorComponent).removeAll(actions);
            }
        });
        return ActionManager.getInstance().createActionToolbar("unknown", (ActionGroup)new DefaultActionGroup(actions), true);
    }

    public static abstract class ToggleByWordDiffActionBase
    extends ToggleAction
    implements DumbAware {
        public ToggleByWordDiffActionBase() {
            super("Show Detailed Differences", null, AllIcons.Actions.PreviewDetails);
        }

        public boolean isSelected(AnActionEvent e) {
            return VcsApplicationSettings.getInstance().SHOW_LST_WORD_DIFFERENCES;
        }

        public void setSelected(AnActionEvent e, boolean state) {
            VcsApplicationSettings.getInstance().SHOW_LST_WORD_DIFFERENCES = state;
            this.reshowPopup();
        }

        protected abstract void reshowPopup();
    }

    private static class PopupPanel
    extends JPanel {
        @Nullable
        private final JComponent myEditorComponent;

        public PopupPanel(final @NotNull Editor editor, @NotNull ActionToolbar toolbar, @Nullable JComponent editorComponent) {
            super(new BorderLayout());
            this.setOpaque(false);
            this.myEditorComponent = editorComponent;
            boolean isEditorVisible = this.myEditorComponent != null;
            Color background = ((EditorEx)editor).getBackgroundColor();
            Color borderColor = editor.getColorsScheme().getColor(EditorColors.SELECTED_TEARLINE_COLOR);
            JComponent toolbarComponent = toolbar.getComponent();
            toolbarComponent.setBackground(background);
            toolbarComponent.setBorder(null);
            BorderLayoutPanel toolbarPanel = JBUI.Panels.simplePanel((Component)toolbarComponent);
            toolbarPanel.setBackground(background);
            Border outsideToolbarBorder = JBUI.Borders.customLine((Color)borderColor, (int)1, (int)1, (int)(isEditorVisible ? 0 : 1), (int)1);
            JBEmptyBorder insideToolbarBorder = JBUI.Borders.empty((int)1, (int)5, (int)1, (int)5);
            toolbarPanel.setBorder(BorderFactory.createCompoundBorder(outsideToolbarBorder, (Border)insideToolbarBorder));
            if (this.myEditorComponent != null) {
                Border outsideEditorBorder = JBUI.Borders.customLine((Color)borderColor, (int)1);
                Border insideEditorBorder = JBUI.Borders.empty((int)2);
                this.myEditorComponent.setBorder(BorderFactory.createCompoundBorder(outsideEditorBorder, insideEditorBorder));
            }
            JPanel emptyPanel = new JPanel();
            emptyPanel.setOpaque(false);
            emptyPanel.setPreferredSize(new Dimension());
            JPanel topPanel = new JPanel(new BorderLayout());
            topPanel.setOpaque(false);
            topPanel.add((Component)toolbarPanel, "West");
            topPanel.add((Component)emptyPanel, "Center");
            this.add((Component)topPanel, "North");
            if (this.myEditorComponent != null) {
                this.add((Component)this.myEditorComponent, "Center");
            }
            MouseAdapter listener2 = new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent e) {
                    PopupPanel.transferEvent(e, editor);
                }

                @Override
                public void mouseClicked(MouseEvent e) {
                    PopupPanel.transferEvent(e, editor);
                }

                @Override
                public void mouseReleased(MouseEvent e) {
                    PopupPanel.transferEvent(e, editor);
                }
            };
            emptyPanel.addMouseListener(listener2);
        }

        private static void transferEvent(MouseEvent e, Editor editor) {
            editor.getContentComponent().dispatchEvent(SwingUtilities.convertMouseEvent(e.getComponent(), e, editor.getContentComponent()));
        }

        public int getEditorTextOffset() {
            return 3;
        }
    }
}

