/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.ex;

import com.intellij.diff.util.DiffUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.TransactionGuard;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.impl.DocumentImpl;
import com.intellij.openapi.editor.impl.DocumentMarkupModel;
import com.intellij.openapi.editor.markup.MarkupEditorFilterFactory;
import com.intellij.openapi.editor.markup.MarkupModel;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vcs.changes.VcsDirtyScopeManager;
import com.intellij.openapi.vcs.ex.LineStatusMarkerPopup;
import com.intellij.openapi.vcs.ex.LineStatusMarkerRenderer;
import com.intellij.openapi.vcs.ex.LineStatusTrackerBase;
import com.intellij.openapi.vcs.ex.LineStatusTrackerDrawing;
import com.intellij.openapi.vcs.ex.Range;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.EditorNotificationPanel;
import com.intellij.util.Function;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;

public class LineStatusTracker
extends LineStatusTrackerBase {
    private static final Key<JPanel> PANEL_KEY = new Key("LineStatusTracker.CanNotCalculateDiffPanel");
    @NotNull
    private final VirtualFile myVirtualFile;
    @NotNull
    private final FileEditorManager myFileEditorManager;
    @NotNull
    private final VcsDirtyScopeManager myVcsDirtyScopeManager;
    @NotNull
    private Mode myMode;

    private LineStatusTracker(@NotNull Project project2, @NotNull Document document, @NotNull VirtualFile virtualFile, @NotNull Mode mode) {
        super(project2, document);
        this.myVirtualFile = virtualFile;
        this.myMode = mode;
        this.myFileEditorManager = FileEditorManager.getInstance((Project)project2);
        this.myVcsDirtyScopeManager = VcsDirtyScopeManager.getInstance((Project)project2);
    }

    public static LineStatusTracker createOn(@NotNull VirtualFile virtualFile, @NotNull Document document, @NotNull Project project2, @NotNull Mode mode) {
        return new LineStatusTracker(project2, document, virtualFile, mode);
    }

    @Override
    @NotNull
    public Project getProject() {
        return super.getProject();
    }

    @NotNull
    public VirtualFile getVirtualFile() {
        return this.myVirtualFile;
    }

    @NotNull
    public Mode getMode() {
        return this.myMode;
    }

    public boolean isSilentMode() {
        return this.myMode == Mode.SILENT;
    }

    public void setMode(@NotNull Mode mode) {
        if (this.myMode == mode) {
            return;
        }
        this.myMode = mode;
        this.reinstallRanges();
    }

    @Override
    protected boolean isDetectWhitespaceChangedLines() {
        return this.myMode == Mode.SMART;
    }

    @Override
    protected void installNotification(@NotNull String text) {
        FileEditor[] editors;
        for (FileEditor editor : editors = this.myFileEditorManager.getAllEditors(this.myVirtualFile)) {
            JPanel panel2 = (JPanel)editor.getUserData(PANEL_KEY);
            if (panel2 != null) continue;
            EditorNotificationPanel newPanel = new EditorNotificationPanel().text(text);
            editor.putUserData(PANEL_KEY, (Object)newPanel);
            this.myFileEditorManager.addTopComponent(editor, (JComponent)newPanel);
        }
    }

    @Override
    protected void destroyNotification() {
        FileEditor[] editors;
        for (FileEditor editor : editors = this.myFileEditorManager.getEditors(this.myVirtualFile)) {
            JPanel panel2 = (JPanel)editor.getUserData(PANEL_KEY);
            if (panel2 == null) continue;
            this.myFileEditorManager.removeTopComponent(editor, (JComponent)panel2);
            editor.putUserData(PANEL_KEY, null);
        }
    }

    @Override
    protected void createHighlighter(@NotNull Range range) {
        this.myApplication.assertIsDispatchThread();
        if (range.getHighlighter() != null) {
            LOG.error("Multiple highlighters registered for the same Range");
            return;
        }
        if (this.myMode == Mode.SILENT) {
            return;
        }
        int first = range.getLine1() >= DiffUtil.getLineCount(this.myDocument) ? this.myDocument.getTextLength() : this.myDocument.getLineStartOffset(range.getLine1());
        int second = range.getLine2() >= DiffUtil.getLineCount(this.myDocument) ? this.myDocument.getTextLength() : this.myDocument.getLineStartOffset(range.getLine2());
        MarkupModel markupModel = DocumentMarkupModel.forDocument(this.myDocument, this.myProject, true);
        RangeHighlighter highlighter = LineStatusMarkerRenderer.createRangeHighlighter(range, new TextRange(first, second), markupModel);
        highlighter.setLineMarkerRenderer(LineStatusMarkerRenderer.createRenderer(range, (Function<Editor, LineStatusMarkerPopup>)((Function)editor -> new LineStatusTrackerDrawing.MyLineStatusMarkerPopup(this, (Editor)editor, range))));
        highlighter.setEditorFilter(MarkupEditorFilterFactory.createIsNotDiffFilter());
        range.setHighlighter(highlighter);
    }

    @Override
    protected void fireFileUnchanged() {
        TransactionGuard.getInstance().submitTransactionLater((Disposable)this.getProject(), () -> {
            FileDocumentManager.getInstance().saveDocument(this.myDocument);
            List<Range> ranges = this.getRanges();
            if (ranges == null || ranges.isEmpty()) {
                this.myVcsDirtyScopeManager.fileDirty(this.myVirtualFile);
            }
        });
    }

    @Override
    protected void doRollbackRange(@NotNull Range range) {
        super.doRollbackRange(range);
        this.markLinesUnchanged(range.getLine1(), range.getLine1() + range.getVcsLine2() - range.getVcsLine1());
    }

    private void markLinesUnchanged(int startLine, int endLine) {
        if (this.myDocument.getTextLength() == 0) {
            return;
        }
        if (startLine == endLine) {
            return;
        }
        ((DocumentImpl)this.myDocument).clearLineModificationFlags(startLine, endLine);
    }

    public static enum Mode {
        DEFAULT,
        SMART,
        SILENT;

    }
}

