/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.ex;

import com.intellij.diff.util.DiffUtil;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.ex.LineStatusTracker;
import com.intellij.openapi.vcs.ex.Range;
import com.intellij.openapi.vcs.impl.LineStatusTrackerManager;
import java.util.BitSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RollbackLineStatusAction
extends DumbAwareAction {
    public void update(AnActionEvent e) {
        Project project2 = e.getProject();
        Editor editor = (Editor)e.getData(CommonDataKeys.EDITOR);
        if (project2 == null || editor == null) {
            e.getPresentation().setEnabledAndVisible(false);
            return;
        }
        if (DiffUtil.isDiffEditor(editor)) {
            e.getPresentation().setEnabledAndVisible(false);
            return;
        }
        LineStatusTracker tracker = LineStatusTrackerManager.getInstance(project2).getLineStatusTracker(editor.getDocument());
        if (tracker == null || !tracker.isValid() || tracker.isSilentMode()) {
            e.getPresentation().setEnabledAndVisible(false);
            return;
        }
        if (!RollbackLineStatusAction.isSomeChangeSelected(editor, tracker)) {
            e.getPresentation().setVisible(true);
            e.getPresentation().setEnabled(false);
            return;
        }
        e.getPresentation().setEnabledAndVisible(true);
    }

    public void actionPerformed(AnActionEvent e) {
        Project project2 = e.getProject();
        Editor editor = (Editor)e.getRequiredData(CommonDataKeys.EDITOR);
        LineStatusTracker tracker = LineStatusTrackerManager.getInstance(project2).getLineStatusTracker(editor.getDocument());
        assert (tracker != null);
        RollbackLineStatusAction.rollback(tracker, editor, null);
    }

    protected static boolean isSomeChangeSelected(@NotNull Editor editor, @NotNull LineStatusTracker tracker) {
        List carets = editor.getCaretModel().getAllCarets();
        if (carets.size() != 1) {
            return true;
        }
        Caret caret = (Caret)carets.get(0);
        if (caret.hasSelection()) {
            return true;
        }
        if (caret.getOffset() == editor.getDocument().getTextLength() && tracker.getRangeForLine(editor.getDocument().getLineCount()) != null) {
            return true;
        }
        return tracker.getRangeForLine(caret.getLogicalPosition().line) != null;
    }

    protected static void rollback(@NotNull LineStatusTracker tracker, @Nullable Editor editor, @Nullable Range range) {
        assert (editor != null || range != null);
        if (range != null) {
            RollbackLineStatusAction.doRollback(tracker, range);
            return;
        }
        RollbackLineStatusAction.doRollback(tracker, DiffUtil.getSelectedLines(editor));
    }

    private static void doRollback(@NotNull LineStatusTracker tracker, @NotNull Range range) {
        RollbackLineStatusAction.execute(tracker, () -> tracker.rollbackChanges(range));
    }

    private static void doRollback(@NotNull LineStatusTracker tracker, @NotNull BitSet lines) {
        RollbackLineStatusAction.execute(tracker, () -> tracker.rollbackChanges(lines));
    }

    private static void execute(@NotNull LineStatusTracker tracker, @NotNull Runnable task) {
        DiffUtil.executeWriteCommand(tracker.getDocument(), tracker.getProject(), VcsBundle.message((String)"command.name.rollback.change", (Object[])new Object[0]), task);
    }
}

