/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.history;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.history.CurrentRevision;
import com.intellij.openapi.vcs.history.DiffFromHistoryHandler;
import com.intellij.openapi.vcs.history.VcsDiffUtil;
import com.intellij.openapi.vcs.history.VcsFileRevision;
import com.intellij.openapi.vcs.history.VcsHistoryUtil;
import com.intellij.openapi.vcs.ui.VcsBalloonProblemNotifier;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BaseDiffFromHistoryHandler<T extends VcsFileRevision>
implements DiffFromHistoryHandler {
    private static final Logger LOG = Logger.getInstance(BaseDiffFromHistoryHandler.class);
    @NotNull
    protected final Project myProject;

    protected BaseDiffFromHistoryHandler(@NotNull Project project2) {
        this.myProject = project2;
    }

    public void showDiffForOne(@NotNull AnActionEvent e, @NotNull Project project2, @NotNull FilePath filePath, @NotNull VcsFileRevision previousRevision, @NotNull VcsFileRevision revision) {
        this.doShowDiff(filePath, previousRevision, revision);
    }

    public void showDiffForTwo(@NotNull Project project2, @NotNull FilePath filePath, @NotNull VcsFileRevision older, @NotNull VcsFileRevision newer) {
        this.doShowDiff(filePath, older, newer);
    }

    protected void doShowDiff(@NotNull FilePath filePath, @NotNull VcsFileRevision older, @NotNull VcsFileRevision newer) {
        if (!filePath.isDirectory()) {
            VcsHistoryUtil.showDifferencesInBackground(this.myProject, filePath, older, newer);
        } else if (older.equals(VcsFileRevision.NULL)) {
            VcsFileRevision right = newer;
            this.showAffectedChanges(filePath, right);
        } else if (newer instanceof CurrentRevision) {
            VcsFileRevision left = older;
            this.showChangesBetweenRevisions(filePath, left, null);
        } else {
            VcsFileRevision left = older;
            VcsFileRevision right = newer;
            this.showChangesBetweenRevisions(filePath, left, right);
        }
    }

    protected void showChangesBetweenRevisions(final @NotNull FilePath path, @NotNull T older, @Nullable T newer) {
        new CollectChangesTask("Comparing revisions...", (VcsFileRevision)older, (VcsFileRevision)newer){
            final /* synthetic */ VcsFileRevision val$older;
            final /* synthetic */ VcsFileRevision val$newer;
            {
                this.val$older = vcsFileRevision;
                this.val$newer = vcsFileRevision2;
                super(title);
            }

            @Override
            @NotNull
            public List<Change> getChanges() throws VcsException {
                return BaseDiffFromHistoryHandler.this.getChangesBetweenRevisions(path, this.val$older, this.val$newer);
            }

            @Override
            @NotNull
            public String getDialogTitle() {
                return BaseDiffFromHistoryHandler.this.getChangesBetweenRevisionsDialogTitle(path, this.val$older, this.val$newer);
            }
        }.queue();
    }

    protected void showAffectedChanges(final @NotNull FilePath path, @NotNull T rev) {
        new CollectChangesTask("Collecting affected changes...", (VcsFileRevision)rev){
            final /* synthetic */ VcsFileRevision val$rev;
            {
                this.val$rev = vcsFileRevision;
                super(title);
            }

            @Override
            @NotNull
            public List<Change> getChanges() throws VcsException {
                return BaseDiffFromHistoryHandler.this.getAffectedChanges(path, this.val$rev);
            }

            @Override
            @NotNull
            public String getDialogTitle() {
                return BaseDiffFromHistoryHandler.this.getAffectedChangesDialogTitle(path, this.val$rev);
            }
        }.queue();
    }

    @NotNull
    protected abstract List<Change> getChangesBetweenRevisions(@NotNull FilePath var1, @NotNull T var2, @Nullable T var3) throws VcsException;

    @NotNull
    protected abstract List<Change> getAffectedChanges(@NotNull FilePath var1, @NotNull T var2) throws VcsException;

    @NotNull
    protected abstract String getPresentableName(@NotNull T var1);

    protected void showChangesDialog(@NotNull String title, @NotNull List<Change> changes) {
        VcsDiffUtil.showChangesDialog(this.myProject, title, changes);
    }

    protected void showError(@NotNull VcsException e, @NotNull String logMessage) {
        LOG.info(logMessage, (Throwable)e);
        VcsBalloonProblemNotifier.showOverVersionControlView(this.myProject, e.getMessage(), MessageType.ERROR);
    }

    @NotNull
    protected String getChangesBetweenRevisionsDialogTitle(@NotNull FilePath path, @NotNull T rev1, @Nullable T rev2) {
        String rev1Title = this.getPresentableName(rev1);
        return rev2 != null ? String.format("Difference between %s and %s in %s", rev1Title, this.getPresentableName(rev2), path.getName()) : String.format("Difference between %s and local version in %s", rev1Title, path.getName());
    }

    @NotNull
    protected String getAffectedChangesDialogTitle(@NotNull FilePath path, @NotNull T rev) {
        return String.format("Initial commit %s in %s", this.getPresentableName(rev), path.getName());
    }

    protected abstract class CollectChangesTask
    extends Task.Backgroundable {
        private List<Change> myChanges;

        public CollectChangesTask(String title) {
            super(BaseDiffFromHistoryHandler.this.myProject, title);
        }

        public void run(@NotNull ProgressIndicator indicator) {
            try {
                this.myChanges = this.getChanges();
            }
            catch (VcsException e) {
                BaseDiffFromHistoryHandler.this.showError(e, "Error during task: " + this.getDialogTitle());
            }
        }

        @NotNull
        public abstract List<Change> getChanges() throws VcsException;

        @NotNull
        public abstract String getDialogTitle();

        public void onSuccess() {
            BaseDiffFromHistoryHandler.this.showChangesDialog(this.getDialogTitle(), ContainerUtil.notNullize(this.myChanges));
        }
    }
}

