/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.history;

import com.intellij.CommonBundle;
import com.intellij.icons.AllIcons;
import com.intellij.ide.CopyProvider;
import com.intellij.ide.actions.RefreshAction;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.CommonShortcuts;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.colors.EditorColorsListener;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.PanelWithActionsAndCloseButton;
import com.intellij.openapi.ui.Splitter;
import com.intellij.openapi.util.Clock;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Getter;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.AbstractVcsHelper;
import com.intellij.openapi.vcs.CommittedChangesProvider;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.RepositoryLocation;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsConfiguration;
import com.intellij.openapi.vcs.VcsDataKeys;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.actions.AnnotateRevisionActionBase;
import com.intellij.openapi.vcs.changes.ByteBackedContentRevision;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.changes.CurrentContentRevision;
import com.intellij.openapi.vcs.changes.actions.CreatePatchFromChangesAction;
import com.intellij.openapi.vcs.changes.issueLinks.IssueLinkRenderer;
import com.intellij.openapi.vcs.changes.issueLinks.TableLinkMouseListener;
import com.intellij.openapi.vcs.history.DetailsPanel;
import com.intellij.openapi.vcs.history.DiffFromHistoryHandler;
import com.intellij.openapi.vcs.history.FileHistoryColumnWrapper;
import com.intellij.openapi.vcs.history.FileHistoryRefresherI;
import com.intellij.openapi.vcs.history.GetVersionAction;
import com.intellij.openapi.vcs.history.HistoryAsTreeProvider;
import com.intellij.openapi.vcs.history.ShortVcsRevisionNumber;
import com.intellij.openapi.vcs.history.StandardDiffFromHistoryHandler;
import com.intellij.openapi.vcs.history.TreeNodeOnVcsRevision;
import com.intellij.openapi.vcs.history.VcsDependentHistoryComponents;
import com.intellij.openapi.vcs.history.VcsFileRevision;
import com.intellij.openapi.vcs.history.VcsFileRevisionEx;
import com.intellij.openapi.vcs.history.VcsHistoryProvider;
import com.intellij.openapi.vcs.history.VcsHistorySession;
import com.intellij.openapi.vcs.history.VcsHistoryUtil;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vcs.impl.AbstractVcsHelperImpl;
import com.intellij.openapi.vcs.versionBrowser.CommittedChangeList;
import com.intellij.openapi.vcs.vfs.VcsFileSystem;
import com.intellij.openapi.vcs.vfs.VcsVirtualFile;
import com.intellij.openapi.vcs.vfs.VcsVirtualFolder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileSystem;
import com.intellij.ui.ColoredTableCellRenderer;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.JBColor;
import com.intellij.ui.OnePixelSplitter;
import com.intellij.ui.PopupHandler;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SpeedSearchComparator;
import com.intellij.ui.TableSpeedSearch;
import com.intellij.ui.content.ContentManager;
import com.intellij.ui.dualView.CellWrapper;
import com.intellij.ui.dualView.DualView;
import com.intellij.ui.dualView.DualViewColumnInfo;
import com.intellij.ui.dualView.TreeTableView;
import com.intellij.ui.speedSearch.SpeedSearchUtil;
import com.intellij.ui.table.TableView;
import com.intellij.util.Alarm;
import com.intellij.util.AsynchConsumer;
import com.intellij.util.Consumer;
import com.intellij.util.PlatformIcons;
import com.intellij.util.TreeItem;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.DateFormatUtil;
import com.intellij.util.ui.ColumnInfo;
import com.intellij.util.ui.StatusText;
import com.intellij.util.ui.TableViewModel;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.RowSorter;
import javax.swing.SortOrder;
import javax.swing.table.TableCellRenderer;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FileHistoryPanelImpl
extends PanelWithActionsAndCloseButton
implements EditorColorsListener,
CopyProvider {
    private static final String COMMIT_MESSAGE_TITLE = VcsBundle.message((String)"label.selected.revision.commit.message", (Object[])new Object[0]);
    private static final String VCS_HISTORY_ACTIONS_GROUP = "VcsHistoryActionsGroup";
    @NotNull
    private final Project myProject;
    @NotNull
    private final AbstractVcs myVcs;
    private final VcsHistoryProvider myProvider;
    @NotNull
    private final FileHistoryRefresherI myRefresherI;
    @NotNull
    private final DiffFromHistoryHandler myDiffHandler;
    @NotNull
    private final FilePath myFilePath;
    @Nullable
    private final VcsRevisionNumber myStartingRevision;
    @NotNull
    private final AsynchConsumer<VcsHistorySession> myHistoryPanelRefresh;
    @NotNull
    private final Map<VcsRevisionNumber, Integer> myRevisionsOrder = ContainerUtil.newHashMap();
    @NotNull
    private final Map<VcsFileRevision, VirtualFile> myRevisionToVirtualFile = ContainerUtil.newHashMap();
    @NotNull
    private final Comparator<VcsFileRevision> myRevisionsInOrderComparator = (o1, o2) -> Comparing.compare((Comparable)this.myRevisionsOrder.get(o2.getRevisionNumber()), (Comparable)this.myRevisionsOrder.get(o1.getRevisionNumber()));
    @NotNull
    private final DetailsPanel myDetails;
    @NotNull
    private final DualView myDualView;
    @Nullable
    private final JComponent myAdditionalDetails;
    @Nullable
    private final Consumer<VcsFileRevision> myRevisionSelectionListener;
    private VcsHistorySession myHistorySession;
    private VcsFileRevision myBottomRevisionForShowDiff;
    private volatile boolean myInRefresh;
    private List<Object> myTargetSelection;
    private boolean myIsStaticAndEmbedded;
    private Splitter myDetailsSplitter;
    private Splitter mySplitter;

    public FileHistoryPanelImpl(@NotNull AbstractVcs vcs, @NotNull FilePath filePath, VcsHistorySession session2, VcsHistoryProvider provider2, ContentManager contentManager, @NotNull FileHistoryRefresherI refresherI, boolean isStaticEmbedded) {
        this(vcs, filePath, null, session2, provider2, contentManager, refresherI, isStaticEmbedded);
    }

    public FileHistoryPanelImpl(@NotNull AbstractVcs vcs, @NotNull FilePath filePath, @Nullable VcsRevisionNumber startingRevision, VcsHistorySession session2, VcsHistoryProvider provider2, ContentManager contentManager, @NotNull FileHistoryRefresherI refresherI, boolean isStaticEmbedded) {
        super(contentManager, provider2.getHelpId() != null ? provider2.getHelpId() : "reference.versionControl.toolwindow.history", !isStaticEmbedded);
        this.myProject = vcs.getProject();
        this.myIsStaticAndEmbedded = false;
        this.myVcs = vcs;
        this.myProvider = provider2;
        this.myRefresherI = refresherI;
        this.myHistorySession = session2;
        this.myFilePath = filePath;
        this.myStartingRevision = startingRevision;
        DiffFromHistoryHandler customDiffHandler = provider2.getHistoryDiffHandler();
        this.myDiffHandler = customDiffHandler == null ? new StandardDiffFromHistoryHandler() : customDiffHandler;
        this.myDetails = new DetailsPanel(this.myProject);
        this.refreshRevisionsOrder();
        VcsDependentHistoryComponents components = provider2.getUICustomization(session2, (JComponent)((Object)this));
        this.myAdditionalDetails = components.getDetailsComponent();
        this.myRevisionSelectionListener = components.getRevisionListener();
        DualViewColumnInfo[] columns = this.createColumnList(this.myProject, provider2, components.getColumns());
        String storageKey = "FileHistory." + provider2.getClass().getName();
        final HistoryAsTreeProvider treeHistoryProvider = this.myHistorySession.getHistoryAsTreeProvider();
        if (treeHistoryProvider != null) {
            this.myDualView = new DualView((Object)new TreeNodeOnVcsRevision(null, treeHistoryProvider.createTreeOn(this.myHistorySession.getRevisionList())), columns, storageKey, this.myVcs.getProject());
        } else {
            this.myDualView = new DualView((Object)new TreeNodeOnVcsRevision(null, ContainerUtil.map((Collection)this.myHistorySession.getRevisionList(), TreeItem::new)), columns, storageKey, this.myVcs.getProject());
            this.myDualView.switchToTheFlatMode();
        }
        new TableSpeedSearch((JTable)this.myDualView.getFlatView()).setComparator(new SpeedSearchComparator(false));
        TableLinkMouseListener listener2 = new TableLinkMouseListener();
        listener2.installOn((Component)this.myDualView.getFlatView());
        listener2.installOn((Component)this.myDualView.getTreeView());
        this.setEmptyText(CommonBundle.getLoadingTreeNodeText());
        this.setupDualView(this.addToGroup(true, new DefaultActionGroup(null, false)));
        if (isStaticEmbedded) {
            this.setIsStaticAndEmbedded(true);
        }
        this.myHistoryPanelRefresh = new AsynchConsumer<VcsHistorySession>(){

            public void finished() {
                TreeTableView treeView;
                int lastRow;
                if (treeHistoryProvider != null && (lastRow = (treeView = FileHistoryPanelImpl.this.myDualView.getTreeView()).getRowCount() - 1) >= 0) {
                    treeView.scrollRectToVisible(treeView.getCellRect(lastRow, 0, true));
                }
                FileHistoryPanelImpl.this.myInRefresh = false;
                FileHistoryPanelImpl.this.myTargetSelection = null;
                FileHistoryPanelImpl.this.mySplitter.revalidate();
                FileHistoryPanelImpl.this.mySplitter.repaint();
            }

            public void consume(VcsHistorySession vcsHistorySession) {
                FileHistoryPanelImpl.this.refresh(vcsHistorySession);
            }
        };
        final Alarm updateAlarm = new Alarm(Alarm.ThreadToUse.POOLED_THREAD, (Disposable)this);
        updateAlarm.addRequest(new Runnable(){

            @Override
            public void run() {
                if (FileHistoryPanelImpl.this.myVcs.getProject().isDisposed()) {
                    return;
                }
                boolean refresh = ApplicationManager.getApplication().isActive() && !FileHistoryPanelImpl.this.myInRefresh && FileHistoryPanelImpl.this.myHistorySession.shouldBeRefreshed();
                updateAlarm.cancelAllRequests();
                if (updateAlarm.isDisposed()) {
                    return;
                }
                updateAlarm.addRequest((Runnable)this, 20000);
                if (refresh) {
                    FileHistoryPanelImpl.this.refreshUiAndScheduleDataRefresh(true);
                }
            }
        }, 20000);
        this.init();
        this.chooseView();
        Disposer.register((Disposable)this.myProject, (Disposable)this);
    }

    private static void makeBold(Component component) {
        if (component instanceof JComponent) {
            JComponent jComponent = (JComponent)component;
            Font font = jComponent.getFont();
            if (font != null) {
                jComponent.setFont(font.deriveFont(1));
            }
        } else if (component instanceof Container) {
            Container container = (Container)component;
            for (int i2 = 0; i2 < container.getComponentCount(); ++i2) {
                FileHistoryPanelImpl.makeBold(container.getComponent(i2));
            }
        }
    }

    @NotNull
    public static String getPresentableText(@NotNull VcsFileRevision revision, boolean withMessage) {
        StringBuilder sb = new StringBuilder();
        sb.append(RevisionColumnInfo.toString(revision, true)).append(" ");
        sb.append(revision.getAuthor());
        long time = revision.getRevisionDate().getTime();
        sb.append(" on ").append(DateFormatUtil.formatDate((long)time)).append(" at ").append(DateFormatUtil.formatTime((long)time));
        if (revision instanceof VcsFileRevisionEx && !Comparing.equal((String)revision.getAuthor(), (String)((VcsFileRevisionEx)revision).getCommitterName())) {
            sb.append(" (committed by ").append(((VcsFileRevisionEx)revision).getCommitterName()).append(")");
        }
        if (withMessage) {
            sb.append(" ").append(MessageColumnInfo.getSubject(revision));
        }
        return sb.toString();
    }

    static boolean sameHistories(@NotNull FileHistoryPanelImpl historyPanel, @NotNull FilePath path, @Nullable VcsRevisionNumber startingRevisionNumber) {
        String existingRevision = historyPanel.getStartingRevision() == null ? null : historyPanel.getStartingRevision().asString();
        String newRevision = startingRevisionNumber == null ? null : startingRevisionNumber.asString();
        return historyPanel.getFilePath().equals(path) && Comparing.equal((String)existingRevision, (String)newRevision);
    }

    void scheduleRefresh(boolean canUseLastRevision) {
        this.refreshUiAndScheduleDataRefresh(canUseLastRevision);
    }

    @Nullable
    public VcsRevisionNumber getStartingRevision() {
        return this.myStartingRevision;
    }

    @NotNull
    private DualViewColumnInfo[] createColumnList(@NotNull Project project2, @NotNull VcsHistoryProvider provider2, @Nullable ColumnInfo[] additionalColumns) {
        ArrayList<VcsColumnInfo<Object>> columns = new ArrayList<VcsColumnInfo<Object>>();
        columns.add(new RevisionColumnInfo(this.myRevisionsInOrderComparator));
        if (!provider2.isDateOmittable()) {
            columns.add(new DateColumnInfo());
        }
        columns.add(new AuthorColumnInfo());
        ArrayList<3> additionalColumnInfo = new ArrayList<3>();
        if (additionalColumns != null) {
            for (ColumnInfo additionalColumn : additionalColumns) {
                additionalColumnInfo.add(new FileHistoryColumnWrapper(additionalColumn){

                    @Override
                    protected DualView getDualView() {
                        return FileHistoryPanelImpl.this.myDualView;
                    }
                });
            }
        }
        columns.addAll(additionalColumnInfo);
        columns.add(new MessageColumnInfo(project2));
        return columns.toArray(new DualViewColumnInfo[columns.size()]);
    }

    private void refresh(VcsHistorySession session2) {
        this.myHistorySession = session2;
        this.refreshRevisionsOrder();
        HistoryAsTreeProvider treeHistoryProvider = session2.getHistoryAsTreeProvider();
        if (this.myHistorySession.getRevisionList().isEmpty()) {
            this.adjustEmptyText();
        }
        if (treeHistoryProvider != null) {
            this.myDualView.setRoot((TreeNode)new TreeNodeOnVcsRevision(null, treeHistoryProvider.createTreeOn(this.myHistorySession.getRevisionList())), this.myTargetSelection);
        } else {
            this.myDualView.setRoot((TreeNode)new TreeNodeOnVcsRevision(null, ContainerUtil.map((Collection)this.myHistorySession.getRevisionList(), TreeItem::new)), this.myTargetSelection);
        }
        this.myDualView.expandAll();
        this.myDualView.repaint();
    }

    private void adjustEmptyText() {
        VirtualFile virtualFile = this.myFilePath.getVirtualFile();
        if (!(virtualFile != null && virtualFile.isValid() || this.myFilePath.getIOFile().exists())) {
            this.setEmptyText("File " + this.myFilePath.getName() + " not found");
        } else if (this.myInRefresh) {
            this.setEmptyText(CommonBundle.getLoadingTreeNodeText());
        } else {
            this.setEmptyText(StatusText.DEFAULT_EMPTY_TEXT);
        }
    }

    private void setEmptyText(@NotNull String emptyText) {
        this.myDualView.setEmptyText(emptyText);
    }

    protected void addActionsTo(DefaultActionGroup group) {
        this.addToGroup(false, group);
    }

    private void setupDualView(@NotNull DefaultActionGroup group) {
        this.myDualView.setShowGrid(true);
        PopupHandler.installPopupHandler((JComponent)this.myDualView.getTreeView(), (ActionGroup)group, (String)"UpdatePopup", (ActionManager)ActionManager.getInstance());
        PopupHandler.installPopupHandler((JComponent)this.myDualView.getFlatView(), (ActionGroup)group, (String)"UpdatePopup", (ActionManager)ActionManager.getInstance());
        this.myDualView.requestFocus();
        this.myDualView.addListSelectionListener(e -> this.updateMessage());
        this.myDualView.setRootVisible(false);
        this.myDualView.expandAll();
        TreeCellRenderer defaultCellRenderer = this.myDualView.getTree().getCellRenderer();
        Getter sessionGetter = () -> this.myHistorySession;
        this.myDualView.setTreeCellRenderer((TreeCellRenderer)new MyTreeCellRenderer(defaultCellRenderer, (Getter<VcsHistorySession>)sessionGetter));
        this.myDualView.setCellWrapper((CellWrapper)new MyCellWrapper((Getter<VcsHistorySession>)sessionGetter));
        this.myDualView.installDoubleClickHandler((AnAction)new MyDiffAction());
        TableView flatView = this.myDualView.getFlatView();
        TableViewModel sortableModel = flatView.getTableViewModel();
        sortableModel.setSortable(true);
        RowSorter rowSorter = flatView.getRowSorter();
        if (rowSorter != null) {
            rowSorter.setSortKeys(Collections.singletonList(new RowSorter.SortKey(0, SortOrder.DESCENDING)));
        }
    }

    private void updateMessage() {
        List<TreeNodeOnVcsRevision> selection = this.getSelection();
        this.myDetails.update(selection);
        if (selection.isEmpty()) {
            return;
        }
        if (this.myRevisionSelectionListener != null) {
            this.myRevisionSelectionListener.consume((Object)selection.get(0).getRevision());
        }
    }

    @NotNull
    protected JComponent createCenterPanel() {
        this.mySplitter = new OnePixelSplitter(true, "vcs.history.splitter.proportion", 0.6f);
        this.mySplitter.setFirstComponent((JComponent)this.myDualView);
        JScrollPane scrollPane = ScrollPaneFactory.createScrollPane((Component)this.myDetails);
        scrollPane.setBorder(IdeBorderFactory.createBorder((int)1));
        this.myDetailsSplitter = new OnePixelSplitter(false, "vcs.history.details.splitter.proportion", 0.5f);
        this.myDetailsSplitter.setFirstComponent((JComponent)scrollPane);
        this.myDetailsSplitter.setSecondComponent(this.myAdditionalDetails);
        this.setupDetails();
        return this.mySplitter;
    }

    private void setupDetails() {
        boolean showDetails = !this.myIsStaticAndEmbedded && this.getConfiguration().SHOW_FILE_HISTORY_DETAILS;
        this.myDualView.setViewBorder(IdeBorderFactory.createBorder((int)1));
        this.mySplitter.setSecondComponent((JComponent)(showDetails ? this.myDetailsSplitter : null));
    }

    private void chooseView() {
        if (this.getConfiguration().SHOW_FILE_HISTORY_AS_TREE) {
            this.myDualView.switchToTheTreeMode();
        } else {
            this.myDualView.switchToTheFlatMode();
        }
    }

    private VcsConfiguration getConfiguration() {
        return VcsConfiguration.getInstance((Project)this.myVcs.getProject());
    }

    @NotNull
    private DefaultActionGroup addToGroup(boolean popup, DefaultActionGroup result2) {
        if (popup) {
            result2.add(ActionManager.getInstance().getAction("EditSource"));
        }
        MyDiffAction diffAction = new MyDiffAction();
        diffAction.registerCustomShortcutSet(CommonShortcuts.getDiff(), null);
        result2.add((AnAction)diffAction);
        result2.add(ActionManager.getInstance().getAction("Vcs.ShowDiffWithLocal"));
        AnAction diffGroup = ActionManager.getInstance().getAction(VCS_HISTORY_ACTIONS_GROUP);
        if (diffGroup != null) {
            result2.add(diffGroup);
        }
        result2.add((AnAction)new MyCreatePatch());
        result2.add((AnAction)new MyGetVersionAction());
        result2.add((AnAction)new MyAnnotateAction());
        AnAction[] additionalActions = this.myProvider.getAdditionalActions(() -> this.refreshUiAndScheduleDataRefresh(true));
        if (additionalActions != null) {
            for (AnAction additionalAction : additionalActions) {
                if (!popup && additionalAction.getTemplatePresentation().getIcon() == null) continue;
                result2.add(additionalAction);
            }
        }
        result2.add((AnAction)new RefreshFileHistoryAction());
        if (!this.myIsStaticAndEmbedded) {
            result2.add((AnAction)new MyShowDetailsAction());
        }
        if (!popup && this.myHistorySession != null && this.myHistorySession.getHistoryAsTreeProvider() != null) {
            result2.add((AnAction)new MyShowAsTreeAction());
        }
        return result2;
    }

    private void refreshUiAndScheduleDataRefresh(boolean canUseLastRevisionCheck) {
        ApplicationManager.getApplication().invokeAndWait(() -> {
            if (this.myInRefresh) {
                return;
            }
            this.myInRefresh = true;
            this.myTargetSelection = this.myDualView.getFlatView().getSelectedObjects();
            this.mySplitter.revalidate();
            this.mySplitter.repaint();
            this.myRefresherI.run(true, canUseLastRevisionCheck);
        });
    }

    @NotNull
    public AsynchConsumer<VcsHistorySession> getHistoryPanelRefresh() {
        return this.myHistoryPanelRefresh;
    }

    public Object getData(String dataId) {
        VcsFileRevision firstSelectedRevision = this.getFirstSelectedRevision();
        if (CommonDataKeys.NAVIGATABLE.is(dataId)) {
            List<TreeNodeOnVcsRevision> selectedItems = this.getSelection();
            if (selectedItems.size() != 1) {
                return null;
            }
            if (!this.myHistorySession.isContentAvailable(firstSelectedRevision)) {
                return null;
            }
            VirtualFile virtualFileForRevision = this.createVirtualFileForRevision(firstSelectedRevision);
            if (virtualFileForRevision != null) {
                return new OpenFileDescriptor(this.myVcs.getProject(), virtualFileForRevision);
            }
            return null;
        }
        if (CommonDataKeys.PROJECT.is(dataId)) {
            return this.myVcs.getProject();
        }
        if (VcsDataKeys.VCS_FILE_REVISION.is(dataId)) {
            return firstSelectedRevision;
        }
        if (VcsDataKeys.VCS_NON_LOCAL_HISTORY_SESSION.is(dataId) && this.myHistorySession != null) {
            return !this.myHistorySession.hasLocalSource();
        }
        if (VcsDataKeys.VCS.is(dataId)) {
            return this.myVcs.getKeyInstanceMethod();
        }
        if (VcsDataKeys.VCS_FILE_REVISIONS.is(dataId)) {
            return this.getSelectedRevisions();
        }
        if (VcsDataKeys.REMOTE_HISTORY_CHANGED_LISTENER.is(dataId)) {
            return s -> this.myDualView.rebuild();
        }
        if (VcsDataKeys.CHANGES.is(dataId)) {
            return this.getChanges();
        }
        if (VcsDataKeys.VCS_VIRTUAL_FILE.is(dataId)) {
            if (firstSelectedRevision == null) {
                return null;
            }
            return this.createVirtualFileForRevision(firstSelectedRevision);
        }
        if (VcsDataKeys.FILE_PATH.is(dataId)) {
            return this.myFilePath;
        }
        if (VcsDataKeys.IO_FILE.is(dataId)) {
            return this.myFilePath.getIOFile();
        }
        if (CommonDataKeys.VIRTUAL_FILE.is(dataId)) {
            VirtualFile virtualFile = this.getVirtualFile();
            return virtualFile == null || !virtualFile.isValid() ? null : virtualFile;
        }
        if (VcsDataKeys.FILE_HISTORY_PANEL.is(dataId)) {
            return this;
        }
        if (VcsDataKeys.HISTORY_SESSION.is(dataId)) {
            return this.myHistorySession;
        }
        if (VcsDataKeys.HISTORY_PROVIDER.is(dataId)) {
            return this.myProvider;
        }
        if (PlatformDataKeys.COPY_PROVIDER.is(dataId)) {
            return this;
        }
        return super.getData(dataId);
    }

    @Nullable
    private Change[] getChanges() {
        VcsFileRevision[] revisions = this.getSelectedRevisions();
        if (revisions.length > 0) {
            Arrays.sort(revisions, (o1, o2) -> o1.getRevisionNumber().compareTo((Object)o2.getRevisionNumber()));
            for (VcsFileRevision revision : revisions) {
                if (this.myHistorySession.isContentAvailable(revision)) continue;
                return null;
            }
            LoadedContentRevision startRevision = new LoadedContentRevision(this.myFilePath, revisions[0], this.myVcs.getProject());
            Object endRevision = revisions.length == 1 ? new CurrentContentRevision(this.myFilePath) : new LoadedContentRevision(this.myFilePath, revisions[revisions.length - 1], this.myVcs.getProject());
            return new Change[]{new Change((ContentRevision)startRevision, (ContentRevision)endRevision)};
        }
        return null;
    }

    private VirtualFile createVirtualFileForRevision(VcsFileRevision revision) {
        if (!this.myRevisionToVirtualFile.containsKey(revision)) {
            FilePath filePath = revision instanceof VcsFileRevisionEx ? ((VcsFileRevisionEx)revision).getPath() : this.myFilePath;
            this.myRevisionToVirtualFile.put(revision, (VirtualFile)(filePath.isDirectory() ? new VcsVirtualFolder(filePath.getPath(), null, (VirtualFileSystem)VcsFileSystem.getInstance()) : new VcsVirtualFile(filePath.getPath(), revision, (VirtualFileSystem)VcsFileSystem.getInstance())));
        }
        return this.myRevisionToVirtualFile.get(revision);
    }

    private List<TreeNodeOnVcsRevision> getSelection() {
        return this.myDualView.getSelection();
    }

    @Nullable
    private VcsFileRevision getFirstSelectedRevision() {
        List<TreeNodeOnVcsRevision> selection = this.getSelection();
        if (selection.isEmpty()) {
            return null;
        }
        return selection.get(0).getRevision();
    }

    @NotNull
    public VcsFileRevision[] getSelectedRevisions() {
        List<TreeNodeOnVcsRevision> selection = this.getSelection();
        VcsFileRevision[] result2 = new VcsFileRevision[selection.size()];
        for (int i2 = 0; i2 < selection.size(); ++i2) {
            result2[i2] = selection.get(i2).getRevision();
        }
        return result2;
    }

    public void dispose() {
        this.myDualView.dispose();
    }

    @NotNull
    public FileHistoryRefresherI getRefresher() {
        return this.myRefresherI;
    }

    @NotNull
    public FilePath getFilePath() {
        return this.myFilePath;
    }

    @Nullable
    public VirtualFile getVirtualFile() {
        return this.myFilePath.getVirtualFile();
    }

    private void refreshRevisionsOrder() {
        List list = this.myHistorySession.getRevisionList();
        this.myRevisionsOrder.clear();
        int cnt = 0;
        for (VcsFileRevision revision : list) {
            this.myRevisionsOrder.put(revision.getRevisionNumber(), cnt);
            ++cnt;
        }
    }

    public void setIsStaticAndEmbedded(boolean isStaticAndEmbedded) {
        this.myIsStaticAndEmbedded = isStaticAndEmbedded;
        this.myDualView.setZipByHeight(isStaticAndEmbedded);
        this.myDualView.getFlatView().updateColumnSizes();
        if (this.myIsStaticAndEmbedded) {
            this.disableClose();
            this.myDualView.getFlatView().getTableHeader().setBorder(IdeBorderFactory.createBorder((int)2));
            this.myDualView.getTreeView().getTableHeader().setBorder(IdeBorderFactory.createBorder((int)2));
            this.myDualView.getFlatView().setBorder(null);
            this.myDualView.getTreeView().setBorder(null);
        }
    }

    public void setBottomRevisionForShowDiff(VcsFileRevision bottomRevisionForShowDiff) {
        this.myBottomRevisionForShowDiff = bottomRevisionForShowDiff;
    }

    public boolean equals(Object obj) {
        return obj instanceof FileHistoryPanelImpl && FileHistoryPanelImpl.sameHistories((FileHistoryPanelImpl)((Object)obj), this.myFilePath, this.myStartingRevision);
    }

    public int hashCode() {
        int result2 = this.myFilePath.hashCode();
        result2 = 31 * result2 + (this.myStartingRevision != null ? this.myStartingRevision.asString().hashCode() : 0);
        return result2;
    }

    public void performCopy(@NotNull DataContext dataContext) {
        String text = StringUtil.join((Object[])this.getSelectedRevisions(), revision -> FileHistoryPanelImpl.getPresentableText(revision, true), (String)"\n");
        CopyPasteManager.getInstance().setContents((Transferable)new StringSelection(text));
    }

    public boolean isCopyEnabled(@NotNull DataContext dataContext) {
        return this.getSelection().size() > 0;
    }

    public boolean isCopyVisible(@NotNull DataContext dataContext) {
        return true;
    }

    public void globalSchemeChange(EditorColorsScheme scheme2) {
        this.updateMessage();
    }

    private class MyShowDetailsAction
    extends ToggleAction
    implements DumbAware {
        public MyShowDetailsAction() {
            super("Show Details", "Display details panel", AllIcons.Actions.Preview);
        }

        public boolean isSelected(AnActionEvent e) {
            return ((FileHistoryPanelImpl)FileHistoryPanelImpl.this).getConfiguration().SHOW_FILE_HISTORY_DETAILS;
        }

        public void setSelected(AnActionEvent e, boolean state) {
            ((FileHistoryPanelImpl)FileHistoryPanelImpl.this).getConfiguration().SHOW_FILE_HISTORY_DETAILS = state;
            FileHistoryPanelImpl.this.setupDetails();
        }
    }

    public class MyCreatePatch
    extends DumbAwareAction {
        private final CreatePatchFromChangesAction myUsualDelegate;

        public MyCreatePatch() {
            super(VcsBundle.message((String)"action.name.create.patch.for.selected.revisions", (Object[])new Object[0]), VcsBundle.message((String)"action.description.create.patch.for.selected.revisions", (Object[])new Object[0]), AllIcons.Actions.CreatePatch);
            this.myUsualDelegate = new CreatePatchFromChangesAction();
        }

        public void actionPerformed(AnActionEvent e) {
            if (FileHistoryPanelImpl.this.myFilePath.isDirectory()) {
                List selection = FileHistoryPanelImpl.this.getSelection();
                if (selection.size() != 1) {
                    return;
                }
                ProgressManager.getInstance().run((Task)new FolderPatchCreationTask(FileHistoryPanelImpl.this.myVcs, (TreeNodeOnVcsRevision)selection.get(0)));
            } else {
                this.myUsualDelegate.actionPerformed(e);
            }
        }

        public void update(AnActionEvent e) {
            e.getPresentation().setVisible(true);
            if (FileHistoryPanelImpl.this.myFilePath.isNonLocal()) {
                e.getPresentation().setEnabled(false);
                return;
            }
            boolean enabled = !FileHistoryPanelImpl.this.myFilePath.isDirectory() || FileHistoryPanelImpl.this.myProvider.supportsHistoryForDirectories();
            int selectionSize = FileHistoryPanelImpl.this.getSelection().size();
            if (enabled && !FileHistoryPanelImpl.this.myFilePath.isDirectory()) {
                enabled = selectionSize > 0 && selectionSize < 3;
            } else if (enabled) {
                enabled = selectionSize == 1 && ((TreeNodeOnVcsRevision)FileHistoryPanelImpl.this.getSelection().get(0)).getChangedRepositoryPath() != null;
            }
            e.getPresentation().setEnabled(enabled);
        }
    }

    private class RefreshFileHistoryAction
    extends RefreshAction
    implements DumbAware {
        public RefreshFileHistoryAction() {
            super(VcsBundle.message((String)"action.name.refresh", (Object[])new Object[0]), VcsBundle.message((String)"action.description.refresh", (Object[])new Object[0]), AllIcons.Actions.Refresh);
            this.registerShortcutOn((JComponent)((Object)FileHistoryPanelImpl.this));
        }

        @Override
        public void actionPerformed(AnActionEvent e) {
            if (FileHistoryPanelImpl.this.myInRefresh) {
                return;
            }
            FileHistoryPanelImpl.this.refreshUiAndScheduleDataRefresh(false);
        }

        @Override
        public void update(AnActionEvent e) {
            super.update(e);
            e.getPresentation().setEnabled(!FileHistoryPanelImpl.this.myInRefresh);
        }
    }

    private class MyAnnotateAction
    extends AnnotateRevisionActionBase
    implements DumbAware {
        public MyAnnotateAction() {
            super(VcsBundle.message((String)"annotate.action.name", (Object[])new Object[0]), VcsBundle.message((String)"annotate.action.description", (Object[])new Object[0]), AllIcons.Actions.Annotate);
            this.setShortcutSet(ActionManager.getInstance().getAction("Annotate").getShortcutSet());
        }

        @Override
        @Nullable
        protected Editor getEditor(@NotNull AnActionEvent e) {
            VirtualFile editorFile;
            VirtualFile virtualFile = FileHistoryPanelImpl.this.getVirtualFile();
            if (virtualFile == null) {
                return null;
            }
            Editor editor = (Editor)e.getData(CommonDataKeys.EDITOR);
            if (editor != null && Comparing.equal((Object)(editorFile = FileDocumentManager.getInstance().getFile(editor.getDocument())), (Object)virtualFile)) {
                return editor;
            }
            FileEditor fileEditor = FileEditorManager.getInstance((Project)FileHistoryPanelImpl.this.myProject).getSelectedEditor(virtualFile);
            if (fileEditor instanceof TextEditor) {
                return ((TextEditor)fileEditor).getEditor();
            }
            return null;
        }

        @Override
        @Nullable
        protected AbstractVcs getVcs(@NotNull AnActionEvent e) {
            return FileHistoryPanelImpl.this.myVcs;
        }

        @Override
        @Nullable
        protected VirtualFile getFile(@NotNull AnActionEvent e) {
            Boolean nonLocal = (Boolean)e.getData(VcsDataKeys.VCS_NON_LOCAL_HISTORY_SESSION);
            if (Boolean.TRUE.equals(nonLocal)) {
                return null;
            }
            VirtualFile file2 = (VirtualFile)e.getData(VcsDataKeys.VCS_VIRTUAL_FILE);
            if (file2 == null || file2.isDirectory()) {
                return null;
            }
            if (FileHistoryPanelImpl.this.myFilePath.getFileType().isBinary()) {
                return null;
            }
            return file2;
        }

        @Override
        @Nullable
        protected VcsFileRevision getFileRevision(@NotNull AnActionEvent e) {
            VcsFileRevision revision = (VcsFileRevision)e.getData(VcsDataKeys.VCS_FILE_REVISION);
            if (!FileHistoryPanelImpl.this.myHistorySession.isContentAvailable(revision)) {
                return null;
            }
            return revision;
        }
    }

    private static class MyGetVersionAction
    extends GetVersionAction {
        private MyGetVersionAction() {
        }

        @Override
        protected boolean isContentAvailable(@NotNull FilePath filePath, @NotNull VcsFileRevision revision, @NotNull AnActionEvent e) {
            VcsHistorySession historySession = (VcsHistorySession)e.getData(VcsDataKeys.HISTORY_SESSION);
            if (historySession == null) {
                return false;
            }
            return historySession.isContentAvailable(revision) && !filePath.isDirectory();
        }
    }

    private class MyDiffAction
    extends AbstractActionForSomeSelection {
        public MyDiffAction() {
            super(VcsBundle.message((String)"action.name.compare", (Object[])new Object[0]), VcsBundle.message((String)"action.description.compare", (Object[])new Object[0]), "diff", 2, FileHistoryPanelImpl.this);
        }

        @Override
        protected void executeAction(AnActionEvent e) {
            List sel = FileHistoryPanelImpl.this.getSelection();
            int selectionSize = sel.size();
            if (selectionSize > 1) {
                List selectedRevisions = ContainerUtil.sorted((Collection)ContainerUtil.map((Collection)sel, TreeNodeOnVcsRevision::getRevision), (Comparator)FileHistoryPanelImpl.this.myRevisionsInOrderComparator);
                VcsFileRevision olderRevision = (VcsFileRevision)selectedRevisions.get(0);
                VcsFileRevision newestRevision = (VcsFileRevision)selectedRevisions.get(sel.size() - 1);
                FileHistoryPanelImpl.this.myDiffHandler.showDiffForTwo((Project)e.getRequiredData(CommonDataKeys.PROJECT), FileHistoryPanelImpl.this.myFilePath, olderRevision, newestRevision);
            } else if (selectionSize == 1) {
                TableView flatView = FileHistoryPanelImpl.this.myDualView.getFlatView();
                int selectedRow = flatView.getSelectedRow();
                VcsFileRevision revision = FileHistoryPanelImpl.this.getFirstSelectedRevision();
                VcsFileRevision previousRevision = selectedRow == flatView.getRowCount() - 1 ? (FileHistoryPanelImpl.this.myBottomRevisionForShowDiff != null ? FileHistoryPanelImpl.this.myBottomRevisionForShowDiff : VcsFileRevision.NULL) : ((TreeNodeOnVcsRevision)flatView.getRow(selectedRow + 1)).getRevision();
                if (revision != null) {
                    FileHistoryPanelImpl.this.myDiffHandler.showDiffForOne(e, (Project)e.getRequiredData(CommonDataKeys.PROJECT), FileHistoryPanelImpl.this.myFilePath, previousRevision, revision);
                }
            }
        }

        @Override
        public void update(AnActionEvent e) {
            super.update(e);
            int selectionSize = FileHistoryPanelImpl.this.getSelection().size();
            e.getPresentation().setEnabled(selectionSize > 0 && this.isEnabled());
        }

        @Override
        public boolean isEnabled() {
            int selectionSize = FileHistoryPanelImpl.this.getSelection().size();
            if (selectionSize == 1) {
                List sel = FileHistoryPanelImpl.this.getSelection();
                return FileHistoryPanelImpl.this.myHistorySession.isContentAvailable((VcsFileRevision)sel.get(0));
            }
            if (selectionSize > 1) {
                return this.isDiffEnabled();
            }
            return false;
        }

        private boolean isDiffEnabled() {
            List sel = FileHistoryPanelImpl.this.getSelection();
            return FileHistoryPanelImpl.this.myHistorySession.isContentAvailable((VcsFileRevision)sel.get(0)) && FileHistoryPanelImpl.this.myHistorySession.isContentAvailable((VcsFileRevision)sel.get(sel.size() - 1));
        }
    }

    private class MyShowAsTreeAction
    extends ToggleAction
    implements DumbAware {
        public MyShowAsTreeAction() {
            super(VcsBundle.message((String)"action.name.show.files.as.tree", (Object[])new Object[0]), null, PlatformIcons.SMALL_VCS_CONFIGURABLE);
        }

        public boolean isSelected(AnActionEvent e) {
            return ((FileHistoryPanelImpl)FileHistoryPanelImpl.this).getConfiguration().SHOW_FILE_HISTORY_AS_TREE;
        }

        public void setSelected(AnActionEvent e, boolean state) {
            ((FileHistoryPanelImpl)FileHistoryPanelImpl.this).getConfiguration().SHOW_FILE_HISTORY_AS_TREE = state;
            FileHistoryPanelImpl.this.chooseView();
        }
    }

    private static class FolderPatchCreationTask
    extends Task.Backgroundable {
        private final AbstractVcs myVcs;
        private final TreeNodeOnVcsRevision myRevision;
        private CommittedChangeList myList;
        private VcsException myException;

        private FolderPatchCreationTask(@NotNull AbstractVcs vcs, TreeNodeOnVcsRevision revision) {
            super(vcs.getProject(), VcsBundle.message((String)"create.patch.loading.content.progress", (Object[])new Object[0]), true);
            this.myVcs = vcs;
            this.myRevision = revision;
        }

        public void run(@NotNull ProgressIndicator indicator) {
            CommittedChangesProvider provider2 = this.myVcs.getCommittedChangesProvider();
            if (provider2 == null) {
                return;
            }
            RepositoryLocation changedRepositoryPath = this.myRevision.getChangedRepositoryPath();
            if (changedRepositoryPath == null) {
                return;
            }
            VcsVirtualFile vf = new VcsVirtualFile(changedRepositoryPath.toPresentableString(), this.myRevision.getRevision(), (VirtualFileSystem)VcsFileSystem.getInstance());
            try {
                this.myList = AbstractVcsHelperImpl.getRemoteList(this.myVcs, this.myRevision.getRevisionNumber(), (VirtualFile)vf);
            }
            catch (VcsException e1) {
                this.myException = e1;
            }
        }

        public void onSuccess() {
            AbstractVcsHelper helper = AbstractVcsHelper.getInstance((Project)this.myProject);
            if (this.myException != null) {
                helper.showError(this.myException, VcsBundle.message((String)"create.patch.error.title", (Object[])new Object[]{this.myException.getMessage()}));
            } else if (this.myList == null) {
                helper.showError(null, "Can not load changelist contents");
            } else {
                CreatePatchFromChangesAction.createPatch(this.myProject, this.myList.getComment(), new ArrayList<Change>(this.myList.getChanges()));
            }
        }
    }

    private static class MyCellWrapper
    implements CellWrapper {
        private final Getter<VcsHistorySession> myHistorySession;

        public MyCellWrapper(Getter<VcsHistorySession> historySession) {
            this.myHistorySession = historySession;
        }

        public void wrap(Component component, JTable table, Object value2, boolean isSelected, boolean hasFocus, int row, int column, Object treeNode) {
            VcsFileRevision revision = (VcsFileRevision)treeNode;
            if (revision == null) {
                return;
            }
            if (((VcsHistorySession)this.myHistorySession.get()).isCurrentRevision(revision.getRevisionNumber())) {
                FileHistoryPanelImpl.makeBold(component);
            }
        }
    }

    private static class MyTreeCellRenderer
    implements TreeCellRenderer {
        private final TreeCellRenderer myDefaultCellRenderer;
        private final Getter<VcsHistorySession> myHistorySession;

        public MyTreeCellRenderer(TreeCellRenderer defaultCellRenderer, Getter<VcsHistorySession> historySession) {
            this.myDefaultCellRenderer = defaultCellRenderer;
            this.myHistorySession = historySession;
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value2, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            VcsFileRevision revision;
            Component result2 = this.myDefaultCellRenderer.getTreeCellRendererComponent(tree, value2, selected, expanded, leaf, row, hasFocus);
            TreePath path = tree.getPathForRow(row);
            if (path == null) {
                return result2;
            }
            VcsFileRevision vcsFileRevision = revision = row >= 0 ? (VcsFileRevision)path.getLastPathComponent() : null;
            if (revision != null) {
                if (((VcsHistorySession)this.myHistorySession.get()).isCurrentRevision(revision.getRevisionNumber())) {
                    FileHistoryPanelImpl.makeBold(result2);
                }
                if (!selected && ((VcsHistorySession)this.myHistorySession.get()).isCurrentRevision(revision.getRevisionNumber())) {
                    result2.setBackground((Color)new JBColor(new Color(188, 227, 231), new Color(188, 227, 231)));
                }
                ((JComponent)result2).setOpaque(false);
            } else if (selected) {
                result2.setBackground(UIUtil.getTableSelectionBackground());
            } else {
                result2.setBackground(UIUtil.getTableBackground());
            }
            return result2;
        }
    }

    static abstract class VcsColumnInfo<T extends Comparable<T>>
    extends DualViewColumnInfo<VcsFileRevision, String>
    implements Comparator<VcsFileRevision> {
        @NotNull
        private final ColoredTableCellRenderer myRenderer = new ColoredTableCellRenderer(){

            protected void customizeCellRenderer(JTable table, Object value2, boolean selected, boolean hasFocus, int row, int column) {
                this.setOpaque(selected);
                this.append(value2.toString());
                SpeedSearchUtil.applySpeedSearchHighlighting((JComponent)table, (SimpleColoredComponent)this, (boolean)false, (boolean)selected);
            }
        };

        public VcsColumnInfo(String name) {
            super(name);
        }

        protected abstract T getDataOf(VcsFileRevision var1);

        public Comparator<VcsFileRevision> getComparator() {
            return this;
        }

        public String valueOf(VcsFileRevision object) {
            T result2 = this.getDataOf(object);
            return result2 == null ? "" : result2.toString();
        }

        @Override
        public int compare(VcsFileRevision o1, VcsFileRevision o2) {
            return Comparing.compare(this.getDataOf(o1), this.getDataOf(o2));
        }

        public boolean shouldBeShownIsTheTree() {
            return true;
        }

        public boolean shouldBeShownIsTheTable() {
            return true;
        }

        @Nullable
        public TableCellRenderer getRenderer(VcsFileRevision revision) {
            return this.myRenderer;
        }
    }

    static abstract class AbstractActionForSomeSelection
    extends AnAction
    implements DumbAware {
        private final int mySuitableSelectedElements;
        private final FileHistoryPanelImpl mySelectionProvider;

        public AbstractActionForSomeSelection(String name, String description, @NonNls String iconName, int suitableSelectionSize, FileHistoryPanelImpl tableProvider) {
            super(name, description, IconLoader.getIcon((String)("/actions/" + iconName + ".png")));
            this.mySuitableSelectedElements = suitableSelectionSize;
            this.mySelectionProvider = tableProvider;
        }

        protected abstract void executeAction(AnActionEvent var1);

        public boolean isEnabled() {
            return this.mySelectionProvider.getSelection().size() == this.mySuitableSelectedElements;
        }

        public void actionPerformed(AnActionEvent e) {
            if (!this.isEnabled()) {
                return;
            }
            this.executeAction(e);
        }

        public void update(AnActionEvent e) {
            Presentation presentation = e.getPresentation();
            presentation.setVisible(true);
            presentation.setEnabled(this.isEnabled());
        }
    }

    private static class LoadedContentRevision
    implements ByteBackedContentRevision {
        private final FilePath myFile;
        private final VcsFileRevision myRevision;
        private final Project myProject;

        private LoadedContentRevision(FilePath file2, VcsFileRevision revision, Project project2) {
            this.myFile = file2;
            this.myRevision = revision;
            this.myProject = project2;
        }

        public String getContent() throws VcsException {
            try {
                return VcsHistoryUtil.loadRevisionContentGuessEncoding(this.myRevision, this.myFile.getVirtualFile(), this.myProject);
            }
            catch (IOException e) {
                throw new VcsException(VcsBundle.message((String)"message.text.cannot.load.revision", (Object[])new Object[]{e.getLocalizedMessage()}));
            }
        }

        @Nullable
        public byte[] getContentAsBytes() throws VcsException {
            try {
                return VcsHistoryUtil.loadRevisionContent(this.myRevision);
            }
            catch (IOException e) {
                throw new VcsException(VcsBundle.message((String)"message.text.cannot.load.revision", (Object[])new Object[]{e.getLocalizedMessage()}));
            }
        }

        @NotNull
        public FilePath getFile() {
            return this.myFile;
        }

        @NotNull
        public VcsRevisionNumber getRevisionNumber() {
            return this.myRevision.getRevisionNumber();
        }
    }

    public static class MessageColumnInfo
    extends VcsColumnInfo<String> {
        private final ColoredTableCellRenderer myRenderer = new ColoredTableCellRenderer(){

            protected void customizeCellRenderer(JTable table, Object value2, boolean selected, boolean hasFocus, int row, int column) {
                this.setOpaque(selected);
                if (value2 instanceof String) {
                    String message2 = (String)value2;
                    myIssueLinkRenderer.appendTextWithLinks(message2);
                    SpeedSearchUtil.applySpeedSearchHighlighting((JComponent)table, (SimpleColoredComponent)this, (boolean)false, (boolean)selected);
                }
            }
        };
        private final IssueLinkRenderer myIssueLinkRenderer;

        public MessageColumnInfo(Project project2) {
            super(COMMIT_MESSAGE_TITLE);
            this.myIssueLinkRenderer = new IssueLinkRenderer(project2, (SimpleColoredComponent)this.myRenderer);
        }

        @NotNull
        public static String getSubject(@NotNull VcsFileRevision object) {
            String originalMessage = object.getCommitMessage();
            if (originalMessage == null) {
                return "";
            }
            int index = StringUtil.indexOfAny((String)originalMessage, (String)"\n\r");
            return index == -1 ? originalMessage : originalMessage.substring(0, index);
        }

        @Override
        protected String getDataOf(VcsFileRevision object) {
            return MessageColumnInfo.getSubject(object);
        }

        public String getPreferredStringValue() {
            return StringUtil.repeatSymbol((char)'m', (int)80);
        }

        @Override
        public TableCellRenderer getRenderer(VcsFileRevision p0) {
            return this.myRenderer;
        }
    }

    public static class AuthorColumnInfo
    extends VcsColumnInfo<String> {
        private final TableCellRenderer AUTHOR_RENDERER = new AuthorCellRenderer();

        public AuthorColumnInfo() {
            super(VcsBundle.message((String)"column.name.revision.list.author", (Object[])new Object[0]));
        }

        static String toString(VcsFileRevision o) {
            VcsFileRevision rev = o;
            if (o instanceof TreeNodeOnVcsRevision) {
                rev = ((TreeNodeOnVcsRevision)o).getRevision();
            }
            if (rev instanceof VcsFileRevisionEx && !Comparing.equal((String)rev.getAuthor(), (String)((VcsFileRevisionEx)rev).getCommitterName())) {
                return o.getAuthor() + "*";
            }
            return o.getAuthor();
        }

        @Override
        protected String getDataOf(VcsFileRevision object) {
            return AuthorColumnInfo.toString(object);
        }

        @Override
        public TableCellRenderer getRenderer(VcsFileRevision revision) {
            return this.AUTHOR_RENDERER;
        }

        public TableCellRenderer getCustomizedRenderer(VcsFileRevision value2, TableCellRenderer renderer) {
            if (renderer instanceof AuthorCellRenderer) {
                VcsFileRevision revision = value2;
                if (value2 instanceof TreeNodeOnVcsRevision) {
                    revision = ((TreeNodeOnVcsRevision)value2).getRevision();
                }
                if (revision instanceof VcsFileRevisionEx) {
                    VcsFileRevisionEx ex = (VcsFileRevisionEx)revision;
                    StringBuilder sb = new StringBuilder(StringUtil.notNullize((String)ex.getAuthor()));
                    if (ex.getAuthorEmail() != null) {
                        sb.append(" &lt;").append(ex.getAuthorEmail()).append("&gt;");
                    }
                    if (ex.getCommitterName() != null && !Comparing.equal((String)ex.getAuthor(), (String)ex.getCommitterName())) {
                        sb.append(", via ").append(ex.getCommitterName());
                        if (ex.getCommitterEmail() != null) {
                            sb.append(" &lt;").append(ex.getCommitterEmail()).append("&gt;");
                        }
                    }
                    ((AuthorCellRenderer)((Object)renderer)).setTooltipText(sb.toString());
                }
            }
            return renderer;
        }

        @NonNls
        public String getPreferredStringValue() {
            return StringUtil.repeatSymbol((char)'m', (int)14);
        }
    }

    private static class AuthorCellRenderer
    extends ColoredTableCellRenderer {
        private String myTooltipText;

        private AuthorCellRenderer() {
        }

        public void setTooltipText(String text) {
            this.myTooltipText = text;
        }

        protected void customizeCellRenderer(JTable table, @Nullable Object value2, boolean selected, boolean hasFocus, int row, int column) {
            this.setToolTipText(this.myTooltipText);
            if (selected || hasFocus) {
                this.setBackground(table.getSelectionBackground());
                this.setForeground(table.getSelectionForeground());
            } else {
                this.setBackground(table.getBackground());
                this.setForeground(table.getForeground());
            }
            if (value2 != null) {
                this.append(value2.toString());
            }
            SpeedSearchUtil.applySpeedSearchHighlighting((JComponent)table, (SimpleColoredComponent)this, (boolean)false, (boolean)selected);
        }
    }

    public static class DateColumnInfo
    extends VcsColumnInfo<String> {
        public DateColumnInfo() {
            super(VcsBundle.message((String)"column.name.revision.date", (Object[])new Object[0]));
        }

        @NotNull
        static String toString(VcsFileRevision object) {
            Date date = object.getRevisionDate();
            if (date == null) {
                return "";
            }
            return DateFormatUtil.formatPrettyDateTime((Date)date);
        }

        @Override
        protected String getDataOf(VcsFileRevision object) {
            return DateColumnInfo.toString(object);
        }

        @Override
        public int compare(VcsFileRevision o1, VcsFileRevision o2) {
            return Comparing.compare((Comparable)o1.getRevisionDate(), (Comparable)o2.getRevisionDate());
        }

        public String getPreferredStringValue() {
            return DateFormatUtil.formatPrettyDateTime((long)(Clock.getTime() + 1000L));
        }
    }

    public static class RevisionColumnInfo
    extends VcsColumnInfo<VcsRevisionNumber> {
        private final Comparator<VcsFileRevision> myComparator;

        public RevisionColumnInfo(Comparator<VcsFileRevision> comparator2) {
            super(VcsBundle.message((String)"column.name.revision.version", (Object[])new Object[0]));
            this.myComparator = comparator2;
        }

        static String toString(VcsFileRevision o, boolean shortVersion) {
            VcsRevisionNumber number = o.getRevisionNumber();
            return shortVersion && number instanceof ShortVcsRevisionNumber ? ((ShortVcsRevisionNumber)number).toShortString() : number.asString();
        }

        @Override
        protected VcsRevisionNumber getDataOf(VcsFileRevision object) {
            return object.getRevisionNumber();
        }

        @Override
        public Comparator<VcsFileRevision> getComparator() {
            return this.myComparator;
        }

        @Override
        public String valueOf(VcsFileRevision object) {
            return RevisionColumnInfo.toString(object, true);
        }

        public String getPreferredStringValue() {
            return StringUtil.repeatSymbol((char)'m', (int)10);
        }
    }
}

