/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.history;

import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsKey;
import com.intellij.openapi.vcs.history.FileHistoryRefresherI;
import com.intellij.openapi.vcs.history.FileHistorySessionPartner;
import com.intellij.openapi.vcs.history.VcsHistoryProvider;
import com.intellij.openapi.vcs.history.VcsHistoryProviderBackgroundableProxy;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.vcs.history.VcsHistoryProviderEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FileHistoryRefresher
implements FileHistoryRefresherI {
    private final FileHistorySessionPartner mySessionPartner;
    private final VcsHistoryProvider myVcsHistoryProvider;
    private final FilePath myPath;
    private final AbstractVcs myVcs;
    @Nullable
    private final VcsRevisionNumber myStartingRevisionNumber;
    private boolean myCanUseCache;
    private boolean myIsRefresh;

    public FileHistoryRefresher(VcsHistoryProvider vcsHistoryProvider, FilePath path, AbstractVcs vcs) {
        this(vcsHistoryProvider, path, null, vcs);
    }

    public FileHistoryRefresher(VcsHistoryProviderEx vcsHistoryProvider, FilePath path, @Nullable VcsRevisionNumber startingRevisionNumber, AbstractVcs vcs) {
        this((VcsHistoryProvider)vcsHistoryProvider, path, startingRevisionNumber, vcs);
    }

    private FileHistoryRefresher(VcsHistoryProvider vcsHistoryProvider, FilePath path, @Nullable VcsRevisionNumber startingRevisionNumber, AbstractVcs vcs) {
        this.myVcsHistoryProvider = vcsHistoryProvider;
        this.myPath = path;
        this.myVcs = vcs;
        this.myStartingRevisionNumber = startingRevisionNumber;
        this.mySessionPartner = new FileHistorySessionPartner(vcsHistoryProvider, path, startingRevisionNumber, vcs, this);
        this.myCanUseCache = true;
    }

    @NotNull
    public static FileHistoryRefresherI findOrCreate(@NotNull VcsHistoryProvider vcsHistoryProvider, @NotNull FilePath path, @NotNull AbstractVcs vcs) {
        FileHistoryRefresherI refresher = FileHistorySessionPartner.findExistingHistoryRefresher(vcs.getProject(), path, null);
        return refresher == null ? new FileHistoryRefresher(vcsHistoryProvider, path, vcs) : refresher;
    }

    @NotNull
    public static FileHistoryRefresherI findOrCreate(@NotNull VcsHistoryProviderEx vcsHistoryProvider, @NotNull FilePath path, @NotNull AbstractVcs vcs, @Nullable VcsRevisionNumber startingRevisionNumber) {
        FileHistoryRefresherI refresher = FileHistorySessionPartner.findExistingHistoryRefresher(vcs.getProject(), path, startingRevisionNumber);
        return refresher == null ? new FileHistoryRefresher(vcsHistoryProvider, path, startingRevisionNumber, vcs) : refresher;
    }

    @Override
    public void run(boolean isRefresh, boolean canUseLastRevision) {
        this.myIsRefresh = isRefresh;
        this.mySessionPartner.beforeRefresh();
        VcsHistoryProviderBackgroundableProxy proxy = new VcsHistoryProviderBackgroundableProxy(this.myVcs, this.myVcsHistoryProvider, this.myVcs.getDiffProvider());
        VcsKey key2 = this.myVcs.getKeyInstanceMethod();
        if (this.myVcsHistoryProvider instanceof VcsHistoryProviderEx && this.myStartingRevisionNumber != null) {
            proxy.executeAppendableSession(key2, this.myPath, this.myStartingRevisionNumber, this.mySessionPartner, null);
        } else {
            proxy.executeAppendableSession(key2, this.myPath, this.mySessionPartner, null, this.myCanUseCache, canUseLastRevision);
        }
        this.myCanUseCache = false;
    }

    @Override
    public boolean isFirstTime() {
        return !this.myIsRefresh;
    }
}

