/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.history;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.ex.ProjectLevelVcsManagerEx;
import com.intellij.openapi.vcs.history.FileHistoryPanelImpl;
import com.intellij.openapi.vcs.history.FileHistoryRefresherI;
import com.intellij.openapi.vcs.history.LimitHistoryCheck;
import com.intellij.openapi.vcs.history.ShortVcsRevisionNumber;
import com.intellij.openapi.vcs.history.VcsAbstractHistorySession;
import com.intellij.openapi.vcs.history.VcsAppendableHistorySessionPartner;
import com.intellij.openapi.vcs.history.VcsFileRevision;
import com.intellij.openapi.vcs.history.VcsHistoryProvider;
import com.intellij.openapi.vcs.history.VcsHistorySession;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vcs.ui.VcsBalloonProblemNotifier;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowId;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.ui.content.ContentManager;
import com.intellij.util.BufferedListConsumer;
import com.intellij.util.Consumer;
import com.intellij.util.ContentUtilEx;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FileHistorySessionPartner
implements VcsAppendableHistorySessionPartner {
    @NotNull
    private final AbstractVcs myVcs;
    @NotNull
    private final VcsHistoryProvider myVcsHistoryProvider;
    @NotNull
    private final FilePath myPath;
    @Nullable
    private final VcsRevisionNumber myStartingRevisionNumber;
    @NotNull
    private final LimitHistoryCheck myLimitHistoryCheck;
    @NotNull
    private final FileHistoryRefresherI myRefresherI;
    @NotNull
    private final BufferedListConsumer<VcsFileRevision> myBuffer;
    private FileHistoryPanelImpl myFileHistoryPanel;
    private volatile VcsAbstractHistorySession mySession;

    public FileHistorySessionPartner(@NotNull VcsHistoryProvider vcsHistoryProvider, @NotNull FilePath path, @Nullable VcsRevisionNumber startingRevisionNumber, @NotNull AbstractVcs vcs, @NotNull FileHistoryRefresherI refresherI) {
        this.myVcsHistoryProvider = vcsHistoryProvider;
        this.myPath = path;
        this.myStartingRevisionNumber = startingRevisionNumber;
        this.myLimitHistoryCheck = new LimitHistoryCheck(vcs.getProject(), path.getPath());
        this.myVcs = vcs;
        this.myRefresherI = refresherI;
        Consumer sessionRefresher = vcsFileRevisions -> {
            this.mySession.getRevisionList().addAll(vcsFileRevisions);
            VcsHistorySession copy = this.mySession.copyWithCachedRevision();
            ApplicationManager.getApplication().invokeAndWait(() -> this.ensureHistoryPanelCreated().getHistoryPanelRefresh().consume((Object)copy));
        };
        this.myBuffer = new BufferedListConsumer<VcsFileRevision>(5, sessionRefresher, 1000){

            @Override
            protected void invokeConsumer(@NotNull Runnable consumerRunnable) {
                consumerRunnable.run();
            }
        };
    }

    @Nullable
    static FileHistoryRefresherI findExistingHistoryRefresher(@NotNull Project project2, @NotNull FilePath path, @Nullable VcsRevisionNumber startingRevisionNumber) {
        JComponent component = ContentUtilEx.findContentComponent(FileHistorySessionPartner.getToolWindow(project2).getContentManager(), (Condition<JComponent>)((Condition)comp -> comp instanceof FileHistoryPanelImpl && FileHistoryPanelImpl.sameHistories((FileHistoryPanelImpl)((Object)((Object)comp)), path, startingRevisionNumber)));
        return component == null ? null : ((FileHistoryPanelImpl)((Object)component)).getRefresher();
    }

    public void acceptRevision(VcsFileRevision revision) {
        this.myLimitHistoryCheck.checkNumber();
        this.myBuffer.consumeOne(revision);
    }

    @NotNull
    private FileHistoryPanelImpl ensureHistoryPanelCreated() {
        if (this.myFileHistoryPanel == null) {
            this.myFileHistoryPanel = this.createFileHistoryPanel(this.mySession.copyWithCachedRevision());
        }
        return this.myFileHistoryPanel;
    }

    @NotNull
    private FileHistoryPanelImpl createFileHistoryPanel(@NotNull VcsHistorySession copy) {
        ContentManager contentManager = ProjectLevelVcsManagerEx.getInstanceEx(this.myVcs.getProject()).getContentManager();
        return new FileHistoryPanelImpl(this.myVcs, this.myPath, this.myStartingRevisionNumber, copy, this.myVcsHistoryProvider, contentManager, this.myRefresherI, false);
    }

    public void reportCreatedEmptySession(VcsAbstractHistorySession session2) {
        if (this.mySession != null && session2 != null && this.mySession.getRevisionList().equals(session2.getRevisionList())) {
            return;
        }
        this.mySession = session2;
        if (this.mySession != null) {
            this.mySession.shouldBeRefreshed();
        }
        ApplicationManager.getApplication().invokeAndWait(() -> {
            VcsHistorySession copy = this.mySession.copyWithCachedRevision();
            if (this.myFileHistoryPanel == null) {
                this.myFileHistoryPanel = this.createFileHistoryPanel(copy);
                this.createOrSelectContentIfNeeded();
            } else if (session2 != null && !session2.getRevisionList().isEmpty()) {
                this.myFileHistoryPanel.getHistoryPanelRefresh().consume((Object)copy);
            }
        });
    }

    @NotNull
    private static ToolWindow getToolWindow(@NotNull Project project2) {
        ToolWindow toolWindow = ToolWindowManager.getInstance((Project)project2).getToolWindow(ToolWindowId.VCS);
        assert (toolWindow != null) : "Version Control ToolWindow should be available at this point.";
        return toolWindow;
    }

    public void reportException(VcsException exception) {
        VcsBalloonProblemNotifier.showOverVersionControlView(this.myVcs.getProject(), VcsBundle.message((String)"message.title.could.not.load.file.history", (Object[])new Object[0]) + ": " + exception.getMessage(), MessageType.ERROR);
    }

    public void beforeRefresh() {
        this.myLimitHistoryCheck.reset();
        if (this.myFileHistoryPanel != null) {
            this.createOrSelectContentIfNeeded();
        }
    }

    private void createOrSelectContentIfNeeded() {
        ToolWindow toolWindow = FileHistorySessionPartner.getToolWindow(this.myVcs.getProject());
        if (this.myRefresherI.isFirstTime()) {
            ContentManager manager = toolWindow.getContentManager();
            boolean selectedExistingContent = ContentUtilEx.selectContent(manager, (JComponent)((Object)this.myFileHistoryPanel), true);
            if (!selectedExistingContent) {
                String tabName = this.myPath.getName();
                if (this.myStartingRevisionNumber != null) {
                    tabName = tabName + " (";
                    tabName = this.myStartingRevisionNumber instanceof ShortVcsRevisionNumber ? tabName + ((ShortVcsRevisionNumber)this.myStartingRevisionNumber).toShortString() : tabName + this.myStartingRevisionNumber.asString();
                    tabName = tabName + ")";
                }
                ContentUtilEx.addTabbedContent(manager, (JComponent)((Object)this.myFileHistoryPanel), "History", tabName, true);
            }
            toolWindow.activate(null);
        }
    }

    public void finished() {
        this.myBuffer.flush();
        ApplicationManager.getApplication().invokeAndWait(() -> {
            if (this.mySession == null) {
                return;
            }
            this.ensureHistoryPanelCreated().getHistoryPanelRefresh().finished();
        });
    }

    public void forceRefresh() {
        ApplicationManager.getApplication().invokeAndWait(() -> {
            if (this.mySession == null) {
                return;
            }
            this.ensureHistoryPanelCreated().scheduleRefresh(false);
        });
    }
}

