/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.history;

import com.intellij.openapi.vcs.RepositoryLocation;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.history.VcsFileRevision;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.ui.dualView.DualTreeElement;
import com.intellij.util.TreeItem;
import java.io.IOException;
import java.util.Date;
import java.util.List;
import javax.swing.tree.DefaultMutableTreeNode;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class TreeNodeOnVcsRevision
extends DefaultMutableTreeNode
implements VcsFileRevision,
DualTreeElement {
    @NotNull
    private final VcsFileRevision myRevision;

    public TreeNodeOnVcsRevision(@Nullable VcsFileRevision revision, @NotNull List<TreeItem<VcsFileRevision>> roots) {
        this.myRevision = revision == null ? VcsFileRevision.NULL : revision;
        for (TreeItem<VcsFileRevision> root : roots) {
            this.add(new TreeNodeOnVcsRevision((VcsFileRevision)root.getData(), root.getChildren()));
        }
    }

    @Nullable
    public RepositoryLocation getChangedRepositoryPath() {
        return this.myRevision.getChangedRepositoryPath();
    }

    @NotNull
    public VcsFileRevision getRevision() {
        return this.myRevision;
    }

    public String getAuthor() {
        return this.myRevision.getAuthor();
    }

    public String getCommitMessage() {
        return this.myRevision.getCommitMessage();
    }

    public byte[] loadContent() throws IOException, VcsException {
        return this.myRevision.loadContent();
    }

    @NotNull
    public VcsRevisionNumber getRevisionNumber() {
        return this.myRevision.getRevisionNumber();
    }

    public Date getRevisionDate() {
        return this.myRevision.getRevisionDate();
    }

    public String getBranchName() {
        return this.myRevision.getBranchName();
    }

    public byte[] getContent() throws IOException, VcsException {
        return this.myRevision.getContent();
    }

    @Override
    public String toString() {
        return this.getRevisionNumber().asString();
    }

    public boolean shouldBeInTheFlatView() {
        return this.myRevision != VcsFileRevision.NULL;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TreeNodeOnVcsRevision that = (TreeNodeOnVcsRevision)o;
        return !(this.myRevision != null ? !this.myRevision.getRevisionNumber().equals(that.myRevision.getRevisionNumber()) : that.myRevision != null);
    }

    public int hashCode() {
        return this.myRevision != null ? this.myRevision.getRevisionNumber().hashCode() : 0;
    }
}

