/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.history;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsConfiguration;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.VcsKey;
import com.intellij.openapi.vcs.VcsType;
import com.intellij.openapi.vcs.diff.DiffProvider;
import com.intellij.openapi.vcs.diff.ItemLatestState;
import com.intellij.openapi.vcs.history.LimitHistoryCheck;
import com.intellij.openapi.vcs.history.VcsAbstractHistorySession;
import com.intellij.openapi.vcs.history.VcsAppendableHistoryPartnerAdapter;
import com.intellij.openapi.vcs.history.VcsAppendableHistorySessionPartner;
import com.intellij.openapi.vcs.history.VcsCacheableHistorySessionFactory;
import com.intellij.openapi.vcs.history.VcsFileRevision;
import com.intellij.openapi.vcs.history.VcsHistoryCache;
import com.intellij.openapi.vcs.history.VcsHistoryProvider;
import com.intellij.openapi.vcs.history.VcsHistorySession;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vcs.impl.BackgroundableActionEnabledHandler;
import com.intellij.openapi.vcs.impl.ProjectLevelVcsManagerImpl;
import com.intellij.openapi.vcs.impl.VcsBackgroundableActions;
import com.intellij.openapi.vcs.impl.VcsBackgroundableComputable;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Consumer;
import com.intellij.vcs.history.VcsHistoryProviderEx;
import com.intellij.vcsUtil.VcsUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VcsHistoryProviderBackgroundableProxy {
    private final Project myProject;
    private final DiffProvider myDiffProvider;
    private final VcsHistoryProvider myDelegate;
    private VcsHistoryCache myVcsHistoryCache;
    private boolean myCachesHistory;
    private final HistoryComputerFactory myHistoryComputerFactory;
    private final VcsType myType;
    private VcsConfiguration myConfiguration;

    public VcsHistoryProviderBackgroundableProxy(AbstractVcs vcs, VcsHistoryProvider delegate, DiffProvider diffProvider) {
        this.myDelegate = delegate;
        this.myProject = vcs.getProject();
        this.myConfiguration = VcsConfiguration.getInstance((Project)this.myProject);
        this.myCachesHistory = this.myDelegate instanceof VcsCacheableHistorySessionFactory;
        this.myDiffProvider = diffProvider;
        this.myVcsHistoryCache = ProjectLevelVcsManager.getInstance((Project)this.myProject).getVcsHistoryCache();
        this.myType = vcs.getType();
        this.myHistoryComputerFactory = new HistoryComputerFactory(){

            @Override
            public ThrowableComputable<VcsHistorySession, VcsException> create(FilePath filePath, Consumer<VcsHistorySession> consumer2, VcsKey vcsKey) {
                if (VcsHistoryProviderBackgroundableProxy.this.myCachesHistory) {
                    return new CachingHistoryComputer(filePath, consumer2, vcsKey);
                }
                return new SimpleHistoryComputer(filePath, consumer2);
            }
        };
    }

    public void createSessionFor(VcsKey vcsKey, FilePath filePath, Consumer<VcsHistorySession> continuation, @Nullable VcsBackgroundableActions actionKey, boolean silent, @Nullable Consumer<VcsHistorySession> backgroundSpecialization) {
        ThrowableComputable<VcsHistorySession, VcsException> throwableComputable = this.myHistoryComputerFactory.create(filePath, backgroundSpecialization, vcsKey);
        VcsBackgroundableActions resultingActionKey = actionKey == null ? VcsBackgroundableActions.CREATE_HISTORY_SESSION : actionKey;
        Object key2 = VcsBackgroundableActions.keyFrom(filePath);
        if (silent) {
            VcsBackgroundableComputable.createAndRunSilent(this.myProject, resultingActionKey, key2, VcsBundle.message((String)"loading.file.history.progress", (Object[])new Object[0]), throwableComputable, continuation);
        } else {
            VcsBackgroundableComputable.createAndRun(this.myProject, resultingActionKey, key2, VcsBundle.message((String)"loading.file.history.progress", (Object[])new Object[0]), VcsBundle.message((String)"message.title.could.not.load.file.history", (Object[])new Object[0]), throwableComputable, continuation, null);
        }
    }

    public void executeAppendableSession(VcsKey vcsKey, FilePath filePath, VcsAppendableHistorySessionPartner partner, @Nullable VcsBackgroundableActions actionKey, boolean canUseCache, boolean canUseLastRevisionCheck) {
        this.doExecuteAppendableSession(vcsKey, filePath, null, partner, actionKey, canUseCache, canUseLastRevisionCheck);
    }

    public void executeAppendableSession(VcsKey vcsKey, FilePath filePath, @Nullable VcsRevisionNumber startRevisionNumber, VcsAppendableHistorySessionPartner partner, @Nullable VcsBackgroundableActions actionKey) {
        if (!(this.myDelegate instanceof VcsHistoryProviderEx)) {
            throw new UnsupportedOperationException();
        }
        this.doExecuteAppendableSession(vcsKey, filePath, startRevisionNumber, partner, actionKey, false, false);
    }

    private void doExecuteAppendableSession(VcsKey vcsKey, FilePath filePath, @Nullable VcsRevisionNumber startRevisionNumber, VcsAppendableHistorySessionPartner partner, @Nullable VcsBackgroundableActions actionKey, boolean canUseCache, boolean canUseLastRevisionCheck) {
        VcsBackgroundableActions resultingActionKey;
        VcsAbstractHistorySession session3;
        if (this.myCachesHistory && canUseCache && (session3 = this.getFullHistoryFromCache(vcsKey, filePath)) != null) {
            partner.reportCreatedEmptySession(session3);
            partner.finished();
            return;
        }
        ProjectLevelVcsManagerImpl vcsManager = (ProjectLevelVcsManagerImpl)ProjectLevelVcsManager.getInstance((Project)this.myProject);
        BackgroundableActionEnabledHandler handler2 = vcsManager.getBackgroundableActionHandler(resultingActionKey = actionKey == null ? VcsBackgroundableActions.CREATE_HISTORY_SESSION : actionKey);
        if (handler2.isInProgress((Object)resultingActionKey)) {
            return;
        }
        handler2.register((Object)resultingActionKey);
        VcsAppendableHistorySessionPartner cachedPartner = this.myCachesHistory && startRevisionNumber == null ? new HistoryPartnerProxy(partner, session2 -> {
            if (session2 == null) {
                return;
            }
            VcsCacheableHistorySessionFactory delegate = (VcsCacheableHistorySessionFactory)this.myDelegate;
            FilePath correctedPath = delegate.getUsedFilePath(session2);
            this.myVcsHistoryCache.put(filePath, correctedPath, vcsKey, (VcsAbstractHistorySession)session2.copy(), delegate, true);
        }) : partner;
        this.reportHistory(filePath, startRevisionNumber, vcsKey, resultingActionKey, handler2, cachedPartner, canUseLastRevisionCheck);
    }

    private VcsAbstractHistorySession getFullHistoryFromCache(VcsKey vcsKey, FilePath filePath) {
        VcsAbstractHistorySession full = this.myVcsHistoryCache.getFull(filePath, vcsKey, (VcsCacheableHistorySessionFactory)this.myDelegate);
        if (full != null && this.myConfiguration.LIMIT_HISTORY && this.myConfiguration.MAXIMUM_HISTORY_ROWS < full.getRevisionList().size()) {
            List list = full.getRevisionList();
            ArrayList was = new ArrayList(list.subList(0, this.myConfiguration.MAXIMUM_HISTORY_ROWS));
            list.clear();
            list.addAll(was);
        }
        return full;
    }

    private void reportHistory(final FilePath filePath, final @Nullable VcsRevisionNumber startRevisionNumber, final VcsKey vcsKey, final VcsBackgroundableActions resultingActionKey, final BackgroundableActionEnabledHandler handler2, final VcsAppendableHistorySessionPartner cachedPartner, final boolean canUseLastRevisionCheck) {
        ProgressManager.getInstance().run((Task)new Task.Backgroundable(this.myProject, VcsBundle.message((String)"loading.file.history.progress", (Object[])new Object[0]), true){

            public void run(@NotNull ProgressIndicator indicator) {
                indicator.setText(VcsUtil.getPathForProgressPresentation((File)filePath.getIOFile()));
                indicator.setIndeterminate(true);
                try {
                    VcsAbstractHistorySession cachedSession;
                    if (canUseLastRevisionCheck && VcsHistoryProviderBackgroundableProxy.this.myCachesHistory && (cachedSession = VcsHistoryProviderBackgroundableProxy.this.getSessionFromCacheWithLastRevisionCheck(filePath, vcsKey)) != null) {
                        cachedPartner.reportCreatedEmptySession(cachedSession);
                    } else if (VcsHistoryProviderBackgroundableProxy.this.myDelegate instanceof VcsHistoryProviderEx) {
                        ((VcsHistoryProviderEx)VcsHistoryProviderBackgroundableProxy.this.myDelegate).reportAppendableHistory(filePath, startRevisionNumber, cachedPartner);
                    } else {
                        VcsHistoryProviderBackgroundableProxy.this.myDelegate.reportAppendableHistory(filePath, cachedPartner);
                    }
                }
                catch (VcsException e) {
                    cachedPartner.reportException(e);
                }
                finally {
                    cachedPartner.finished();
                    ApplicationManager.getApplication().invokeLater(() -> handler2.completed((Object)resultingActionKey), ModalityState.NON_MODAL);
                }
            }
        });
    }

    private VcsAbstractHistorySession createSessionWithLimitCheck(FilePath filePath) throws VcsException {
        VcsAppendableHistoryPartnerAdapter partner;
        block2: {
            final LimitHistoryCheck check = new LimitHistoryCheck(this.myProject, filePath.getPath());
            partner = new VcsAppendableHistoryPartnerAdapter(){

                public void acceptRevision(VcsFileRevision revision) {
                    check.checkNumber();
                    super.acceptRevision(revision);
                }
            };
            try {
                this.myDelegate.reportAppendableHistory(filePath, (VcsAppendableHistorySessionPartner)partner);
            }
            catch (ProcessCanceledException e) {
                if (check.isOver()) break block2;
                throw e;
            }
        }
        return partner.getSession();
    }

    @Nullable
    private VcsAbstractHistorySession getSessionFromCacheWithLastRevisionCheck(FilePath filePath, VcsKey vcsKey) {
        VcsAbstractHistorySession cached;
        ProgressIndicator pi = ProgressManager.getInstance().getProgressIndicator();
        if (pi != null) {
            pi.setText2("Checking last revision");
        }
        if ((cached = this.getFullHistoryFromCache(vcsKey, filePath)) == null) {
            return null;
        }
        FilePath correctedFilePath = ((VcsCacheableHistorySessionFactory)this.myDelegate).getUsedFilePath(cached);
        if (VcsType.distributed.equals((Object)this.myType)) {
            FilePath path = correctedFilePath != null ? correctedFilePath : filePath;
            VirtualFile virtualFile = path.getVirtualFile();
            if (virtualFile == null) {
                virtualFile = LocalFileSystem.getInstance().refreshAndFindFileByPath(path.getPath());
            }
            if (virtualFile != null) {
                VcsRevisionNumber currentRevision = this.myDiffProvider.getCurrentRevision(virtualFile);
                List revisionList = cached.getRevisionList();
                if (!revisionList.isEmpty() && ((VcsFileRevision)revisionList.get(0)).getRevisionNumber().equals(currentRevision)) {
                    return cached;
                }
            }
        } else {
            List revisionList;
            ItemLatestState lastRevision = this.myDiffProvider.getLastRevision(correctedFilePath != null ? correctedFilePath : filePath);
            if (lastRevision != null && !lastRevision.isDefaultHead() && lastRevision.isItemExists() && !(revisionList = cached.getRevisionList()).isEmpty() && ((VcsFileRevision)revisionList.get(0)).getRevisionNumber().equals(lastRevision.getNumber())) {
                return cached;
            }
        }
        return null;
    }

    private class CachingHistoryComputer
    implements ThrowableComputable<VcsHistorySession, VcsException> {
        private final FilePath myFilePath;
        private final Consumer<VcsHistorySession> myConsumer;
        private final VcsKey myVcsKey;

        private CachingHistoryComputer(FilePath filePath, Consumer<VcsHistorySession> consumer2, VcsKey vcsKey) {
            this.myFilePath = filePath;
            this.myConsumer = consumer2;
            this.myVcsKey = vcsKey;
        }

        public VcsHistorySession compute() throws VcsException {
            VcsAbstractHistorySession session2 = VcsHistoryProviderBackgroundableProxy.this.getSessionFromCacheWithLastRevisionCheck(this.myFilePath, this.myVcsKey);
            if (session2 == null) {
                session2 = VcsHistoryProviderBackgroundableProxy.this.createSessionWithLimitCheck(this.myFilePath);
                VcsCacheableHistorySessionFactory delegate = (VcsCacheableHistorySessionFactory)VcsHistoryProviderBackgroundableProxy.this.myDelegate;
                FilePath correctedPath = delegate.getUsedFilePath(session2);
                VcsHistoryProviderBackgroundableProxy.this.myVcsHistoryCache.put(this.myFilePath, correctedPath, this.myVcsKey, (VcsAbstractHistorySession)session2.copy(), delegate, true);
            }
            if (this.myConsumer != null) {
                this.myConsumer.consume((Object)session2);
            }
            return session2;
        }
    }

    private class SimpleHistoryComputer
    implements ThrowableComputable<VcsHistorySession, VcsException> {
        private final FilePath myFilePath;
        private final Consumer<VcsHistorySession> myConsumer;

        private SimpleHistoryComputer(FilePath filePath, Consumer<VcsHistorySession> consumer2) {
            this.myFilePath = filePath;
            this.myConsumer = consumer2;
        }

        public VcsHistorySession compute() throws VcsException {
            VcsAbstractHistorySession session2 = VcsHistoryProviderBackgroundableProxy.this.createSessionWithLimitCheck(this.myFilePath);
            if (this.myConsumer != null) {
                this.myConsumer.consume((Object)session2);
            }
            return session2;
        }
    }

    private static interface HistoryComputerFactory {
        public ThrowableComputable<VcsHistorySession, VcsException> create(FilePath var1, Consumer<VcsHistorySession> var2, VcsKey var3);
    }

    private static class HistoryPartnerProxy
    implements VcsAppendableHistorySessionPartner {
        private final VcsAppendableHistorySessionPartner myPartner;
        private final Consumer<VcsAbstractHistorySession> myFinish;
        private VcsAbstractHistorySession myCopy;

        private HistoryPartnerProxy(VcsAppendableHistorySessionPartner partner, Consumer<VcsAbstractHistorySession> finish) {
            this.myPartner = partner;
            this.myFinish = finish;
        }

        public void reportCreatedEmptySession(VcsAbstractHistorySession session2) {
            this.myCopy = (VcsAbstractHistorySession)session2.copy();
            this.myPartner.reportCreatedEmptySession(session2);
        }

        public void acceptRevision(VcsFileRevision revision) {
            this.myCopy.appendRevision(revision);
            this.myPartner.acceptRevision(revision);
        }

        public void reportException(VcsException exception) {
            this.myPartner.reportException(exception);
        }

        public void finished() {
            this.myPartner.finished();
            this.myFinish.consume((Object)this.myCopy);
        }

        public void beforeRefresh() {
            this.myPartner.beforeRefresh();
        }

        public void forceRefresh() {
            this.myPartner.forceRefresh();
        }
    }
}

