/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.merge;

import com.intellij.CommonBundle;
import com.intellij.diff.DiffManager;
import com.intellij.diff.DiffRequestFactory;
import com.intellij.diff.InvalidDiffRequestException;
import com.intellij.diff.merge.MergeRequest;
import com.intellij.diff.merge.MergeResult;
import com.intellij.diff.merge.MergeUtil;
import com.intellij.diff.util.DiffUtil;
import com.intellij.ide.presentation.VirtualFilePresentation;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diff.impl.mergeTool.MergeVersion;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ex.ProjectManagerEx;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.VcsDirtyScopeManager;
import com.intellij.openapi.vcs.merge.MergeData;
import com.intellij.openapi.vcs.merge.MergeDialogCustomizer;
import com.intellij.openapi.vcs.merge.MergeProvider;
import com.intellij.openapi.vcs.merge.MergeProvider2;
import com.intellij.openapi.vcs.merge.MergeSession;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.ColoredTableCellRenderer;
import com.intellij.ui.DoubleClickListener;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.TableSpeedSearch;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.speedSearch.SpeedSearchUtil;
import com.intellij.ui.table.TableView;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.Consumer;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.Convertor;
import com.intellij.util.ui.ColumnInfo;
import com.intellij.util.ui.ListTableModel;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.ResourceBundle;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableCellRenderer;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MultipleFileMergeDialog
extends DialogWrapper {
    private static final Logger LOG = Logger.getInstance(MultipleFileMergeDialog.class);
    private JPanel myRootPanel;
    private JButton myAcceptYoursButton;
    private JButton myAcceptTheirsButton;
    private JButton myMergeButton;
    private TableView<VirtualFile> myTable;
    private JBLabel myDescriptionLabel;
    private final MergeProvider myProvider;
    private final MergeSession myMergeSession;
    private final List<VirtualFile> myFiles;
    private final ListTableModel<VirtualFile> myModel;
    @Nullable
    private final Project myProject;
    private final ProjectManagerEx myProjectManager;
    private final List<VirtualFile> myProcessedFiles;
    private final Set<VirtualFile> myBinaryFiles;
    private final MergeDialogCustomizer myMergeDialogCustomizer;
    private final VirtualFileRenderer myVirtualFileRenderer;

    public MultipleFileMergeDialog(@Nullable Project project2, @NotNull List<VirtualFile> files, @NotNull MergeProvider provider2, @NotNull MergeDialogCustomizer mergeDialogCustomizer) {
        super(project2);
        this.$$$setupUI$$$();
        this.myProcessedFiles = new SmartList();
        this.myBinaryFiles = new HashSet<VirtualFile>();
        this.myVirtualFileRenderer = new VirtualFileRenderer();
        this.myProject = project2;
        this.myProjectManager = ProjectManagerEx.getInstanceEx();
        this.myProjectManager.blockReloadingProjectOnExternalChanges();
        this.myFiles = new ArrayList<VirtualFile>(files);
        this.myProvider = provider2;
        this.myMergeDialogCustomizer = mergeDialogCustomizer;
        String description = this.myMergeDialogCustomizer.getMultipleFileMergeDescription(files);
        if (!StringUtil.isEmptyOrSpaces((String)description)) {
            this.myDescriptionLabel.setText(description);
        }
        ArrayList<ColumnInfo> columns = new ArrayList<ColumnInfo>();
        columns.add(new ColumnInfo<VirtualFile, VirtualFile>(VcsBundle.message((String)"multiple.file.merge.column.name", (Object[])new Object[0])){

            public VirtualFile valueOf(VirtualFile virtualFile) {
                return virtualFile;
            }

            public TableCellRenderer getRenderer(VirtualFile virtualFile) {
                return MultipleFileMergeDialog.this.myVirtualFileRenderer;
            }

            @Nullable
            public Comparator<VirtualFile> getComparator() {
                return VirtualFileComparator.INSTANCE;
            }
        });
        columns.add(new ColumnInfo<VirtualFile, String>(VcsBundle.message((String)"multiple.file.merge.column.type", (Object[])new Object[0])){

            public String valueOf(VirtualFile virtualFile) {
                return MultipleFileMergeDialog.this.myBinaryFiles.contains(virtualFile) ? VcsBundle.message((String)"multiple.file.merge.type.binary", (Object[])new Object[0]) : VcsBundle.message((String)"multiple.file.merge.type.text", (Object[])new Object[0]);
            }

            public String getMaxStringValue() {
                return VcsBundle.message((String)"multiple.file.merge.type.binary", (Object[])new Object[0]);
            }

            public int getAdditionalWidth() {
                return 10;
            }
        });
        if (this.myProvider instanceof MergeProvider2) {
            this.myMergeSession = ((MergeProvider2)this.myProvider).createMergeSession(files);
            Collections.addAll(columns, this.myMergeSession.getMergeInfoColumns());
        } else {
            this.myMergeSession = null;
        }
        this.myModel = new ListTableModel(columns.toArray(new ColumnInfo[columns.size()]));
        this.myModel.setItems(files);
        this.myTable.setModelAndUpdateColumns(this.myModel);
        this.myVirtualFileRenderer.setFont(UIUtil.getListFont());
        this.myTable.setRowHeight(this.myVirtualFileRenderer.getPreferredSize().height);
        this.setTitle(this.myMergeDialogCustomizer.getMultipleFileDialogTitle());
        this.init();
        this.myAcceptYoursButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(@NotNull ActionEvent e) {
                MultipleFileMergeDialog.this.acceptRevision(true);
            }
        });
        this.myAcceptTheirsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(@NotNull ActionEvent e) {
                MultipleFileMergeDialog.this.acceptRevision(false);
            }
        });
        this.myTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(@NotNull ListSelectionEvent e) {
                MultipleFileMergeDialog.this.updateButtonState();
            }
        });
        for (VirtualFile file2 : files) {
            if (!file2.getFileType().isBinary() && !provider2.isBinary(file2)) continue;
            this.myBinaryFiles.add(file2);
        }
        this.myTable.getSelectionModel().setSelectionInterval(0, 0);
        new DoubleClickListener(){

            protected boolean onDoubleClick(MouseEvent event) {
                MultipleFileMergeDialog.this.showMergeDialog();
                return true;
            }
        }.installOn(this.myTable);
        new TableSpeedSearch((JTable)this.myTable, new Convertor<Object, String>(){

            public String convert(Object o) {
                if (o instanceof VirtualFile) {
                    return ((VirtualFile)o).getName();
                }
                return null;
            }
        });
    }

    private void updateButtonState() {
        boolean haveSelection = this.myTable.getSelectedRowCount() > 0;
        boolean haveUnmergeableFiles = false;
        for (VirtualFile file2 : this.myTable.getSelection()) {
            boolean canMerge;
            if (this.myMergeSession == null || (canMerge = this.myMergeSession.canMerge(file2))) continue;
            haveUnmergeableFiles = true;
            break;
        }
        this.myAcceptYoursButton.setEnabled(haveSelection);
        this.myAcceptTheirsButton.setEnabled(haveSelection);
        this.myMergeButton.setEnabled(haveSelection && !haveUnmergeableFiles);
    }

    @Nullable
    protected JComponent createCenterPanel() {
        return this.myRootPanel;
    }

    @NotNull
    protected Action[] createActions() {
        return new Action[]{this.getCancelAction()};
    }

    @NotNull
    protected Action getCancelAction() {
        Action action = super.getCancelAction();
        action.putValue("Name", CommonBundle.getCloseButtonText());
        return action;
    }

    protected void dispose() {
        this.myProjectManager.unblockReloadingProjectOnExternalChanges();
        super.dispose();
    }

    protected boolean beforeResolve(Collection<VirtualFile> files) {
        return true;
    }

    @NonNls
    protected String getDimensionServiceKey() {
        return "MultipleFileMergeDialog";
    }

    private void acceptRevision(boolean isCurrent) {
        FileDocumentManager.getInstance().saveAllDocuments();
        Collection files = this.myTable.getSelection();
        if (!this.beforeResolve(files)) {
            return;
        }
        try {
            for (VirtualFile file2 : files) {
                this.acceptFileRevision(file2, isCurrent);
                this.markFileProcessed(file2, isCurrent ? MergeSession.Resolution.AcceptedYours : MergeSession.Resolution.AcceptedTheirs);
            }
        }
        catch (Exception e) {
            LOG.warn((Throwable)e);
            Messages.showErrorDialog((Component)this.myRootPanel, (String)("Error saving merged data: " + e.getMessage()));
        }
        this.updateModelFromFiles();
    }

    private void acceptFileRevision(@NotNull VirtualFile file2, boolean isCurrent) throws Exception {
        if (this.myProvider instanceof MergeProvider2 && !this.myMergeSession.canMerge(file2)) {
            return;
        }
        if (!DiffUtil.makeWritable(this.myProject, file2)) {
            throw new IOException("File is read-only: " + file2.getPresentableName());
        }
        MergeData data = this.myProvider.loadRevisions(file2);
        Ref ex = new Ref();
        CommandProcessor.getInstance().executeCommand(this.myProject, () -> ApplicationManager.getApplication().runWriteAction(() -> {
            try {
                if (isCurrent) {
                    file2.setBinaryContent(data.CURRENT);
                } else {
                    file2.setBinaryContent(data.LAST);
                    this.checkMarkModifiedProject(file2);
                }
            }
            catch (Exception e) {
                ex.set((Object)e);
            }
        }), "Accept " + (isCurrent ? "Yours" : "Theirs"), null);
        if (!ex.isNull()) {
            throw (Exception)ex.get();
        }
    }

    private void markFileProcessed(@NotNull VirtualFile file2, @NotNull MergeSession.Resolution resolution) {
        this.myFiles.remove(file2);
        if (this.myProvider instanceof MergeProvider2) {
            this.myMergeSession.conflictResolvedForFile(file2, resolution);
        } else {
            this.myProvider.conflictResolvedForFile(file2);
        }
        this.myProcessedFiles.add(file2);
        if (this.myProject != null) {
            VcsDirtyScopeManager.getInstance((Project)this.myProject).fileDirty(file2);
        }
    }

    private void updateModelFromFiles() {
        if (this.myFiles.isEmpty()) {
            this.doCancelAction();
        } else {
            int selIndex = this.myTable.getSelectionModel().getMinSelectionIndex();
            this.myModel.setItems(this.myFiles);
            if (selIndex >= this.myFiles.size()) {
                selIndex = this.myFiles.size() - 1;
            }
            this.myTable.getSelectionModel().setSelectionInterval(selIndex, selIndex);
        }
    }

    private void showMergeDialog() {
        DiffRequestFactory requestFactory = DiffRequestFactory.getInstance();
        Collection files = this.myTable.getSelection();
        if (!this.beforeResolve(files)) {
            return;
        }
        for (VirtualFile file2 : files) {
            MergeRequest request;
            MergeData mergeData;
            try {
                mergeData = this.myProvider.loadRevisions(file2);
            }
            catch (VcsException ex) {
                Messages.showErrorDialog((Component)this.myRootPanel, (String)("Error loading revisions to merge: " + ex.getMessage()));
                break;
            }
            if (mergeData.CURRENT == null || mergeData.LAST == null || mergeData.ORIGINAL == null) {
                Messages.showErrorDialog((Component)this.myRootPanel, (String)"Error loading revisions to merge");
                break;
            }
            String leftTitle = this.myMergeDialogCustomizer.getLeftPanelTitle(file2);
            String baseTitle = this.myMergeDialogCustomizer.getCenterPanelTitle(file2);
            String rightTitle = this.myMergeDialogCustomizer.getRightPanelTitle(file2, mergeData.LAST_REVISION_NUMBER);
            String title = this.myMergeDialogCustomizer.getMergeWindowTitle(file2);
            List byteContents = ContainerUtil.list((Object[])new byte[][]{mergeData.CURRENT, mergeData.ORIGINAL, mergeData.LAST});
            List contentTitles = ContainerUtil.list((Object[])new String[]{leftTitle, baseTitle, rightTitle});
            Consumer callback = result2 -> {
                Document document = FileDocumentManager.getInstance().getCachedDocument(file2);
                if (document != null) {
                    FileDocumentManager.getInstance().saveDocument(document);
                }
                this.checkMarkModifiedProject(file2);
                if (result2 != MergeResult.CANCEL) {
                    ApplicationManager.getApplication().runWriteAction(() -> this.markFileProcessed(file2, MultipleFileMergeDialog.getSessionResolution(result2)));
                }
            };
            try {
                request = this.myProvider.isBinary(file2) ? requestFactory.createBinaryMergeRequest(this.myProject, file2, byteContents, title, contentTitles, callback) : requestFactory.createMergeRequest(this.myProject, file2, byteContents, title, contentTitles, callback);
                MergeUtil.putRevisionInfos(request, mergeData);
            }
            catch (InvalidDiffRequestException e) {
                LOG.error((Throwable)e);
                Messages.showErrorDialog((Component)this.myRootPanel, (String)"Can't show merge dialog");
                break;
            }
            DiffManager.getInstance().showMerge(this.myProject, request);
        }
        this.updateModelFromFiles();
    }

    @NotNull
    private static MergeSession.Resolution getSessionResolution(@NotNull MergeResult result2) {
        switch (result2) {
            case LEFT: {
                return MergeSession.Resolution.AcceptedYours;
            }
            case RIGHT: {
                return MergeSession.Resolution.AcceptedTheirs;
            }
            case RESOLVED: {
                return MergeSession.Resolution.Merged;
            }
        }
        throw new IllegalArgumentException(result2.name());
    }

    private void checkMarkModifiedProject(@NotNull VirtualFile file2) {
        MergeVersion.MergeDocumentVersion.reportProjectFileChangeIfNeeded(this.myProject, file2);
    }

    private void createUIComponents() {
        AbstractAction mergeAction = new AbstractAction(){

            @Override
            public void actionPerformed(@NotNull ActionEvent e) {
                MultipleFileMergeDialog.this.showMergeDialog();
            }
        };
        mergeAction.putValue("DefaultAction", Boolean.TRUE);
        this.myMergeButton = this.createJButtonForAction(mergeAction);
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myTable;
    }

    @NotNull
    public List<VirtualFile> getProcessedFiles() {
        return this.myProcessedFiles;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JBLabel jBLabel;
        TableView tableView;
        JButton jButton;
        JButton jButton2;
        JPanel jPanel;
        this.createUIComponents();
        this.myRootPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(2, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(4, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel2, new GridConstraints(1, 1, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myAcceptYoursButton = jButton2 = new JButton();
        this.$$$loadButtonText$$$(jButton2, ResourceBundle.getBundle("messages/VcsBundle").getString("multiple.file.merge.accept.yours"));
        jPanel2.add((Component)jButton2, new GridConstraints(0, 0, 1, 1, 0, 1, 3, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel2.add((Component)spacer, new GridConstraints(3, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        this.myAcceptTheirsButton = jButton = new JButton();
        this.$$$loadButtonText$$$(jButton, ResourceBundle.getBundle("messages/VcsBundle").getString("multiple.file.merge.accept.theirs"));
        jPanel2.add((Component)jButton, new GridConstraints(1, 0, 1, 1, 0, 1, 3, 0, null, null, null));
        JButton jButton3 = this.myMergeButton;
        this.$$$loadButtonText$$$(jButton3, ResourceBundle.getBundle("messages/VcsBundle").getString("multiple.file.merge.merge"));
        jPanel2.add((Component)jButton3, new GridConstraints(2, 0, 1, 1, 0, 1, 3, 0, null, null, null));
        JBScrollPane jBScrollPane = new JBScrollPane();
        jPanel.add((Component)jBScrollPane, new GridConstraints(1, 0, 1, 1, 0, 3, 7, 7, null, null, null));
        this.myTable = tableView = new TableView();
        jBScrollPane.setViewportView((Component)tableView);
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(5, 5, 5, 5), -1, -1, false, false));
        jPanel.add((Component)jPanel3, new GridConstraints(0, 0, 1, 2, 0, 3, 3, 3, null, null, null));
        this.myDescriptionLabel = jBLabel = new JBLabel();
        jPanel3.add((Component)jBLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 3, null, null, null, 1));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myRootPanel;
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int j = 0; j < string.length(); ++j) {
            if (string.charAt(j) == '&') {
                if (++j == string.length()) break;
                if (!bl && string.charAt(j) != '&') {
                    bl = true;
                    c = string.charAt(j);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(j));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }

    private static class VirtualFileComparator
    implements Comparator<VirtualFile> {
        public static final VirtualFileComparator INSTANCE = new VirtualFileComparator();

        private VirtualFileComparator() {
        }

        @Override
        public int compare(VirtualFile file1, VirtualFile file2) {
            int delta = StringUtil.naturalCompare((String)file1.getName(), (String)file2.getName());
            if (delta != 0) {
                return delta;
            }
            VirtualFile parent1 = file1.getParent();
            VirtualFile parent2 = file2.getParent();
            String path1 = parent1 != null ? parent1.getPath() : null;
            String path2 = parent2 != null ? parent2.getPath() : null;
            return StringUtil.naturalCompare((String)path1, (String)path2);
        }
    }

    private class VirtualFileRenderer
    extends ColoredTableCellRenderer {
        private VirtualFileRenderer() {
        }

        protected void customizeCellRenderer(JTable table, Object value2, boolean selected, boolean hasFocus, int row, int column) {
            VirtualFile vf = (VirtualFile)value2;
            this.setIcon(VirtualFilePresentation.getIcon((VirtualFile)vf));
            this.append(vf.getName(), SimpleTextAttributes.REGULAR_ATTRIBUTES);
            VirtualFile parent = vf.getParent();
            if (parent != null) {
                this.append(" (" + FileUtil.toSystemDependentName((String)parent.getPresentableUrl()) + ")", SimpleTextAttributes.GRAYED_ATTRIBUTES);
            }
            SpeedSearchUtil.applySpeedSearchHighlighting((JComponent)MultipleFileMergeDialog.this.myTable, (SimpleColoredComponent)this, (boolean)true, (boolean)selected);
        }
    }
}

