/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.readOnlyHandler;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.readOnlyHandler.FileInfo;
import com.intellij.openapi.vcs.readOnlyHandler.FileListRenderer;
import com.intellij.openapi.vcs.readOnlyHandler.HandleType;
import com.intellij.openapi.vcs.readOnlyHandler.ReadonlyStatusHandlerImpl;
import com.intellij.openapi.vfs.ReadonlyStatusHandler;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.CollectionComboBoxModel;
import com.intellij.ui.ColoredListCellRendererWrapper;
import com.intellij.ui.JBColor;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBList;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.ui.OptionsDialog;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.AbstractListModel;
import javax.swing.ButtonGroup;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JRootPane;
import org.jetbrains.annotations.NotNull;

public class ReadOnlyStatusDialog
extends OptionsDialog {
    private static final SimpleTextAttributes BOLD_ATTRIBUTES = new SimpleTextAttributes(1, JBColor.foreground());
    private static final SimpleTextAttributes SELECTED_BOLD_ATTRIBUTES = new SimpleTextAttributes(1, (Color)new JBColor(UIUtil::getListSelectionForeground));
    private JPanel myTopPanel;
    private JList myFileList;
    private JRadioButton myUsingFileSystemRadioButton;
    private JRadioButton myUsingVcsRadioButton;
    private JComboBox myChangelist;
    private FileInfo[] myFiles;

    public ReadOnlyStatusDialog(Project project2, FileInfo[] files) {
        super(project2);
        Object[] objectArray = new Object[]{};
        this.$$$setupUI$$$();
        this.setTitle(VcsBundle.message((String)"dialog.title.clear.read.only.file.status", (Object[])objectArray));
        this.myFiles = files;
        this.myFileList.setPreferredSize(ReadOnlyStatusDialog.getDialogPreferredSize());
        this.initFileList();
        ActionListener listener2 = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ReadOnlyStatusDialog.this.myChangelist.setEnabled(ReadOnlyStatusDialog.this.myUsingVcsRadioButton.isSelected());
            }
        };
        this.myUsingVcsRadioButton.addActionListener(listener2);
        this.myUsingFileSystemRadioButton.addActionListener(listener2);
        (this.myUsingVcsRadioButton.isEnabled() ? this.myUsingVcsRadioButton : this.myUsingFileSystemRadioButton).setSelected(true);
        this.myChangelist.setEnabled(this.myUsingVcsRadioButton.isSelected());
        this.myFileList.setCellRenderer(new FileListRenderer());
        this.init();
    }

    public long getTypeAheadTimeoutMs() {
        return Registry.intValue((String)"actionSystem.typeAheadTimeBeforeDialog");
    }

    private void initFileList() {
        this.myFileList.setModel(new AbstractListModel(){

            @Override
            public int getSize() {
                return ReadOnlyStatusDialog.this.myFiles.length;
            }

            @Override
            public Object getElementAt(int index) {
                return ReadOnlyStatusDialog.this.myFiles[index].getFile();
            }
        });
        boolean hasVcs = false;
        for (FileInfo info : this.myFiles) {
            if (!info.hasVersionControl()) continue;
            hasVcs = true;
            HandleType handleType = info.getSelectedHandleType();
            List<String> changelists = handleType.getChangelists();
            final String defaultChangelist = handleType.getDefaultChangelist();
            this.myChangelist.setModel(new CollectionComboBoxModel(changelists, (Object)defaultChangelist));
            this.myChangelist.setRenderer(new ColoredListCellRendererWrapper<String>(){

                protected void doCustomize(JList list, String value2, int index, boolean selected, boolean hasFocus) {
                    if (value2 == null) {
                        return;
                    }
                    String trimmed = StringUtil.first((String)value2, (int)50, (boolean)true);
                    if (value2.equals(defaultChangelist)) {
                        this.append(trimmed, selected ? SELECTED_BOLD_ATTRIBUTES : BOLD_ATTRIBUTES);
                    } else {
                        this.append(trimmed, selected ? SimpleTextAttributes.SELECTED_SIMPLE_CELL_ATTRIBUTES : SimpleTextAttributes.SIMPLE_CELL_ATTRIBUTES);
                    }
                }
            });
            break;
        }
        this.myUsingVcsRadioButton.setEnabled(hasVcs);
    }

    protected boolean isToBeShown() {
        ReadonlyStatusHandlerImpl.State state = ((ReadonlyStatusHandlerImpl)ReadonlyStatusHandler.getInstance((Project)this.myProject)).getState();
        return state != null && state.SHOW_DIALOG;
    }

    protected void setToBeShown(boolean value2, boolean onOk) {
        ReadonlyStatusHandlerImpl.State state;
        if (onOk && (state = ((ReadonlyStatusHandlerImpl)ReadonlyStatusHandler.getInstance((Project)this.myProject)).getState()) != null) {
            state.SHOW_DIALOG = value2;
        }
    }

    protected boolean shouldSaveOptionsOnCancel() {
        return false;
    }

    protected JComponent createCenterPanel() {
        return this.myTopPanel;
    }

    protected String getDimensionServiceKey() {
        return "vcs.readOnlyHandler.ReadOnlyStatusDialog";
    }

    protected void doOKAction() {
        for (FileInfo info2 : this.myFiles) {
            if (this.myUsingFileSystemRadioButton.isSelected()) {
                info2.getHandleType().selectFirst();
                continue;
            }
            if (!info2.hasVersionControl()) continue;
            info2.getHandleType().select(info2.getHandleType().get(1));
        }
        ArrayList<FileInfo> files = new ArrayList<FileInfo>();
        Collections.addAll(files, this.myFiles);
        String changelist = (String)this.myChangelist.getSelectedItem();
        ReadonlyStatusHandlerImpl.processFiles(files, changelist);
        if (files.isEmpty()) {
            super.doOKAction();
        } else {
            String list = StringUtil.join(files, info -> info.getFile().getPresentableUrl(), (String)"<br>");
            String message2 = VcsBundle.message((String)"handle.ro.file.status.failed", (Object[])new Object[]{list});
            Messages.showErrorDialog((Component)this.getRootPane(), (String)message2, (String)VcsBundle.message((String)"dialog.title.clear.read.only.file.status", (Object[])new Object[0]));
            this.myFiles = files.toArray(new FileInfo[files.size()]);
            this.initFileList();
        }
    }

    public JComponent getPreferredFocusedComponent() {
        JRootPane pane = this.getRootPane();
        return pane != null ? pane.getDefaultButton() : null;
    }

    public static Dimension getDialogPreferredSize() {
        return new Dimension(500, 400);
    }

    @NotNull
    public static String getTheseFilesMessage(Collection<VirtualFile> files) {
        boolean dirsOnly = true;
        for (VirtualFile each : files) {
            if (each.isDirectory()) continue;
            dirsOnly = false;
            break;
        }
        int size = files.size();
        return StringUtil.pluralize((String)"this", (int)size) + " " + StringUtil.pluralize((String)(dirsOnly ? "directory" : "file"), (int)size);
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JComboBox jComboBox;
        JRadioButton jRadioButton;
        JRadioButton jRadioButton2;
        JPanel jPanel;
        this.myTopPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JBScrollPane jBScrollPane = new JBScrollPane();
        jPanel.add((Component)jBScrollPane, new GridConstraints(0, 0, 1, 1, 0, 3, 7, 7, null, null, null));
        JBList jBList = new JBList();
        this.myFileList = jBList;
        jBScrollPane.setViewportView((Component)jBList);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(2, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel2, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myUsingFileSystemRadioButton = jRadioButton2 = new JRadioButton();
        jRadioButton2.setText("Using file system");
        jRadioButton2.setMnemonic('F');
        jRadioButton2.setDisplayedMnemonicIndex(6);
        jPanel2.add((Component)jRadioButton2, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, new Dimension(175, 22), null));
        this.myUsingVcsRadioButton = jRadioButton = new JRadioButton();
        jRadioButton.setText("Using version control integration");
        jRadioButton.setMnemonic('V');
        jRadioButton.setDisplayedMnemonicIndex(6);
        jPanel2.add((Component)jRadioButton, new GridConstraints(1, 0, 1, 1, 8, 0, 3, 0, null, new Dimension(175, 22), null));
        this.myChangelist = jComboBox = new JComboBox();
        jPanel2.add(jComboBox, new GridConstraints(1, 2, 1, 1, 8, 1, 6, 0, null, null, null));
        JBLabel jBLabel = new JBLabel();
        jBLabel.setText("   Change list:");
        jBLabel.setDisplayedMnemonic('L');
        jBLabel.setDisplayedMnemonicIndex(10);
        jBLabel.setHorizontalAlignment(11);
        jPanel2.add((Component)jBLabel, new GridConstraints(1, 1, 1, 1, 0, 0, 0, 0, null, new Dimension(34, 14), null));
        jBLabel.setLabelFor(jComboBox);
        ButtonGroup buttonGroup2 = new ButtonGroup();
        buttonGroup2.add(jRadioButton2);
        buttonGroup2.add(jRadioButton);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myTopPanel;
    }
}

