/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.roots;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsDirectoryMapping;
import com.intellij.openapi.vcs.VcsNotifier;
import com.intellij.openapi.vcs.VcsRoot;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public abstract class VcsIntegrationEnabler {
    @NotNull
    protected final Project myProject;
    @NotNull
    private final AbstractVcs myVcs;

    protected VcsIntegrationEnabler(@NotNull AbstractVcs vcs) {
        this.myProject = vcs.getProject();
        this.myVcs = vcs;
    }

    public void enable(@NotNull Collection<VcsRoot> vcsRoots) {
        Collection roots = vcsRoots.stream().filter(root -> {
            AbstractVcs vcs = root.getVcs();
            return vcs != null && vcs.getName().equals(this.myVcs.getName());
        }).map(VcsRoot::getPath).collect(Collectors.toList());
        VirtualFile projectDir = this.myProject.getBaseDir();
        assert (projectDir != null) : "Base dir is unexpectedly null for project: " + this.myProject;
        if (roots.isEmpty()) {
            boolean succeeded = this.initOrNotifyError(projectDir);
            if (succeeded) {
                this.addVcsRoots(Collections.singleton(projectDir));
            }
        } else {
            if (roots.size() > 1 || this.isProjectBelowVcs(roots)) {
                this.notifyAddedRoots(roots);
            }
            this.addVcsRoots(roots);
        }
    }

    private boolean isProjectBelowVcs(@NotNull Collection<VirtualFile> roots) {
        return ContainerUtil.exists(roots, root -> VfsUtilCore.isAncestor((VirtualFile)root, (VirtualFile)this.myProject.getBaseDir(), (boolean)true));
    }

    @NotNull
    public static String joinRootsPaths(@NotNull Collection<VirtualFile> roots) {
        return StringUtil.join(roots, VirtualFile::getPresentableUrl, (String)", ");
    }

    protected abstract boolean initOrNotifyError(@NotNull VirtualFile var1);

    protected void notifyAddedRoots(Collection<VirtualFile> roots) {
        String message2 = String.format("Added %s %s: %s", this.myVcs.getName(), StringUtil.pluralize((String)"root", (int)roots.size()), VcsIntegrationEnabler.joinRootsPaths(roots));
        VcsNotifier.getInstance(this.myProject).notifySuccess(message2);
    }

    private void addVcsRoots(@NotNull Collection<VirtualFile> roots) {
        ProjectLevelVcsManager vcsManager = ProjectLevelVcsManager.getInstance((Project)this.myProject);
        List<VirtualFile> currentVcsRoots = Arrays.asList(vcsManager.getRootsUnderVcs(this.myVcs));
        ArrayList<VcsDirectoryMapping> mappings = new ArrayList<VcsDirectoryMapping>(vcsManager.getDirectoryMappings(this.myVcs));
        for (VirtualFile root : roots) {
            if (currentVcsRoots.contains(root)) continue;
            mappings.add(new VcsDirectoryMapping(root.getPath(), this.myVcs.getName()));
        }
        vcsManager.setDirectoryMappings(mappings);
    }

    protected static void refreshVcsDir(@NotNull VirtualFile projectDir, @NotNull String vcsDirName) {
        LocalFileSystem.getInstance().refreshAndFindFileByPath(projectDir.getPath() + "/" + vcsDirName);
    }
}

