/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.roots;

import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsRoot;
import com.intellij.openapi.vcs.VcsRootChecker;
import com.intellij.openapi.vcs.roots.VcsRootDetector;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VcsRootDetectorImpl
implements VcsRootDetector {
    private static final int MAXIMUM_SCAN_DEPTH = 2;
    @NotNull
    private final Project myProject;
    @NotNull
    private final ProjectRootManager myProjectManager;
    @NotNull
    private final ProjectLevelVcsManager myVcsManager;
    @NotNull
    private final VcsRootChecker[] myCheckers;

    public VcsRootDetectorImpl(@NotNull Project project2, @NotNull ProjectRootManager projectRootManager, @NotNull ProjectLevelVcsManager projectLevelVcsManager) {
        this.myProject = project2;
        this.myProjectManager = projectRootManager;
        this.myVcsManager = projectLevelVcsManager;
        this.myCheckers = (VcsRootChecker[])Extensions.getExtensions((ExtensionPointName)VcsRootChecker.EXTENSION_POINT_NAME);
    }

    @NotNull
    public Collection<VcsRoot> detect() {
        return this.detect(this.myProject.getBaseDir());
    }

    @NotNull
    public Collection<VcsRoot> detect(@Nullable VirtualFile startDir) {
        if (startDir == null || this.myCheckers.length == 0) {
            return Collections.emptyList();
        }
        Set<VcsRoot> roots = this.scanForRootsInsideDir(startDir);
        roots.addAll(this.scanForRootsInContentRoots());
        for (VcsRoot root : roots) {
            if (!startDir.equals(root.getPath())) continue;
            return roots;
        }
        List<VcsRoot> rootsAbove = this.scanForSingleRootAboveDir(startDir);
        roots.addAll(rootsAbove);
        return roots;
    }

    @NotNull
    private Set<VcsRoot> scanForRootsInContentRoots() {
        VirtualFile[] roots;
        HashSet<VcsRoot> vcsRoots = new HashSet<VcsRoot>();
        if (this.myProject.isDisposed()) {
            return vcsRoots;
        }
        for (VirtualFile contentRoot : roots = this.myProjectManager.getContentRoots()) {
            Set<VcsRoot> rootsInsideRoot = this.scanForRootsInsideDir(contentRoot);
            boolean shouldScanAbove = true;
            for (VcsRoot root : rootsInsideRoot) {
                if (!contentRoot.equals(root.getPath())) continue;
                shouldScanAbove = false;
            }
            if (shouldScanAbove) {
                List<VcsRoot> rootsAbove = this.scanForSingleRootAboveDir(contentRoot);
                rootsInsideRoot.addAll(rootsAbove);
            }
            vcsRoots.addAll(rootsInsideRoot);
        }
        return vcsRoots;
    }

    @NotNull
    private Set<VcsRoot> scanForRootsInsideDir(@NotNull VirtualFile dir, int depth) {
        HashSet<VcsRoot> roots = new HashSet<VcsRoot>();
        if (depth > 2) {
            return roots;
        }
        if (this.myProject.isDisposed() || !dir.isDirectory()) {
            return roots;
        }
        List<AbstractVcs> vcsList = this.getVcsListFor(dir);
        for (AbstractVcs vcs : vcsList) {
            roots.add(new VcsRoot(vcs, dir));
        }
        for (VirtualFile child : dir.getChildren()) {
            roots.addAll(this.scanForRootsInsideDir(child, depth + 1));
        }
        return roots;
    }

    @NotNull
    private Set<VcsRoot> scanForRootsInsideDir(@NotNull VirtualFile dir) {
        return this.scanForRootsInsideDir(dir, 0);
    }

    @NotNull
    private List<VcsRoot> scanForSingleRootAboveDir(@NotNull VirtualFile dir) {
        ArrayList<VcsRoot> roots = new ArrayList<VcsRoot>();
        if (this.myProject.isDisposed()) {
            return roots;
        }
        for (VirtualFile par = dir.getParent(); par != null; par = par.getParent()) {
            List<AbstractVcs> vcsList = this.getVcsListFor(par);
            for (AbstractVcs vcs : vcsList) {
                roots.add(new VcsRoot(vcs, par));
            }
            if (roots.isEmpty()) continue;
            return roots;
        }
        return roots;
    }

    @NotNull
    private List<AbstractVcs> getVcsListFor(@NotNull VirtualFile dir) {
        ArrayList<AbstractVcs> vcsList = new ArrayList<AbstractVcs>();
        for (VcsRootChecker checker : this.myCheckers) {
            if (!checker.isRoot(dir.getPath())) continue;
            vcsList.add(this.myVcsManager.findVcsByName(checker.getSupportedVcs().getName()));
        }
        return vcsList;
    }
}

