/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.roots;

import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsDirectoryMapping;
import com.intellij.openapi.vcs.VcsRoot;
import com.intellij.openapi.vcs.VcsRootChecker;
import com.intellij.openapi.vcs.VcsRootError;
import com.intellij.openapi.vcs.VcsRootErrorImpl;
import com.intellij.openapi.vcs.roots.VcsRootDetector;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class VcsRootErrorsFinder {
    @NotNull
    private final Project myProject;
    @NotNull
    private final ProjectLevelVcsManager myVcsManager;
    @NotNull
    private final VcsRootDetector myRootDetector;

    public VcsRootErrorsFinder(@NotNull Project project2) {
        this.myProject = project2;
        this.myVcsManager = ProjectLevelVcsManager.getInstance((Project)project2);
        this.myRootDetector = (VcsRootDetector)ServiceManager.getService((Project)this.myProject, VcsRootDetector.class);
    }

    @NotNull
    public Collection<VcsRootError> find() {
        List mappings = this.myVcsManager.getDirectoryMappings();
        Collection vcsRoots = this.myRootDetector.detect();
        ArrayList<VcsRootError> errors = new ArrayList<VcsRootError>();
        errors.addAll(this.findExtraMappings(mappings));
        errors.addAll(this.findUnregisteredRoots(mappings, vcsRoots));
        return errors;
    }

    @NotNull
    private Collection<VcsRootError> findUnregisteredRoots(@NotNull List<VcsDirectoryMapping> mappings, @NotNull Collection<VcsRoot> vcsRoots) {
        ArrayList<VcsRootError> errors = new ArrayList<VcsRootError>();
        List<String> mappedPaths = this.mappingsToPathsWithSelectedVcs(mappings);
        for (VcsRoot root : vcsRoots) {
            String vcsPath;
            VirtualFile virtualFileFromRoot = root.getPath();
            if (virtualFileFromRoot == null || mappedPaths.contains(vcsPath = virtualFileFromRoot.getPath()) || root.getVcs() == null) continue;
            errors.add(new VcsRootErrorImpl(VcsRootError.Type.UNREGISTERED_ROOT, vcsPath, root.getVcs().getName()));
        }
        return errors;
    }

    @NotNull
    private Collection<VcsRootError> findExtraMappings(@NotNull List<VcsDirectoryMapping> mappings) {
        ArrayList<VcsRootError> errors = new ArrayList<VcsRootError>();
        for (VcsDirectoryMapping mapping : mappings) {
            if (!VcsRootErrorsFinder.hasVcsChecker(mapping.getVcs())) continue;
            if (mapping.isDefaultMapping()) {
                if (this.isRoot(mapping)) continue;
                errors.add(new VcsRootErrorImpl(VcsRootError.Type.EXTRA_MAPPING, "<Project>", mapping.getVcs()));
                continue;
            }
            String mappedPath = mapping.systemIndependentPath();
            if (this.isRoot(mapping)) continue;
            errors.add(new VcsRootErrorImpl(VcsRootError.Type.EXTRA_MAPPING, mappedPath, mapping.getVcs()));
        }
        return errors;
    }

    private static boolean hasVcsChecker(String vcs) {
        VcsRootChecker[] checkers;
        if (StringUtil.isEmptyOrSpaces((String)vcs)) {
            return false;
        }
        for (VcsRootChecker checker : checkers = (VcsRootChecker[])Extensions.getExtensions((ExtensionPointName)VcsRootChecker.EXTENSION_POINT_NAME)) {
            if (!vcs.equalsIgnoreCase(checker.getSupportedVcs().getName())) continue;
            return true;
        }
        return false;
    }

    private List<String> mappingsToPathsWithSelectedVcs(@NotNull List<VcsDirectoryMapping> mappings) {
        ArrayList<String> paths = new ArrayList<String>();
        for (VcsDirectoryMapping mapping : mappings) {
            if (StringUtil.isEmptyOrSpaces((String)mapping.getVcs())) continue;
            if (!mapping.isDefaultMapping()) {
                paths.add(mapping.systemIndependentPath());
                continue;
            }
            String basePath = this.myProject.getBasePath();
            if (basePath == null) continue;
            paths.add(FileUtil.toSystemIndependentName((String)basePath));
        }
        return paths;
    }

    public static VcsRootErrorsFinder getInstance(Project project2) {
        return new VcsRootErrorsFinder(project2);
    }

    private boolean isRoot(final @NotNull VcsDirectoryMapping mapping) {
        Object[] checkers = (VcsRootChecker[])Extensions.getExtensions((ExtensionPointName)VcsRootChecker.EXTENSION_POINT_NAME);
        final String pathToCheck = mapping.isDefaultMapping() ? this.myProject.getBasePath() : mapping.getDirectory();
        return ContainerUtil.find((Object[])checkers, (Condition)new Condition<VcsRootChecker>(){

            public boolean value(VcsRootChecker checker) {
                return checker.getSupportedVcs().getName().equalsIgnoreCase(mapping.getVcs()) && checker.isRoot(pathToCheck);
            }
        }) != null;
    }
}

