/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.ui;

import com.intellij.openapi.editor.impl.ComplementaryFontsRegistry;
import com.intellij.util.ui.UIUtil;
import java.awt.Font;
import org.jetbrains.annotations.NotNull;

public class FontUtil {
    @NotNull
    public static Font getFontAbleToDisplay(char c, int size, int style, @NotNull String family) {
        return ComplementaryFontsRegistry.getFontAbleToDisplay(c, size, style, family, null).getFont();
    }

    @NotNull
    public static String getHtmlWithFonts(@NotNull String input) {
        Font font = UIUtil.getLabelFont();
        return FontUtil.getHtmlWithFonts(input, font.getStyle(), font);
    }

    @NotNull
    public static String getHtmlWithFonts(@NotNull String input, int style, @NotNull Font baseFont) {
        int start = baseFont.canDisplayUpTo(input);
        if (start == -1) {
            return input;
        }
        Font font = null;
        StringBuilder result2 = new StringBuilder(input.substring(0, start));
        for (int i2 = start; i2 < input.length(); ++i2) {
            char c = input.charAt(i2);
            if (baseFont.canDisplay(c)) {
                if (font != null) {
                    result2.append("</font>");
                }
                result2.append(c);
                font = null;
                continue;
            }
            if (font != null && font.canDisplay(c)) {
                result2.append(c);
                continue;
            }
            if (font != null) {
                result2.append("</font>");
            }
            if ((font = FontUtil.getFontAbleToDisplay(c, baseFont.getSize(), style, baseFont.getFamily())) != baseFont) {
                result2.append("<font face=\"").append(font.getFamily()).append("\">");
            }
            result2.append(c);
        }
        if (font != null) {
            result2.append("</font>");
        }
        return result2.toString();
    }
}

